/*
 * Copyright (C) 2008 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef FrameNetworkingContextManx_h
#define FrameNetworkingContextManx_h

#include "FrameNetworkingContext.h"

namespace WebCore {

class FrameNetworkingContextManx : public WebCore::FrameNetworkingContext {
public:
    static PassRefPtr<FrameNetworkingContextManx> create(WebCore::Frame* frame)
    {
        return adoptRef(new FrameNetworkingContextManx(frame));
    }

    WebCore::Frame* coreFrame() const { return frame(); }

    virtual void onAuthenticationRequired(const AuthenticationChallenge& challenge) const 
    {
        if (frame() && frame()->loader() && frame()->loader()->client()) {
            FrameLoaderClient* loaderclient = frame()->loader()->client();
            loaderclient->dispatchDidReceiveAuthenticationChallenge(0, 0, challenge);
        }
    }

    virtual void onCertificateVerificationRequest(const ResourceError& error) const
    {
        if (frame() && frame()->loader() && frame()->loader()->client()) {
            FrameLoaderClient* loaderclient = frame()->loader()->client();
            loaderclient->dispatchDidFailLoad(error);
        }
    }

    virtual bool isMainResource(const void* client) const
    {
        ASSERT(client);
        if (frame() && frame()->loader() && frame()->loader()->activeDocumentLoader() && frame()->loader()->activeDocumentLoader()->mainResourceLoader()) {
            MainResourceLoader* mainloader = frame()->loader()->activeDocumentLoader()->mainResourceLoader();
            if (mainloader == client)
                return true;
        }
        return false;
    }

    virtual void replaceUrlOfMainResource(const WebCore::KURL& responseUrl) const { }

private:
    FrameNetworkingContextManx(WebCore::Frame* frame)
        : WebCore::FrameNetworkingContext(frame)
    {
    }
};

}

#endif
