/*
 * Copyright (C) 2006 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#ifndef ResourceError_h
#define ResourceError_h

#include "ResourceErrorBase.h"
#include <wtf/text/CString.h>

namespace WebCore {

class ResourceError : public ResourceErrorBase {
public:
    ResourceError()
        : m_sslError(0), m_shouldCertVerify(false), m_confirm(false), m_cert(0)
    {
    }

    ResourceError(const String& domain, int errorCode, const String& failingURL, const String& localizedDescription)
        : ResourceErrorBase(domain, errorCode, failingURL, localizedDescription), m_sslError(0), m_shouldCertVerify(false), m_confirm(false), m_cert(0)
    {
    }

    ResourceError(int sslError, const String& failingURL)
        : ResourceErrorBase(String(), 0, failingURL, String()), m_sslError(sslError), m_shouldCertVerify(true), m_confirm(false), m_cert(0)
    {
    }

    void setCert(void* cert) { m_cert = cert; }
    void* cert() const { return m_cert; }

    void setCerts(Vector<CString>& certs) { m_certs = certs; }
    Vector<CString>& certs() const { return m_certs; }

    bool shouldCertificateVerify() const { return m_shouldCertVerify; }
    void setConfirmCert(bool confirm) const { m_confirm = confirm; }
    bool confirmCert() { return m_confirm; }

    int sslError() const { return m_sslError; }

private:
    int m_sslError;
    bool m_shouldCertVerify;
    mutable bool m_confirm;
    mutable void* m_cert;
    mutable Vector<CString> m_certs;

};

}

#endif // ResourceError_h_
