/*
 * Copyright (C) 2008 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "ClipboardManx.h"

#include "FileList.h"
#include "IntPoint.h"
#include "NotImplemented.h"
#include "Pasteboard.h"
#include "PlatformString.h"
#include <wtf/HashTable.h>
#include <wtf/text/StringHash.h>

namespace WebCore {

PassRefPtr<Clipboard> Clipboard::create(ClipboardAccessPolicy policy, DragData* forDragging, Frame* frame)
{
    return 0;
}

ClipboardManx::ClipboardManx(ClipboardAccessPolicy policy, ClipboardType clipboardType)
    : Clipboard(policy, clipboardType)
{
}

void ClipboardManx::clearData(const String& type)
{
    notImplemented();
}

void ClipboardManx::clearAllData()
{
    Pasteboard::generalPasteboard()->clear();
}

String ClipboardManx::getData(const String& type) const
{
    notImplemented();
    return "";
}

bool ClipboardManx::setData(const String& type, const String& data)
{
    notImplemented();
    return false;
}

// extensions beyond IE's API
HashSet<String> ClipboardManx::types() const
{
    notImplemented();
    HashSet<String> result;
    return result;
}

PassRefPtr<FileList> ClipboardManx::files() const
{
    notImplemented();
    return 0;
}

IntPoint ClipboardManx::dragLocation() const
{
    notImplemented();
    return IntPoint(0, 0);
}

CachedImage* ClipboardManx::dragImage() const
{
    notImplemented();
    return 0;
}

void ClipboardManx::setDragImage(CachedImage*, const IntPoint&)
{
    notImplemented();
}

Node* ClipboardManx::dragImageElement()
{
    notImplemented();
    return 0;
}

void ClipboardManx::setDragImageElement(Node*, const IntPoint&)
{
    notImplemented();
}

DragImageRef ClipboardManx::createDragImage(IntPoint& dragLoc) const
{
    notImplemented();
    return 0;
}

void ClipboardManx::declareAndWriteDragImage(Element*, const KURL&, const String&, Frame*)
{
    notImplemented();
}

void ClipboardManx::writeURL(const KURL& url, const String& string, Frame* frame)
{
    Pasteboard::generalPasteboard()->writeURL(url, string, frame);
}

void ClipboardManx::writeRange(Range*, Frame*)
{
    notImplemented();
}

void ClipboardManx::writePlainText(const String& text)
{
    notImplemented();
}

bool ClipboardManx::hasData()
{
    notImplemented();
    return false;
}

}
