/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMTestSerializedScriptValueInterface.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "MessagePortArray.h"
#include "SerializedScriptValue.h"
#include "TestSerializedScriptValueInterface.h"
#include "WebKitDOMBinding.h"
#include "gobject/ConvertToUTF8String.h"
#include "webkit/WebKitDOMArray.h"
#include "webkit/WebKitDOMArrayPrivate.h"
#include "webkit/WebKitDOMMessagePortArray.h"
#include "webkit/WebKitDOMMessagePortArrayPrivate.h"
#include "webkit/WebKitDOMSerializedScriptValue.h"
#include "webkit/WebKitDOMSerializedScriptValuePrivate.h"
#include "webkit/WebKitDOMTestSerializedScriptValueInterfacePrivate.h"
#include "webkitdefines.h"
#include "webkitglobalsprivate.h"
#include "webkitmarshal.h"
#include <glib-object.h>
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#if ENABLE(Condition1) || ENABLE(Condition2)

namespace WebKit {

WebKitDOMTestSerializedScriptValueInterface* kit(WebCore::TestSerializedScriptValueInterface* obj)
{
    g_return_val_if_fail(obj, 0);

    if (gpointer ret = DOMObjectCache::get(obj))
        return static_cast<WebKitDOMTestSerializedScriptValueInterface*>(ret);

    return static_cast<WebKitDOMTestSerializedScriptValueInterface*>(DOMObjectCache::put(obj, WebKit::wrapTestSerializedScriptValueInterface(obj)));
}

WebCore::TestSerializedScriptValueInterface* core(WebKitDOMTestSerializedScriptValueInterface* request)
{
    g_return_val_if_fail(request, 0);

    WebCore::TestSerializedScriptValueInterface* coreObject = static_cast<WebCore::TestSerializedScriptValueInterface*>(WEBKIT_DOM_OBJECT(request)->coreObject);
    g_return_val_if_fail(coreObject, 0);

    return coreObject;
}

WebKitDOMTestSerializedScriptValueInterface* wrapTestSerializedScriptValueInterface(WebCore::TestSerializedScriptValueInterface* coreObject)
{
    g_return_val_if_fail(coreObject, 0);

    // We call ref() rather than using a C++ smart pointer because we can't store a C++ object
    // in a C-allocated GObject structure. See the finalize() code for the matching deref().
    coreObject->ref();

    return WEBKIT_DOM_TEST_SERIALIZED_SCRIPT_VALUE_INTERFACE(g_object_new(WEBKIT_TYPE_DOM_TEST_SERIALIZED_SCRIPT_VALUE_INTERFACE, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(Condition1) || ENABLE(Condition2)

G_DEFINE_TYPE(WebKitDOMTestSerializedScriptValueInterface, webkit_dom_test_serialized_script_value_interface, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_VALUE,
    PROP_READONLY_VALUE,
    PROP_CACHED_VALUE,
    PROP_PORTS,
    PROP_CACHED_READONLY_VALUE,
};

static void webkit_dom_test_serialized_script_value_interface_finalize(GObject* object)
{
#if ENABLE(Condition1) || ENABLE(Condition2)
    WebKitDOMObject* domObject = WEBKIT_DOM_OBJECT(object);
    
    if (domObject->coreObject) {
        WebCore::TestSerializedScriptValueInterface* coreObject = static_cast<WebCore::TestSerializedScriptValueInterface*>(domObject->coreObject);

        WebKit::DOMObjectCache::forget(coreObject);
        coreObject->deref();

        domObject->coreObject = 0;
    }
#endif // ENABLE(Condition1) || ENABLE(Condition2)

    G_OBJECT_CLASS(webkit_dom_test_serialized_script_value_interface_parent_class)->finalize(object);
}

static void webkit_dom_test_serialized_script_value_interface_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
    switch (propertyId) {
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}


static void webkit_dom_test_serialized_script_value_interface_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
    WebKitDOMTestSerializedScriptValueInterface* self = WEBKIT_DOM_TEST_SERIALIZED_SCRIPT_VALUE_INTERFACE(object);
    WebCore::TestSerializedScriptValueInterface* coreSelf = WebKit::core(self);
    switch (propertyId) {
    case PROP_VALUE: {
#if ENABLE(Condition1) || ENABLE(Condition2)
        RefPtr<WebCore::SerializedScriptValue> ptr = coreSelf->value();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
        break;
    }
    case PROP_READONLY_VALUE: {
#if ENABLE(Condition1) || ENABLE(Condition2)
        RefPtr<WebCore::SerializedScriptValue> ptr = coreSelf->readonlyValue();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
        break;
    }
    case PROP_CACHED_VALUE: {
#if ENABLE(Condition1) || ENABLE(Condition2)
        RefPtr<WebCore::SerializedScriptValue> ptr = coreSelf->cachedValue();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
        break;
    }
    case PROP_PORTS: {
#if ENABLE(Condition1) || ENABLE(Condition2)
        RefPtr<WebCore::MessagePortArray> ptr = coreSelf->ports();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
        break;
    }
    case PROP_CACHED_READONLY_VALUE: {
#if ENABLE(Condition1) || ENABLE(Condition2)
        RefPtr<WebCore::SerializedScriptValue> ptr = coreSelf->cachedReadonlyValue();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}


static void webkit_dom_test_serialized_script_value_interface_constructed(GObject* object)
{

    if (G_OBJECT_CLASS(webkit_dom_test_serialized_script_value_interface_parent_class)->constructed)
        G_OBJECT_CLASS(webkit_dom_test_serialized_script_value_interface_parent_class)->constructed(object);
}

static void webkit_dom_test_serialized_script_value_interface_class_init(WebKitDOMTestSerializedScriptValueInterfaceClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->finalize = webkit_dom_test_serialized_script_value_interface_finalize;
    gobjectClass->set_property = webkit_dom_test_serialized_script_value_interface_set_property;
    gobjectClass->get_property = webkit_dom_test_serialized_script_value_interface_get_property;
    gobjectClass->constructed = webkit_dom_test_serialized_script_value_interface_constructed;

    g_object_class_install_property(gobjectClass,
                                    PROP_VALUE,
                                    g_param_spec_object("value", /* name */
                                                           "test_serialized_script_value_interface_value", /* short description */
                                                           "read-write  WebKitDOMSerializedScriptValue* TestSerializedScriptValueInterface.value", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_SERIALIZED_SCRIPT_VALUE, /* gobject type */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_READONLY_VALUE,
                                    g_param_spec_object("readonly-value", /* name */
                                                           "test_serialized_script_value_interface_readonly-value", /* short description */
                                                           "read-only  WebKitDOMSerializedScriptValue* TestSerializedScriptValueInterface.readonly-value", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_SERIALIZED_SCRIPT_VALUE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CACHED_VALUE,
                                    g_param_spec_object("cached-value", /* name */
                                                           "test_serialized_script_value_interface_cached-value", /* short description */
                                                           "read-write  WebKitDOMSerializedScriptValue* TestSerializedScriptValueInterface.cached-value", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_SERIALIZED_SCRIPT_VALUE, /* gobject type */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PORTS,
                                    g_param_spec_object("ports", /* name */
                                                           "test_serialized_script_value_interface_ports", /* short description */
                                                           "read-only  WebKitDOMMessagePortArray* TestSerializedScriptValueInterface.ports", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_MESSAGE_PORT_ARRAY, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CACHED_READONLY_VALUE,
                                    g_param_spec_object("cached-readonly-value", /* name */
                                                           "test_serialized_script_value_interface_cached-readonly-value", /* short description */
                                                           "read-only  WebKitDOMSerializedScriptValue* TestSerializedScriptValueInterface.cached-readonly-value", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_SERIALIZED_SCRIPT_VALUE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));


}

static void webkit_dom_test_serialized_script_value_interface_init(WebKitDOMTestSerializedScriptValueInterface* request)
{
}

void
webkit_dom_test_serialized_script_value_interface_accept_transfer_list(WebKitDOMTestSerializedScriptValueInterface* self, WebKitDOMSerializedScriptValue* data, WebKitDOMArray* transferList)
{
#if ENABLE(Condition1) || ENABLE(Condition2)
    g_return_if_fail(self);
    WebCore::JSMainThreadNullState state;
    WebCore::TestSerializedScriptValueInterface* item = WebKit::core(self);
    g_return_if_fail(data);
    g_return_if_fail(transferList);
    WebCore::SerializedScriptValue* convertedData = 0;
    if (data) {
        convertedData = WebKit::core(data);
        g_return_if_fail(convertedData);
    }
    WebCore::Array* convertedTransferList = 0;
    if (transferList) {
        convertedTransferList = WebKit::core(transferList);
        g_return_if_fail(convertedTransferList);
    }
    item->acceptTransferList(convertedData, convertedTransferList);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
}

void
webkit_dom_test_serialized_script_value_interface_multi_transfer_list(WebKitDOMTestSerializedScriptValueInterface* self, WebKitDOMSerializedScriptValue* first, WebKitDOMArray* tx, WebKitDOMSerializedScriptValue* second, WebKitDOMArray* txx)
{
#if ENABLE(Condition1) || ENABLE(Condition2)
    g_return_if_fail(self);
    WebCore::JSMainThreadNullState state;
    WebCore::TestSerializedScriptValueInterface* item = WebKit::core(self);
    g_return_if_fail(first);
    g_return_if_fail(tx);
    g_return_if_fail(second);
    g_return_if_fail(txx);
    WebCore::SerializedScriptValue* convertedFirst = 0;
    if (first) {
        convertedFirst = WebKit::core(first);
        g_return_if_fail(convertedFirst);
    }
    WebCore::Array* convertedTx = 0;
    if (tx) {
        convertedTx = WebKit::core(tx);
        g_return_if_fail(convertedTx);
    }
    WebCore::SerializedScriptValue* convertedSecond = 0;
    if (second) {
        convertedSecond = WebKit::core(second);
        g_return_if_fail(convertedSecond);
    }
    WebCore::Array* convertedTxx = 0;
    if (txx) {
        convertedTxx = WebKit::core(txx);
        g_return_if_fail(convertedTxx);
    }
    item->multiTransferList(convertedFirst, convertedTx, convertedSecond, convertedTxx);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
}

WebKitDOMSerializedScriptValue*
webkit_dom_test_serialized_script_value_interface_get_value(WebKitDOMTestSerializedScriptValueInterface* self)
{
#if ENABLE(Condition1) || ENABLE(Condition2)
    g_return_val_if_fail(self, 0);
    WebCore::JSMainThreadNullState state;
    WebCore::TestSerializedScriptValueInterface* item = WebKit::core(self);
    RefPtr<WebCore::SerializedScriptValue> gobjectResult = WTF::getPtr(item->value());
    WebKitDOMSerializedScriptValue* result = WebKit::kit(gobjectResult.get());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
    return 0;
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
}

void
webkit_dom_test_serialized_script_value_interface_set_value(WebKitDOMTestSerializedScriptValueInterface* self, WebKitDOMSerializedScriptValue* value)
{
#if ENABLE(Condition1) || ENABLE(Condition2)
    g_return_if_fail(self);
    WebCore::JSMainThreadNullState state;
    WebCore::TestSerializedScriptValueInterface* item = WebKit::core(self);
    g_return_if_fail(value);
    WebCore::SerializedScriptValue* convertedValue = 0;
    if (value) {
        convertedValue = WebKit::core(value);
        g_return_if_fail(convertedValue);
    }
    item->setValue(convertedValue);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
}

WebKitDOMSerializedScriptValue*
webkit_dom_test_serialized_script_value_interface_get_readonly_value(WebKitDOMTestSerializedScriptValueInterface* self)
{
#if ENABLE(Condition1) || ENABLE(Condition2)
    g_return_val_if_fail(self, 0);
    WebCore::JSMainThreadNullState state;
    WebCore::TestSerializedScriptValueInterface* item = WebKit::core(self);
    RefPtr<WebCore::SerializedScriptValue> gobjectResult = WTF::getPtr(item->readonlyValue());
    WebKitDOMSerializedScriptValue* result = WebKit::kit(gobjectResult.get());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
    return 0;
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
}

WebKitDOMSerializedScriptValue*
webkit_dom_test_serialized_script_value_interface_get_cached_value(WebKitDOMTestSerializedScriptValueInterface* self)
{
#if ENABLE(Condition1) || ENABLE(Condition2)
    g_return_val_if_fail(self, 0);
    WebCore::JSMainThreadNullState state;
    WebCore::TestSerializedScriptValueInterface* item = WebKit::core(self);
    RefPtr<WebCore::SerializedScriptValue> gobjectResult = WTF::getPtr(item->cachedValue());
    WebKitDOMSerializedScriptValue* result = WebKit::kit(gobjectResult.get());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
    return 0;
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
}

void
webkit_dom_test_serialized_script_value_interface_set_cached_value(WebKitDOMTestSerializedScriptValueInterface* self, WebKitDOMSerializedScriptValue* value)
{
#if ENABLE(Condition1) || ENABLE(Condition2)
    g_return_if_fail(self);
    WebCore::JSMainThreadNullState state;
    WebCore::TestSerializedScriptValueInterface* item = WebKit::core(self);
    g_return_if_fail(value);
    WebCore::SerializedScriptValue* convertedValue = 0;
    if (value) {
        convertedValue = WebKit::core(value);
        g_return_if_fail(convertedValue);
    }
    item->setCachedValue(convertedValue);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
}

WebKitDOMMessagePortArray*
webkit_dom_test_serialized_script_value_interface_get_ports(WebKitDOMTestSerializedScriptValueInterface* self)
{
#if ENABLE(Condition1) || ENABLE(Condition2)
    g_return_val_if_fail(self, 0);
    WebCore::JSMainThreadNullState state;
    WebCore::TestSerializedScriptValueInterface* item = WebKit::core(self);
    RefPtr<WebCore::MessagePortArray> gobjectResult = WTF::getPtr(item->ports());
    WebKitDOMMessagePortArray* result = WebKit::kit(gobjectResult.get());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
    return 0;
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
}

WebKitDOMSerializedScriptValue*
webkit_dom_test_serialized_script_value_interface_get_cached_readonly_value(WebKitDOMTestSerializedScriptValueInterface* self)
{
#if ENABLE(Condition1) || ENABLE(Condition2)
    g_return_val_if_fail(self, 0);
    WebCore::JSMainThreadNullState state;
    WebCore::TestSerializedScriptValueInterface* item = WebKit::core(self);
    RefPtr<WebCore::SerializedScriptValue> gobjectResult = WTF::getPtr(item->cachedReadonlyValue());
    WebKitDOMSerializedScriptValue* result = WebKit::kit(gobjectResult.get());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
    return 0;
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
}

