/*
 * Copyright (C) 2010 Apple Inc. All rights reserved.
 * Portions Copyright (c) 2010 Motorola Mobility, Inc.  All rights reserved.
 * Copyright (C) 2011 Igalia S.L.
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WKView_h
#define WKView_h

#include <WebKit2/WKBase.h>
#include <WebKit2/WKEvent.h>
#include <WebKit2/WKGeometry.h>
#include <WebKit2/WKPopupMenuItem.h>
#include <cairo.h>
#include <manx/ImeEvent.h>
#include <manx/KeyboardEvent.h>
#include <manx/MouseEvent.h>
#include <manx/WheelEvent.h>

#ifdef __cplusplus
extern "C" {
#endif

enum {
    kWKCursorTypePointer = 0,
    kWKCursorTypeCross = 1,
    kWKCursorTypeHand = 2,
    kWKCursorTypeIBeam = 3,
    kWKCursorTypeWait = 4,
    kWKCursorTypeHelp = 5,
    kWKCursorTypeEastResize = 6,
    kWKCursorTypeNorthResize = 7,
    kWKCursorTypeNorthEastResize = 8,
    kWKCursorTypeNorthWestResize = 9,
    kWKCursorTypeSouthResize = 10,
    kWKCursorTypeSouthEastResize = 11,
    kWKCursorTypeSouthWestResize = 12,
    kWKCursorTypeWestResize = 13,
    kWKCursorTypeNorthSouthResize = 14,
    kWKCursorTypeEastWestResize = 15,
    kWKCursorTypeNorthEastSouthWestResize = 16,
    kWKCursorTypeNorthWestSouthEastResize = 17,
    kWKCursorTypeColumnResize = 18,
    kWKCursorTypeRowResize = 19,
    kWKCursorTypeMiddlePanning = 20,
    kWKCursorTypeEastPanning = 21,
    kWKCursorTypeNorthPanning = 22,
    kWKCursorTypeNorthEastPanning = 23,
    kWKCursorTypeNorthWestPanning = 24,
    kWKCursorTypeSouthPanning = 25,
    kWKCursorTypeSouthEastPanning = 26,
    kWKCursorTypeSouthWestPanning = 27,
    kWKCursorTypeWestPanning = 28,
    kWKCursorTypeMove = 29,
    kWKCursorTypeVerticalText = 30,
    kWKCursorTypeCell = 31,
    kWKCursorTypeContextMenu = 32,
    kWKCursorTypeAlias = 33,
    kWKCursorTypeProgress = 34,
    kWKCursorTypeNoDrop = 35,
    kWKCursorTypeCopy = 36,
    kWKCursorTypeNone = 37,
    kWKCursorTypeNotAllowed = 38,
    kWKCursorTypeZoomIn = 39,
    kWKCursorTypeZoomOut = 40,
    kWKCursorTypeGrab = 41,
    kWKCursorTypeGrabbing = 42,
    kWKCursorTypeCustom = 43
};
typedef uint32_t WKCursorType;

typedef void (*WKViewSetViewNeedsDisplayCallback)(WKViewRef view, WKRect rect, const void* clientInfo);
typedef WKSize (*WKViewViewSizeCallback)(WKViewRef view, const void* clientInfo);
typedef void (*WKViewSetCursorPositionCallback)(WKViewRef view, WKPoint cursorPosition, const void* clientInfo);
typedef void (*WKViewSetCursorCallback)(WKViewRef view, WKCursorType cursorType, const void* clientInfo);

typedef void (*WKViewDoneWithKeyEventCallback)(WKViewRef view, const Manx::KeyboardEvent* event, bool wasEventHandled, const void* clientInfo);
typedef void (*WKViewDoneWithMouseEventCallback)(WKViewRef view, bool wasEventHandled, const void* clientInfo);

// fullscreen callback
typedef void (*WKViewEnterFullScreenCallback)(WKViewRef view, const void* clientInfo);
typedef void (*WKViewExitFullScreenCallback)(WKViewRef view, const void* clientInfo);
typedef void (*WKViewCloseFullScreenCallback)(WKViewRef view, const void* clientInfo);
typedef void (*WKViewBeganEnterFullScreenCallback)(WKViewRef view, const WKRect initialFrame, const WKRect finalFrame, const void* clientInfo);
typedef void (*WKViewBeganExitFullScreenCallback)(WKViewRef view, const WKRect initialFrame, const WKRect finalFrame, const void* clientInfo);

// IME callback
typedef void (*WKViewDidChangeContentEditableCallback)(WKViewRef view, bool contentEditable, int fieldType, int fieldLang, WKRect fieldRect, WKStringRef fieldText, int caretOffset, const void* clientInfo);
typedef void (*WKViewDidChangeCompositionCallback)(WKViewRef view, WKRect compositionRect, const void* clientInfo);
typedef void (*WKViewDidChangeSelectionCallback)(WKViewRef view, WKStringRef selectedText, WKRect selectedRect, const void* clientInfo);
typedef void (*WKViewDidChangeContentEditable2Callback)(WKViewRef view, bool contentEditable, int fieldType, int fieldLang, WKRect fieldRect, WKStringRef fieldText, const void* clientInfo);
typedef void (*WKViewDidMoveCaretCallback)(WKViewRef view, WKStringRef fieldText, int caretOffset, const void* clientInfo);

// sync callback
typedef void (*WKViewRunJavaScriptAlertCallback)(WKViewRef view, WKStringRef alertText, WKFrameRef frame, const void *clientInfo);
typedef void (*WKViewRunJavaScriptConfirmCallback)(WKViewRef view, WKStringRef message, WKFrameRef frame, const void *clientInfo);
typedef void (*WKViewRunJavaScriptPromptCallback)(WKViewRef view, WKStringRef message, WKStringRef defaultValue, WKFrameRef frame, const void *clientInfo);
typedef void (*WKViewRunAuthenticationChallengeCallback)(WKViewRef view, WKFrameRef frame, WKStringRef hostname, WKStringRef realm, WKStringRef prefilledUsername, WKStringRef prefilledPassword, const void* clientInfo);
typedef void (*WKViewRunCertificateVerificationRequestCallback)(WKViewRef view, WKFrameRef frame, int error, WKStringRef url, WKArrayRef certificates, const void* clientInfo);
typedef void (*WKViewCreateNewPageCallback)(WKViewRef view, WKURLRequestRef urlRequest, WKDictionaryRef features, WKEventModifiers modifiers, WKEventMouseButton mouseButton, const void *clientInfo);

// Accelerated Compositing callback
typedef void (*WKViewEnterAcceleratedCompositingModeCallback)(WKViewRef view, uint32_t canvasHandle, const void *clientInfo);
typedef void (*WKViewExitAcceleratedCompositingModeCallback)(WKViewRef view, const void *clientInfo);
typedef void (*WKViewUpdateAcceleratedCompositingModeCallback)(WKViewRef view, uint32_t canvasHandle, const void *clientInfo);

struct WKViewClient {
    int                                                                 version;
    const void *                                                        clientInfo;

    // Version 0
    WKViewSetViewNeedsDisplayCallback                                   setViewNeedsDisplay;
    WKViewViewSizeCallback                                              viewSize;
    WKViewSetCursorPositionCallback                                     setCursorPosition;
    WKViewEnterFullScreenCallback                                       enterFullScreen;
    WKViewExitFullScreenCallback                                        exitFullScreen;
    WKViewCloseFullScreenCallback                                       closeFullScreen;
    WKViewBeganEnterFullScreenCallback                                  beganEnterFullScreen;
    WKViewBeganExitFullScreenCallback                                   beganExitFullScreen;
    WKViewDidChangeContentEditableCallback                              didChangeContentEditable;
    WKViewDidChangeSelectionCallback                                    didChangeSelection;
    WKViewRunJavaScriptAlertCallback                                    runJavaScriptAlert;
    WKViewRunJavaScriptConfirmCallback                                  runJavaScriptConfirm;
    WKViewRunJavaScriptPromptCallback                                   runJavaScriptPrompt;
    WKViewRunAuthenticationChallengeCallback                            runAuthenticationChallenge;
    WKViewRunCertificateVerificationRequestCallback                     runCertificateVerificationRequest;
    WKViewCreateNewPageCallback                                         createNewPage;
    WKViewEnterAcceleratedCompositingModeCallback                       enterAcceleratedCompositingMode;
    WKViewExitAcceleratedCompositingModeCallback                        exitAcceleratedCompositingMode;
    WKViewUpdateAcceleratedCompositingModeCallback                      updateAcceleratedCompositingMode;    
    WKViewDidChangeCompositionCallback                                  didChangeComposition;
    WKViewSetCursorCallback                                             setCursor;
    WKViewDidChangeContentEditable2Callback                             didChangeContentEditable2;
    WKViewDidMoveCaretCallback                                          didMoveCaret;
    WKViewDoneWithKeyEventCallback                                      doneWithKeyEvent;
    WKViewDoneWithMouseEventCallback                                    doneWithMouseDownEvent;
    WKViewDoneWithMouseEventCallback                                    doneWithMouseUpEvent;
};
typedef struct WKViewClient WKViewClient;

enum { kWKViewClientCurrentVersion = 0 };

typedef void (*WKViewShowPopupMenuCallback)(WKViewRef view, WKArrayRef popupMenuItem, WKRect rect, int32_t selectedIndex, const void* clientInfo);
typedef void (*WKViewHidePopupMenuCallback)(WKViewRef view, const void* clientInfo);

struct WKViewPopupMenuClient {
    int                                                                 version;
    const void *                                                        clientInfo;

    // Version 0
    WKViewShowPopupMenuCallback                                         showPopupMenu;
    WKViewHidePopupMenuCallback                                         hidePopupMenu;    
};
typedef struct WKViewPopupMenuClient WKViewPopupMenuClient;

enum { kWKViewPopupMenuClientCurrentVersion = 0 };

WK_EXPORT WKViewRef WKViewCreate(WKContextRef context, WKPageGroupRef pageGroup, const WKViewClient* client);

WK_EXPORT WKPageRef WKViewGetPage(WKViewRef view);

WK_EXPORT void WKViewPaint(WKViewRef view, cairo_t* c, int x, int y, int width, int height);
WK_EXPORT void WKViewScrollBy(WKViewRef view, int x, int y);
WK_EXPORT void WKViewHandleKeyboardEvent(WKViewRef view, const Manx::KeyboardEvent*);
WK_EXPORT void WKViewHandleImeEvent(WKViewRef view, const Manx::ImeEvent*);
WK_EXPORT void WKViewClearSelection(WKViewRef view);
WK_EXPORT void WKViewHandleMouseEvent(WKViewRef view, const Manx::MouseEvent*);
WK_EXPORT void WKViewHandleWheelEvent(WKViewRef view, const Manx::WheelEvent*);
WK_EXPORT void WKViewSetDrawsTransparentBackground(WKViewRef view, bool drawsTransparentBackground);
WK_EXPORT void WKViewSetSize(WKViewRef view, int width, int height);
WK_EXPORT void WKViewSetViewPopupMenuClient(WKViewRef view, const WKViewPopupMenuClient* client);
WK_EXPORT void WKViewValueChangedForPopupMenu(WKViewRef view, int selectedIndex);
WK_EXPORT void WKViewSetFocused(WKViewRef view, bool isFocused);
WK_EXPORT void WKViewSetActive(WKViewRef view, bool isActive);
WK_EXPORT void WKViewSetIsVisible(WKViewRef view, bool isVisible);
WK_EXPORT void WKViewReplyJavaScriptAlert(WKViewRef view);
WK_EXPORT void WKViewReplyJavaScriptConfirm(WKViewRef view, bool confirmResult);
WK_EXPORT void WKViewReplyJavaScriptPrompt(WKViewRef view, WKStringRef promptResult);
WK_EXPORT void WKViewReplyAuthenticationChallenge(WKViewRef view, bool result, WKStringRef userName, WKStringRef password);
WK_EXPORT void WKViewReplyCertificateVerification(WKViewRef view, bool result);
WK_EXPORT void WKViewReplyCreateNewPage(WKViewRef view, WKPageRef newPage);

// fullscreen api
WK_EXPORT void WKViewWillEnterFullScreen(WKViewRef view);
WK_EXPORT void WKViewDidEnterFullScreen(WKViewRef view);
WK_EXPORT void WKViewWillExitFullScreen(WKViewRef view);
WK_EXPORT void WKViewDidExitFullScreen(WKViewRef view);
WK_EXPORT void WKViewRequestExitFullScreen(WKViewRef view);
WK_EXPORT bool WKViewIsFullScreen(WKViewRef view);

#ifdef __cplusplus
}
#endif

#endif /* WKView_h */
