/*
 * Copyright (C) 2010 Apple Inc. All rights reserved.
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "SharedMemory.h"

#include "ArgumentDecoder.h"
#include "ArgumentEncoder.h"
#include <WebCore/NotImplemented.h>
#include <wtf/RefPtr.h>

namespace WebKit {

SharedMemory::Handle::Handle()
    : m_size(0)
{
}

SharedMemory::Handle::~Handle()
{
}

void SharedMemory::Handle::encode(CoreIPC::ArgumentEncoder* encoder) const
{
    encoder->encode(m_size);
    encoder->encode(m_handle);
}

bool SharedMemory::Handle::decode(CoreIPC::ArgumentDecoder* decoder, Handle& handle)
{
    if (!decoder->decode(handle.m_size))
        return false;
    if (!decoder->decode(handle.m_handle))
        return false;
    return true;
}

PassRefPtr<SharedMemory> SharedMemory::create(size_t size)
{
    Manx::SharedMemory::Handle handle;
    if (!Manx::SharedMemory::allocate(size, &handle))
        return 0;
    RefPtr<SharedMemory> memory = adoptRef(new SharedMemory);
    memory->m_size = size;
    memory->m_handle = handle;
    memory->m_sharedMemory = adoptPtr(Manx::SharedMemory::map(handle, Manx::SharedMemory::ReadWrite));
    memory->m_data = memory->m_sharedMemory->data();
    return memory.release();
}

PassRefPtr<SharedMemory> SharedMemory::create(const Handle& handle, Protection protection)
{
    RefPtr<SharedMemory> memory = adoptRef(new SharedMemory);
    memory->m_handle = handle.m_handle;
    memory->m_size = handle.m_size;
    memory->m_sharedMemory = adoptPtr(Manx::SharedMemory::map(handle.m_handle, Manx::SharedMemory::ReadWrite));
    memory->m_data = memory->m_sharedMemory->data();
    return memory.release();
}

SharedMemory::~SharedMemory()
{
    if (m_handle != Manx::SharedMemory::INVALID_HANDLE)
        Manx::SharedMemory::free(m_handle);
}

bool SharedMemory::createHandle(Handle& handle, Protection protection)
{
    handle.m_size = m_size;
    handle.m_handle = Manx::SharedMemory::duplicate(m_handle);
    return true;
}

unsigned SharedMemory::systemPageSize()
{
    unsigned pageSize = 0;

    notImplemented();
    return pageSize;
}

} // namespace WebKit
