/*
 * Copyright (C) 2008 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebViewManager_h
#define WebViewManager_h

#include <manx/DataTypes.h>
#include <webkit/WebViewHitTestResult.h>

class WebViewQueue;
class WebViewPopupMenu;

#define VARDATA_CHAR_OUT_SIZE (512)

typedef VarData HtmlEventData;
typedef VarData CompositionEventData;
typedef VarData CallbackData;

enum CallbackType {
    CallbackTypeUndefined = -1,

    CALLBACK_SET_TEXTURE,
    CALLBACK_SET_BACKINGSTORE,
    CALLBACK_SET_TITLE,
    CALLBACK_SET_URL,
    CALLBACK_HOVER_LINK_URL,
    CALLBACK_FOCUS_INPUT_TEXT,
    CALLBACK_VIEWPORT_CHANGED,
    CALLBACK_CONTENTS_SIZE_CHANGED,
    CALLBACK_SHOW_POPUP_MENU,
    CALLBACK_HIDE_POPUP_MENU,
    CALLBACK_SHOW_POPUP_MENU_ITEM,
    CALLBACK_LOAD_STARTED,
    CALLBACK_LOAD_FINISHED,
    CALLBACK_LOAD_FAILED,
    CALLBACK_LOAD_PROGRESS_CHANGED,
    CALLBACK_LOAD_SECURE,
    CALLBACK_JAVASCRIPT_ALERT,
    CALLBACK_JAVASCRIPT_CONFIRM,
    CALLBACK_JAVASCRIPT_PROMPT,
    CALLBACK_HISTORY_CHANGED,
    CALLBACK_BEGIN_COMPOSITION,
    CALLBACK_END_COMPOSITION,
    CALLBACK_CHANGE_SELECTION_COMPOSITION,
    CALLBACK_IS_DEFAULT_PREVENTED,
    CALLBACK_HITTEST,
    CALLBACK_DOWNLOAD_START,
    CALLBACK_UPLOAD_REQUEST,
    CALLBACK_JAVASCRIPT_DELEGATE,
    CALLBACK_CREATE_WINDOW,
    CALLBACK_CLOSE_WINDOW,
    CALLBACK_SCROLL_REQUESTED,
    CALLBACK_NAVIGATION_CONFIRM,
    CALLBACK_UNSUPPORT_SCHEME,
    CALLBACK_IMAGE_BUF_START,
    CALLBACK_IMAGE_BUF_ING,
    CALLBACK_IMAGE_BUF_FINISH,
    CALLBACK_NAVIGATION_WARNING,
    CALLBACK_HTTP_AUTH,
    CALLBACK_CERTIFICATE_VERIFY,
    CALLBACK_WINDOW_OBJECT_CLEARED,
    CALLBACK_WINDOW_CREATED,
    CALLBACK_SET_CURSOR_POSITION,
    CALLBACK_SET_CURSOR_TYPE,
    CALLBACK_DL_IMAGE_START,
    CALLBACK_DL_IMAGE_PROGRESS,
    CALLBACK_DL_IMAGE_FINISHED,
    CALLBACK_DL_IMAGE_FAILED,
    CALLBACK_DID_RECEIVE_KEY_EVENT2,
    CallbackTypeCount
};

namespace WebKit {

class WebViewManager {
public:
    static void deleteAllCookies();
    static void setCookies(const char* url, const char* cookie);
    static void initWebCore();
    static void exitWebCore();
};

} // namespace WebKit

namespace MXGlue {

class WebView;
class WebViewCommand;

class WebViewManager {
public:
    friend class WebView;

    typedef bool (*CallbackHandler)(WebView *webview, void *userData, CallbackType type, const CallbackData *in, CallbackData *out);

    WEBKIT_PUBLIC static bool init(bool async = false, CallbackHandler = 0, void *userData = 0);
    WEBKIT_PUBLIC static bool exit();
    WEBKIT_PUBLIC static bool update();

    WEBKIT_PUBLIC static WebView *create(int width, int height, void* pool = 0, void* painter = 0);
    WEBKIT_PUBLIC static bool createWebViewAsync(int width, int height, void* userArg = 0, void* pool = 0, void* painter = 0);
    WEBKIT_PUBLIC static bool destroy(WebView *webview);

    static bool processCallback(WebView*, CallbackType);
    static CallbackData s_callbackIn[16];
    static CallbackData s_callbackOut[16];

private:
    static void *processThread(void *);

    static void pushCommand(WebViewCommand *cmd, int limit = 0);
    static WebViewCommand *popResult();
    static void processCommand();

    static bool isInitialized() { return s_initialized; }

    static bool isWebThread();
    
    static bool s_initialized;

    static WebViewQueue *s_instanceQueue;
    static WebViewQueue *s_commandQueue;
    static WebViewQueue *s_resultQueue;

    static CallbackHandler s_callbackHandler;
    static void *s_callbackUserData;
};

} // namespace MXGlue

#endif // WebViewManager_h
