/*
 * Copyright (C) 2008 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebViewHitTestResult_h
#define WebViewHitTestResult_h

#if defined _WINDOWS            /* should be moved to apropriate header */
    #ifdef BUILDING_WEBKIT
        #define WEBKIT_PUBLIC __declspec(dllexport)
    #else
        #define WEBKIT_PUBLIC __declspec(dllimport)
    #endif
#elif defined __ORBIS__
    #define WEBKIT_PUBLIC __attribute__ ((visibility ("default")))
#else
    #define WEBKIT_PUBLIC
#endif

typedef struct {
    int x;
    int y;
    int width;
    int height;
} RectInfo;

typedef struct {
    int x;
    int y;
} PointInfo;

namespace WebCore {

class IntRect;
class KURL;
class IntPoint;

}

namespace WTF {

class CString;

}

class WebViewHitTestResult {
public:
    WEBKIT_PUBLIC WebViewHitTestResult();
    WEBKIT_PUBLIC WebViewHitTestResult(const WebViewHitTestResult* base);
    WEBKIT_PUBLIC ~WebViewHitTestResult();

    WEBKIT_PUBLIC void setImageUrl(WebCore::KURL);
    WEBKIT_PUBLIC const char* imageUrl() const;
    WEBKIT_PUBLIC void setImageUrlLength(int length) { m_imageLength = length; }
    WEBKIT_PUBLIC int imageUrlLength() const { return m_imageLength; }

    WEBKIT_PUBLIC void setLinkUrl(WebCore::KURL);
    WEBKIT_PUBLIC const char* linkUrl() const;
    WEBKIT_PUBLIC void setLinkUrlLength(int length) { m_linkLength = length; }
    WEBKIT_PUBLIC int linkUrlLength() const { return m_linkLength; }

    WEBKIT_PUBLIC void setRect(const WebCore::IntRect);
    WEBKIT_PUBLIC void getRect(RectInfo&) const;

    WEBKIT_PUBLIC void setPoint(const WebCore::IntPoint);
    WEBKIT_PUBLIC void getPoint(PointInfo&) const;

    WEBKIT_PUBLIC void setFormat(const char*);
    WEBKIT_PUBLIC const char* format() const;
    WEBKIT_PUBLIC void setFormatLength(int formatLength) { m_formatLength = formatLength; }
    WEBKIT_PUBLIC int formatLength() const { return m_formatLength; }

    WEBKIT_PUBLIC void setImageSize(int size) { m_imageSize = size; }
    WEBKIT_PUBLIC int imageSize() const { return m_imageSize; }

    WEBKIT_PUBLIC void setCanScroll(bool canScroll) { m_canScroll = canScroll; }
    WEBKIT_PUBLIC bool canScroll() const { return m_canScroll; }

private:
    WebCore::KURL* m_imageUrl;
    int m_imageLength;
    WebCore::KURL* m_linkUrl;
    int m_linkLength;
    RectInfo* m_rect;
    PointInfo* m_point;
    WTF::CString* m_format;
    int m_formatLength;
    int m_imageSize;
    bool m_canScroll;
};

#endif // WebViewHitTestResult_h
