/*
 * Copyright (C) 2008 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebViewPopupMenu_h
#define WebViewPopupMenu_h

#define WEBVIEWPOPUPMENU_MAX_ITEMS  256

namespace WebCore {
class IntRect;
class PopupMenuClient;
};

namespace WebKit {
class WebViewPrivate;
}

class WebViewPopupMenu {
public:
    WebViewPopupMenu(WebKit::WebViewPrivate*);
    ~WebViewPopupMenu();

    void clear();

    void show(WebCore::PopupMenuClient*, int, const WebCore::IntRect&);
    void hide(bool cancel);
    void setValue(int index);
    bool isActive();

    void getItem(int index);

private:
    void setSelected(int index);
    void valueChanged(int index);
 
    WebKit::WebViewPrivate* m_webView;
    WebCore::PopupMenuClient *m_client;

    int m_itemCount;

    int m_value;
    int m_selected;
};

#endif // WebViewPopupMenu_h
