/*
 * Copyright (C) 2013 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#include "config.h"
#include "OpenGLManx.h"

#include <EGL/egl.h>

#if GL_SCE_orbis_canvas_texture
extern "C" void glOrbisTexImageCanvas2DSCE(GLenum target, GLuint uCanvasHandle)
{
    static bool initialized = false;
    static PFNGLGLTEXIMAGE2DCANVASORBISSCEPROC proc = 0;
    if (!initialized)
        proc = (PFNGLGLTEXIMAGE2DCANVASORBISSCEPROC)eglGetProcAddress("glOrbisTexImageCanvas2DSCE");
    ASSERT(proc);
    if (proc)
        proc(target, uCanvasHandle);
}
#endif

#if GL_SCE_orbis_map_texture
extern "C" void glOrbisMapTexImage2DSCE(GLenum target, GLint level, GLORBISTEXIMAGE2DMAPPEDDESCSCE* desc)
{
    static bool initialized = false;
    static PFNGLORBISMAPTEXIMAGE2DSCEPROC proc = 0;
    if (!initialized)
        proc = (PFNGLORBISMAPTEXIMAGE2DSCEPROC)eglGetProcAddress("glOrbisMapTexImage2DSCE");
    ASSERT(proc);
    if (proc)
        proc(target, level, desc);
}

extern "C" void glOrbisUnmapTexImage2DSCE(GLenum target)
{
    static bool initialized = false;
    static PFNGLORBISUNMAPTEXIMAGE2DSCEPROC proc = 0;
    if (!initialized)
        proc = (PFNGLORBISUNMAPTEXIMAGE2DSCEPROC)eglGetProcAddress("glOrbisUnmapTexImage2DSCE");
    ASSERT(proc);
    if (proc)
        proc(target);
}
#endif

#if GL_SCE_orbis_pointer_texture
extern "C" void glOrbisTexImage2DPointerSCE(GLenum target, GLint width, GLint height, GLenum format, GLenum type, GLint num_levels, const GLvoid* ptr)
{
    static bool initialized = false;
    static PFNGLORBISTEXIMAGE2DPTRSCEPROC proc = 0;
    if (!initialized)
        proc = (PFNGLORBISTEXIMAGE2DPTRSCEPROC)eglGetProcAddress("glOrbisTexImage2DPointerSCE");
    ASSERT(proc);
    if (proc)
        proc(target, width, height, format, type, num_levels, ptr);
}
#endif
