#!/bin/bash

set -o errexit
set -o xtrace

jobs=1
export DERIVED_SOURCES_DIR="$1"
export FEATURE_DEFINES="`python features-manx.py $2`"
export SRCROOT="$PWD/.."

mkdir -p "${DERIVED_SOURCES_DIR}/WebCore"
cd "${DERIVED_SOURCES_DIR}/WebCore"

rm -f WebCore
/bin/ln -sf "${SRCROOT}" WebCore
export WebCore="WebCore"

case "$2" in
    orbis)
    make_arg="MEDIA_CONTROLS_STYLE_SHEETS=mediaControlsManxOrbis.css FULL_SCREEN_MEDIA_CONTROLS_STYLE_SHEETS=fullscreenManxOrbis.css"
    ;;
    psp2)
    make_arg="MEDIA_CONTROLS_STYLE_SHEETS=mediaControlsManxPSP2.css FULL_SCREEN_MEDIA_CONTROLS_STYLE_SHEETS=fullscreenManxPSP2.css"
    ;;
esac

rm -f supplemental_dependency.tmp
make --no-builtin-rules -f "WebCore/DerivedSources.make" -j $jobs $make_arg
rm -f supplemental_dependency.tmp
make --no-builtin-rules -f "WebCore/DerivedSources-manx.make" -j $jobs $make_arg
