/*
 * This file is part of the WebKit open source project.
 * This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include "WebDOMTestEventConstructor.h"

#include "KURL.h"
#include "TestEventConstructor.h"
#include "WebDOMString.h"
#include "WebExceptionHandler.h"
#include "wtf/text/AtomicString.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

struct WebDOMTestEventConstructor::WebDOMTestEventConstructorPrivate {
    WebDOMTestEventConstructorPrivate(WebCore::TestEventConstructor* object = 0)
        : impl(object)
    {
    }

    RefPtr<WebCore::TestEventConstructor> impl;
};

WebDOMTestEventConstructor::WebDOMTestEventConstructor()
    : WebDOMObject()
    , m_impl(0)
{
}

WebDOMTestEventConstructor::WebDOMTestEventConstructor(WebCore::TestEventConstructor* impl)
    : WebDOMObject()
    , m_impl(new WebDOMTestEventConstructorPrivate(impl))
{
}

WebDOMTestEventConstructor::WebDOMTestEventConstructor(const WebDOMTestEventConstructor& copy)
    : WebDOMObject()
{
    m_impl = copy.impl() ? new WebDOMTestEventConstructorPrivate(copy.impl()) : 0;
}

WebDOMTestEventConstructor& WebDOMTestEventConstructor::operator=(const WebDOMTestEventConstructor& copy)
{
    delete m_impl;
    m_impl = copy.impl() ? new WebDOMTestEventConstructorPrivate(copy.impl()) : 0;
    return *this;
}

WebCore::TestEventConstructor* WebDOMTestEventConstructor::impl() const
{
    return m_impl ? WTF::getPtr(m_impl->impl) : 0;
}

WebDOMTestEventConstructor::~WebDOMTestEventConstructor()
{
    delete m_impl;
    m_impl = 0;
}

WebDOMString WebDOMTestEventConstructor::attr1() const
{
    if (!impl())
        return WebDOMString();

    return static_cast<const WTF::String&>(impl()->attr1());
}

WebDOMString WebDOMTestEventConstructor::attr2() const
{
    if (!impl())
        return WebDOMString();

    return static_cast<const WTF::String&>(impl()->attr2());
}

WebCore::TestEventConstructor* toWebCore(const WebDOMTestEventConstructor& wrapper)
{
    return wrapper.impl();
}

WebDOMTestEventConstructor toWebKit(WebCore::TestEventConstructor* value)
{
    return WebDOMTestEventConstructor(value);
}
