// Copyright (C) 2012 Sony Computer Entertainment Inc.
// All Rights Reserved.
#ifndef WTF_SharedTypes_h
#define WTF_SharedTypes_h

#include <wtf/VectorTraits.h>

namespace WTF {

template <typename T>
struct SharedType {
    SharedType() {}

    explicit SharedType(T value)
        : m_value(value) {}

    operator T() const { return m_value; }

    T operator=(T value) { return m_value = value; }

    T m_value;
};

typedef SharedType<char>     SharedChar;
typedef SharedType<int32_t>  SharedInt32;
typedef SharedType<UChar>    SharedUChar;
typedef SharedType<unsigned> SharedUnsigned;

template<> struct VectorTraits<SharedChar> : VectorTraitsBase<true, SharedChar> {
    static const bool needsSharedDataMemory = true;
};
template<> struct VectorTraits<SharedInt32> : VectorTraitsBase<true, SharedInt32> {
    static const bool needsSharedDataMemory = true;
};
template<> struct VectorTraits<SharedUChar> : VectorTraitsBase<true, SharedUChar> {
    static const bool needsSharedDataMemory = true;
};
template<> struct VectorTraits<SharedUnsigned> : VectorTraitsBase<true, SharedUnsigned> {
    static const bool needsSharedDataMemory = true;
};

} // namespaace WTF

using WTF::SharedChar;
using WTF::SharedInt32;
using WTF::SharedUChar;
using WTF::SharedUnsigned;

#endif // #ifndef WTF_SharedTypes_h
