{
    'variables': {
        'project_dir': ['.'],
        # These headers are part of JavaScriptCore's public API in the Apple Mac build.
        'javascriptcore_publicheader_files': [
            'API/APICast.h',
            'API/APIShims.h',
            'API/JSBase.h',
            'API/JSContextRef.h',
            'API/JSContextRefPrivate.h',
            'API/JSMemoryStatsSCE.h',
            'API/JSObjectRef.h',
            'API/JSObjectRefPrivate.h',
            'API/JSRetainPtr.h',
            'API/JSStringRef.h',
            'API/JSStringRefBSTR.h',
            'API/JSStringRefCF.h',
            'API/JSValueRef.h',
            'API/JSWeakObjectMapRefInternal.h',
            'API/JSWeakObjectMapRefPrivate.h',
            'API/JavaScript.h',
            'API/JavaScriptCore.h',
            'API/OpaqueJSString.h',
            'API/WebKitAvailability.h',
        ],
        # These headers are part of JavaScriptCore's private API in the Apple Mac build.
        'javascriptcore_privateheader_files': [
            'assembler/AbstractMacroAssembler.h',
            'assembler/ARMAssembler.h',
            'assembler/ARMv7Assembler.h',
            'assembler/AssemblerBuffer.h',
            'assembler/AssemblerBufferWithConstantPool.h',
            'assembler/CodeLocation.h',
            'assembler/LinkBuffer.h',
            'assembler/MacroAssembler.h',
            'assembler/MacroAssemblerARM.h',
            'assembler/MacroAssemblerARMv7.h',
            'assembler/MacroAssemblerCodeRef.h',
            'assembler/MacroAssemblerMIPS.h',
            'assembler/MacroAssemblerSH4.h',
            'assembler/MacroAssemblerX86.h',
            'assembler/MacroAssemblerX86Common.h',
            'assembler/MacroAssemblerX86_64.h',
            'assembler/MIPSAssembler.h',
            'assembler/RepatchBuffer.h',
            'assembler/SH4Assembler.h',
            'assembler/X86Assembler.h',
            'bytecode/BytecodeConventions.h',
            'bytecode/CallLinkInfo.h',
            'bytecode/CallLinkStatus.h',
            'bytecode/CallReturnOffsetToBytecodeOffset.h',
            'bytecode/CodeBlock.h',
            'bytecode/CodeOrigin.h',
            'bytecode/CodeType.h',
            'bytecode/DataFormat.h',
            'bytecode/DFGExitProfile.h',
            'bytecode/EvalCodeCache.h',
            'bytecode/ExecutionCounter.h',
            'bytecode/ExpressionRangeInfo.h',
            'bytecode/GetByIdStatus.h',
            'bytecode/GlobalResolveInfo.h',
            'bytecode/HandlerInfo.h',
            'bytecode/Instruction.h',
            'bytecode/JumpTable.h',
            'bytecode/LazyOperandValueProfile.h',
            'bytecode/LineInfo.h',
            'bytecode/LLIntCallLinkInfo.h',
            'bytecode/MethodCallLinkInfo.h',
            'bytecode/MethodCallLinkStatus.h',
            'bytecode/MethodOfGettingAValueProfile.h',
            'bytecode/Opcode.h',
            'bytecode/Operands.h',
            'bytecode/PolymorphicPutByIdList.h',
            'bytecode/PredictedType.h',
            'bytecode/PutByIdStatus.h',
            'bytecode/PutKind.h',
            'bytecode/SamplingTool.h',
            'bytecode/StructureSet.h',
            'bytecode/StructureStubInfo.h',
            'bytecode/ValueProfile.h',
            'bytecode/ValueRecovery.h',
            'bytecode/VirtualRegister.h',
            'dfg/DFGAbstractState.h',
            'dfg/DFGAbstractValue.h',
            'dfg/DFGAdjacencyList.h',
            'dfg/DFGAssemblyHelpers.h',
            'dfg/DFGBasicBlock.h',
            'dfg/DFGByteCodeCache.h',
            'dfg/DFGByteCodeParser.h',
            'dfg/DFGCapabilities.h',
            'dfg/DFGCCallHelpers.h',
            'dfg/DFGCFAPhase.h',
            'dfg/DFGCommon.h',
            'dfg/DFGCorrectableJumpPoint.h',
            'dfg/DFGCSEPhase.h',
            'dfg/DFGDriver.h',
            'dfg/DFGEdge.h',
            'dfg/DFGFixupPhase.h',
            'dfg/DFGFPRInfo.h',
            'dfg/DFGGenerationInfo.h',
            'dfg/DFGGPRInfo.h',
            'dfg/DFGGraph.h',
            'dfg/DFGInsertionSet.h',
            'dfg/DFGJITCompiler.h',
            'dfg/DFGNode.h',
            'dfg/DFGNodeFlags.h',
            'dfg/DFGNodeType.h',
            'dfg/DFGOperations.h',
            'dfg/DFGOSREntry.h',
            'dfg/DFGOSRExit.h',
            'dfg/DFGOSRExitCompiler.h',
            'dfg/DFGPhase.h',
            'dfg/DFGPredictionPropagationPhase.h',
            'dfg/DFGRedundantPhiEliminationPhase.h',
            'dfg/DFGRegisterBank.h',
            'dfg/DFGRepatch.h',
            'dfg/DFGScoreBoard.h',
            'dfg/DFGSpeculativeJIT.h',
            'dfg/DFGThunks.h',
            'dfg/DFGVariableAccessData.h',
            'dfg/DFGVirtualRegisterAllocationPhase.h',
            'heap/CardSet.h',
            'heap/ConservativeRoots.h',
            'heap/CopiedAllocator.h',
            'heap/CopiedBlock.h',
            'heap/CopiedSpace.h',
            'heap/CopiedSpaceInlineMethods.h',
            'heap/DFGCodeBlocks.h',
            'heap/GCAssertions.h',
            'heap/Handle.h',
            'heap/HandleSet.h',
            'heap/HandleStack.h',
            'heap/HandleTypes.h',
            'heap/Heap.h',
            'heap/HeapBlock.h',
            'heap/HeapRootVisitor.h',
            'heap/ListableHandler.h',
            'heap/Local.h',
            'heap/LocalScope.h',
            'heap/MachineStackMarker.h',
            'heap/MarkedAllocator.h',
            'heap/MarkedBlock.h',
            'heap/MarkedBlockSet.h',
            'heap/MarkedSpace.h',
            'heap/MarkStack.h',
            'heap/PassWeak.h',
            'heap/SlotVisitor.h',
            'heap/Strong.h',
            'heap/StrongInlines.h',
            'heap/TinyBloomFilter.h',
            'heap/UnconditionalFinalizer.h',
            'heap/VTableSpectrum.h',
            'heap/Weak.h',
            'heap/WeakBlock.h',
            'heap/WeakHandleOwner.h',
            'heap/WeakImpl.h',
            'heap/WeakReferenceHarvester.h',
            'heap/WeakSet.h',
            'heap/WeakSetInlines.h',
            'heap/WriteBarrierSupport.h',
            'debugger/Debugger.h',
            'debugger/DebuggerActivation.h',
            'debugger/DebuggerCallFrame.h',
            'interpreter/AbstractPC.h',
            'interpreter/CachedCall.h',
            'interpreter/CallFrame.h',
            'interpreter/CallFrameClosure.h',
            'interpreter/Interpreter.h',
            'interpreter/Register.h',
            'interpreter/RegisterFile.h',
            'jit/CompactJITCodeMap.h',
            'jit/ExecutableAllocator.h',
            'jit/HostCallReturnValue.h',
            'jit/JIT.h',
            'jit/JITCode.h',
            'jit/JITCompilationEffort.h',
            'jit/JITDriver.h',
            'jit/JITExceptions.h',
            'jit/JITInlineMethods.h',
            'jit/JITStubCall.h',
            'jit/JITStubs.h',
            'jit/JITWriteBarrier.h',
            'jit/JSInterfaceJIT.h',
            'jit/SpecializedThunkJIT.h',
            'jit/ThunkGenerators.h',
            'parser/ASTBuilder.h',
            'parser/Lexer.h',
            'parser/NodeConstructors.h',
            'parser/NodeInfo.h',
            'parser/Nodes.h',
            'parser/Parser.h',
            'parser/ParserArena.h',
            'parser/ParserTokens.h',
            'parser/ResultType.h',
            'parser/SourceCode.h',
            'parser/SourceProvider.h',
            'parser/SourceProviderCache.h',
            'parser/SourceProviderCacheItem.h',
            'parser/SyntaxChecker.h',
            'profiler/CallIdentifier.h',
            'profiler/Profile.h',
            'profiler/ProfileGenerator.h',
            'profiler/ProfileNode.h',
            'profiler/Profiler.h',
            'runtime/ArgList.h',
            'runtime/Arguments.h',
            'runtime/ArrayConstructor.h',
            'runtime/ArrayPrototype.h',
            'runtime/BatchedTransitionOptimizer.h',
            'runtime/BigInteger.h',
            'runtime/BooleanConstructor.h',
            'runtime/BooleanObject.h',
            'runtime/BooleanPrototype.h',
            'runtime/CachedTranscendentalFunction.h',
            'runtime/CallData.h',
            'runtime/ClassInfo.h',
            'runtime/CodeSpecializationKind.h',
            'runtime/CommonIdentifiers.h',
            'runtime/CommonSlowPaths.h',
            'runtime/Completion.h',
            'runtime/ConstructData.h',
            'runtime/DateConstructor.h',
            'runtime/DateConversion.h',
            'runtime/DateInstance.h',
            'runtime/DateInstanceCache.h',
            'runtime/DatePrototype.h',
            'runtime/Error.h',
            'runtime/ErrorConstructor.h',
            'runtime/ErrorInstance.h',
            'runtime/ErrorPrototype.h',
            'runtime/ExceptionHelpers.h',
            'runtime/Executable.h',
            'runtime/ExecutionHarness.h',
            'runtime/FunctionConstructor.h',
            'runtime/FunctionPrototype.h',
            'runtime/GCActivityCallback.h',
            'runtime/GetterSetter.h',
            'runtime/Identifier.h',
            'runtime/InitializeThreading.h',
            'runtime/InternalFunction.h',
            'runtime/Intrinsic.h',
            'runtime/JSActivation.h',
            'runtime/JSAPIValueWrapper.h',
            'runtime/JSArray.h',
            'runtime/JSBoundFunction.h',
            'runtime/JSCell.h',
            'runtime/JSChunk.h',
            'runtime/JSDateMath.h',
            'runtime/JSExportMacros.h',
            'runtime/JSFunction.h',
            'runtime/JSGlobalData.h',
            'runtime/JSGlobalObject.h',
            'runtime/JSGlobalObjectFunctions.h',
            'runtime/JSGlobalThis.h',
            'runtime/JSLock.h',
            'runtime/JSNotAnObject.h',
            'runtime/JSObject.h',
            'runtime/JSONObject.h',
            'runtime/JSPropertyNameIterator.h',
            'runtime/JSStaticScopeObject.h',
            'runtime/JSString.h',
            'runtime/JSStringBuilder.h',
            'runtime/JSStringJoiner.h',
            'runtime/JSType.h',
            'runtime/JSTypeInfo.h',
            'runtime/JSValue.h',
            'runtime/JSValueInlineMethods.h',
            'runtime/JSVariableObject.h',
            'runtime/JSWrapperObject.h',
            'runtime/LiteralParser.h',
            'runtime/Lookup.h',
            'runtime/MatchResult.h',
            'runtime/MathObject.h',
            'runtime/MemoryStatistics.h',
            'runtime/NativeErrorConstructor.h',
            'runtime/NativeErrorPrototype.h',
            'runtime/NumberConstructor.h',
            'runtime/NumberObject.h',
            'runtime/NumberPrototype.h',
            'runtime/NumericStrings.h',
            'runtime/ObjectConstructor.h',
            'runtime/ObjectPrototype.h',
            'runtime/Operations.h',
            'runtime/Options.h',
            'runtime/PropertyDescriptor.h',
            'runtime/PropertyMapHashTable.h',
            'runtime/PropertyNameArray.h',
            'runtime/PropertySlot.h',
            'runtime/Protect.h',
            'runtime/PutPropertySlot.h',
            'runtime/RegExp.h',
            'runtime/RegExpCache.h',
            'runtime/RegExpCachedResult.h',
            'runtime/RegExpConstructor.h',
            'runtime/RegExpKey.h',
            'runtime/RegExpMatchesArray.h',
            'runtime/RegExpObject.h',
            'runtime/RegExpPrototype.h',
            'runtime/SamplingCounter.h',
            'runtime/ScopeChain.h',
            'runtime/ScopeChainMark.h',
            'runtime/SmallStrings.h',
            'runtime/StorageBarrier.h',
            'runtime/StrictEvalActivation.h',
            'runtime/StringConstructor.h',
            'runtime/StringObject.h',
            'runtime/StringPrototype.h',
            'runtime/StringRecursionChecker.h',
            'runtime/Structure.h',
            'runtime/StructureChain.h',
            'runtime/StructureTransitionTable.h',
            'runtime/SymbolTable.h',
            'runtime/Terminator.h',
            'runtime/TimeoutChecker.h',
            'runtime/Tracing.h',
            'runtime/Uint16WithFraction.h',
            'runtime/UString.h',
            'runtime/UStringBuilder.h',
            'runtime/UStringConcatenate.h',
            'runtime/WeakGCMap.h',
            'runtime/WeakRandom.h',
            'runtime/WriteBarrier.h',
            'yarr/Yarr.h',
            'yarr/YarrCanonicalizeUCS2.h',
            'yarr/YarrInterpreter.h',
            'yarr/YarrJIT.h',
            'yarr/YarrParser.h',
            'yarr/YarrPattern.h',
            'yarr/YarrSyntaxChecker.h',
        ],
        'javascriptcore_files': [
            'API/JSBase.cpp',
            'API/JSCallbackConstructor.cpp',
            'API/JSCallbackFunction.cpp',
            'API/JSCallbackObject.cpp',
            'API/JSClassRef.cpp',
            'API/JSContextRef.cpp',
            'API/JSMemoryStatsSCE.cpp',
            'API/JSObjectRef.cpp',
            'API/JSProfilerPrivate.cpp',
            'API/JSStringRef.cpp',
            'API/JSStringRefBSTR.cpp',
            'API/JSStringRefCF.cpp',
            'API/JSValueRef.cpp',
            'API/JSWeakObjectMapRefPrivate.cpp',
            'API/OpaqueJSString.cpp',
            'assembler/ARMAssembler.cpp',
            'assembler/ARMv7Assembler.cpp',
            'assembler/MacroAssemblerARM.cpp',
            'assembler/MacroAssemblerSH4.cpp',
            'bytecode/CallLinkInfo.cpp',
            'bytecode/CallLinkStatus.cpp',
            'bytecode/CodeBlock.cpp',
            'bytecode/DFGExitProfile.cpp',
            'bytecode/ExecutionCounter.cpp',
            'bytecode/GetByIdStatus.cpp',
            'bytecode/JumpTable.cpp',
            'bytecode/LazyOperandValueProfile.cpp',
            'bytecode/MethodCallLinkInfo.cpp',
            'bytecode/MethodCallLinkStatus.cpp',
            'bytecode/MethodOfGettingAValueProfile.cpp',
            'bytecode/Opcode.cpp',
            'bytecode/PolymorphicPutByIdList.cpp',
            'bytecode/PredictedType.cpp',
            'bytecode/PutByIdStatus.cpp',
            'bytecode/SamplingTool.cpp',
            'bytecode/StructureStubInfo.cpp',
            'bytecompiler/BytecodeGenerator.cpp',
            'bytecompiler/NodesCodegen.cpp',
            'debugger/Debugger.cpp',
            'debugger/DebuggerActivation.cpp',
            'debugger/DebuggerCallFrame.cpp',
            'dfg/DFGAbstractState.cpp',
            'dfg/DFGAssemblyHelpers.cpp',
            'dfg/DFGByteCodeParser.cpp',
            'dfg/DFGCapabilities.cpp',
            'dfg/DFGCFAPhase.cpp',
            'dfg/DFGCorrectableJumpPoint.cpp',
            'dfg/DFGCSEPhase.cpp',
            'dfg/DFGDriver.cpp',
            'dfg/DFGFixupPhase.cpp',
            'dfg/DFGGraph.cpp',
            'dfg/DFGJITCompiler.cpp',
            'dfg/DFGNodeFlags.cpp',
            'dfg/DFGOperations.cpp',
            'dfg/DFGOSREntry.cpp',
            'dfg/DFGOSRExit.cpp',
            'dfg/DFGOSRExitCompiler.cpp',
            'dfg/DFGOSRExitCompiler32_64.cpp',
            'dfg/DFGOSRExitCompiler64.cpp',
            'dfg/DFGPhase.cpp',
            'dfg/DFGPredictionPropagationPhase.cpp',
            'dfg/DFGRedundantPhiEliminationPhase.cpp',
            'dfg/DFGRepatch.cpp',
            'dfg/DFGSpeculativeJIT.cpp',
            'dfg/DFGSpeculativeJIT32_64.cpp',
            'dfg/DFGSpeculativeJIT64.cpp',
            'dfg/DFGThunks.cpp',
            'dfg/DFGVirtualRegisterAllocationPhase.cpp',
            'heap/ConservativeRoots.cpp',
            'heap/CopiedSpace.cpp',
            'heap/DFGCodeBlocks.cpp',
            'heap/HandleSet.cpp',
            'heap/HandleStack.cpp',
            'heap/BlockAllocator.cpp',
            'heap/Heap.cpp',
            'heap/MachineStackMarker.cpp',
            'heap/MarkedAllocator.cpp',
            'heap/MarkedBlock.cpp',
            'heap/MarkedSpace.cpp',
            'heap/MarkStack.cpp',
            'heap/VTableSpectrum.cpp',
            'heap/WeakBlock.cpp',
            'heap/WeakHandleOwner.cpp',
            'heap/WeakSet.cpp',
            'heap/WriteBarrierSupport.cpp',
            'interpreter/AbstractPC.cpp',
            'interpreter/CallFrame.cpp',
            'interpreter/Interpreter.cpp',
            'interpreter/RegisterFile.cpp',
            'jit/ExecutableAllocator.cpp',
            'jit/ExecutableAllocatorFixedVMPool.cpp',
            'jit/HostCallReturnValue.cpp',
            'jit/JIT.cpp',
            'jit/JITArithmetic.cpp',
            'jit/JITArithmetic32_64.cpp',
            'jit/JITCall.cpp',
            'jit/JITCall32_64.cpp',
            'jit/JITExceptions.cpp',
            'jit/JITOpcodes.cpp',
            'jit/JITOpcodes32_64.cpp',
            'jit/JITPropertyAccess.cpp',
            'jit/JITPropertyAccess32_64.cpp',
            'jit/JITStubs.cpp',
            'jit/ThunkGenerators.cpp',
            'parser/Lexer.cpp',
            'parser/Nodes.cpp',
            'parser/Parser.cpp',
            'parser/ParserArena.cpp',
            'parser/SourceProviderCache.cpp',
            'profiler/Profile.cpp',
            'profiler/ProfileGenerator.cpp',
            'profiler/ProfileNode.cpp',
            'profiler/Profiler.cpp',
            'runtime/ArgList.cpp',
            'runtime/Arguments.cpp',
            'runtime/ArrayConstructor.cpp',
            'runtime/ArrayPrototype.cpp',
            'runtime/BooleanConstructor.cpp',
            'runtime/BooleanObject.cpp',
            'runtime/BooleanPrototype.cpp',
            'runtime/CallData.cpp',
            'runtime/CommonIdentifiers.cpp',
            'runtime/Completion.cpp',
            'runtime/ConstructData.cpp',
            'runtime/DateConstructor.cpp',
            'runtime/DateConversion.cpp',
            'runtime/DateInstance.cpp',
            'runtime/DatePrototype.cpp',
            'runtime/Error.cpp',
            'runtime/ErrorConstructor.cpp',
            'runtime/ErrorInstance.cpp',
            'runtime/ErrorPrototype.cpp',
            'runtime/ExceptionHelpers.cpp',
            'runtime/Executable.cpp',
            'runtime/FunctionConstructor.cpp',
            'runtime/FunctionPrototype.cpp',
            'runtime/GCActivityCallback.cpp',
            'runtime/GCActivityCallbackCF.cpp',
            'runtime/GetterSetter.cpp',
            'runtime/Identifier.cpp',
            'runtime/InitializeThreading.cpp',
            'runtime/InternalFunction.cpp',
            'runtime/JSActivation.cpp',
            'runtime/JSAPIValueWrapper.cpp',
            'runtime/JSArray.cpp',
            'runtime/JSBoundFunction.cpp',
            'runtime/JSCell.cpp',
            'runtime/JSChunk.cpp',
            'runtime/JSDateMath.cpp',
            'runtime/JSFunction.cpp',
            'runtime/JSGlobalData.cpp',
            'runtime/JSGlobalObject.cpp',
            'runtime/JSGlobalObjectFunctions.cpp',
            'runtime/JSGlobalThis.cpp',
            'runtime/JSLock.cpp',
            'runtime/JSNotAnObject.cpp',
            'runtime/JSObject.cpp',
            'runtime/JSONObject.cpp',
            'runtime/JSPropertyNameIterator.cpp',
            'runtime/JSStaticScopeObject.cpp',
            'runtime/JSString.cpp',
            'runtime/JSStringJoiner.cpp',
            'runtime/JSValue.cpp',
            'runtime/JSVariableObject.cpp',
            'runtime/JSWrapperObject.cpp',
            'runtime/LiteralParser.cpp',
            'runtime/Lookup.cpp',
            'runtime/MathObject.cpp',
            'runtime/MemoryStatistics.cpp',
            'runtime/NativeErrorConstructor.cpp',
            'runtime/NativeErrorPrototype.cpp',
            'runtime/NumberConstructor.cpp',
            'runtime/NumberObject.cpp',
            'runtime/NumberPrototype.cpp',
            'runtime/ObjectConstructor.cpp',
            'runtime/ObjectPrototype.cpp',
            'runtime/Operations.cpp',
            'runtime/Options.cpp',
            'runtime/PropertyDescriptor.cpp',
            'runtime/PropertyNameArray.cpp',
            'runtime/PropertySlot.cpp',
            'runtime/RegExp.cpp',
            'runtime/RegExpCache.cpp',
            'runtime/RegExpCachedResult.cpp',
            'runtime/RegExpConstructor.cpp',
            'runtime/RegExpMatchesArray.cpp',
            'runtime/RegExpObject.cpp',
            'runtime/RegExpPrototype.cpp',
            'runtime/SamplingCounter.cpp',
            'runtime/ScopeChain.cpp',
            'runtime/SmallStrings.cpp',
            'runtime/StrictEvalActivation.cpp',
            'runtime/StringConstructor.cpp',
            'runtime/StringObject.cpp',
            'runtime/StringPrototype.cpp',
            'runtime/StringRecursionChecker.cpp',
            'runtime/Structure.cpp',
            'runtime/StructureChain.cpp',
            'runtime/TimeoutChecker.cpp',
            'runtime/UString.cpp',
            'tools/CodeProfile.cpp',
            'tools/CodeProfiling.cpp',
            'yarr/YarrCanonicalizeUCS2.cpp',
            'yarr/YarrInterpreter.cpp',
            'yarr/YarrJIT.cpp',
            'yarr/YarrPattern.cpp',
            'yarr/YarrSyntaxChecker.cpp',
        ],
        'javascriptcore_derived_source_files': [
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/Lexer.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/RegExpJitTables.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/TracingDtrace.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/ArrayConstructor.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/ArrayPrototype.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/BooleanPrototype.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/DateConstructor.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/DatePrototype.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/ErrorPrototype.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/JSGlobalObject.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/JSONObject.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/MathObject.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/NumberConstructor.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/NumberPrototype.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/ObjectConstructor.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/ObjectPrototype.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/RegExpConstructor.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/RegExpObject.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/RegExpPrototype.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/StringConstructor.lut.h',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/StringPrototype.lut.h',
        ],
        'minidom_files': [
            'API/tests/JSNode.c',
            'API/tests/JSNode.h',
            'API/tests/JSNodeList.c',
            'API/tests/JSNodeList.h',
            'API/tests/Node.c',
            'API/tests/Node.h',
            'API/tests/NodeList.c',
            'API/tests/NodeList.h',
            'API/tests/minidom.c',
        ],
        'minidom_support_files': [
            'API/tests/minidom.js',
        ],
        'testapi_files': [
            'API/tests/testapi.c',
        ],
        'testapi_support_files': [
            'API/tests/testapi.js',
        ],
        'jsc_files': [
            'jsc.cpp',
        ],
        'jscore_include_dirs' : [
            '.',
            '..',
            'API',
            'ForwardingHeaders',
            'assembler',
            'bytecode',
            'bytecompiler',
            'debugger',
            'dfg',
            'heap',
            'interpreter',
            'jit',
            'jit_detached',
            'llint',
            'parser',
            'profiler',
            'runtime',
            'tools',
            'yarr',
            '<(PRODUCT_DIR)/DerivedSources/JavaScriptCore/',
       ],
    }
}
