/*
 * Copyright (C) 2016 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef DebugFontData_h
#define DebugFontData_h

static const int DebugFontWidth = 8;
static const int DebugFontHeight = 8;
static const int FirstDebugFontChar = 32;
static const int LastDebugFontChars = 151;
static const int NumDebugFontChars = LastDebugFontChars - FirstDebugFontChar + 1;
static const unsigned char DebugFontData[NumDebugFontChars][DebugFontHeight] =
{
    { // 32
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 33
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x00, // ........
        0x20, // ..*.....
        0x00, // ........
    }, { // 34
        0x50, // .*.*....
        0x50, // .*.*....
        0x50, // .*.*....
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 35
        0x50, // .*.*....
        0x50, // .*.*....
        0xf8, // *****...
        0x50, // .*.*....
        0xf8, // *****...
        0x50, // .*.*....
        0x50, // .*.*....
        0x00, // ........
    }, { // 36
        0x20, // ..*.....
        0x78, // .****...
        0xa0, // *.*.....
        0x70, // .***....
        0x28, // ..*.*...
        0xf0, // ****....
        0x20, // ..*.....
        0x00, // ........
    }, { // 37
        0xc0, // **......
        0xc8, // **..*...
        0x10, // ...*....
        0x20, // ..*.....
        0x40, // .*......
        0x98, // *..**...
        0x18, // ...**...
        0x00, // ........
    }, { // 38
        0x40, // .*......
        0xa0, // *.*.....
        0xa0, // *.*.....
        0x40, // .*......
        0xa8, // *.*.*...
        0x90, // *..*....
        0x68, // .**.*...
        0x00, // ........
    }, { // 39
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 40
        0x20, // ..*.....
        0x40, // .*......
        0x80, // *.......
        0x80, // *.......
        0x80, // *.......
        0x40, // .*......
        0x20, // ..*.....
        0x00, // ........
    }, { // 41
        0x20, // ..*.....
        0x10, // ...*....
        0x08, // ....*...
        0x08, // ....*...
        0x08, // ....*...
        0x10, // ...*....
        0x20, // ..*.....
        0x00, // ........
    }, { // 42
        0x20, // ..*.....
        0xa8, // *.*.*...
        0x70, // .***....
        0xa8, // *.*.*...
        0x70, // .***....
        0xa8, // *.*.*...
        0x20, // ..*.....
        0x00, // ........
    }, { // 43
        0x00, // ........
        0x20, // ..*.....
        0x20, // ..*.....
        0xf8, // *****...
        0x20, // ..*.....
        0x20, // ..*.....
        0x00, // ........
        0x00, // ........
    }, { // 44
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x20, // ..*.....
        0x20, // ..*.....
        0x40, // .*......
    }, { // 45
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0xf8, // *****...
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 46
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x20, // ..*.....
        0x00, // ........
    }, { // 47
        0x00, // ........
        0x08, // ....*...
        0x10, // ...*....
        0x20, // ..*.....
        0x40, // .*......
        0x80, // *.......
        0x00, // ........
        0x00, // ........
    }, { // 48
        0x70, // .***....
        0x88, // *...*...
        0x98, // *..**...
        0xa8, // *.*.*...
        0xc8, // **..*...
        0x88, // *...*...
        0x70, // .***....
        0x00, // ........
    }, { // 49
        0x20, // ..*.....
        0x60, // .**.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x70, // .***....
        0x00, // ........
    }, { // 50
        0x70, // .***....
        0x88, // *...*...
        0x08, // ....*...
        0x30, // ..**....
        0x40, // .*......
        0x80, // *.......
        0xf8, // *****...
        0x00, // ........
    }, { // 51
        0xf8, // *****...
        0x08, // ....*...
        0x10, // ...*....
        0x30, // ..**....
        0x08, // ....*...
        0x88, // *...*...
        0x70, // .***....
        0x00, // ........
    }, { // 52
        0x10, // ...*....
        0x30, // ..**....
        0x50, // .*.*....
        0x90, // *..*....
        0xf8, // *****...
        0x10, // ...*....
        0x10, // ...*....
        0x00, // ........
    }, { // 53
        0xf8, // *****...
        0x80, // *.......
        0xf0, // ****....
        0x08, // ....*...
        0x08, // ....*...
        0x88, // *...*...
        0x70, // .***....
        0x00, // ........
    }, { // 54
        0x38, // ..***...
        0x40, // .*......
        0x80, // *.......
        0xf0, // ****....
        0x88, // *...*...
        0x88, // *...*...
        0x70, // .***....
        0x00, // ........
    }, { // 55
        0xf8, // *****...
        0x08, // ....*...
        0x10, // ...*....
        0x20, // ..*.....
        0x40, // .*......
        0x40, // .*......
        0x40, // .*......
        0x00, // ........
    }, { // 56
        0x70, // .***....
        0x88, // *...*...
        0x88, // *...*...
        0x70, // .***....
        0x88, // *...*...
        0x88, // *...*...
        0x70, // .***....
        0x00, // ........
    }, { // 57
        0x70, // .***....
        0x88, // *...*...
        0x88, // *...*...
        0x78, // .****...
        0x08, // ....*...
        0x10, // ...*....
        0xe0, // ***.....
        0x00, // ........
    }, { // 58
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x20, // ..*.....
        0x00, // ........
        0x20, // ..*.....
        0x00, // ........
        0x00, // ........
    }, { // 59
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x20, // ..*.....
        0x00, // ........
        0x20, // ..*.....
        0x20, // ..*.....
        0x40, // .*......
    }, { // 60
        0x10, // ...*....
        0x20, // ..*.....
        0x40, // .*......
        0x80, // *.......
        0x40, // .*......
        0x20, // ..*.....
        0x10, // ...*....
        0x00, // ........
    }, { // 61
        0x00, // ........
        0x00, // ........
        0xf8, // *****...
        0x00, // ........
        0xf8, // *****...
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 62
        0x40, // .*......
        0x20, // ..*.....
        0x10, // ...*....
        0x08, // ....*...
        0x10, // ...*....
        0x20, // ..*.....
        0x40, // .*......
        0x00, // ........
    }, { // 63
        0x70, // .***....
        0x88, // *...*...
        0x10, // ...*....
        0x20, // ..*.....
        0x20, // ..*.....
        0x00, // ........
        0x20, // ..*.....
        0x00, // ........
    }, { // 64
        0x70, // .***....
        0x88, // *...*...
        0xa8, // *.*.*...
        0xb8, // *.***...
        0xb0, // *.**....
        0x80, // *.......
        0x78, // .****...
        0x00, // ........
    }, { // 65
        0x20, // ..*.....
        0x50, // .*.*....
        0x88, // *...*...
        0x88, // *...*...
        0xf8, // *****...
        0x88, // *...*...
        0x88, // *...*...
        0x00, // ........
    }, { // 66
        0xf0, // ****....
        0x88, // *...*...
        0x88, // *...*...
        0xf0, // ****....
        0x88, // *...*...
        0x88, // *...*...
        0xf0, // ****....
        0x00, // ........
    }, { // 67
        0x70, // .***....
        0x88, // *...*...
        0x80, // *.......
        0x80, // *.......
        0x80, // *.......
        0x88, // *...*...
        0x70, // .***....
        0x00, // ........
    }, { // 68
        0xf0, // ****....
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0xf0, // ****....
        0x00, // ........
    }, { // 69
        0xf8, // *****...
        0x80, // *.......
        0x80, // *.......
        0xf0, // ****....
        0x80, // *.......
        0x80, // *.......
        0xf8, // *****...
        0x00, // ........
    }, { // 70
        0xf8, // *****...
        0x80, // *.......
        0x80, // *.......
        0xf0, // ****....
        0x80, // *.......
        0x80, // *.......
        0x80, // *.......
        0x00, // ........
    }, { // 71
        0x70, // .***....
        0x88, // *...*...
        0x80, // *.......
        0x80, // *.......
        0x98, // *..**...
        0x88, // *...*...
        0x78, // .****...
        0x00, // ........
    }, { // 72
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0xf8, // *****...
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0x00, // ........
    }, { // 73
        0x70, // .***....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x70, // .***....
        0x00, // ........
    }, { // 74
        0x08, // ....*...
        0x08, // ....*...
        0x08, // ....*...
        0x08, // ....*...
        0x08, // ....*...
        0x88, // *...*...
        0x70, // .***....
        0x00, // ........
    }, { // 75
        0x88, // *...*...
        0x90, // *..*....
        0xa0, // *.*.....
        0xc0, // **......
        0xa0, // *.*.....
        0x90, // *..*....
        0x88, // *...*...
        0x00, // ........
    }, { // 76
        0x80, // *.......
        0x80, // *.......
        0x80, // *.......
        0x80, // *.......
        0x80, // *.......
        0x80, // *.......
        0xf8, // *****...
        0x00, // ........
    }, { // 77
        0x88, // *...*...
        0xd8, // **.**...
        0xa8, // *.*.*...
        0xa8, // *.*.*...
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0x00, // ........
    }, { // 78
        0x88, // *...*...
        0x88, // *...*...
        0xc8, // **..*...
        0xa8, // *.*.*...
        0x98, // *..**...
        0x88, // *...*...
        0x88, // *...*...
        0x00, // ........
    }, { // 79
        0x70, // .***....
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0x70, // .***....
        0x00, // ........
    }, { // 80
        0xf0, // ****....
        0x88, // *...*...
        0x88, // *...*...
        0xf0, // ****....
        0x80, // *.......
        0x80, // *.......
        0x80, // *.......
        0x00, // ........
    }, { // 81
        0x70, // .***....
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0xa8, // *.*.*...
        0x90, // *..*....
        0x68, // .**.*...
        0x00, // ........
    }, { // 82
        0xf0, // ****....
        0x88, // *...*...
        0x88, // *...*...
        0xf0, // ****....
        0xa0, // *.*.....
        0x90, // *..*....
        0x88, // *...*...
        0x00, // ........
    }, { // 83
        0x70, // .***....
        0x88, // *...*...
        0x80, // *.......
        0x70, // .***....
        0x08, // ....*...
        0x88, // *...*...
        0x70, // .***....
        0x00, // ........
    }, { // 84
        0xf8, // *****...
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x00, // ........
    }, { // 85
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0x70, // .***....
        0x00, // ........
    }, { // 86
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0x50, // .*.*....
        0x20, // ..*.....
        0x00, // ........
    }, { // 87
        0x88, // *...*...
        0x88, // *...*...
        0x88, // *...*...
        0xa8, // *.*.*...
        0xa8, // *.*.*...
        0xd8, // **.**...
        0x88, // *...*...
        0x00, // ........
    }, { // 88
        0x88, // *...*...
        0x88, // *...*...
        0x50, // .*.*....
        0x20, // ..*.....
        0x50, // .*.*....
        0x88, // *...*...
        0x88, // *...*...
        0x00, // ........
    }, { // 89
        0x88, // *...*...
        0x88, // *...*...
        0x50, // .*.*....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x00, // ........
    }, { // 90
        0xf8, // *****...
        0x08, // ....*...
        0x10, // ...*....
        0x20, // ..*.....
        0x40, // .*......
        0x80, // *.......
        0xf8, // *****...
        0x00, // ........
    }, { // 91
        0xf8, // *****...
        0xc0, // **......
        0xc0, // **......
        0xc0, // **......
        0xc0, // **......
        0xc0, // **......
        0xf8, // *****...
        0x00, // ........
    }, { // 92
        0x00, // ........
        0x80, // *.......
        0x40, // .*......
        0x20, // ..*.....
        0x10, // ...*....
        0x08, // ....*...
        0x00, // ........
        0x00, // ........
    }, { // 93
        0xf8, // *****...
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0xf8, // *****...
        0x00, // ........
    }, { // 94
        0x00, // ........
        0x00, // ........
        0x20, // ..*.....
        0x50, // .*.*....
        0x88, // *...*...
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 95
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0xf8, // *****...
    }, { // 96
        0x40, // .*......
        0x20, // ..*.....
        0x10, // ...*....
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 97
        0x00, // ........
        0x00, // ........
        0x60, // .**.....
        0x98, // *..**...
        0x88, // *...*...
        0x98, // *..**...
        0x68, // .**.*...
        0x00, // ........
    }, { // 98
        0x40, // .*......
        0x40, // .*......
        0x50, // .*.*....
        0x68, // .**.*...
        0x48, // .*..*...
        0x48, // .*..*...
        0x30, // ..**....
        0x00, // ........
    }, { // 99
        0x00, // ........
        0x00, // ........
        0x38, // ..***...
        0x40, // .*......
        0x40, // .*......
        0x40, // .*......
        0x38, // ..***...
        0x00, // ........
    }, { // 100
        0x08, // ....*...
        0x08, // ....*...
        0x28, // ..*.*...
        0x58, // .*.**...
        0x48, // .*..*...
        0x48, // .*..*...
        0x30, // ..**....
        0x00, // ........
    }, { // 101
        0x00, // ........
        0x00, // ........
        0x30, // ..**....
        0x48, // .*..*...
        0x70, // .***....
        0x40, // .*......
        0x38, // ..***...
        0x00, // ........
    }, { // 102
        0x30, // ..**....
        0x28, // ..*.*...
        0x20, // ..*.....
        0x70, // .***....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x00, // ........
    }, { // 103
        0x00, // ........
        0x00, // ........
        0x30, // ..**....
        0x48, // .*..*...
        0x48, // .*..*...
        0x38, // ..***...
        0x08, // ....*...
        0x38, // ..***...
    }, { // 104
        0x40, // .*......
        0x40, // .*......
        0x50, // .*.*....
        0x68, // .**.*...
        0x48, // .*..*...
        0x48, // .*..*...
        0x48, // .*..*...
        0x00, // ........
    }, { // 105
        0x20, // ..*.....
        0x00, // ........
        0x60, // .**.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x70, // .***....
        0x00, // ........
    }, { // 106
        0x08, // ....*...
        0x00, // ........
        0x08, // ....*...
        0x08, // ....*...
        0x08, // ....*...
        0x08, // ....*...
        0x48, // .*..*...
        0x70, // .***....
    }, { // 107
        0x40, // .*......
        0x40, // .*......
        0x48, // .*..*...
        0x50, // .*.*....
        0x70, // .***....
        0x48, // .*..*...
        0x48, // .*..*...
        0x00, // ........
    }, { // 108
        0x60, // .**.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x70, // .***....
        0x00, // ........
    }, { // 109
        0x00, // ........
        0x00, // ........
        0xd0, // **.*....
        0xa8, // *.*.*...
        0xa8, // *.*.*...
        0xa8, // *.*.*...
        0x88, // *...*...
        0x00, // ........
    }, { // 110
        0x00, // ........
        0x00, // ........
        0x70, // .***....
        0x48, // .*..*...
        0x48, // .*..*...
        0x48, // .*..*...
        0x48, // .*..*...
        0x00, // ........
    }, { // 111
        0x00, // ........
        0x00, // ........
        0x30, // ..**....
        0x48, // .*..*...
        0x48, // .*..*...
        0x48, // .*..*...
        0x30, // ..**....
        0x00, // ........
    }, { // 112
        0x00, // ........
        0x00, // ........
        0x30, // ..**....
        0x48, // .*..*...
        0x48, // .*..*...
        0x70, // .***....
        0x40, // .*......
        0x40, // .*......
    }, { // 113
        0x00, // ........
        0x00, // ........
        0x38, // ..***...
        0x48, // .*..*...
        0x48, // .*..*...
        0x38, // ..***...
        0x08, // ....*...
        0x08, // ....*...
    }, { // 114
        0x00, // ........
        0x00, // ........
        0x58, // .*.**...
        0x68, // .**.*...
        0x40, // .*......
        0x40, // .*......
        0x40, // .*......
        0x00, // ........
    }, { // 115
        0x00, // ........
        0x00, // ........
        0x38, // ..***...
        0x40, // .*......
        0x30, // ..**....
        0x08, // ....*...
        0x70, // .***....
        0x00, // ........
    }, { // 116
        0x20, // ..*.....
        0x20, // ..*.....
        0x70, // .***....
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x30, // ..**....
        0x00, // ........
    }, { // 117
        0x00, // ........
        0x00, // ........
        0x48, // .*..*...
        0x48, // .*..*...
        0x48, // .*..*...
        0x58, // .*.**...
        0x28, // ..*.*...
        0x00, // ........
    }, { // 118
        0x00, // ........
        0x00, // ........
        0x88, // *...*...
        0x88, // *...*...
        0x50, // .*.*....
        0x50, // .*.*....
        0x20, // ..*.....
        0x00, // ........
    }, { // 119
        0x00, // ........
        0x00, // ........
        0x88, // *...*...
        0xa8, // *.*.*...
        0xa8, // *.*.*...
        0xa8, // *.*.*...
        0xd0, // **.*....
        0x00, // ........
    }, { // 120
        0x00, // ........
        0x00, // ........
        0xd8, // **.**...
        0x50, // .*.*....
        0x20, // ..*.....
        0x50, // .*.*....
        0xd8, // **.**...
        0x00, // ........
    }, { // 121
        0x00, // ........
        0x00, // ........
        0x48, // .*..*...
        0x48, // .*..*...
        0x58, // .*.**...
        0x28, // ..*.*...
        0x08, // ....*...
        0x18, // ...**...
    }, { // 122
        0x00, // ........
        0x00, // ........
        0x78, // .****...
        0x08, // ....*...
        0x30, // ..**....
        0x40, // .*......
        0x78, // .****...
        0x00, // ........
    }, { // 123
        0x18, // ...**...
        0x60, // .**.....
        0x40, // .*......
        0x20, // ..*.....
        0x40, // .*......
        0x60, // .**.....
        0x18, // ...**...
        0x00, // ........
    }, { // 124
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x00, // ........
        0x20, // ..*.....
        0x20, // ..*.....
        0x20, // ..*.....
        0x00, // ........
    }, { // 125
        0xc0, // **......
        0x30, // ..**....
        0x10, // ...*....
        0x20, // ..*.....
        0x10, // ...*....
        0x30, // ..**....
        0xc0, // **......
        0x00, // ........
    }, { // 126
        0x40, // .*......
        0xa8, // *.*.*...
        0x10, // ...*....
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 127
        0xff, // ********
        0xff, // ********
        0xff, // ********
        0xff, // ********
        0xff, // ********
        0xff, // ********
        0xff, // ********
        0xff, // ********
    }, { // 128
        0x00, // ........
        0x00, // ........
        0x18, // ...**...
        0x3c, // ..****..
        0x3c, // ..****..
        0x18, // ...**...
        0x00, // ........
        0x00, // ........
    }, { // 129
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0xf8, // *****...
        0xf8, // *****...
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 130
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 131
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0xf8, // *****...
        0xf8, // *****...
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 132
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x1f, // ...*****
        0x1f, // ...*****
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 133
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0xff, // ********
        0xff, // ********
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 134
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0x1f, // ...*****
        0x1f, // ...*****
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 135
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0xff, // ********
        0xff, // ********
        0x00, // ........
        0x00, // ........
        0x00, // ........
    }, { // 136
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
    }, { // 137
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0xf8, // *****...
        0xf8, // *****...
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
    }, { // 138
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
    }, { // 139
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0xf8, // *****...
        0xf8, // *****...
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
    }, { // 140
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0x1f, // ...*****
        0x1f, // ...*****
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
    }, { // 141
        0x00, // ........
        0x00, // ........
        0x00, // ........
        0xff, // ********
        0xff, // ********
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
    }, { // 142
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0x1f, // ...*****
        0x1f, // ...*****
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
    }, { // 143
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
        0xff, // ********
        0xff, // ********
        0x18, // ...**...
        0x18, // ...**...
        0x18, // ...**...
    }, { // 144
        0x07, // .....***
        0x3c, // ..****..
        0x60, // .**.....
        0xc0, // **......
        0xc0, // **......
        0x60, // .**.....
        0x3c, // ..****..
        0x07, // .....***
    }, { // 145
        0xc0, // **......
        0x30, // ..**....
        0x0c, // ....**..
        0x03, // ......**
        0x03, // ......**
        0x0c, // ....**..
        0x30, // ..**....
        0xc0, // **......
    }, { // 146
        0xff, // ********
        0xc0, // **......
        0xc0, // **......
        0xc0, // **......
        0xc0, // **......
        0xc0, // **......
        0xc0, // **......
        0xff, // ********
    }, { // 147
        0x01, // .......*
        0x03, // ......**
        0x06, // .....**.
        0x0c, // ....**..
        0x18, // ...**...
        0x30, // ..**....
        0x60, // .**.....
        0xff, // ********
    }, { // 148
        0xc0, // **......
        0x78, // .****...
        0x0c, // ....**..
        0x06, // .....**.
        0x06, // .....**.
        0x0c, // ....**..
        0x78, // .****...
        0xc0, // **......
    }, { // 149
        0x06, // .....**.
        0x18, // ...**...
        0x60, // .**.....
        0x80, // *.......
        0x80, // *.......
        0x60, // .**.....
        0x18, // ...**...
        0x06, // .....**.
    }, { // 150
        0xfe, // *******.
        0x06, // .....**.
        0x06, // .....**.
        0x06, // .....**.
        0x06, // .....**.
        0x06, // .....**.
        0x06, // .....**.
        0xfe, // *******.
    }, { // 151
        0x00, // ........
        0x80, // *.......
        0xc0, // **......
        0x60, // .**.....
        0x30, // ..**....
        0x18, // ...**...
        0x0c, // ....**..
        0xfe, // *******.
    }
};

#endif // DebugFontData_h
