/*
 * Copyright (C) 2006, 2007, 2008, 2013 Apple Inc. All rights reserved.
 * Copyright (C) 2006 Samuel Weinig <sam.weinig@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#if defined(HAVE_CONFIG_H) && HAVE_CONFIG_H && defined(BUILDING_WITH_CMAKE)
#include "cmakeconfig.h"
#endif

#include <wtf/Platform.h>
#include <wtf/ExportMacros.h>
#if !defined(BUILDING_WTF)
#include "JSExportMacros.h"
#endif

#if OS(WINDOWS)

#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x601
#endif

#ifndef WINVER
#define WINVER 0x0601
#endif

#if !COMPILER(MSVC7_OR_LOWER)
// We need to define this before the first #include of stdlib.h or it won't contain rand_s.
#ifndef _CRT_RAND_S
#define _CRT_RAND_S
#endif
#endif // !COMPILER(MSVC7_OR_LOWER

#endif // OS(WINDOWS)

#ifdef __cplusplus
#undef new
#undef delete
#include <wtf/FastMalloc.h>
#endif

#include <wtf/DisallowCType.h>

#if COMPILER(MSVC)
#define SKIP_STATIC_CONSTRUCTORS_ON_MSVC 1
#else
#define SKIP_STATIC_CONSTRUCTORS_ON_GCC 1
#endif

#if PLATFORM(MANX)
#include <manx/util.h>

#define PUSH_CPU_MARKER(label, color) pa_push_marker(label, color)
#define POP_CPU_MARKER() pa_pop_marker()
#define CPU_SYNC() pa_sync()

#ifdef __cplusplus
#define FUNCTION_MARKER ScopedMarker marker ## __LINE__(__PRETTY_FUNCTION__, PA_COLOR_GREEN)
#endif // __cplusplus

#define GP_TRACE(label, number) gp_trace(label, number)

#else // PLATFORM(MANX)
#define PUSH_CPU_MARKER(label, color, flags)
#define POP_CPU_MARKER()
#define CPU_SYNC() 

#ifdef __cplusplus
#define FUNCTION_MARKER
#endif // __cplusplus

#define GP_TRACE(label, number)
#endif // PLATFORM(MANX)

