///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2005,2006,2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CEUTYPES_H__
#define __CEUTYPES_H__

#include "CESysDefs.h"

#if CE_OS(WIN32)
#  include <assert.h>
#  if defined(_DEBUG)
#    include <crtdbg.h>
#  endif // DEBUG
#elif CE_OS(LINUX) || CE_OS(XAI) || CE_OS(HYDRA) || CE_OS(ANDROID)
#  include <assert.h>
#else
#  error unknown or unspecified development platform
#endif


///////////////////////////////////////////////////////////////
#ifdef __cplusplus 
extern "C" {
#endif // __cplusplus


///////////////////////////////////////////////////////////////
typedef void* CEULibraryHandleRef;

#define CEU_MAJOR1_VERSION 0
#define CEU_MAJOR2_VERSION 0
#define CEU_MINOR1_VERSION 0
#define CEU_MINOR2_VERSION 1
#define CEU_VERSION_SIZE 4

//! This structure is a argument of \f CEUInit().
//!
//! CEUInit(const CEUInitArg* initarg, CEULibraryHandleRef* handleOut, UINT8* currentVersionOut) initializes this library.
//! \param[in] initarg pointer to the CEUInitArg structure. 
//! \param[out] handleOut pointer to the CEULibraryHandleRef. If function is succeeded, initialized library handle is return.
//! \param[out] currentVersionOut pointer to the buffer(UINT8 version[CEU_VERSION_SIZE]).
//! 
//! Before call the CEUInit(), initialize CEUInitArg structure by using CEUInitializeInitArg(CEUInitArg* pArg). CEUInitializeInitArg()
//! fills verion member and clear other members of CEUInitArg structur. After that, specify
//! _free, _malloc, _realloc, _calloc members of CEUInitArg structure.
//! 
//! To shutdown this library, call CEUShutdonw(CEULibraryHandleRef handle) with library handle
//! which is returned by CEUInit().
//! 
struct CEUInitArg  {
	UINT8 version[CEU_VERSION_SIZE];
} ;

///////////////////////////////////////////////////////////////
// utility macros
///////////////////////////////////////////////////////////////

#define CEU_VALIDATE_PTR_ERR(_ptr, _jgss_err_val) \
	if ( !(_ptr) ) {\
	return _jgss_err_val;\
	}

#define CEU_VALIDATE_PTR_VOID(_ptr) \
	if ( !(_ptr) ) {\
	return ;\
	}

#define CEU_VALIDATE_PTR(_ptr) \
	if ( !(_ptr) ) {\
	return CE_SILK_ERR_VALUEINVALID;\
	}

#define CEU_INIT_OPTIONAL_OUTPTR(_out) \
	if ( _out ) { *_out = 0; }

#define CEU_SET_OPTIONAL_OUTPTR(_out, _val) \
	if ( _out ) { *_out = _val; }

#define CEU_VALIDATE_OUTPTR(_out) \
	if ( !_out ) {\
	   return CE_SILK_ERR_BADARGS; \
	} else {\
		*_out = 0; \
	}

#define CEU_VALIDATE_REFPTR(_out) \
	if ( !_out ) {\
	   return CE_SILK_ERR_BADARGS; \
	} 

#define CEU_ENSURE_PTR(_err, _ptr, _ret) \
	if ( (_err) || !(_ptr) ) { return (CEHResult)(_ret); }

#define CEU_ENSURE_PTR1(_ptr, _ret) \
	if ( !(_ptr) ) { return (CEHResult)(_ret); }

#define CEU_ENSURE_SUCCESS(_err, _ret) \
	if ( (_err) ) { return (CEHResult)(_ret); }

#define CEU_ENSURE_SUCCESS1(_err) \
	if ( (_err) ) { return (CEHResult)(_err); }

#define CEU_ENSURE_TRUE(_b, _ret) \
	if ( !(_b) ) { return (CEHResult)(_ret); }

#define CEU_ENSURE_FALSE(_b, _ret) \
	if ( (_b) ) { return (CEHResult)(_ret); }

// deprecated. use JGSS_VERIFY.
// ignore function argument. (for warning of gcc compiler).
#define CEU_UNUSED(_c) ((void)(_c))

#if defined(__GNUC__)
#  define CEU_ATTR_UNUSED __attribute__((unused))
#else
#  define CEU_ATTR_UNUSED
#endif

typedef INT32 CEUTextMeasurement;

#ifdef __cplusplus 
}
#endif // __cplusplus

#endif // __CEU_TYPES_H__
