///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2005,2006 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CEUList_H__
#define __CEUList_H__

#include "CESysDefs.h"
#include "CECom.h"

// double-linked circular list
class CEUList
{
public:
	////////////////////////////////////////////////////////////////
	// operator new, delete, new[] and delete[].
	////////////////////////////////////////////////////////////////
	CEALLOCATORS;

	// constructor initializes this as an empty list
	CEUList() 
	{
		_prev = this;
		_next = this;
	}

	// return whether the list represeted by this, is empty or not
	bool isEmpty()const { return (this == _next); }
		
	/////////////////////////////////////////////////////////////////////
	//  Primitive List Operations
	//
	//  Note:
	//  You may face these method name confliction if you define the subclass of this.
	//  I recommend you not to inherit, but to use this as the embedded member.
	/////////////////////////////////////////////////////////////////////

	// get the previous element
	CEUList* getPrev()const { return _prev; }

	// get the next element
	CEUList* getNext()const { return _next; }

	// Insert this element after the specified one, 'afterElem'
	//
	//  [Before]                      [After]
	//
	//           next                          next        next
	//  elem[i] -----> elem[j]  ===>  elem[i] -----> this -----> elem[j]
	//   ^      <-----                 ^      <-----      <-----
	//   |       prev                  |       prev        prev
	//   |                             |    	
	//  afterElem                     afterElem
	//
	// 
	// Note: 'afterElem' should be already a member of the list before calling insertAfter
	//
	void insertAfter(CEUList* afterElem)
	{
		_prev = afterElem;
		_next = afterElem->_next;
		_next->_prev = this;
		_prev->_next = this;
	}

	// Insert this element before the specified one, 'beforeElem'
	//
	//  [Before]                      [After]
	//
	//           next                          next        next
	//  elem[i] -----> elem[j]  ===>  elem[i] -----> this -----> elem[j]
	//          <-----  ^                     <-----      <-----  ^
	//           prev   |                      prev        prev   |
	//                  |                                         |
	//                 beforeElem                                beforeElem
	//  
	// Note: 'beforeElem' should be already a member of the list before calling insertBefore
	//
	void insertBefore(CEUList* beforeElem)
	{
		_prev = beforeElem->_prev;
		_next = beforeElem;
		_prev->_next = this;
		_next->_prev = this;
	}

	// Remove this element from the list this belongs to
	//
	//  [Before]                                  [After]
	//
	//           next        next                          next  
	//  elem[i] -----> this -----> elem[j]  ===>  elem[i] -----> elem[j]
    //          <-----      <-----                        <-----
	//           prev        prev                          prev
	//  
	void removeThis()
	{
		_prev->_next = _next;
		_next->_prev = _prev;
		_next = _prev = this;
	}
	
	// returns whether the specified element 'elem' is a member of the list represeted by this
	bool isMemberOf(CEUList* elem)const
	{
		bool result = false;
		CEUList* curr;
		for(curr = _next ; curr != this ; curr = curr->_next)
		{
			if (curr == elem)
			{
				result = true;
				break;
			}
		}
		return result;
	}

private:
	CEUList* _next;
	CEUList* _prev;
};

#endif // __CEUList_H__



