///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEUIImage_h
#define ICEUIImage_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "CEUITypes.h"
#include "ICEUString.h"
#include "CEApiImage.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEUIImage ICEUIImage
 * @{
 */

/*!
 * ID of ICEUIImage
 */
#define CEComIID_ICEUIImage 0xf68efd9d


/*!
 * ICEUIImage
 */
typedef struct ICEUIImage
{
	const struct ICEUIImage_vtbl* _vtbl;
} ICEUIImage;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iUIImage	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEUIImage_queryInterface) (ICEUIImage* iUIImage, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIImage_addRef) (ICEUIImage* iUIImage);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIImage_release) (ICEUIImage* iUIImage);


/*!
 * <b>Summary:</b>
 * Get dimension.<br>
 * 
 * \param[in]	iUIImage	Specifies interface pointer
 * \param[out]	widthOut	Width.
 * \param[out]	heightOut	Height.
 *
 * \return error status
 * 
 * <b>Description:</b>
 * None
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEUIImage_getDimension) (ICEUIImage* iUIImage, INT32 *const widthOut, INT32 *const heightOut);


/*!
 * <b>Summary:</b>
 * Get getSurface.<br>
 * 
 * \param[in]	iUIImage	Specifies interface pointer
 * \param[out]	pSurface	Surface.
 *
 * \return error status
 * 
 * <b>Description:</b>
 * None
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEUIImage_getSurface) (ICEUIImage* iUIImage, struct ICEDXSurface **const pSurface);

typedef CEHResult (*iCEUIImage_isTransparent) (ICEUIImage* iUIImage, bool *const transparentOut);

/*!
 * V-table of ICEUIImage
 */
struct ICEUIImage_vtbl
{
	iCEUIImage_queryInterface	_queryInterface;	//!< Query interface.
	iCEUIImage_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEUIImage_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEUIImage_getDimension	_getDimension;	//!< Get dimension.
	iCEUIImage_getSurface	_getSurface;	//!< Get getSurface.
	iCEUIImage_isTransparent	_isTransparent;
};

/*! @}
 * end of ICEUIImage
 */

/*! \defgroup ICEUIImageDecoder ICEUIImageDecoder
 * @{
 */

/*!
 * ID of ICEUIImageDecoder
 */
#define CEComIID_ICEUIImageDecoder 0xab53ab14


/*!
 * ICEUIImageDecoder
 * TODO: This interface is due to be deleted after connecting new image manager.
 */
typedef struct ICEUIImageDecoder
{
	const struct ICEUIImageDecoder_vtbl* _vtbl;
} ICEUIImageDecoder;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iUIImageDecoder	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEUIImageDecoder_queryInterface) (ICEUIImageDecoder* iUIImageDecoder, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIImageDecoder_addRef) (ICEUIImageDecoder* iUIImageDecoder);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIImageDecoder_release) (ICEUIImageDecoder* iUIImageDecoder);

typedef CEHResult (*iCEUIImageDecoder_input) (ICEUIImageDecoder* iUIImageDecoder, const UINT8* data, const UINT32 size);

typedef CEHResult (*iCEUIImageDecoder_getDecodedImage) (ICEUIImageDecoder* iUIImageDecoder, struct ICEUIImage* *const iImageOut);

typedef CEHResult (*iCEUIImageDecoder_getImageContentType) (ICEUIImageDecoder* iUIImageDecoder, struct ICEUString* *const imageContentTypeOut);

/*!
 * V-table of ICEUIImageDecoder
 */
struct ICEUIImageDecoder_vtbl
{
	iCEUIImageDecoder_queryInterface	_queryInterface;	//!< Query interface.
	iCEUIImageDecoder_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEUIImageDecoder_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEUIImageDecoder_input	_input;
	iCEUIImageDecoder_getDecodedImage	_getDecodedImage;
	iCEUIImageDecoder_getImageContentType	_getImageContentType;
};

/*! @}
 * end of ICEUIImageDecoder
 */

/*! \defgroup ICEUIImageDecoderNotificationReceiver ICEUIImageDecoderNotificationReceiver
 * @{
 */

/*!
 * ID of ICEUIImageDecoderNotificationReceiver
 */
#define CEComIID_ICEUIImageDecoderNotificationReceiver 0xcb9fb1c6


/*!
 * ICEUIImageDecoderNotificationReceiver
 * TODO: This interface is due to be deleted after connecting new image manager.
 */
typedef struct ICEUIImageDecoderNotificationReceiver
{
	const struct ICEUIImageDecoderNotificationReceiver_vtbl* _vtbl;
} ICEUIImageDecoderNotificationReceiver;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iUIImageDecoderNotificationReceiver	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEUIImageDecoderNotificationReceiver_queryInterface) (ICEUIImageDecoderNotificationReceiver* iUIImageDecoderNotificationReceiver, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIImageDecoderNotificationReceiver_addRef) (ICEUIImageDecoderNotificationReceiver* iUIImageDecoderNotificationReceiver);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIImageDecoderNotificationReceiver_release) (ICEUIImageDecoderNotificationReceiver* iUIImageDecoderNotificationReceiver);

/*!
 * V-table of ICEUIImageDecoderNotificationReceiver
 */
struct ICEUIImageDecoderNotificationReceiver_vtbl
{
	iCEUIImageDecoderNotificationReceiver_queryInterface	_queryInterface;	//!< Query interface.
	iCEUIImageDecoderNotificationReceiver_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEUIImageDecoderNotificationReceiver_release	_release;	//!< Decrease the reference count of the specified interface pointer.
};

/*! @}
 * end of ICEUIImageDecoderNotificationReceiver
 */

/*! \defgroup ICEUIImageDecoderFactory ICEUIImageDecoderFactory
 * @{
 */

/*!
 * ID of ICEUIImageDecoderFactory
 */
#define CEComIID_ICEUIImageDecoderFactory 0xd242be94


/*!
 * ICEUIImageDecoderFactory
 * TODO: This interface is due to be deleted after connecting new image manager.
 */
typedef struct ICEUIImageDecoderFactory
{
	const struct ICEUIImageDecoderFactory_vtbl* _vtbl;
} ICEUIImageDecoderFactory;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iUIImageDecoderFactory	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEUIImageDecoderFactory_queryInterface) (ICEUIImageDecoderFactory* iUIImageDecoderFactory, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIImageDecoderFactory_addRef) (ICEUIImageDecoderFactory* iUIImageDecoderFactory);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIImageDecoderFactory_release) (ICEUIImageDecoderFactory* iUIImageDecoderFactory);

typedef CEHResult (*iCEUIImageDecoderFactory_create) (ICEUIImageDecoderFactory* iUIImageDecoderFactory, UINT8* data, const UINT32 size, bool animateImage, struct ICEUnknown* iUnknownCallback, struct ICEUIImageDecoder* *const iImageDecoderOut);

/*!
 * V-table of ICEUIImageDecoderFactory
 */
struct ICEUIImageDecoderFactory_vtbl
{
	iCEUIImageDecoderFactory_queryInterface	_queryInterface;	//!< Query interface.
	iCEUIImageDecoderFactory_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEUIImageDecoderFactory_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEUIImageDecoderFactory_create	_create;
};

/*! @}
 * end of ICEUIImageDecoderFactory
 */

/*! \defgroup ICEUIImageUtility ICEUIImageUtility
 * @{
 */

/*!
 * ID of ICEUIImageUtility
 */
#define CEComIID_ICEUIImageUtility 0x0eb26802


/*!
 * ICEUIImageUtility
 * TODO: This interface is due to be deleted after connecting new image manager.
 */
typedef struct ICEUIImageUtility
{
	const struct ICEUIImageUtility_vtbl* _vtbl;
} ICEUIImageUtility;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iUIImageUtility	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEUIImageUtility_queryInterface) (ICEUIImageUtility* iUIImageUtility, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIImageUtility_addRef) (ICEUIImageUtility* iUIImageUtility);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIImageUtility_release) (ICEUIImageUtility* iUIImageUtility);

typedef CEHResult (*iCEUIImageUtility_sniffMimeType) (ICEUIImageUtility* iUIImageUtility, UINT8* data, UINT32 size, struct ICEUString* *const strMimeTypeOut);

/*!
 * V-table of ICEUIImageUtility
 */
struct ICEUIImageUtility_vtbl
{
	iCEUIImageUtility_queryInterface	_queryInterface;	//!< Query interface.
	iCEUIImageUtility_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEUIImageUtility_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEUIImageUtility_sniffMimeType	_sniffMimeType;
};

/*! @}
 * end of ICEUIImageUtility
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEUIImageRef CEComICEUIImageRef
 * @{
 */

class CEComICEUIImageRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEUIImageRef() : _iUIImage(0) {}
	CEComICEUIImageRef(ICEUIImage* iOther) : _iUIImage(0)
	{
		if (iOther)
		{
			_iUIImage = iOther;
			_iUIImage->_vtbl->_addRef(_iUIImage);
		}
	}

	CEComICEUIImageRef(const CEComICEUIImageRef& other) : _iUIImage(0)
	{
		if (other._iUIImage)
		{
			_iUIImage = other._iUIImage;
			_iUIImage->_vtbl->_addRef(_iUIImage);
		}
	}

	~CEComICEUIImageRef()
	{
		if (_iUIImage)
		{
			ICEUIImage* tmp = _iUIImage;
			_iUIImage = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEUIImage* iUIImage;
				void* _ptr;
			} uIntf;
			uIntf.iUIImage = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEUIImage, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iUIImage)
				{
					ICEUIImage* tmp = _iUIImage;
					_iUIImage = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iUIImage = uIntf.iUIImage;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEUIImage* object() const	{ return _iUIImage; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEUIImage* iOther)
	{
		if (_iUIImage)
		{
			ICEUIImage* tmp = _iUIImage;
			_iUIImage = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iUIImage = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEUIImage* detach()
	{
		ICEUIImage* iIntf = _iUIImage;
		_iUIImage = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEUIImage* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iUIImage;
		if (_iUIImage)
		{
			_iUIImage->_vtbl->_addRef(_iUIImage);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEUIImage*() const	{ return _iUIImage; }
	FORCEINLINE_WITHOUT_DEBUG ICEUIImage& operator*() const	{ return *_iUIImage; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iUIImage == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEUIImage* iOther) const	{ return (_iUIImage != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEUIImage* iOther) const	{ return (_iUIImage == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEUIImageRef& operator=(const CEComICEUIImageRef& other)	{ return operator=(other._iUIImage); }

	CEComICEUIImageRef& operator=(const ICEUIImage* iOther)
	{
		if (_iUIImage != iOther)
		{
			if (_iUIImage)
			{
				ICEUIImage* tmp = _iUIImage;
				_iUIImage = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iUIImage = const_cast<ICEUIImage*>(iOther);
			if (_iUIImage)
			{
				_iUIImage->_vtbl->_addRef(_iUIImage);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEUIImage** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEUIImageRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iUIImage && "has a com object reference. clear first.");
		return & _iUIImage; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEUIImageRef& other)
	{
		bool result = false;
		if (_iUIImage)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iUIImage);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iUIImage ? _iUIImage->_vtbl->_queryInterface(_iUIImage, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iUIImage) { _iUIImage->_vtbl->_addRef(_iUIImage); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iUIImage) { _iUIImage->_vtbl->_release(_iUIImage); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDimension(INT32 *const widthOut, INT32 *const heightOut)	{ return _iUIImage ? _iUIImage->_vtbl->_getDimension(_iUIImage, widthOut, heightOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getSurface(struct ICEDXSurface **const pSurface)	{ return _iUIImage ? _iUIImage->_vtbl->_getSurface(_iUIImage, pSurface) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isTransparent(bool *const transparentOut)	{ return _iUIImage ? _iUIImage->_vtbl->_isTransparent(_iUIImage, transparentOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEUIImage* _iUIImage;
};

/*! @}
 * end of CEComICEUIImageRef
 */

/*! \defgroup CEComICEUIImageDecoderRef CEComICEUIImageDecoderRef
 * @{
 */

class CEComICEUIImageDecoderRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEUIImageDecoderRef() : _iUIImageDecoder(0) {}
	CEComICEUIImageDecoderRef(ICEUIImageDecoder* iOther) : _iUIImageDecoder(0)
	{
		if (iOther)
		{
			_iUIImageDecoder = iOther;
			_iUIImageDecoder->_vtbl->_addRef(_iUIImageDecoder);
		}
	}

	CEComICEUIImageDecoderRef(const CEComICEUIImageDecoderRef& other) : _iUIImageDecoder(0)
	{
		if (other._iUIImageDecoder)
		{
			_iUIImageDecoder = other._iUIImageDecoder;
			_iUIImageDecoder->_vtbl->_addRef(_iUIImageDecoder);
		}
	}

	~CEComICEUIImageDecoderRef()
	{
		if (_iUIImageDecoder)
		{
			ICEUIImageDecoder* tmp = _iUIImageDecoder;
			_iUIImageDecoder = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEUIImageDecoder* iUIImageDecoder;
				void* _ptr;
			} uIntf;
			uIntf.iUIImageDecoder = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEUIImageDecoder, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iUIImageDecoder)
				{
					ICEUIImageDecoder* tmp = _iUIImageDecoder;
					_iUIImageDecoder = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iUIImageDecoder = uIntf.iUIImageDecoder;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEUIImageDecoder* object() const	{ return _iUIImageDecoder; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEUIImageDecoder* iOther)
	{
		if (_iUIImageDecoder)
		{
			ICEUIImageDecoder* tmp = _iUIImageDecoder;
			_iUIImageDecoder = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iUIImageDecoder = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEUIImageDecoder* detach()
	{
		ICEUIImageDecoder* iIntf = _iUIImageDecoder;
		_iUIImageDecoder = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEUIImageDecoder* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iUIImageDecoder;
		if (_iUIImageDecoder)
		{
			_iUIImageDecoder->_vtbl->_addRef(_iUIImageDecoder);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEUIImageDecoder*() const	{ return _iUIImageDecoder; }
	FORCEINLINE_WITHOUT_DEBUG ICEUIImageDecoder& operator*() const	{ return *_iUIImageDecoder; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iUIImageDecoder == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEUIImageDecoder* iOther) const	{ return (_iUIImageDecoder != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEUIImageDecoder* iOther) const	{ return (_iUIImageDecoder == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEUIImageDecoderRef& operator=(const CEComICEUIImageDecoderRef& other)	{ return operator=(other._iUIImageDecoder); }

	CEComICEUIImageDecoderRef& operator=(const ICEUIImageDecoder* iOther)
	{
		if (_iUIImageDecoder != iOther)
		{
			if (_iUIImageDecoder)
			{
				ICEUIImageDecoder* tmp = _iUIImageDecoder;
				_iUIImageDecoder = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iUIImageDecoder = const_cast<ICEUIImageDecoder*>(iOther);
			if (_iUIImageDecoder)
			{
				_iUIImageDecoder->_vtbl->_addRef(_iUIImageDecoder);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEUIImageDecoder** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEUIImageDecoderRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iUIImageDecoder && "has a com object reference. clear first.");
		return & _iUIImageDecoder; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEUIImageDecoderRef& other)
	{
		bool result = false;
		if (_iUIImageDecoder)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iUIImageDecoder);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iUIImageDecoder ? _iUIImageDecoder->_vtbl->_queryInterface(_iUIImageDecoder, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iUIImageDecoder) { _iUIImageDecoder->_vtbl->_addRef(_iUIImageDecoder); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iUIImageDecoder) { _iUIImageDecoder->_vtbl->_release(_iUIImageDecoder); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult input(const UINT8* data, const UINT32 size)	{ return _iUIImageDecoder ? _iUIImageDecoder->_vtbl->_input(_iUIImageDecoder, data, size) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDecodedImage(struct ICEUIImage* *const iImageOut)	{ return _iUIImageDecoder ? _iUIImageDecoder->_vtbl->_getDecodedImage(_iUIImageDecoder, iImageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getImageContentType(struct ICEUString* *const imageContentTypeOut)	{ return _iUIImageDecoder ? _iUIImageDecoder->_vtbl->_getImageContentType(_iUIImageDecoder, imageContentTypeOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEUIImageDecoder* _iUIImageDecoder;
};

/*! @}
 * end of CEComICEUIImageDecoderRef
 */

/*! \defgroup CEComICEUIImageDecoderNotificationReceiverRef CEComICEUIImageDecoderNotificationReceiverRef
 * @{
 */

class CEComICEUIImageDecoderNotificationReceiverRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEUIImageDecoderNotificationReceiverRef() : _iUIImageDecoderNotificationReceiver(0) {}
	CEComICEUIImageDecoderNotificationReceiverRef(ICEUIImageDecoderNotificationReceiver* iOther) : _iUIImageDecoderNotificationReceiver(0)
	{
		if (iOther)
		{
			_iUIImageDecoderNotificationReceiver = iOther;
			_iUIImageDecoderNotificationReceiver->_vtbl->_addRef(_iUIImageDecoderNotificationReceiver);
		}
	}

	CEComICEUIImageDecoderNotificationReceiverRef(const CEComICEUIImageDecoderNotificationReceiverRef& other) : _iUIImageDecoderNotificationReceiver(0)
	{
		if (other._iUIImageDecoderNotificationReceiver)
		{
			_iUIImageDecoderNotificationReceiver = other._iUIImageDecoderNotificationReceiver;
			_iUIImageDecoderNotificationReceiver->_vtbl->_addRef(_iUIImageDecoderNotificationReceiver);
		}
	}

	~CEComICEUIImageDecoderNotificationReceiverRef()
	{
		if (_iUIImageDecoderNotificationReceiver)
		{
			ICEUIImageDecoderNotificationReceiver* tmp = _iUIImageDecoderNotificationReceiver;
			_iUIImageDecoderNotificationReceiver = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEUIImageDecoderNotificationReceiver* iUIImageDecoderNotificationReceiver;
				void* _ptr;
			} uIntf;
			uIntf.iUIImageDecoderNotificationReceiver = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEUIImageDecoderNotificationReceiver, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iUIImageDecoderNotificationReceiver)
				{
					ICEUIImageDecoderNotificationReceiver* tmp = _iUIImageDecoderNotificationReceiver;
					_iUIImageDecoderNotificationReceiver = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iUIImageDecoderNotificationReceiver = uIntf.iUIImageDecoderNotificationReceiver;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEUIImageDecoderNotificationReceiver* object() const	{ return _iUIImageDecoderNotificationReceiver; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEUIImageDecoderNotificationReceiver* iOther)
	{
		if (_iUIImageDecoderNotificationReceiver)
		{
			ICEUIImageDecoderNotificationReceiver* tmp = _iUIImageDecoderNotificationReceiver;
			_iUIImageDecoderNotificationReceiver = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iUIImageDecoderNotificationReceiver = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEUIImageDecoderNotificationReceiver* detach()
	{
		ICEUIImageDecoderNotificationReceiver* iIntf = _iUIImageDecoderNotificationReceiver;
		_iUIImageDecoderNotificationReceiver = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEUIImageDecoderNotificationReceiver* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iUIImageDecoderNotificationReceiver;
		if (_iUIImageDecoderNotificationReceiver)
		{
			_iUIImageDecoderNotificationReceiver->_vtbl->_addRef(_iUIImageDecoderNotificationReceiver);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEUIImageDecoderNotificationReceiver*() const	{ return _iUIImageDecoderNotificationReceiver; }
	FORCEINLINE_WITHOUT_DEBUG ICEUIImageDecoderNotificationReceiver& operator*() const	{ return *_iUIImageDecoderNotificationReceiver; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iUIImageDecoderNotificationReceiver == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEUIImageDecoderNotificationReceiver* iOther) const	{ return (_iUIImageDecoderNotificationReceiver != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEUIImageDecoderNotificationReceiver* iOther) const	{ return (_iUIImageDecoderNotificationReceiver == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEUIImageDecoderNotificationReceiverRef& operator=(const CEComICEUIImageDecoderNotificationReceiverRef& other)	{ return operator=(other._iUIImageDecoderNotificationReceiver); }

	CEComICEUIImageDecoderNotificationReceiverRef& operator=(const ICEUIImageDecoderNotificationReceiver* iOther)
	{
		if (_iUIImageDecoderNotificationReceiver != iOther)
		{
			if (_iUIImageDecoderNotificationReceiver)
			{
				ICEUIImageDecoderNotificationReceiver* tmp = _iUIImageDecoderNotificationReceiver;
				_iUIImageDecoderNotificationReceiver = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iUIImageDecoderNotificationReceiver = const_cast<ICEUIImageDecoderNotificationReceiver*>(iOther);
			if (_iUIImageDecoderNotificationReceiver)
			{
				_iUIImageDecoderNotificationReceiver->_vtbl->_addRef(_iUIImageDecoderNotificationReceiver);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEUIImageDecoderNotificationReceiver** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEUIImageDecoderNotificationReceiverRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iUIImageDecoderNotificationReceiver && "has a com object reference. clear first.");
		return & _iUIImageDecoderNotificationReceiver; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEUIImageDecoderNotificationReceiverRef& other)
	{
		bool result = false;
		if (_iUIImageDecoderNotificationReceiver)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iUIImageDecoderNotificationReceiver);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iUIImageDecoderNotificationReceiver ? _iUIImageDecoderNotificationReceiver->_vtbl->_queryInterface(_iUIImageDecoderNotificationReceiver, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iUIImageDecoderNotificationReceiver) { _iUIImageDecoderNotificationReceiver->_vtbl->_addRef(_iUIImageDecoderNotificationReceiver); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iUIImageDecoderNotificationReceiver) { _iUIImageDecoderNotificationReceiver->_vtbl->_release(_iUIImageDecoderNotificationReceiver); } }


private:
	ICEUIImageDecoderNotificationReceiver* _iUIImageDecoderNotificationReceiver;
};

/*! @}
 * end of CEComICEUIImageDecoderNotificationReceiverRef
 */

/*! \defgroup CEComICEUIImageDecoderFactoryRef CEComICEUIImageDecoderFactoryRef
 * @{
 */

class CEComICEUIImageDecoderFactoryRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEUIImageDecoderFactoryRef() : _iUIImageDecoderFactory(0) {}
	CEComICEUIImageDecoderFactoryRef(ICEUIImageDecoderFactory* iOther) : _iUIImageDecoderFactory(0)
	{
		if (iOther)
		{
			_iUIImageDecoderFactory = iOther;
			_iUIImageDecoderFactory->_vtbl->_addRef(_iUIImageDecoderFactory);
		}
	}

	CEComICEUIImageDecoderFactoryRef(const CEComICEUIImageDecoderFactoryRef& other) : _iUIImageDecoderFactory(0)
	{
		if (other._iUIImageDecoderFactory)
		{
			_iUIImageDecoderFactory = other._iUIImageDecoderFactory;
			_iUIImageDecoderFactory->_vtbl->_addRef(_iUIImageDecoderFactory);
		}
	}

	~CEComICEUIImageDecoderFactoryRef()
	{
		if (_iUIImageDecoderFactory)
		{
			ICEUIImageDecoderFactory* tmp = _iUIImageDecoderFactory;
			_iUIImageDecoderFactory = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEUIImageDecoderFactory* iUIImageDecoderFactory;
				void* _ptr;
			} uIntf;
			uIntf.iUIImageDecoderFactory = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEUIImageDecoderFactory, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iUIImageDecoderFactory)
				{
					ICEUIImageDecoderFactory* tmp = _iUIImageDecoderFactory;
					_iUIImageDecoderFactory = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iUIImageDecoderFactory = uIntf.iUIImageDecoderFactory;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEUIImageDecoderFactory* object() const	{ return _iUIImageDecoderFactory; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEUIImageDecoderFactory* iOther)
	{
		if (_iUIImageDecoderFactory)
		{
			ICEUIImageDecoderFactory* tmp = _iUIImageDecoderFactory;
			_iUIImageDecoderFactory = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iUIImageDecoderFactory = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEUIImageDecoderFactory* detach()
	{
		ICEUIImageDecoderFactory* iIntf = _iUIImageDecoderFactory;
		_iUIImageDecoderFactory = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEUIImageDecoderFactory* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iUIImageDecoderFactory;
		if (_iUIImageDecoderFactory)
		{
			_iUIImageDecoderFactory->_vtbl->_addRef(_iUIImageDecoderFactory);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEUIImageDecoderFactory*() const	{ return _iUIImageDecoderFactory; }
	FORCEINLINE_WITHOUT_DEBUG ICEUIImageDecoderFactory& operator*() const	{ return *_iUIImageDecoderFactory; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iUIImageDecoderFactory == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEUIImageDecoderFactory* iOther) const	{ return (_iUIImageDecoderFactory != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEUIImageDecoderFactory* iOther) const	{ return (_iUIImageDecoderFactory == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEUIImageDecoderFactoryRef& operator=(const CEComICEUIImageDecoderFactoryRef& other)	{ return operator=(other._iUIImageDecoderFactory); }

	CEComICEUIImageDecoderFactoryRef& operator=(const ICEUIImageDecoderFactory* iOther)
	{
		if (_iUIImageDecoderFactory != iOther)
		{
			if (_iUIImageDecoderFactory)
			{
				ICEUIImageDecoderFactory* tmp = _iUIImageDecoderFactory;
				_iUIImageDecoderFactory = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iUIImageDecoderFactory = const_cast<ICEUIImageDecoderFactory*>(iOther);
			if (_iUIImageDecoderFactory)
			{
				_iUIImageDecoderFactory->_vtbl->_addRef(_iUIImageDecoderFactory);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEUIImageDecoderFactory** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEUIImageDecoderFactoryRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iUIImageDecoderFactory && "has a com object reference. clear first.");
		return & _iUIImageDecoderFactory; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEUIImageDecoderFactoryRef& other)
	{
		bool result = false;
		if (_iUIImageDecoderFactory)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iUIImageDecoderFactory);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iUIImageDecoderFactory ? _iUIImageDecoderFactory->_vtbl->_queryInterface(_iUIImageDecoderFactory, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iUIImageDecoderFactory) { _iUIImageDecoderFactory->_vtbl->_addRef(_iUIImageDecoderFactory); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iUIImageDecoderFactory) { _iUIImageDecoderFactory->_vtbl->_release(_iUIImageDecoderFactory); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult create(UINT8* data, const UINT32 size, bool animateImage, struct ICEUnknown* iUnknownCallback, struct ICEUIImageDecoder* *const iImageDecoderOut)	{ return _iUIImageDecoderFactory ? _iUIImageDecoderFactory->_vtbl->_create(_iUIImageDecoderFactory, data, size, animateImage, iUnknownCallback, iImageDecoderOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEUIImageDecoderFactory* _iUIImageDecoderFactory;
};

/*! @}
 * end of CEComICEUIImageDecoderFactoryRef
 */

/*! \defgroup CEComICEUIImageUtilityRef CEComICEUIImageUtilityRef
 * @{
 */

class CEComICEUIImageUtilityRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEUIImageUtilityRef() : _iUIImageUtility(0) {}
	CEComICEUIImageUtilityRef(ICEUIImageUtility* iOther) : _iUIImageUtility(0)
	{
		if (iOther)
		{
			_iUIImageUtility = iOther;
			_iUIImageUtility->_vtbl->_addRef(_iUIImageUtility);
		}
	}

	CEComICEUIImageUtilityRef(const CEComICEUIImageUtilityRef& other) : _iUIImageUtility(0)
	{
		if (other._iUIImageUtility)
		{
			_iUIImageUtility = other._iUIImageUtility;
			_iUIImageUtility->_vtbl->_addRef(_iUIImageUtility);
		}
	}

	~CEComICEUIImageUtilityRef()
	{
		if (_iUIImageUtility)
		{
			ICEUIImageUtility* tmp = _iUIImageUtility;
			_iUIImageUtility = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEUIImageUtility* iUIImageUtility;
				void* _ptr;
			} uIntf;
			uIntf.iUIImageUtility = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEUIImageUtility, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iUIImageUtility)
				{
					ICEUIImageUtility* tmp = _iUIImageUtility;
					_iUIImageUtility = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iUIImageUtility = uIntf.iUIImageUtility;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEUIImageUtility* object() const	{ return _iUIImageUtility; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEUIImageUtility* iOther)
	{
		if (_iUIImageUtility)
		{
			ICEUIImageUtility* tmp = _iUIImageUtility;
			_iUIImageUtility = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iUIImageUtility = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEUIImageUtility* detach()
	{
		ICEUIImageUtility* iIntf = _iUIImageUtility;
		_iUIImageUtility = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEUIImageUtility* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iUIImageUtility;
		if (_iUIImageUtility)
		{
			_iUIImageUtility->_vtbl->_addRef(_iUIImageUtility);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEUIImageUtility*() const	{ return _iUIImageUtility; }
	FORCEINLINE_WITHOUT_DEBUG ICEUIImageUtility& operator*() const	{ return *_iUIImageUtility; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iUIImageUtility == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEUIImageUtility* iOther) const	{ return (_iUIImageUtility != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEUIImageUtility* iOther) const	{ return (_iUIImageUtility == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEUIImageUtilityRef& operator=(const CEComICEUIImageUtilityRef& other)	{ return operator=(other._iUIImageUtility); }

	CEComICEUIImageUtilityRef& operator=(const ICEUIImageUtility* iOther)
	{
		if (_iUIImageUtility != iOther)
		{
			if (_iUIImageUtility)
			{
				ICEUIImageUtility* tmp = _iUIImageUtility;
				_iUIImageUtility = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iUIImageUtility = const_cast<ICEUIImageUtility*>(iOther);
			if (_iUIImageUtility)
			{
				_iUIImageUtility->_vtbl->_addRef(_iUIImageUtility);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEUIImageUtility** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEUIImageUtilityRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iUIImageUtility && "has a com object reference. clear first.");
		return & _iUIImageUtility; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEUIImageUtilityRef& other)
	{
		bool result = false;
		if (_iUIImageUtility)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iUIImageUtility);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iUIImageUtility ? _iUIImageUtility->_vtbl->_queryInterface(_iUIImageUtility, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iUIImageUtility) { _iUIImageUtility->_vtbl->_addRef(_iUIImageUtility); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iUIImageUtility) { _iUIImageUtility->_vtbl->_release(_iUIImageUtility); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult sniffMimeType(UINT8* data, UINT32 size, struct ICEUString* *const strMimeTypeOut)	{ return _iUIImageUtility ? _iUIImageUtility->_vtbl->_sniffMimeType(_iUIImageUtility, data, size, strMimeTypeOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEUIImageUtility* _iUIImageUtility;
};

/*! @}
 * end of CEComICEUIImageUtilityRef
 */

#endif // __cplusplus

#endif
