///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEJSSSPropertyDeclarer_h
#define ICEJSSSPropertyDeclarer_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
	CEJSSSPropertyAttr_None = 0,
	CEJSSSPropertyAttr_ReadOnly = 1<<0,
	CEJSSSPropertyAttr_Const = 1<<1
} CEJSSSPropertyAttr;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEJSSSPropertyDeclarer ICEJSSSPropertyDeclarer
 * @{
 */

/*!
 * ID of ICEJSSSPropertyDeclarer
 */
#define CEComIID_ICEJSSSPropertyDeclarer 0x9e159fb3


/*!
 * ICEJSSSPropertyDeclarer
 */
typedef struct ICEJSSSPropertyDeclarer
{
	const struct ICEJSSSPropertyDeclarer_vtbl* _vtbl;
} ICEJSSSPropertyDeclarer;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iJSSSPropertyDeclarer	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEJSSSPropertyDeclarer_queryInterface) (ICEJSSSPropertyDeclarer* iJSSSPropertyDeclarer, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSSSPropertyDeclarer_addRef) (ICEJSSSPropertyDeclarer* iJSSSPropertyDeclarer);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSSSPropertyDeclarer_release) (ICEJSSSPropertyDeclarer* iJSSSPropertyDeclarer);

typedef CEHResult (*iCEJSSSPropertyDeclarer_declareProperty) (ICEJSSSPropertyDeclarer* iJSSSPropertyDeclarer, INT32 propertyId, const UTF16CHAR* pPropertyName, UINT32 numOfChars16, UINT32 attr);

typedef CEHResult (*iCEJSSSPropertyDeclarer_declareMethod) (ICEJSSSPropertyDeclarer* iJSSSPropertyDeclarer, INT32 methodId, const UTF16CHAR* pMethodName, UINT32 numOfChars16, UINT32 attr, UINT32 argCount);

/*!
 * V-table of ICEJSSSPropertyDeclarer
 */
struct ICEJSSSPropertyDeclarer_vtbl
{
	iCEJSSSPropertyDeclarer_queryInterface	_queryInterface;	//!< Query interface.
	iCEJSSSPropertyDeclarer_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEJSSSPropertyDeclarer_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEJSSSPropertyDeclarer_declareProperty	_declareProperty;
	iCEJSSSPropertyDeclarer_declareMethod	_declareMethod;
};

/*! @}
 * end of ICEJSSSPropertyDeclarer
 */

/*! \defgroup ICEJSSSPropertyParent ICEJSSSPropertyParent
 * @{
 */

/*!
 * ID of ICEJSSSPropertyParent
 */
#define CEComIID_ICEJSSSPropertyParent 0x682a4b52


/*!
 * ICEJSSSPropertyParent
 */
typedef struct ICEJSSSPropertyParent
{
	const struct ICEJSSSPropertyParent_vtbl* _vtbl;
} ICEJSSSPropertyParent;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iJSSSPropertyParent	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEJSSSPropertyParent_queryInterface) (ICEJSSSPropertyParent* iJSSSPropertyParent, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSSSPropertyParent_addRef) (ICEJSSSPropertyParent* iJSSSPropertyParent);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSSSPropertyParent_release) (ICEJSSSPropertyParent* iJSSSPropertyParent);

typedef CEHResult (*iCEJSSSPropertyParent_declareChildProperty) (ICEJSSSPropertyParent* iJSSSPropertyParent, INT32 propertyId, const UTF16CHAR* pPropertyName, UINT32 numOfChars16, UINT32 attr);

typedef CEHResult (*iCEJSSSPropertyParent_declareChildMethod) (ICEJSSSPropertyParent* iJSSSPropertyParent, INT32 methodId, const UTF16CHAR* pMethodName, UINT32 numOfChars16, UINT32 attr, UINT32 argCount);

/*!
 * V-table of ICEJSSSPropertyParent
 */
struct ICEJSSSPropertyParent_vtbl
{
	iCEJSSSPropertyParent_queryInterface	_queryInterface;	//!< Query interface.
	iCEJSSSPropertyParent_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEJSSSPropertyParent_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEJSSSPropertyParent_declareChildProperty	_declareChildProperty;
	iCEJSSSPropertyParent_declareChildMethod	_declareChildMethod;
};

/*! @}
 * end of ICEJSSSPropertyParent
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEJSSSPropertyDeclarerRef CEComICEJSSSPropertyDeclarerRef
 * @{
 */

class CEComICEJSSSPropertyDeclarerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEJSSSPropertyDeclarerRef() : _iJSSSPropertyDeclarer(0) {}
	CEComICEJSSSPropertyDeclarerRef(ICEJSSSPropertyDeclarer* iOther) : _iJSSSPropertyDeclarer(0)
	{
		if (iOther)
		{
			_iJSSSPropertyDeclarer = iOther;
			_iJSSSPropertyDeclarer->_vtbl->_addRef(_iJSSSPropertyDeclarer);
		}
	}

	CEComICEJSSSPropertyDeclarerRef(const CEComICEJSSSPropertyDeclarerRef& other) : _iJSSSPropertyDeclarer(0)
	{
		if (other._iJSSSPropertyDeclarer)
		{
			_iJSSSPropertyDeclarer = other._iJSSSPropertyDeclarer;
			_iJSSSPropertyDeclarer->_vtbl->_addRef(_iJSSSPropertyDeclarer);
		}
	}

	~CEComICEJSSSPropertyDeclarerRef()
	{
		if (_iJSSSPropertyDeclarer)
		{
			ICEJSSSPropertyDeclarer* tmp = _iJSSSPropertyDeclarer;
			_iJSSSPropertyDeclarer = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEJSSSPropertyDeclarer* iJSSSPropertyDeclarer;
				void* _ptr;
			} uIntf;
			uIntf.iJSSSPropertyDeclarer = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEJSSSPropertyDeclarer, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iJSSSPropertyDeclarer)
				{
					ICEJSSSPropertyDeclarer* tmp = _iJSSSPropertyDeclarer;
					_iJSSSPropertyDeclarer = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iJSSSPropertyDeclarer = uIntf.iJSSSPropertyDeclarer;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEJSSSPropertyDeclarer* object() const	{ return _iJSSSPropertyDeclarer; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEJSSSPropertyDeclarer* iOther)
	{
		if (_iJSSSPropertyDeclarer)
		{
			ICEJSSSPropertyDeclarer* tmp = _iJSSSPropertyDeclarer;
			_iJSSSPropertyDeclarer = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iJSSSPropertyDeclarer = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEJSSSPropertyDeclarer* detach()
	{
		ICEJSSSPropertyDeclarer* iIntf = _iJSSSPropertyDeclarer;
		_iJSSSPropertyDeclarer = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEJSSSPropertyDeclarer* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iJSSSPropertyDeclarer;
		if (_iJSSSPropertyDeclarer)
		{
			_iJSSSPropertyDeclarer->_vtbl->_addRef(_iJSSSPropertyDeclarer);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEJSSSPropertyDeclarer*() const	{ return _iJSSSPropertyDeclarer; }
	FORCEINLINE_WITHOUT_DEBUG ICEJSSSPropertyDeclarer& operator*() const	{ return *_iJSSSPropertyDeclarer; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iJSSSPropertyDeclarer == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEJSSSPropertyDeclarer* iOther) const	{ return (_iJSSSPropertyDeclarer != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEJSSSPropertyDeclarer* iOther) const	{ return (_iJSSSPropertyDeclarer == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEJSSSPropertyDeclarerRef& operator=(const CEComICEJSSSPropertyDeclarerRef& other)	{ return operator=(other._iJSSSPropertyDeclarer); }

	CEComICEJSSSPropertyDeclarerRef& operator=(const ICEJSSSPropertyDeclarer* iOther)
	{
		if (_iJSSSPropertyDeclarer != iOther)
		{
			if (_iJSSSPropertyDeclarer)
			{
				ICEJSSSPropertyDeclarer* tmp = _iJSSSPropertyDeclarer;
				_iJSSSPropertyDeclarer = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iJSSSPropertyDeclarer = const_cast<ICEJSSSPropertyDeclarer*>(iOther);
			if (_iJSSSPropertyDeclarer)
			{
				_iJSSSPropertyDeclarer->_vtbl->_addRef(_iJSSSPropertyDeclarer);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEJSSSPropertyDeclarer** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEJSSSPropertyDeclarerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iJSSSPropertyDeclarer && "has a com object reference. clear first.");
		return & _iJSSSPropertyDeclarer; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEJSSSPropertyDeclarerRef& other)
	{
		bool result = false;
		if (_iJSSSPropertyDeclarer)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iJSSSPropertyDeclarer);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iJSSSPropertyDeclarer ? _iJSSSPropertyDeclarer->_vtbl->_queryInterface(_iJSSSPropertyDeclarer, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iJSSSPropertyDeclarer) { _iJSSSPropertyDeclarer->_vtbl->_addRef(_iJSSSPropertyDeclarer); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iJSSSPropertyDeclarer) { _iJSSSPropertyDeclarer->_vtbl->_release(_iJSSSPropertyDeclarer); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult declareProperty(INT32 propertyId, const UTF16CHAR* pPropertyName, UINT32 numOfChars16, UINT32 attr)	{ return _iJSSSPropertyDeclarer ? _iJSSSPropertyDeclarer->_vtbl->_declareProperty(_iJSSSPropertyDeclarer, propertyId, pPropertyName, numOfChars16, attr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult declareMethod(INT32 methodId, const UTF16CHAR* pMethodName, UINT32 numOfChars16, UINT32 attr, UINT32 argCount)	{ return _iJSSSPropertyDeclarer ? _iJSSSPropertyDeclarer->_vtbl->_declareMethod(_iJSSSPropertyDeclarer, methodId, pMethodName, numOfChars16, attr, argCount) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEJSSSPropertyDeclarer* _iJSSSPropertyDeclarer;
};

/*! @}
 * end of CEComICEJSSSPropertyDeclarerRef
 */

/*! \defgroup CEComICEJSSSPropertyParentRef CEComICEJSSSPropertyParentRef
 * @{
 */

class CEComICEJSSSPropertyParentRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEJSSSPropertyParentRef() : _iJSSSPropertyParent(0) {}
	CEComICEJSSSPropertyParentRef(ICEJSSSPropertyParent* iOther) : _iJSSSPropertyParent(0)
	{
		if (iOther)
		{
			_iJSSSPropertyParent = iOther;
			_iJSSSPropertyParent->_vtbl->_addRef(_iJSSSPropertyParent);
		}
	}

	CEComICEJSSSPropertyParentRef(const CEComICEJSSSPropertyParentRef& other) : _iJSSSPropertyParent(0)
	{
		if (other._iJSSSPropertyParent)
		{
			_iJSSSPropertyParent = other._iJSSSPropertyParent;
			_iJSSSPropertyParent->_vtbl->_addRef(_iJSSSPropertyParent);
		}
	}

	~CEComICEJSSSPropertyParentRef()
	{
		if (_iJSSSPropertyParent)
		{
			ICEJSSSPropertyParent* tmp = _iJSSSPropertyParent;
			_iJSSSPropertyParent = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEJSSSPropertyParent* iJSSSPropertyParent;
				void* _ptr;
			} uIntf;
			uIntf.iJSSSPropertyParent = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEJSSSPropertyParent, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iJSSSPropertyParent)
				{
					ICEJSSSPropertyParent* tmp = _iJSSSPropertyParent;
					_iJSSSPropertyParent = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iJSSSPropertyParent = uIntf.iJSSSPropertyParent;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEJSSSPropertyParent* object() const	{ return _iJSSSPropertyParent; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEJSSSPropertyParent* iOther)
	{
		if (_iJSSSPropertyParent)
		{
			ICEJSSSPropertyParent* tmp = _iJSSSPropertyParent;
			_iJSSSPropertyParent = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iJSSSPropertyParent = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEJSSSPropertyParent* detach()
	{
		ICEJSSSPropertyParent* iIntf = _iJSSSPropertyParent;
		_iJSSSPropertyParent = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEJSSSPropertyParent* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iJSSSPropertyParent;
		if (_iJSSSPropertyParent)
		{
			_iJSSSPropertyParent->_vtbl->_addRef(_iJSSSPropertyParent);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEJSSSPropertyParent*() const	{ return _iJSSSPropertyParent; }
	FORCEINLINE_WITHOUT_DEBUG ICEJSSSPropertyParent& operator*() const	{ return *_iJSSSPropertyParent; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iJSSSPropertyParent == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEJSSSPropertyParent* iOther) const	{ return (_iJSSSPropertyParent != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEJSSSPropertyParent* iOther) const	{ return (_iJSSSPropertyParent == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEJSSSPropertyParentRef& operator=(const CEComICEJSSSPropertyParentRef& other)	{ return operator=(other._iJSSSPropertyParent); }

	CEComICEJSSSPropertyParentRef& operator=(const ICEJSSSPropertyParent* iOther)
	{
		if (_iJSSSPropertyParent != iOther)
		{
			if (_iJSSSPropertyParent)
			{
				ICEJSSSPropertyParent* tmp = _iJSSSPropertyParent;
				_iJSSSPropertyParent = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iJSSSPropertyParent = const_cast<ICEJSSSPropertyParent*>(iOther);
			if (_iJSSSPropertyParent)
			{
				_iJSSSPropertyParent->_vtbl->_addRef(_iJSSSPropertyParent);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEJSSSPropertyParent** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEJSSSPropertyParentRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iJSSSPropertyParent && "has a com object reference. clear first.");
		return & _iJSSSPropertyParent; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEJSSSPropertyParentRef& other)
	{
		bool result = false;
		if (_iJSSSPropertyParent)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iJSSSPropertyParent);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iJSSSPropertyParent ? _iJSSSPropertyParent->_vtbl->_queryInterface(_iJSSSPropertyParent, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iJSSSPropertyParent) { _iJSSSPropertyParent->_vtbl->_addRef(_iJSSSPropertyParent); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iJSSSPropertyParent) { _iJSSSPropertyParent->_vtbl->_release(_iJSSSPropertyParent); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult declareChildProperty(INT32 propertyId, const UTF16CHAR* pPropertyName, UINT32 numOfChars16, UINT32 attr)	{ return _iJSSSPropertyParent ? _iJSSSPropertyParent->_vtbl->_declareChildProperty(_iJSSSPropertyParent, propertyId, pPropertyName, numOfChars16, attr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult declareChildMethod(INT32 methodId, const UTF16CHAR* pMethodName, UINT32 numOfChars16, UINT32 attr, UINT32 argCount)	{ return _iJSSSPropertyParent ? _iJSSSPropertyParent->_vtbl->_declareChildMethod(_iJSSSPropertyParent, methodId, pMethodName, numOfChars16, attr, argCount) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEJSSSPropertyParent* _iJSSSPropertyParent;
};

/*! @}
 * end of CEComICEJSSSPropertyParentRef
 */

#endif // __cplusplus

#endif
