///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEJSPrivilegeSSObjectListener_h
#define ICEJSPrivilegeSSObjectListener_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEJSPrivilegeExtObjectListener.h"
#include "ICEJSPrivilegeSSObjectDeclarer.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEJSPrivilegeSSObjectListener ICEJSPrivilegeSSObjectListener
 * @{
 */

/*!
 * ID of ICEJSPrivilegeSSObjectListener
 */
#define CEComIID_ICEJSPrivilegeSSObjectListener 0x60bc4965


/*!
 * ICEJSPrivilegeSSObjectListener
 */
typedef struct ICEJSPrivilegeSSObjectListener
{
	const struct ICEJSPrivilegeSSObjectListener_vtbl* _vtbl;
} ICEJSPrivilegeSSObjectListener;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iJSPrivilegeSSObjectListener	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEJSPrivilegeSSObjectListener_queryInterface) (ICEJSPrivilegeSSObjectListener* iJSPrivilegeSSObjectListener, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSPrivilegeSSObjectListener_addRef) (ICEJSPrivilegeSSObjectListener* iJSPrivilegeSSObjectListener);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSPrivilegeSSObjectListener_release) (ICEJSPrivilegeSSObjectListener* iJSPrivilegeSSObjectListener);

typedef CEHResult (*iCEJSPrivilegeSSObjectListener_handleDeclarePrivilegeSSObject) (ICEJSPrivilegeSSObjectListener* iJSPrivilegeSSObjectListener, struct ICEJSPrivilegeSSObjectDeclarer* iDeclarer);

typedef CEHResult (*iCEJSPrivilegeSSObjectListener_handleDeclarePrivilegeSSObjectWithParent) (ICEJSPrivilegeSSObjectListener* iJSPrivilegeSSObjectListener, struct ICEJSPrivilegeSSObjectParent* iParent, struct ICEJSPrivilegeSSObjectDeclarer* iDeclarer);

typedef CEHResult (*iCEJSPrivilegeSSObjectListener_handleAuthorize) (ICEJSPrivilegeSSObjectListener* iJSPrivilegeSSObjectListener, INT32 classId, struct ICEHtmlCredential* iCredential, CEJSAuthStatus* statusOut, INT_PTR* objectIdOut);

typedef CEHResult (*iCEJSPrivilegeSSObjectListener_handleFinalizeObjectId) (ICEJSPrivilegeSSObjectListener* iJSPrivilegeSSObjectListener, INT_PTR objectId);

typedef CEHResult (*iCEJSPrivilegeSSObjectListener_handleDeclareProperty) (ICEJSPrivilegeSSObjectListener* iJSPrivilegeSSObjectListener, INT_PTR objectId, struct ICEJSSSPropertyDeclarer* iDeclarer);

typedef CEHResult (*iCEJSPrivilegeSSObjectListener_handleDeclarePropertyWithParent) (ICEJSPrivilegeSSObjectListener* iJSPrivilegeSSObjectListener, INT_PTR objectId, struct ICEJSSSPropertyParent* iParent, struct ICEJSSSPropertyDeclarer* iDeclarer);

typedef CEHResult (*iCEJSPrivilegeSSObjectListener_handleGetProperty) (ICEJSPrivilegeSSObjectListener* iJSPrivilegeSSObjectListener, INT_PTR objectId, INT32 propertyId, struct ICEJSExtVariantFactory* iFactory, struct ICEJSExtVariant** iValueOut);

typedef CEHResult (*iCEJSPrivilegeSSObjectListener_handleSetProperty) (ICEJSPrivilegeSSObjectListener* iJSPrivilegeSSObjectListener, INT_PTR objectId, INT32 propertyId, struct ICEJSExtVariant* iValue, struct ICEJSExtVariantFactory* iFactory, struct ICEJSExtVariant** iValueOut);

typedef CEHResult (*iCEJSPrivilegeSSObjectListener_handleIsDirtyProperty) (ICEJSPrivilegeSSObjectListener* iJSPrivilegeSSObjectListener, INT_PTR objectId, INT32 propertyId, CEJSIsDirtyStatus* statusOut);

typedef CEHResult (*iCEJSPrivilegeSSObjectListener_handleInvokeMethod) (ICEJSPrivilegeSSObjectListener* iJSPrivilegeSSObjectListener, INT_PTR objectId, INT32 methodId, struct ICEJSExtVariant** iArgValues, UINT32 argCount, struct ICEJSExtVariantFactory* iFactory, struct ICEJSExtVariant** iValueOut);

/*!
 * V-table of ICEJSPrivilegeSSObjectListener
 */
struct ICEJSPrivilegeSSObjectListener_vtbl
{
	iCEJSPrivilegeSSObjectListener_queryInterface	_queryInterface;	//!< Query interface.
	iCEJSPrivilegeSSObjectListener_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEJSPrivilegeSSObjectListener_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEJSPrivilegeSSObjectListener_handleDeclarePrivilegeSSObject	_handleDeclarePrivilegeSSObject;
	iCEJSPrivilegeSSObjectListener_handleDeclarePrivilegeSSObjectWithParent	_handleDeclarePrivilegeSSObjectWithParent;
	iCEJSPrivilegeSSObjectListener_handleAuthorize	_handleAuthorize;
	iCEJSPrivilegeSSObjectListener_handleFinalizeObjectId	_handleFinalizeObjectId;
	iCEJSPrivilegeSSObjectListener_handleDeclareProperty	_handleDeclareProperty;
	iCEJSPrivilegeSSObjectListener_handleDeclarePropertyWithParent	_handleDeclarePropertyWithParent;
	iCEJSPrivilegeSSObjectListener_handleGetProperty	_handleGetProperty;
	iCEJSPrivilegeSSObjectListener_handleSetProperty	_handleSetProperty;
	iCEJSPrivilegeSSObjectListener_handleIsDirtyProperty	_handleIsDirtyProperty;
	iCEJSPrivilegeSSObjectListener_handleInvokeMethod	_handleInvokeMethod;
};

/*! @}
 * end of ICEJSPrivilegeSSObjectListener
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEJSPrivilegeSSObjectListenerRef CEComICEJSPrivilegeSSObjectListenerRef
 * @{
 */

class CEComICEJSPrivilegeSSObjectListenerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEJSPrivilegeSSObjectListenerRef() : _iJSPrivilegeSSObjectListener(0) {}
	CEComICEJSPrivilegeSSObjectListenerRef(ICEJSPrivilegeSSObjectListener* iOther) : _iJSPrivilegeSSObjectListener(0)
	{
		if (iOther)
		{
			_iJSPrivilegeSSObjectListener = iOther;
			_iJSPrivilegeSSObjectListener->_vtbl->_addRef(_iJSPrivilegeSSObjectListener);
		}
	}

	CEComICEJSPrivilegeSSObjectListenerRef(const CEComICEJSPrivilegeSSObjectListenerRef& other) : _iJSPrivilegeSSObjectListener(0)
	{
		if (other._iJSPrivilegeSSObjectListener)
		{
			_iJSPrivilegeSSObjectListener = other._iJSPrivilegeSSObjectListener;
			_iJSPrivilegeSSObjectListener->_vtbl->_addRef(_iJSPrivilegeSSObjectListener);
		}
	}

	~CEComICEJSPrivilegeSSObjectListenerRef()
	{
		if (_iJSPrivilegeSSObjectListener)
		{
			ICEJSPrivilegeSSObjectListener* tmp = _iJSPrivilegeSSObjectListener;
			_iJSPrivilegeSSObjectListener = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEJSPrivilegeSSObjectListener* iJSPrivilegeSSObjectListener;
				void* _ptr;
			} uIntf;
			uIntf.iJSPrivilegeSSObjectListener = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEJSPrivilegeSSObjectListener, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iJSPrivilegeSSObjectListener)
				{
					ICEJSPrivilegeSSObjectListener* tmp = _iJSPrivilegeSSObjectListener;
					_iJSPrivilegeSSObjectListener = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iJSPrivilegeSSObjectListener = uIntf.iJSPrivilegeSSObjectListener;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeSSObjectListener* object() const	{ return _iJSPrivilegeSSObjectListener; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEJSPrivilegeSSObjectListener* iOther)
	{
		if (_iJSPrivilegeSSObjectListener)
		{
			ICEJSPrivilegeSSObjectListener* tmp = _iJSPrivilegeSSObjectListener;
			_iJSPrivilegeSSObjectListener = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iJSPrivilegeSSObjectListener = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEJSPrivilegeSSObjectListener* detach()
	{
		ICEJSPrivilegeSSObjectListener* iIntf = _iJSPrivilegeSSObjectListener;
		_iJSPrivilegeSSObjectListener = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEJSPrivilegeSSObjectListener* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iJSPrivilegeSSObjectListener;
		if (_iJSPrivilegeSSObjectListener)
		{
			_iJSPrivilegeSSObjectListener->_vtbl->_addRef(_iJSPrivilegeSSObjectListener);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEJSPrivilegeSSObjectListener*() const	{ return _iJSPrivilegeSSObjectListener; }
	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeSSObjectListener& operator*() const	{ return *_iJSPrivilegeSSObjectListener; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iJSPrivilegeSSObjectListener == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEJSPrivilegeSSObjectListener* iOther) const	{ return (_iJSPrivilegeSSObjectListener != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEJSPrivilegeSSObjectListener* iOther) const	{ return (_iJSPrivilegeSSObjectListener == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEJSPrivilegeSSObjectListenerRef& operator=(const CEComICEJSPrivilegeSSObjectListenerRef& other)	{ return operator=(other._iJSPrivilegeSSObjectListener); }

	CEComICEJSPrivilegeSSObjectListenerRef& operator=(const ICEJSPrivilegeSSObjectListener* iOther)
	{
		if (_iJSPrivilegeSSObjectListener != iOther)
		{
			if (_iJSPrivilegeSSObjectListener)
			{
				ICEJSPrivilegeSSObjectListener* tmp = _iJSPrivilegeSSObjectListener;
				_iJSPrivilegeSSObjectListener = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iJSPrivilegeSSObjectListener = const_cast<ICEJSPrivilegeSSObjectListener*>(iOther);
			if (_iJSPrivilegeSSObjectListener)
			{
				_iJSPrivilegeSSObjectListener->_vtbl->_addRef(_iJSPrivilegeSSObjectListener);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeSSObjectListener** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEJSPrivilegeSSObjectListenerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iJSPrivilegeSSObjectListener && "has a com object reference. clear first.");
		return & _iJSPrivilegeSSObjectListener; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEJSPrivilegeSSObjectListenerRef& other)
	{
		bool result = false;
		if (_iJSPrivilegeSSObjectListener)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iJSPrivilegeSSObjectListener);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iJSPrivilegeSSObjectListener ? _iJSPrivilegeSSObjectListener->_vtbl->_queryInterface(_iJSPrivilegeSSObjectListener, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iJSPrivilegeSSObjectListener) { _iJSPrivilegeSSObjectListener->_vtbl->_addRef(_iJSPrivilegeSSObjectListener); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iJSPrivilegeSSObjectListener) { _iJSPrivilegeSSObjectListener->_vtbl->_release(_iJSPrivilegeSSObjectListener); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleDeclarePrivilegeSSObject(struct ICEJSPrivilegeSSObjectDeclarer* iDeclarer)	{ return _iJSPrivilegeSSObjectListener ? _iJSPrivilegeSSObjectListener->_vtbl->_handleDeclarePrivilegeSSObject(_iJSPrivilegeSSObjectListener, iDeclarer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleDeclarePrivilegeSSObjectWithParent(struct ICEJSPrivilegeSSObjectParent* iParent, struct ICEJSPrivilegeSSObjectDeclarer* iDeclarer)	{ return _iJSPrivilegeSSObjectListener ? _iJSPrivilegeSSObjectListener->_vtbl->_handleDeclarePrivilegeSSObjectWithParent(_iJSPrivilegeSSObjectListener, iParent, iDeclarer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleAuthorize(INT32 classId, struct ICEHtmlCredential* iCredential, CEJSAuthStatus* statusOut, INT_PTR* objectIdOut)	{ return _iJSPrivilegeSSObjectListener ? _iJSPrivilegeSSObjectListener->_vtbl->_handleAuthorize(_iJSPrivilegeSSObjectListener, classId, iCredential, statusOut, objectIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleFinalizeObjectId(INT_PTR objectId)	{ return _iJSPrivilegeSSObjectListener ? _iJSPrivilegeSSObjectListener->_vtbl->_handleFinalizeObjectId(_iJSPrivilegeSSObjectListener, objectId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleDeclareProperty(INT_PTR objectId, struct ICEJSSSPropertyDeclarer* iDeclarer)	{ return _iJSPrivilegeSSObjectListener ? _iJSPrivilegeSSObjectListener->_vtbl->_handleDeclareProperty(_iJSPrivilegeSSObjectListener, objectId, iDeclarer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleDeclarePropertyWithParent(INT_PTR objectId, struct ICEJSSSPropertyParent* iParent, struct ICEJSSSPropertyDeclarer* iDeclarer)	{ return _iJSPrivilegeSSObjectListener ? _iJSPrivilegeSSObjectListener->_vtbl->_handleDeclarePropertyWithParent(_iJSPrivilegeSSObjectListener, objectId, iParent, iDeclarer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleGetProperty(INT_PTR objectId, INT32 propertyId, struct ICEJSExtVariantFactory* iFactory, struct ICEJSExtVariant** iValueOut)	{ return _iJSPrivilegeSSObjectListener ? _iJSPrivilegeSSObjectListener->_vtbl->_handleGetProperty(_iJSPrivilegeSSObjectListener, objectId, propertyId, iFactory, iValueOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleSetProperty(INT_PTR objectId, INT32 propertyId, struct ICEJSExtVariant* iValue, struct ICEJSExtVariantFactory* iFactory, struct ICEJSExtVariant** iValueOut)	{ return _iJSPrivilegeSSObjectListener ? _iJSPrivilegeSSObjectListener->_vtbl->_handleSetProperty(_iJSPrivilegeSSObjectListener, objectId, propertyId, iValue, iFactory, iValueOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleIsDirtyProperty(INT_PTR objectId, INT32 propertyId, CEJSIsDirtyStatus* statusOut)	{ return _iJSPrivilegeSSObjectListener ? _iJSPrivilegeSSObjectListener->_vtbl->_handleIsDirtyProperty(_iJSPrivilegeSSObjectListener, objectId, propertyId, statusOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleInvokeMethod(INT_PTR objectId, INT32 methodId, struct ICEJSExtVariant** iArgValues, UINT32 argCount, struct ICEJSExtVariantFactory* iFactory, struct ICEJSExtVariant** iValueOut)	{ return _iJSPrivilegeSSObjectListener ? _iJSPrivilegeSSObjectListener->_vtbl->_handleInvokeMethod(_iJSPrivilegeSSObjectListener, objectId, methodId, iArgValues, argCount, iFactory, iValueOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEJSPrivilegeSSObjectListener* _iJSPrivilegeSSObjectListener;
};

/*! @}
 * end of CEComICEJSPrivilegeSSObjectListenerRef
 */

#endif // __cplusplus

#endif
