///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEJSExtVariant_h
#define ICEJSExtVariant_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
	CEJSVariantType_Undefined,
	CEJSVariantType_Null,
	CEJSVariantType_Boolean,
	CEJSVariantType_Number,
	CEJSVariantType_String,
	CEJSVariantType_Object
} CEJSExtVariantType;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEJSExtVariant ICEJSExtVariant
 * @{
 */

/*!
 * ID of ICEJSExtVariant
 */
#define CEComIID_ICEJSExtVariant 0xa93135c0


/*!
 * ICEJSExtVariant
 */
typedef struct ICEJSExtVariant
{
	const struct ICEJSExtVariant_vtbl* _vtbl;
} ICEJSExtVariant;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iJSExtVariant	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEJSExtVariant_queryInterface) (ICEJSExtVariant* iJSExtVariant, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSExtVariant_addRef) (ICEJSExtVariant* iJSExtVariant);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSExtVariant_release) (ICEJSExtVariant* iJSExtVariant);

typedef CEHResult (*iCEJSExtVariant_getType) (ICEJSExtVariant* iJSExtVariant, CEJSExtVariantType* typeOut);

typedef CEHResult (*iCEJSExtVariant_toBoolean) (ICEJSExtVariant* iJSExtVariant, UINT8* booleanOut);

typedef CEHResult (*iCEJSExtVariant_toNumber) (ICEJSExtVariant* iJSExtVariant, double* numberOut);

typedef CEHResult (*iCEJSExtVariant_toInteger) (ICEJSExtVariant* iJSExtVariant, double* integerOut);

typedef CEHResult (*iCEJSExtVariant_toInt32) (ICEJSExtVariant* iJSExtVariant, INT32* int32Out);

typedef CEHResult (*iCEJSExtVariant_toUint32) (ICEJSExtVariant* iJSExtVariant, UINT32* uint32Out);

typedef CEHResult (*iCEJSExtVariant_toUint16) (ICEJSExtVariant* iJSExtVariant, UINT16* uint16Out);

typedef CEHResult (*iCEJSExtVariant_toString) (ICEJSExtVariant* iJSExtVariant, const UTF16CHAR **const pCharArray16Out, UINT32 *const numOfChars16Out);

/*!
 * V-table of ICEJSExtVariant
 */
struct ICEJSExtVariant_vtbl
{
	iCEJSExtVariant_queryInterface	_queryInterface;	//!< Query interface.
	iCEJSExtVariant_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEJSExtVariant_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEJSExtVariant_getType	_getType;
	iCEJSExtVariant_toBoolean	_toBoolean;
	iCEJSExtVariant_toNumber	_toNumber;
	iCEJSExtVariant_toInteger	_toInteger;
	iCEJSExtVariant_toInt32	_toInt32;
	iCEJSExtVariant_toUint32	_toUint32;
	iCEJSExtVariant_toUint16	_toUint16;
	iCEJSExtVariant_toString	_toString;
};

/*! @}
 * end of ICEJSExtVariant
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEJSExtVariantRef CEComICEJSExtVariantRef
 * @{
 */

class CEComICEJSExtVariantRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEJSExtVariantRef() : _iJSExtVariant(0) {}
	CEComICEJSExtVariantRef(ICEJSExtVariant* iOther) : _iJSExtVariant(0)
	{
		if (iOther)
		{
			_iJSExtVariant = iOther;
			_iJSExtVariant->_vtbl->_addRef(_iJSExtVariant);
		}
	}

	CEComICEJSExtVariantRef(const CEComICEJSExtVariantRef& other) : _iJSExtVariant(0)
	{
		if (other._iJSExtVariant)
		{
			_iJSExtVariant = other._iJSExtVariant;
			_iJSExtVariant->_vtbl->_addRef(_iJSExtVariant);
		}
	}

	~CEComICEJSExtVariantRef()
	{
		if (_iJSExtVariant)
		{
			ICEJSExtVariant* tmp = _iJSExtVariant;
			_iJSExtVariant = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEJSExtVariant* iJSExtVariant;
				void* _ptr;
			} uIntf;
			uIntf.iJSExtVariant = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEJSExtVariant, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iJSExtVariant)
				{
					ICEJSExtVariant* tmp = _iJSExtVariant;
					_iJSExtVariant = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iJSExtVariant = uIntf.iJSExtVariant;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEJSExtVariant* object() const	{ return _iJSExtVariant; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEJSExtVariant* iOther)
	{
		if (_iJSExtVariant)
		{
			ICEJSExtVariant* tmp = _iJSExtVariant;
			_iJSExtVariant = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iJSExtVariant = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEJSExtVariant* detach()
	{
		ICEJSExtVariant* iIntf = _iJSExtVariant;
		_iJSExtVariant = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEJSExtVariant* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iJSExtVariant;
		if (_iJSExtVariant)
		{
			_iJSExtVariant->_vtbl->_addRef(_iJSExtVariant);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEJSExtVariant*() const	{ return _iJSExtVariant; }
	FORCEINLINE_WITHOUT_DEBUG ICEJSExtVariant& operator*() const	{ return *_iJSExtVariant; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iJSExtVariant == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEJSExtVariant* iOther) const	{ return (_iJSExtVariant != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEJSExtVariant* iOther) const	{ return (_iJSExtVariant == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEJSExtVariantRef& operator=(const CEComICEJSExtVariantRef& other)	{ return operator=(other._iJSExtVariant); }

	CEComICEJSExtVariantRef& operator=(const ICEJSExtVariant* iOther)
	{
		if (_iJSExtVariant != iOther)
		{
			if (_iJSExtVariant)
			{
				ICEJSExtVariant* tmp = _iJSExtVariant;
				_iJSExtVariant = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iJSExtVariant = const_cast<ICEJSExtVariant*>(iOther);
			if (_iJSExtVariant)
			{
				_iJSExtVariant->_vtbl->_addRef(_iJSExtVariant);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEJSExtVariant** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEJSExtVariantRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iJSExtVariant && "has a com object reference. clear first.");
		return & _iJSExtVariant; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEJSExtVariantRef& other)
	{
		bool result = false;
		if (_iJSExtVariant)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iJSExtVariant);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iJSExtVariant ? _iJSExtVariant->_vtbl->_queryInterface(_iJSExtVariant, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iJSExtVariant) { _iJSExtVariant->_vtbl->_addRef(_iJSExtVariant); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iJSExtVariant) { _iJSExtVariant->_vtbl->_release(_iJSExtVariant); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getType(CEJSExtVariantType* typeOut)	{ return _iJSExtVariant ? _iJSExtVariant->_vtbl->_getType(_iJSExtVariant, typeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult toBoolean(UINT8* booleanOut)	{ return _iJSExtVariant ? _iJSExtVariant->_vtbl->_toBoolean(_iJSExtVariant, booleanOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult toNumber(double* numberOut)	{ return _iJSExtVariant ? _iJSExtVariant->_vtbl->_toNumber(_iJSExtVariant, numberOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult toInteger(double* integerOut)	{ return _iJSExtVariant ? _iJSExtVariant->_vtbl->_toInteger(_iJSExtVariant, integerOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult toInt32(INT32* int32Out)	{ return _iJSExtVariant ? _iJSExtVariant->_vtbl->_toInt32(_iJSExtVariant, int32Out) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult toUint32(UINT32* uint32Out)	{ return _iJSExtVariant ? _iJSExtVariant->_vtbl->_toUint32(_iJSExtVariant, uint32Out) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult toUint16(UINT16* uint16Out)	{ return _iJSExtVariant ? _iJSExtVariant->_vtbl->_toUint16(_iJSExtVariant, uint16Out) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult toString(const UTF16CHAR **const pCharArray16Out, UINT32 *const numOfChars16Out)	{ return _iJSExtVariant ? _iJSExtVariant->_vtbl->_toString(_iJSExtVariant, pCharArray16Out, numOfChars16Out) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEJSExtVariant* _iJSExtVariant;
};

/*! @}
 * end of CEComICEJSExtVariantRef
 */

#endif // __cplusplus

#endif
