///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEJSException_h
#define ICEJSException_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEJSException ICEJSException
 * @{
 */

/*!
 * ID of ICEJSException
 */
#define CEComIID_ICEJSException 0x853ea904


/*!
 * ICEJSException
 */
typedef struct ICEJSException
{
	const struct ICEJSException_vtbl* _vtbl;
} ICEJSException;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iJSException	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEJSException_queryInterface) (ICEJSException* iJSException, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSException_addRef) (ICEJSException* iJSException);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSException_release) (ICEJSException* iJSException);

typedef CEHResult (*iCEJSException_getMessage) (ICEJSException* iJSException, const UTF16CHAR **const pCharArray16Out, UINT32 *const pNumOfChars16Out);

/*!
 * V-table of ICEJSException
 */
struct ICEJSException_vtbl
{
	iCEJSException_queryInterface	_queryInterface;	//!< Query interface.
	iCEJSException_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEJSException_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEJSException_getMessage	_getMessage;
};

/*! @}
 * end of ICEJSException
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEJSExceptionRef CEComICEJSExceptionRef
 * @{
 */

class CEComICEJSExceptionRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEJSExceptionRef() : _iJSException(0) {}
	CEComICEJSExceptionRef(ICEJSException* iOther) : _iJSException(0)
	{
		if (iOther)
		{
			_iJSException = iOther;
			_iJSException->_vtbl->_addRef(_iJSException);
		}
	}

	CEComICEJSExceptionRef(const CEComICEJSExceptionRef& other) : _iJSException(0)
	{
		if (other._iJSException)
		{
			_iJSException = other._iJSException;
			_iJSException->_vtbl->_addRef(_iJSException);
		}
	}

	~CEComICEJSExceptionRef()
	{
		if (_iJSException)
		{
			ICEJSException* tmp = _iJSException;
			_iJSException = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEJSException* iJSException;
				void* _ptr;
			} uIntf;
			uIntf.iJSException = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEJSException, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iJSException)
				{
					ICEJSException* tmp = _iJSException;
					_iJSException = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iJSException = uIntf.iJSException;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEJSException* object() const	{ return _iJSException; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEJSException* iOther)
	{
		if (_iJSException)
		{
			ICEJSException* tmp = _iJSException;
			_iJSException = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iJSException = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEJSException* detach()
	{
		ICEJSException* iIntf = _iJSException;
		_iJSException = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEJSException* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iJSException;
		if (_iJSException)
		{
			_iJSException->_vtbl->_addRef(_iJSException);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEJSException*() const	{ return _iJSException; }
	FORCEINLINE_WITHOUT_DEBUG ICEJSException& operator*() const	{ return *_iJSException; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iJSException == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEJSException* iOther) const	{ return (_iJSException != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEJSException* iOther) const	{ return (_iJSException == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEJSExceptionRef& operator=(const CEComICEJSExceptionRef& other)	{ return operator=(other._iJSException); }

	CEComICEJSExceptionRef& operator=(const ICEJSException* iOther)
	{
		if (_iJSException != iOther)
		{
			if (_iJSException)
			{
				ICEJSException* tmp = _iJSException;
				_iJSException = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iJSException = const_cast<ICEJSException*>(iOther);
			if (_iJSException)
			{
				_iJSException->_vtbl->_addRef(_iJSException);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEJSException** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEJSExceptionRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iJSException && "has a com object reference. clear first.");
		return & _iJSException; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEJSExceptionRef& other)
	{
		bool result = false;
		if (_iJSException)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iJSException);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iJSException ? _iJSException->_vtbl->_queryInterface(_iJSException, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iJSException) { _iJSException->_vtbl->_addRef(_iJSException); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iJSException) { _iJSException->_vtbl->_release(_iJSException); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getMessage(const UTF16CHAR **const pCharArray16Out, UINT32 *const pNumOfChars16Out)	{ return _iJSException ? _iJSException->_vtbl->_getMessage(_iJSException, pCharArray16Out, pNumOfChars16Out) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEJSException* _iJSException;
};

/*! @}
 * end of CEComICEJSExceptionRef
 */

#endif // __cplusplus

#endif
