///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEI18nTypes_h
#define ICEI18nTypes_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------


#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------


/*!
 * Character encoding type
 */
typedef enum
{
	eICEI18nEncoding_FIRST = 0,	
	eICEI18nEncoding_Unknown = eICEI18nEncoding_FIRST,
	eICEI18nEncoding_ucs_2,			//! Unicode (UCS-2)
	eICEI18nEncoding_us_ascii,							//! CP=20127, [US-ASCII]
	eICEI18nEncoding_utf_8,								//! CP=65001, [Unicode (UTF-8)]
	eICEI18nEncoding_LAST = eICEI18nEncoding_utf_8
} eICEI18nEncoding;


/*!
* see RFC 3066. TBD.
*/
typedef enum
{
	eCEI18nLanguageTagType_Iso,
	eCEI18nLanguageTagType_Iana,
	eCEI18nLanguageTagType_Experimental,
	eCEI18nLanguageTagType_LAST = eCEI18nLanguageTagType_Experimental
} eCEI18nLanguageTagType;


/*!
 * see RFC 3808, June 2004.
 */
typedef enum
{
	eCEI18nIanaMIBEnum_other = 1,   // used if the designated character set is not currently registered by IANA
	eCEI18nIanaMIBEnum_unknown = 2, // used as a default value
	eCEI18nIanaMIBEnum_csASCII = 3,
	eCEI18nIanaMIBEnum_csISOLatin1 = 4,
	eCEI18nIanaMIBEnum_csISOLatin2 = 5,
	eCEI18nIanaMIBEnum_csISOLatin3 = 6,
	eCEI18nIanaMIBEnum_csISOLatin4 = 7,
	eCEI18nIanaMIBEnum_csISOLatinCyrillic = 8,
	eCEI18nIanaMIBEnum_csISOLatinArabic = 9,
	eCEI18nIanaMIBEnum_csISOLatinGreek = 10,
	eCEI18nIanaMIBEnum_csISOLatinHebrew = 11,
	eCEI18nIanaMIBEnum_csISOLatin5 = 12,
	eCEI18nIanaMIBEnum_csISOLatin6 = 13,
	eCEI18nIanaMIBEnum_csISOTextComm = 14,
	eCEI18nIanaMIBEnum_csHalfWidthKatakana = 15,
	eCEI18nIanaMIBEnum_csJISEncoding = 16,
	eCEI18nIanaMIBEnum_csShiftJIS = 17,
	eCEI18nIanaMIBEnum_csEUCPkdFmtJapanese = 18,
	eCEI18nIanaMIBEnum_csEUCFixWidJapanese = 19,
	eCEI18nIanaMIBEnum_csISO4UnitedKingdom = 20,
	eCEI18nIanaMIBEnum_csISO11SwedishForNames = 21,
	eCEI18nIanaMIBEnum_csISO15Italian = 22,
	eCEI18nIanaMIBEnum_csISO17Spanish = 23,
	eCEI18nIanaMIBEnum_csISO21German = 24,
	eCEI18nIanaMIBEnum_csISO60DanishNorwegian = 25,
	eCEI18nIanaMIBEnum_csISO69French = 26,
	eCEI18nIanaMIBEnum_csISO10646UTF1 = 27,
	eCEI18nIanaMIBEnum_csISO646basic1983 = 28,
	eCEI18nIanaMIBEnum_csINVARIANT = 29,
	eCEI18nIanaMIBEnum_csISO2IntlRefVersion = 30,
	eCEI18nIanaMIBEnum_csNATSSEFI = 31,
	eCEI18nIanaMIBEnum_csNATSSEFIADD = 32,
	eCEI18nIanaMIBEnum_csNATSDANO = 33,
	eCEI18nIanaMIBEnum_csNATSDANOADD = 34,
	eCEI18nIanaMIBEnum_csISO10Swedish = 35,
	eCEI18nIanaMIBEnum_csKSC56011987 = 36,
	eCEI18nIanaMIBEnum_csISO2022KR = 37,
	eCEI18nIanaMIBEnum_csEUCKR = 38,
	eCEI18nIanaMIBEnum_csISO2022JP = 39,
	eCEI18nIanaMIBEnum_csISO2022JP2 = 40,
	eCEI18nIanaMIBEnum_csISO13JISC6220jp = 41,
	eCEI18nIanaMIBEnum_csISO14JISC6220ro = 42,
	eCEI18nIanaMIBEnum_csISO16Portuguese = 43,
	eCEI18nIanaMIBEnum_csISO18Greek7Old = 44,
	eCEI18nIanaMIBEnum_csISO19LatinGreek = 45,
	eCEI18nIanaMIBEnum_csISO25French = 46,
	eCEI18nIanaMIBEnum_csISO27LatinGreek1 = 47,
	eCEI18nIanaMIBEnum_csISO5427Cyrillic = 48,
	eCEI18nIanaMIBEnum_csISO42JISC62261978 = 49,
	eCEI18nIanaMIBEnum_csISO47BSViewdata = 50,
	eCEI18nIanaMIBEnum_csISO49INIS = 51,
	eCEI18nIanaMIBEnum_csISO50INIS8 = 52,
	eCEI18nIanaMIBEnum_csISO51INISCyrillic = 53,
	eCEI18nIanaMIBEnum_csISO54271981 = 54,
	eCEI18nIanaMIBEnum_csISO5428Greek = 55,
	eCEI18nIanaMIBEnum_csISO57GB1988 = 56,
	eCEI18nIanaMIBEnum_csISO58GB231280 = 57,
	eCEI18nIanaMIBEnum_csISO61Norwegian2 = 58,
	eCEI18nIanaMIBEnum_csISO70VideotexSupp1 = 59,
	eCEI18nIanaMIBEnum_csISO84Portuguese2 = 60,
	eCEI18nIanaMIBEnum_csISO85Spanish2 = 61,
	eCEI18nIanaMIBEnum_csISO86Hungarian = 62,
	eCEI18nIanaMIBEnum_csISO87JISX0208 = 63,
	eCEI18nIanaMIBEnum_csISO88Greek7 = 64,
	eCEI18nIanaMIBEnum_csISO89ASMO449 = 65,
	eCEI18nIanaMIBEnum_csISO90 = 66,
	eCEI18nIanaMIBEnum_csISO91JISC62291984a = 67,
	eCEI18nIanaMIBEnum_csISO92JISC62991984b = 68,
	eCEI18nIanaMIBEnum_csISO93JIS62291984badd = 69,
	eCEI18nIanaMIBEnum_csISO94JIS62291984hand = 70,
	eCEI18nIanaMIBEnum_csISO95JIS62291984handadd = 71,
	eCEI18nIanaMIBEnum_csISO96JISC62291984kana = 72,
	eCEI18nIanaMIBEnum_csISO2033 = 73,
	eCEI18nIanaMIBEnum_csISO99NAPLPS = 74,
	eCEI18nIanaMIBEnum_csISO102T617bit = 75,
	eCEI18nIanaMIBEnum_csISO103T618bit = 76,
	eCEI18nIanaMIBEnum_csISO111ECMACyrillic = 77,
	eCEI18nIanaMIBEnum_csa71 = 78,
	eCEI18nIanaMIBEnum_csa72 = 79,
	eCEI18nIanaMIBEnum_csISO123CSAZ24341985gr = 80,
	eCEI18nIanaMIBEnum_csISO88596E = 81,
	eCEI18nIanaMIBEnum_csISO88596I = 82,
	eCEI18nIanaMIBEnum_csISO128T101G2 = 83,
	eCEI18nIanaMIBEnum_csISO88598E = 84,
	eCEI18nIanaMIBEnum_csISO88598I = 85,
	eCEI18nIanaMIBEnum_csISO139CSN369103 = 86,
	eCEI18nIanaMIBEnum_csISO141JUSIB1002 = 87,
	eCEI18nIanaMIBEnum_csISO143IECP271 = 88,
	eCEI18nIanaMIBEnum_csISO146Serbian = 89,
	eCEI18nIanaMIBEnum_csISO147Macedonian = 90,
	eCEI18nIanaMIBEnum_csISO150 = 91,
	eCEI18nIanaMIBEnum_csISO151Cuba = 92,
	eCEI18nIanaMIBEnum_csISO6937Add = 93,
	eCEI18nIanaMIBEnum_csISO153GOST1976874 = 94,
	eCEI18nIanaMIBEnum_csISO8859Supp = 95,
	eCEI18nIanaMIBEnum_csISO10367Box = 96,
	eCEI18nIanaMIBEnum_csISO158Lap = 97,
	eCEI18nIanaMIBEnum_csISO159JISX02121990 = 98,
	eCEI18nIanaMIBEnum_csISO646Danish = 99,
	eCEI18nIanaMIBEnum_csUSDK = 100,
	eCEI18nIanaMIBEnum_csDKUS = 101,
	eCEI18nIanaMIBEnum_csKSC5636 = 102,
	eCEI18nIanaMIBEnum_csUnicode11UTF7 = 103,
	eCEI18nIanaMIBEnum_csISO2022CN = 104,
	eCEI18nIanaMIBEnum_csISO2022CNEXT = 105,
	eCEI18nIanaMIBEnum_csUTF8 = 106,
	eCEI18nIanaMIBEnum_csISO885913 = 109,
	eCEI18nIanaMIBEnum_csISO885914 = 110,
	eCEI18nIanaMIBEnum_csISO885915 = 111,
	eCEI18nIanaMIBEnum_csISO885916 = 112,
	eCEI18nIanaMIBEnum_csGBK = 113,
	eCEI18nIanaMIBEnum_csGB18030 = 114,
	eCEI18nIanaMIBEnum_csOSDEBCDICDF0415 = 115,
	eCEI18nIanaMIBEnum_csOSDEBCDICDF03IRV = 116,
	eCEI18nIanaMIBEnum_csOSDEBCDICDF041 = 117,
	eCEI18nIanaMIBEnum_csUnicode = 1000,
	eCEI18nIanaMIBEnum_csUCS4 = 1001,
	eCEI18nIanaMIBEnum_csUnicodeASCII = 1002,
	eCEI18nIanaMIBEnum_csUnicodeLatin1 = 1003,
	eCEI18nIanaMIBEnum_csUnicodeIBM1261 = 1005,
	eCEI18nIanaMIBEnum_csUnicodeIBM1268 = 1006,
	eCEI18nIanaMIBEnum_csUnicodeIBM1276 = 1007,
	eCEI18nIanaMIBEnum_csUnicodeIBM1264 = 1008,
	eCEI18nIanaMIBEnum_csUnicodeIBM1265 = 1009,
	eCEI18nIanaMIBEnum_csUnicode11 = 1010,
	eCEI18nIanaMIBEnum_csSCSU = 1011,
	eCEI18nIanaMIBEnum_csUTF7 = 1012,
	eCEI18nIanaMIBEnum_csUTF16BE = 1013,
	eCEI18nIanaMIBEnum_csUTF16LE = 1014,
	eCEI18nIanaMIBEnum_csUTF16 = 1015,
	eCEI18nIanaMIBEnum_csCESU8 = 1016,
	eCEI18nIanaMIBEnum_csUTF32 = 1017,
	eCEI18nIanaMIBEnum_csUTF32BE = 1018,
	eCEI18nIanaMIBEnum_csUTF32LE = 1019,
	eCEI18nIanaMIBEnum_csBOCU1 = 1020,
	eCEI18nIanaMIBEnum_csWindows30Latin1 = 2000,
	eCEI18nIanaMIBEnum_csWindows31Latin1 = 2001,
	eCEI18nIanaMIBEnum_csWindows31Latin2 = 2002,
	eCEI18nIanaMIBEnum_csWindows31Latin5 = 2003,
	eCEI18nIanaMIBEnum_csHPRoman8 = 2004,
	eCEI18nIanaMIBEnum_csAdobeStandardEncoding = 2005,
	eCEI18nIanaMIBEnum_csVenturaUS = 2006,
	eCEI18nIanaMIBEnum_csVenturaInternational = 2007,
	eCEI18nIanaMIBEnum_csDECMCS = 2008,
	eCEI18nIanaMIBEnum_csPC850Multilingual = 2009,
	eCEI18nIanaMIBEnum_csPCp852 = 2010,
	eCEI18nIanaMIBEnum_csPC8CodePage437 = 2011,
	eCEI18nIanaMIBEnum_csPC8DanishNorwegian = 2012,
	eCEI18nIanaMIBEnum_csPC862LatinHebrew = 2013,
	eCEI18nIanaMIBEnum_csPC8Turkish = 2014,
	eCEI18nIanaMIBEnum_csIBMSymbols = 2015,
	eCEI18nIanaMIBEnum_csIBMThai = 2016,
	eCEI18nIanaMIBEnum_csHPLegal = 2017,
	eCEI18nIanaMIBEnum_csHPPiFont = 2018,
	eCEI18nIanaMIBEnum_csHPMath8 = 2019,
	eCEI18nIanaMIBEnum_csHPPSMath = 2020,
	eCEI18nIanaMIBEnum_csHPDesktop = 2021,
	eCEI18nIanaMIBEnum_csVenturaMath = 2022,
	eCEI18nIanaMIBEnum_csMicrosoftPublishing = 2023,
	eCEI18nIanaMIBEnum_csWindows31J = 2024,
	eCEI18nIanaMIBEnum_csGB2312 = 2025,
	eCEI18nIanaMIBEnum_csBig5 = 2026,
	eCEI18nIanaMIBEnum_csMacintosh = 2027,
	eCEI18nIanaMIBEnum_csIBM037 = 2028,
	eCEI18nIanaMIBEnum_csIBM038 = 2029,
	eCEI18nIanaMIBEnum_csIBM273 = 2030,
	eCEI18nIanaMIBEnum_csIBM274 = 2031,
	eCEI18nIanaMIBEnum_csIBM275 = 2032,
	eCEI18nIanaMIBEnum_csIBM277 = 2033,
	eCEI18nIanaMIBEnum_csIBM278 = 2034,
	eCEI18nIanaMIBEnum_csIBM280 = 2035,
	eCEI18nIanaMIBEnum_csIBM281 = 2036,
	eCEI18nIanaMIBEnum_csIBM284 = 2037,
	eCEI18nIanaMIBEnum_csIBM285 = 2038,
	eCEI18nIanaMIBEnum_csIBM290 = 2039,
	eCEI18nIanaMIBEnum_csIBM297 = 2040,
	eCEI18nIanaMIBEnum_csIBM420 = 2041,
	eCEI18nIanaMIBEnum_csIBM423 = 2042,
	eCEI18nIanaMIBEnum_csIBM424 = 2043,
	eCEI18nIanaMIBEnum_csIBM500 = 2044,
	eCEI18nIanaMIBEnum_csIBM851 = 2045,
	eCEI18nIanaMIBEnum_csIBM855 = 2046,
	eCEI18nIanaMIBEnum_csIBM857 = 2047,
	eCEI18nIanaMIBEnum_csIBM860 = 2048,
	eCEI18nIanaMIBEnum_csIBM861 = 2049,
	eCEI18nIanaMIBEnum_csIBM863 = 2050,
	eCEI18nIanaMIBEnum_csIBM864 = 2051,
	eCEI18nIanaMIBEnum_csIBM865 = 2052,
	eCEI18nIanaMIBEnum_csIBM868 = 2053,
	eCEI18nIanaMIBEnum_csIBM869 = 2054,
	eCEI18nIanaMIBEnum_csIBM870 = 2055,
	eCEI18nIanaMIBEnum_csIBM871 = 2056,
	eCEI18nIanaMIBEnum_csIBM880 = 2057,
	eCEI18nIanaMIBEnum_csIBM891 = 2058,
	eCEI18nIanaMIBEnum_csIBM903 = 2059,
	eCEI18nIanaMIBEnum_csIBBM904 = 2060,
	eCEI18nIanaMIBEnum_csIBM905 = 2061,
	eCEI18nIanaMIBEnum_csIBM918 = 2062,
	eCEI18nIanaMIBEnum_csIBM1026 = 2063,
	eCEI18nIanaMIBEnum_csIBMEBCDICATDE = 2064,
	eCEI18nIanaMIBEnum_csEBCDICATDEA = 2065,
	eCEI18nIanaMIBEnum_csEBCDICCAFR = 2066,
	eCEI18nIanaMIBEnum_csEBCDICDKNO = 2067,
	eCEI18nIanaMIBEnum_csEBCDICDKNOA = 2068,
	eCEI18nIanaMIBEnum_csEBCDICFISE = 2069,
	eCEI18nIanaMIBEnum_csEBCDICFISEA = 2070,
	eCEI18nIanaMIBEnum_csEBCDICFR = 2071,
	eCEI18nIanaMIBEnum_csEBCDICIT = 2072,
	eCEI18nIanaMIBEnum_csEBCDICPT = 2073,
	eCEI18nIanaMIBEnum_csEBCDICES = 2074,
	eCEI18nIanaMIBEnum_csEBCDICESA = 2075,
	eCEI18nIanaMIBEnum_csEBCDICESS = 2076,
	eCEI18nIanaMIBEnum_csEBCDICUK = 2077,
	eCEI18nIanaMIBEnum_csEBCDICUS = 2078,
	eCEI18nIanaMIBEnum_csUnknown8BiT = 2079,
	eCEI18nIanaMIBEnum_csMnemonic = 2080,
	eCEI18nIanaMIBEnum_csMnem = 2081,
	eCEI18nIanaMIBEnum_csVISCII = 2082,
	eCEI18nIanaMIBEnum_csVIQR = 2083,
	eCEI18nIanaMIBEnum_csKOI8R = 2084,
	eCEI18nIanaMIBEnum_csHZGB2312 = 2085,
	eCEI18nIanaMIBEnum_csIBM866 = 2086,
	eCEI18nIanaMIBEnum_csPC775Baltic = 2087,
	eCEI18nIanaMIBEnum_csKOI8U = 2088,
	eCEI18nIanaMIBEnum_csIBM00858 = 2089,
	eCEI18nIanaMIBEnum_csIBM00924 = 2090,
	eCEI18nIanaMIBEnum_csIBM01140 = 2091,
	eCEI18nIanaMIBEnum_csIBM01141 = 2092,
	eCEI18nIanaMIBEnum_csIBM01142 = 2093,
	eCEI18nIanaMIBEnum_csIBM01143 = 2094,
	eCEI18nIanaMIBEnum_csIBM01144 = 2095,
	eCEI18nIanaMIBEnum_csIBM01145 = 2096,
	eCEI18nIanaMIBEnum_csIBM01146 = 2097,
	eCEI18nIanaMIBEnum_csIBM01147 = 2098,
	eCEI18nIanaMIBEnum_csIBM01148 = 2099,
	eCEI18nIanaMIBEnum_csIBM01149 = 2100,
	eCEI18nIanaMIBEnum_csBig5HKSCS = 2101,
	eCEI18nIanaMIBEnum_csIBM1047 = 2102,
	eCEI18nIanaMIBEnum_csPTCP154 = 2103,
	eCEI18nIanaMIBEnum_csAmiga1251 = 2104,
	eCEI18nIanaMIBEnum_csKOI7switched = 2105,
	eCEI18nIanaMIBEnum_cswindows1250 = 2250,
	eCEI18nIanaMIBEnum_cswindows1251 = 2251,
	eCEI18nIanaMIBEnum_cswindows1252 = 2252,
	eCEI18nIanaMIBEnum_cswindows1253 = 2253,
	eCEI18nIanaMIBEnum_cswindows1254 = 2254,
	eCEI18nIanaMIBEnum_cswindows1255 = 2255,
	eCEI18nIanaMIBEnum_cswindows1256 = 2256,
	eCEI18nIanaMIBEnum_cswindows1257 = 2257,
	eCEI18nIanaMIBEnum_cswindows1258 = 2258,
	eCEI18nIanaMIBEnum_csTIS620 = 2259,
	eCEI18nIanaMIBEnum_reserved = 3000
} eCEI18nIanaMIBEnum;


/*!
 * see ISO 15924 script codes and 
 * UAX #24 Script Names (http://www.unicode.org/reports/tr24/).
 */
typedef enum
{
	eCEI18nScriptCode_INVALID_CODE = -1,
	eCEI18nScriptCode_COMMON       =  0 , /* Zyyy */
	eCEI18nScriptCode_INHERITED    =  1,  /* Qaai */
	eCEI18nScriptCode_ARABIC       =  2,  /* Arab */
	eCEI18nScriptCode_ARMENIAN     =  3,  /* Armn */
	eCEI18nScriptCode_BENGALI      =  4,  /* Beng */
	eCEI18nScriptCode_BOPOMOFO     =  5,  /* Bopo */
	eCEI18nScriptCode_CHEROKEE     =  6,  /* Cher */
	eCEI18nScriptCode_COPTIC       =  7,  /* Copt */
	eCEI18nScriptCode_CYRILLIC     =  8,  /* Cyrl */
	eCEI18nScriptCode_DESERET      =  9,  /* Dsrt */
	eCEI18nScriptCode_DEVANAGARI   = 10,  /* Deva */
	eCEI18nScriptCode_ETHIOPIC     = 11,  /* Ethi */
	eCEI18nScriptCode_GEORGIAN     = 12,  /* Geor */
	eCEI18nScriptCode_GOTHIC       = 13,  /* Goth */
	eCEI18nScriptCode_GREEK        = 14,  /* Grek */
	eCEI18nScriptCode_GUJARATI     = 15,  /* Gujr */
	eCEI18nScriptCode_GURMUKHI     = 16,  /* Guru */
	eCEI18nScriptCode_HAN          = 17,  /* Hani */
	eCEI18nScriptCode_HANGUL       = 18,  /* Hang */
	eCEI18nScriptCode_HEBREW       = 19,  /* Hebr */
	eCEI18nScriptCode_HIRAGANA     = 20,  /* Hira */
	eCEI18nScriptCode_KANNADA      = 21,  /* Knda */
	eCEI18nScriptCode_KATAKANA     = 22,  /* Kana */
	eCEI18nScriptCode_KHMER        = 23,  /* Khmr */
	eCEI18nScriptCode_LAO          = 24,  /* Laoo */
	eCEI18nScriptCode_LATIN        = 25,  /* Latn */
	eCEI18nScriptCode_MALAYALAM    = 26,  /* Mlym */
	eCEI18nScriptCode_MONGOLIAN    = 27,  /* Mong */
	eCEI18nScriptCode_MYANMAR      = 28,  /* Mymr */
	eCEI18nScriptCode_OGHAM        = 29,  /* Ogam */
	eCEI18nScriptCode_OLD_ITALIC   = 30,  /* Ital */
	eCEI18nScriptCode_ORIYA        = 31,  /* Orya */
	eCEI18nScriptCode_RUNIC        = 32,  /* Runr */
	eCEI18nScriptCode_SINHALA      = 33,  /* Sinh */
	eCEI18nScriptCode_SYRIAC       = 34,  /* Syrc */
	eCEI18nScriptCode_TAMIL        = 35,  /* Taml */
	eCEI18nScriptCode_TELUGU       = 36,  /* Telu */
	eCEI18nScriptCode_THAANA       = 37,  /* Thaa */
	eCEI18nScriptCode_THAI         = 38,  /* Thai */
	eCEI18nScriptCode_TIBETAN      = 39,  /* Tibt */
	/** Canadian_Aboriginal script */
	eCEI18nScriptCode_CANADIAN_ABORIGINAL = 40,  /* Cans */
	/** Canadian_Aboriginal script */
	eCEI18nScriptCode_UCAS         = eCEI18nScriptCode_CANADIAN_ABORIGINAL,
	eCEI18nScriptCode_YI           = 41,  /* Yiii */
	eCEI18nScriptCode_TAGALOG      = 42,  /* Tglg */
	eCEI18nScriptCode_HANUNOO      = 43,  /* Hano */
	eCEI18nScriptCode_BUHID        = 44,  /* Buhd */
	eCEI18nScriptCode_TAGBANWA     = 45,  /* Tagb */

	/* New scripts in Unicode 4 */
	eCEI18nScriptCode_BRAILLE      = 46,  /* Brai */
	eCEI18nScriptCode_CYPRIOT      = 47,  /* Cprt */
	eCEI18nScriptCode_LIMBU        = 48,  /* Limb */
	eCEI18nScriptCode_LINEAR_B     = 49,  /* Linb */
	eCEI18nScriptCode_OSMANYA      = 50,  /* Osma */
	eCEI18nScriptCode_SHAVIAN      = 51,  /* Shaw */
	eCEI18nScriptCode_TAI_LE       = 52,  /* Tale */
	eCEI18nScriptCode_UGARITIC     = 53,  /* Ugar */

	/** New script code in Unicode 4.0.1*/
	eCEI18nScriptCode_KATAKANA_OR_HIRAGANA = 54,/*Hrkt */

	/* New scripts in Unicode 4.1*/
	eCEI18nScriptCode_BUGINESE      = 55, /* Bugi */
	eCEI18nScriptCode_GLAGOLITIC    = 56, /* Glag */
	eCEI18nScriptCode_KHAROSHTHI    = 57, /* Khar */
	eCEI18nScriptCode_SYLOTI_NAGRI  = 58, /* Sylo */
	eCEI18nScriptCode_NEW_TAI_LUE   = 59, /* Talu */
	eCEI18nScriptCode_TIFINAGH      = 60, /* Tfng */
	eCEI18nScriptCode_OLD_PERSIAN   = 61, /* Xpeo */

	/* New script codes from ISO 15924 */
	eCEI18nScriptCode_BALINESE                      = 62, /* Bali */
	eCEI18nScriptCode_BATAK                         = 63, /* Batk */
	eCEI18nScriptCode_BLISSYMBOLS                   = 64, /* Blis */
	eCEI18nScriptCode_BRAHMI                        = 65, /* Brah */
	eCEI18nScriptCode_CHAM                          = 66, /* Cham */
	eCEI18nScriptCode_CIRTH                         = 67, /* Cirt */
	eCEI18nScriptCode_OLD_CHURCH_SLAVONIC_CYRILLIC  = 68, /* Cyrs */
	eCEI18nScriptCode_DEMOTIC_EGYPTIAN              = 69, /* Egyd */
	eCEI18nScriptCode_HIERATIC_EGYPTIAN             = 70, /* Egyh */
	eCEI18nScriptCode_EGYPTIAN_HIEROGLYPHS          = 71, /* Egyp */
	eCEI18nScriptCode_KHUTSURI                      = 72, /* Geok */
	eCEI18nScriptCode_SIMPLIFIED_HAN                = 73, /* Hans */
	eCEI18nScriptCode_TRADITIONAL_HAN               = 74, /* Hant */
	eCEI18nScriptCode_PAHAWH_HMONG                  = 75, /* Hmng */
	eCEI18nScriptCode_OLD_HUNGARIAN                 = 76, /* Hung */
	eCEI18nScriptCode_HARAPPAN_INDUS                = 77, /* Inds */
	eCEI18nScriptCode_JAVANESE                      = 78, /* Java */
	eCEI18nScriptCode_KAYAH_LI                      = 79, /* Kali */
	eCEI18nScriptCode_LATIN_FRAKTUR                 = 80, /* Latf */
	eCEI18nScriptCode_LATIN_GAELIC                  = 81, /* Latg */
	eCEI18nScriptCode_LEPCHA                        = 82, /* Lepc */
	eCEI18nScriptCode_LINEAR_A                      = 83, /* Lina */
	eCEI18nScriptCode_MANDAEAN                      = 84, /* Mand */
	eCEI18nScriptCode_MAYAN_HIEROGLYPHS             = 85, /* Maya */
	eCEI18nScriptCode_MEROITIC                      = 86, /* Mero */
	eCEI18nScriptCode_NKO                           = 87, /* Nkoo */
	eCEI18nScriptCode_ORKHON                        = 88, /* Orkh */
	eCEI18nScriptCode_OLD_PERMIC                    = 89, /* Perm */
	eCEI18nScriptCode_PHAGS_PA                      = 90, /* Phag */
	eCEI18nScriptCode_PHOENICIAN                    = 91, /* Phnx */
	eCEI18nScriptCode_PHONETIC_POLLARD              = 92, /* Plrd */
	eCEI18nScriptCode_RONGORONGO                    = 93, /* Roro */
	eCEI18nScriptCode_SARATI                        = 94, /* Sara */
	eCEI18nScriptCode_ESTRANGELO_SYRIAC             = 95, /* Syre */
	eCEI18nScriptCode_WESTERN_SYRIAC                = 96, /* Syrj */
	eCEI18nScriptCode_EASTERN_SYRIAC                = 97, /* Syrn */
	eCEI18nScriptCode_TENGWAR                       = 98, /* Teng */
	eCEI18nScriptCode_VAI                           = 99, /* Vaii */
	eCEI18nScriptCode_VISIBLE_SPEECH                = 100, /* Visp */
	eCEI18nScriptCode_CUNEIFORM                     = 101,/* Xsux */
	eCEI18nScriptCode_UNWRITTEN_LANGUAGES           = 102,/* Zxxx */
	eCEI18nScriptCode_UNKNOWN                       = 103,/* Zzzz */ /* Unknown="Code for uncoded script", for unassigned code points */

	/* New script codes from ISO 15924 */
	eCEI18nScriptCode_CARIAN                        = 104,/* Cari */
	eCEI18nScriptCode_JAPANESE                      = 105,/* Jpan */
	eCEI18nScriptCode_LANNA                         = 106,/* Lana */
	eCEI18nScriptCode_LYCIAN                        = 107,/* Lyci */
	eCEI18nScriptCode_LYDIAN                        = 108,/* Lydi */
	eCEI18nScriptCode_OL_CHIKI                      = 109,/* Olck */
	eCEI18nScriptCode_REJANG                        = 110,/* Rjng */
	eCEI18nScriptCode_SAURASHTRA                    = 111,/* Saur */
	eCEI18nScriptCode_SIGN_WRITING                  = 112,/* Sgnw */
	eCEI18nScriptCode_SUNDANESE                     = 113,/* Sund */
	eCEI18nScriptCode_MOON                          = 114,/* Moon */
	eCEI18nScriptCode_MEITEI_MAYEK                  = 115,/* Mtei */

	/* New script codes from ISO 15924 @draft ICU 4.0 */
	eCEI18nScriptCode_IMPERIAL_ARAMAIC              = 116,/* Armi */
	eCEI18nScriptCode_AVESTAN                       = 117,/* Avst */
	eCEI18nScriptCode_CHAKMA                        = 118,/* Cakm */
	eCEI18nScriptCode_KOREAN                        = 119,/* Kore */
	eCEI18nScriptCode_KAITHI                        = 120,/* Kthi */
	eCEI18nScriptCode_MANICHAEAN                    = 121,/* Mani */
	eCEI18nScriptCode_INSCRIPTIONAL_PAHLAVI         = 122,/* Phli */
	eCEI18nScriptCode_PSALTER_PAHLAVI               = 123,/* Phlp */
	eCEI18nScriptCode_BOOK_PAHLAVI                  = 124,/* Phlv */
	eCEI18nScriptCode_INSCRIPTIONAL_PARTHIAN        = 125,/* Prti */
	eCEI18nScriptCode_SAMARITAN                     = 126,/* Samr */
	eCEI18nScriptCode_TAI_VIET                      = 127,/* Tavt */
	eCEI18nScriptCode_MATHEMATICAL_NOTATION         = 128,/* Zmth */
	eCEI18nScriptCode_SYMBOLS                       = 129,/* Zsym */

	/* Private use codes from Qaaa - Qabx are not supported*/
	eCEI18nScriptCode_CODE_LIMIT    = 130
} eCEI18nScriptCode;


/*!
* type of CEI18nBreakIterator. see UAX#29.
*/
typedef enum
{
	eCEI18nBreakIteratorType_CHARACTER	= 0,
	eCEI18nBreakIteratorType_WORD		= 1,
	eCEI18nBreakIteratorType_LINE		= 2,
	eCEI18nBreakIteratorType_SENTENCE	= 3,

	eCEI18nBreakIteratorType_FIRST = eCEI18nBreakIteratorType_CHARACTER,
	eCEI18nBreakIteratorType_LAST = eCEI18nBreakIteratorType_SENTENCE
} eCEI18nBreakIteratorType;


/*!
* UAX#29: Grapheme Cluster Break. 
*/
typedef enum
{
	eCEI18nGCB_XX	= 0, // Any Others
	eCEI18nGCB_CN	= 1, //	Control
	eCEI18nGCB_CR	= 2, // CR
	eCEI18nGCB_LF	= 3, // LF
	eCEI18nGCB_EX	= 4, // extend
	eCEI18nGCB_L	= 5, 
	eCEI18nGCB_LE	= 6,
	eCEI18nGCB_LV	= 7,
	eCEI18nGCB_LVT	= 8,
	eCEI18nGCB_T	= 9,
	eCEI18nGCB_V	= 10,

	eCEI18nGCB_FIRST = eCEI18nGCB_XX,
	eCEI18nGCB_LAST = eCEI18nGCB_V
} eCEI18nGCB;

typedef enum
{
	eCEI18nURangeCode_Unknown = -1,
	eCEI18nURangeCode_FIRST = 0,

	//
	//  Variable Width Ranges --- Dense Cache
	//
	eCEI18nURangeCode_BasicLatin = eCEI18nURangeCode_FIRST,
	eCEI18nURangeCode_Latin1Supplement_LatinExtendedA,							// 0x0080-0x017f
	eCEI18nURangeCode_CJKSymbolsAndPunctuation_Hiragana_Katakana,				// 0x3000-0x30ff

	//
	//  Fixed Width Cache
	//	
	eCEI18nURangeCode_CJKUnifiedIdeographs,										// 0x3400-0x9fff
	// CJKRadicalsSupplement, KangxiRadicals			(0x2e80-0x2fff)

	//
	//  Rarely used --- Uncached (or fixed width cache)
	//
	eCEI18nURangeCode_Hangul,													// 0xac00-0xd7ff

	eCEI18nURangeCode_CJKOthers,		// EnclosedCJKLettersAndMonths, CJKCompatibility	(0x3200-0x33ff)
	// CJKCompatibilityIdeographs						(0xf900-0xfaff)


	//
	//  Rarely used --- Uncached (or Sparse Cache)
	//
	eCEI18nURangeCode_LatinExtendedB_IPAExtensions_SpacingModifierLetters,		// 0x0180-0x02ff
	eCEI18nURangeCode_CombiningDiacriticalMarks_BasicGreek_Cyrillic,			// 0x0300-0x04ff

	eCEI18nURangeCode_BasicArabic,												// 0x0600-0x06ff
	eCEI18nURangeCode_Devanagari,												// 0x0900-0x097f
	eCEI18nURangeCode_Gurmukhi_Gujarati,										// 0x0a00-0x0aff
	eCEI18nURangeCode_Tamil,													// 0x0b80-0x0bff
	eCEI18nURangeCode_Telugu_Kannada,											// 0x0c00-0x0cff

	eCEI18nURangeCode_Thai_Lao,													// Thai:0x0e00-0x0e7f
																				// Lao: 0x0e80-0x0eff

	eCEI18nURangeCode_BasicGeorgian,											// 0x10a0-0x10ff 
	eCEI18nURangeCode_HangulJamo,												// 0x1100-0x11ff

	eCEI18nURangeCode_LatinExtendedAdditional_GreekExtended,					// 0x1e00-0x1fff

	eCEI18nURangeCode_Punctuation_SuperSubScripts_Currency_Diacriticals,		// 0x2000-0x20ff
	eCEI18nURangeCode_LetterLike_NumberForms_Arrows,							// 0x2100-0x21ff

	eCEI18nURangeCode_MathematicalOperators,									// 0x2200-0x22ff
	eCEI18nURangeCode_MiscellaneousTechnical,									// 0x2300-0x23ff
	eCEI18nURangeCode_ControlPicture_OCR_EnclosedAlphanumerics,					// 0x2400-0x24ff
	eCEI18nURangeCode_BoxDrawing,												// 0x2500-0x257f 
	eCEI18nURangeCode_BlockElements_GeometricShapes,							// 0x2580-0x25ff
	eCEI18nURangeCode_MiscellaneousSymbols,										// 0x2600-0x26ff
	eCEI18nURangeCode_Dingbats,													// 0x2700-0x27bf

	eCEI18nURangeCode_Bopomofo_HangulCompatJamo_Kanbun,							// 0x3100-0x31ff

	eCEI18nURangeCode_SurrogateArea,											// 0xd800-0xdfff

	eCEI18nURangeCode_CompatibilityArea,	// Alphabetic_Arabic_PresentationForms	(0xfb00-0xfdff)
	// CombiningHalfMarks												(0xfe20-0xfe2f)
	// CJKCompaibilityForms_SmallFormVariants_ArabicPresentationFormsB	(0xfe30-0xfeff)

	eCEI18nURangeCode_HalfWidthAndFullWidthForms_Specials,						// 0xff00-0xffff

	// <<------------- CEURangeCode_HalfWidthAndFullWidthForms_Specials sub ranges ----------------
	eCEI18nURangeCode_FullWidthAsciiAndBrackets = eCEI18nURangeCode_HalfWidthAndFullWidthForms_Specials,	//U+FF01  U+FF60:  Fullwidth ASCII (- U+FF5E), Fullwidth brackets(- U+FF60)
	eCEI18nURangeCode_HalfWidthCJKAndKatakana,       //U+FF61  U+FF9F: Halfwidth CJK punctuation(61-64), Halfwidth Katakana variants (65-9F)
	eCEI18nURangeCode_HalfWidthHangul,               //U+FFA0  U+FFDC: Halfwidth Hangul variants
	eCEI18nURangeCode_FullWidthSymbol,               //U+FFE0  U+FFE6: Fullwidth symbol variants(E0-E6)
	eCEI18nURangeCode_HalfWidthSymbol,               //U+FFE8  U+FFEE: Halfwidth symbol variants(E8-EE)
	// ------------- CEURangeCode_HalfWidthAndFullWidthForms_Specials sub ranges ---------------->>

	eCEI18nURangeCode_Reserved,	// rest of above

	eCEI18nURangeCode_LAST = eCEI18nURangeCode_Reserved
} eCEI18nURangeCode;

typedef enum
{
	eCEI18nBiDiDirection_Unknown = -1, 

    eCEI18nBiDiDirection_LTR = 0,
    eCEI18nBiDiDirection_RTL,
    eCEI18nBiDiDirection_MIXED,
} eCEI18nBiDiDirection;

typedef enum
{
	eCEI18nBiDiControlCode_LRE = 0x202a,
	eCEI18nBiDiControlCode_RLE = 0x202b,

	eCEI18nBiDiControlCode_PDF = 0x202c,

	eCEI18nBiDiControlCode_LRO = 0x202d,
	eCEI18nBiDiControlCode_RLO = 0x202e,

	eCEI18nBiDiControlCode_LRM = 0x200e,
	eCEI18nBiDiControlCode_RLM = 0x200f,

	eCEI18nBiDiControlCode_ZWNJ = 0x200c,
	eCEI18nBiDiControlCode_ZWJ = 0x200d
} eCEI18nBiDiControlCode;

typedef enum
{
	eCEI18nBiDiLevel_LTR = 0x0,
	eCEI18nBiDiLevel_RTL = 0x1,
} eCEI18nBiDiLevel;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

#endif // __cplusplus

#endif
