///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlPlugin_h
#define ICEHtmlPlugin_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "CEApiFSFileSystem.h"
#include "CEApiFSPathname.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
    eCEHtmlPluginInfo_MIMEType,
    eCEHtmlPluginInfo_FileExtension,
    eCEHtmlPluginInfo_Description,
	eCEHtmlPluginInfo_OpenName,
	eCEHtmlPluginInfo_ProductName,
} eCEHtmlPluginInfo;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlPluginModuleLoader ICEHtmlPluginModuleLoader
 * @{
 */

/*!
 * ID of ICEHtmlPluginModuleLoader
 */
#define CEComIID_ICEHtmlPluginModuleLoader 0xc8e3eb74

/*!
 * ICEHtmlPluginModuleLoader
 */
typedef struct ICEHtmlPluginModuleLoader
{
	const struct ICEHtmlPluginModuleLoader_vtbl* _vtbl;
} ICEHtmlPluginModuleLoader;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iPluginModuleLoader	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlPluginModuleLoader_queryInterface) (ICEHtmlPluginModuleLoader* iPluginModuleLoader, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlPluginModuleLoader_addRef) (ICEHtmlPluginModuleLoader* iPluginModuleLoader);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlPluginModuleLoader_release) (ICEHtmlPluginModuleLoader* iPluginModuleLoader);

typedef CEHResult (*iCEHtmlPluginModuleLoader_loadModule) (ICEHtmlPluginModuleLoader* iPluginModuleLoader, struct ICEUString* iModuleName, void** handleOut);

typedef CEHResult (*iCEHtmlPluginModuleLoader_unloadModule) (ICEHtmlPluginModuleLoader* iPluginModuleLoader, void* handle);

typedef CEHResult (*iCEHtmlPluginModuleLoader_findSymbol) (ICEHtmlPluginModuleLoader* iPluginModuleLoader, void* handle, const CHAR8* symbolName, const UINT32 symbolNameLength, void** symbolOut);

typedef CEHResult (*iCEHtmlPluginModuleLoader_getModuleInfoString) (ICEHtmlPluginModuleLoader* iPluginModuleLoader, void* handle, struct ICEUString** valueOut);

/*!
 * V-table of ICEHtmlPluginModuleLoader
 */
struct ICEHtmlPluginModuleLoader_vtbl
{
	iCEHtmlPluginModuleLoader_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlPluginModuleLoader_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlPluginModuleLoader_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlPluginModuleLoader_loadModule	_loadModule;
	iCEHtmlPluginModuleLoader_unloadModule	_unloadModule;
	iCEHtmlPluginModuleLoader_findSymbol	_findSymbol;
	iCEHtmlPluginModuleLoader_getModuleInfoString	_getModuleInfoString;
};

/*! @}
 * end of ICEHtmlPluginModuleLoader
 */

/*! \defgroup ICEHtmlPluginModuleInfoReader ICEHtmlPluginModuleInfoReader
 * @{
 */

/*!
 * ID of ICEHtmlPluginModuleInfoReader
 */
#define CEComIID_ICEHtmlPluginModuleInfoReader 0x890f9958

/*!
 * ICEHtmlPluginModuleInfoReader
 */
typedef struct ICEHtmlPluginModuleInfoReader
{
	const struct ICEHtmlPluginModuleInfoReader_vtbl* _vtbl;
} ICEHtmlPluginModuleInfoReader;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iPluginModuleInfoReader	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlPluginModuleInfoReader_queryInterface) (ICEHtmlPluginModuleInfoReader* iPluginModuleInfoReader, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlPluginModuleInfoReader_addRef) (ICEHtmlPluginModuleInfoReader* iPluginModuleInfoReader);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlPluginModuleInfoReader_release) (ICEHtmlPluginModuleInfoReader* iPluginModuleInfoReader);

typedef CEHResult (*iCEHtmlPluginModuleInfoReader_readModuleInfo) (ICEHtmlPluginModuleInfoReader* iPluginModuleInfoReader, struct ICEUString* iModuleName, eCEHtmlPluginInfo info, struct ICEUString** valueOut);

/*!
 * V-table of ICEHtmlPluginModuleInfoReader
 */
struct ICEHtmlPluginModuleInfoReader_vtbl
{
	iCEHtmlPluginModuleInfoReader_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlPluginModuleInfoReader_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlPluginModuleInfoReader_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlPluginModuleInfoReader_readModuleInfo	_readModuleInfo;
};

/*! @}
 * end of ICEHtmlPluginModuleInfoReader
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlPluginModuleLoaderRef CEComICEHtmlPluginModuleLoaderRef
 * @{
 */

class CEComICEHtmlPluginModuleLoaderRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlPluginModuleLoaderRef() : _iPluginModuleLoader(0) {}
	CEComICEHtmlPluginModuleLoaderRef(ICEHtmlPluginModuleLoader* iOther) : _iPluginModuleLoader(0)
	{
		if (iOther)
		{
			_iPluginModuleLoader = iOther;
			_iPluginModuleLoader->_vtbl->_addRef(_iPluginModuleLoader);
		}
	}

	CEComICEHtmlPluginModuleLoaderRef(const CEComICEHtmlPluginModuleLoaderRef& other) : _iPluginModuleLoader(0)
	{
		if (other._iPluginModuleLoader)
		{
			_iPluginModuleLoader = other._iPluginModuleLoader;
			_iPluginModuleLoader->_vtbl->_addRef(_iPluginModuleLoader);
		}
	}

	~CEComICEHtmlPluginModuleLoaderRef()
	{
		if (_iPluginModuleLoader)
		{
			ICEHtmlPluginModuleLoader* tmp = _iPluginModuleLoader;
			_iPluginModuleLoader = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlPluginModuleLoader* iPluginModuleLoader;
				void* _ptr;
			} uIntf;
			uIntf.iPluginModuleLoader = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlPluginModuleLoader, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iPluginModuleLoader)
				{
					ICEHtmlPluginModuleLoader* tmp = _iPluginModuleLoader;
					_iPluginModuleLoader = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iPluginModuleLoader = uIntf.iPluginModuleLoader;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginModuleLoader* object() const	{ return _iPluginModuleLoader; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlPluginModuleLoader* iOther)
	{
		if (_iPluginModuleLoader)
		{
			ICEHtmlPluginModuleLoader* tmp = _iPluginModuleLoader;
			_iPluginModuleLoader = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iPluginModuleLoader = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlPluginModuleLoader* detach()
	{
		ICEHtmlPluginModuleLoader* iIntf = _iPluginModuleLoader;
		_iPluginModuleLoader = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlPluginModuleLoader* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iPluginModuleLoader;
		if (_iPluginModuleLoader)
		{
			_iPluginModuleLoader->_vtbl->_addRef(_iPluginModuleLoader);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlPluginModuleLoader*() const	{ return _iPluginModuleLoader; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginModuleLoader& operator*() const	{ return *_iPluginModuleLoader; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iPluginModuleLoader == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlPluginModuleLoader* iOther) const	{ return (_iPluginModuleLoader != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlPluginModuleLoader* iOther) const	{ return (_iPluginModuleLoader == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlPluginModuleLoaderRef& operator=(const CEComICEHtmlPluginModuleLoaderRef& other)	{ return operator=(other._iPluginModuleLoader); }

	CEComICEHtmlPluginModuleLoaderRef& operator=(const ICEHtmlPluginModuleLoader* iOther)
	{
		if (_iPluginModuleLoader != iOther)
		{
			if (_iPluginModuleLoader)
			{
				ICEHtmlPluginModuleLoader* tmp = _iPluginModuleLoader;
				_iPluginModuleLoader = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iPluginModuleLoader = const_cast<ICEHtmlPluginModuleLoader*>(iOther);
			if (_iPluginModuleLoader)
			{
				_iPluginModuleLoader->_vtbl->_addRef(_iPluginModuleLoader);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginModuleLoader** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlPluginModuleLoaderRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iPluginModuleLoader && "has a com object reference. clear first.");
		return & _iPluginModuleLoader; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlPluginModuleLoaderRef& other)
	{
		bool result = false;
		if (_iPluginModuleLoader)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iPluginModuleLoader);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iPluginModuleLoader ? _iPluginModuleLoader->_vtbl->_queryInterface(_iPluginModuleLoader, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iPluginModuleLoader) { _iPluginModuleLoader->_vtbl->_addRef(_iPluginModuleLoader); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iPluginModuleLoader) { _iPluginModuleLoader->_vtbl->_release(_iPluginModuleLoader); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loadModule(struct ICEUString* iModuleName, void** handleOut)	{ return _iPluginModuleLoader ? _iPluginModuleLoader->_vtbl->_loadModule(_iPluginModuleLoader, iModuleName, handleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult unloadModule(void* handle)	{ return _iPluginModuleLoader ? _iPluginModuleLoader->_vtbl->_unloadModule(_iPluginModuleLoader, handle) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult findSymbol(void* handle, const CHAR8* symbolName, const UINT32 symbolNameLength, void** symbolOut)	{ return _iPluginModuleLoader ? _iPluginModuleLoader->_vtbl->_findSymbol(_iPluginModuleLoader, handle, symbolName, symbolNameLength, symbolOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getModuleInfoString(void* handle, struct ICEUString** valueOut)	{ return _iPluginModuleLoader ? _iPluginModuleLoader->_vtbl->_getModuleInfoString(_iPluginModuleLoader, handle, valueOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlPluginModuleLoader* _iPluginModuleLoader;
};

/*! @}
 * end of CEComICEHtmlPluginModuleLoaderRef
 */

/*! \defgroup CEComICEHtmlPluginModuleInfoReaderRef CEComICEHtmlPluginModuleInfoReaderRef
 * @{
 */

class CEComICEHtmlPluginModuleInfoReaderRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlPluginModuleInfoReaderRef() : _iPluginModuleInfoReader(0) {}
	CEComICEHtmlPluginModuleInfoReaderRef(ICEHtmlPluginModuleInfoReader* iOther) : _iPluginModuleInfoReader(0)
	{
		if (iOther)
		{
			_iPluginModuleInfoReader = iOther;
			_iPluginModuleInfoReader->_vtbl->_addRef(_iPluginModuleInfoReader);
		}
	}

	CEComICEHtmlPluginModuleInfoReaderRef(const CEComICEHtmlPluginModuleInfoReaderRef& other) : _iPluginModuleInfoReader(0)
	{
		if (other._iPluginModuleInfoReader)
		{
			_iPluginModuleInfoReader = other._iPluginModuleInfoReader;
			_iPluginModuleInfoReader->_vtbl->_addRef(_iPluginModuleInfoReader);
		}
	}

	~CEComICEHtmlPluginModuleInfoReaderRef()
	{
		if (_iPluginModuleInfoReader)
		{
			ICEHtmlPluginModuleInfoReader* tmp = _iPluginModuleInfoReader;
			_iPluginModuleInfoReader = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlPluginModuleInfoReader* iPluginModuleInfoReader;
				void* _ptr;
			} uIntf;
			uIntf.iPluginModuleInfoReader = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlPluginModuleInfoReader, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iPluginModuleInfoReader)
				{
					ICEHtmlPluginModuleInfoReader* tmp = _iPluginModuleInfoReader;
					_iPluginModuleInfoReader = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iPluginModuleInfoReader = uIntf.iPluginModuleInfoReader;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginModuleInfoReader* object() const	{ return _iPluginModuleInfoReader; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlPluginModuleInfoReader* iOther)
	{
		if (_iPluginModuleInfoReader)
		{
			ICEHtmlPluginModuleInfoReader* tmp = _iPluginModuleInfoReader;
			_iPluginModuleInfoReader = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iPluginModuleInfoReader = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlPluginModuleInfoReader* detach()
	{
		ICEHtmlPluginModuleInfoReader* iIntf = _iPluginModuleInfoReader;
		_iPluginModuleInfoReader = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlPluginModuleInfoReader* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iPluginModuleInfoReader;
		if (_iPluginModuleInfoReader)
		{
			_iPluginModuleInfoReader->_vtbl->_addRef(_iPluginModuleInfoReader);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlPluginModuleInfoReader*() const	{ return _iPluginModuleInfoReader; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginModuleInfoReader& operator*() const	{ return *_iPluginModuleInfoReader; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iPluginModuleInfoReader == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlPluginModuleInfoReader* iOther) const	{ return (_iPluginModuleInfoReader != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlPluginModuleInfoReader* iOther) const	{ return (_iPluginModuleInfoReader == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlPluginModuleInfoReaderRef& operator=(const CEComICEHtmlPluginModuleInfoReaderRef& other)	{ return operator=(other._iPluginModuleInfoReader); }

	CEComICEHtmlPluginModuleInfoReaderRef& operator=(const ICEHtmlPluginModuleInfoReader* iOther)
	{
		if (_iPluginModuleInfoReader != iOther)
		{
			if (_iPluginModuleInfoReader)
			{
				ICEHtmlPluginModuleInfoReader* tmp = _iPluginModuleInfoReader;
				_iPluginModuleInfoReader = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iPluginModuleInfoReader = const_cast<ICEHtmlPluginModuleInfoReader*>(iOther);
			if (_iPluginModuleInfoReader)
			{
				_iPluginModuleInfoReader->_vtbl->_addRef(_iPluginModuleInfoReader);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPluginModuleInfoReader** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlPluginModuleInfoReaderRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iPluginModuleInfoReader && "has a com object reference. clear first.");
		return & _iPluginModuleInfoReader; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlPluginModuleInfoReaderRef& other)
	{
		bool result = false;
		if (_iPluginModuleInfoReader)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iPluginModuleInfoReader);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iPluginModuleInfoReader ? _iPluginModuleInfoReader->_vtbl->_queryInterface(_iPluginModuleInfoReader, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iPluginModuleInfoReader) { _iPluginModuleInfoReader->_vtbl->_addRef(_iPluginModuleInfoReader); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iPluginModuleInfoReader) { _iPluginModuleInfoReader->_vtbl->_release(_iPluginModuleInfoReader); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult readModuleInfo(struct ICEUString* iModuleName, eCEHtmlPluginInfo info, struct ICEUString** valueOut)	{ return _iPluginModuleInfoReader ? _iPluginModuleInfoReader->_vtbl->_readModuleInfo(_iPluginModuleInfoReader, iModuleName, info, valueOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlPluginModuleInfoReader* _iPluginModuleInfoReader;
};

/*! @}
 * end of CEComICEHtmlPluginModuleInfoReaderRef
 */

#endif // __cplusplus

#endif
