///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlFrameWindow_h
#define ICEHtmlFrameWindow_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEHtmlFrameWindowWidget.h"
#include "ICEHtmlStatusbarWidget.h"
#include "ICEHtmlWindowWidgetContainer.h"
#include "ICEHtmlFrameWindowNavigationEventHandler.h"
#include "ICEHtmlHistoryNavigator.h"
#include "CEHtmlWindowCommon.h"
#include "CEComAtomicSupport.h"
#include "ceulinearlists.h"
#include "CEApiFile.h"
#include "ICEHtmlJavascriptDialogHandler.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------

struct ICEHtmlFrameWindowWidget;

//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
	CEHtmlSuspendedFeature_FIRST = 0,	// Don't edit this.
	CEHtmlSuspendedFeature_Plugin,    //!< plugin

	CEHtmlSuspendedFeature_LAST = CEHtmlSuspendedFeature_Plugin,	// Terminator.
} CEHtmlSuspendedFeature;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlFrameWindowPaintEvent ICEHtmlFrameWindowPaintEvent
 * @{
 */

/*!
 * ID of ICEHtmlFrameWindowPaintEvent
 */
#define CEComIID_ICEHtmlFrameWindowPaintEvent 0x5d38171b

/*!
 * ICEHtmlFrameWindowPaintEvent
 */
typedef struct ICEHtmlFrameWindowPaintEvent
{
	const struct ICEHtmlFrameWindowPaintEvent_vtbl* _vtbl;
} ICEHtmlFrameWindowPaintEvent;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iFrameWindowPaintEvent	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlFrameWindowPaintEvent_queryInterface) (ICEHtmlFrameWindowPaintEvent* iFrameWindowPaintEvent, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFrameWindowPaintEvent_addRef) (ICEHtmlFrameWindowPaintEvent* iFrameWindowPaintEvent);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFrameWindowPaintEvent_release) (ICEHtmlFrameWindowPaintEvent* iFrameWindowPaintEvent);

typedef CEHResult (*iCEHtmlFrameWindowPaintEvent_getGraphicsContext) (ICEHtmlFrameWindowPaintEvent* iFrameWindowPaintEvent, struct ICEUIGraphicsContext** iGCOut);

typedef CEHResult (*iCEHtmlFrameWindowPaintEvent_notifyStarted) (ICEHtmlFrameWindowPaintEvent* iFrameWindowPaintEvent);

typedef CEHResult (*iCEHtmlFrameWindowPaintEvent_notifyFinished) (ICEHtmlFrameWindowPaintEvent* iFrameWindowPaintEvent, CEHResult result);

/*!
 * V-table of ICEHtmlFrameWindowPaintEvent
 */
struct ICEHtmlFrameWindowPaintEvent_vtbl
{
	iCEHtmlFrameWindowPaintEvent_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlFrameWindowPaintEvent_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlFrameWindowPaintEvent_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlFrameWindowPaintEvent_getGraphicsContext	_getGraphicsContext;
	iCEHtmlFrameWindowPaintEvent_notifyStarted	_notifyStarted;
	iCEHtmlFrameWindowPaintEvent_notifyFinished	_notifyFinished;
};

/*! @}
 * end of ICEHtmlFrameWindowPaintEvent
 */

/*! \defgroup ICEHtmlFrameWindowPeer ICEHtmlFrameWindowPeer
 * @{
 */

/*!
 * ID of ICEHtmlFrameWindowPeer
 */
#define CEComIID_ICEHtmlFrameWindowPeer 0xec894dec

/*!
 * ICEHtmlFrameWindowPeer
 */
typedef struct ICEHtmlFrameWindowPeer
{
	const struct ICEHtmlFrameWindowPeer_vtbl* _vtbl;
} ICEHtmlFrameWindowPeer;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iFrameWindowPeer	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlFrameWindowPeer_queryInterface) (ICEHtmlFrameWindowPeer* iFrameWindowPeer, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFrameWindowPeer_addRef) (ICEHtmlFrameWindowPeer* iFrameWindowPeer);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFrameWindowPeer_release) (ICEHtmlFrameWindowPeer* iFrameWindowPeer);

typedef CEHResult (*iCEHtmlFrameWindowPeer_handleCancelEvent) (ICEHtmlFrameWindowPeer* iFrameWindowPeer);

typedef CEHResult (*iCEHtmlFrameWindowPeer_replyMouseOverElementInformation) (ICEHtmlFrameWindowPeer* iFrameWindowPeer, CERect* zoomRect, struct ICEUString* anchorUrl, struct ICEUString* anchorText, struct ICEUString* imageUrl, INT_PTR userData);

typedef CEHResult (*iCEHtmlFrameWindowPeer_initializeTextInput) (ICEHtmlFrameWindowPeer* iFrameWindowPeer, UINT32 mode, struct ICEUString* iString, INT32 maxLength, INT32 lineHieght, INT32 x, INT32 y, INT32 width, INT32 height);

typedef CEHResult (*iCEHtmlFrameWindowPeer_shutdownTextInput) (ICEHtmlFrameWindowPeer* iFrameWindowPeer, bool nextIsTextInput);

typedef CEHResult (*iCEHtmlFrameWindowPeer_showPopupMenu) (ICEHtmlFrameWindowPeer* iFrameWindowPeer, CEUUINT32List *attrList, CEUStringList *itemList, INT32 selectedIndex, INT32 x, INT32 y, INT32 width, INT32 height, void *const cData);

typedef CEHResult (*iCEHtmlFrameWindowPeer_hidePopupMenu) (ICEHtmlFrameWindowPeer* iFrameWindowPeer);

typedef CEHResult (*iCEHtmlFrameWindowPeer_focusedElementChanged) (ICEHtmlFrameWindowPeer* iFrameWindowPeer, INT32 x, INT32 y, CERect* rect, struct ICEUString* anchorUrl);

typedef CEHResult (*iCEHtmlFrameWindowPeer_replyServerCertificateInformationCount) (ICEHtmlFrameWindowPeer* iFrameWindowPeer, UINT32 serverCertificateInformationCount, void *const aData);

typedef CEHResult (*iCEHtmlFrameWindowPeer_replyServerCertificateInformation) (ICEHtmlFrameWindowPeer* iFrameWindowPeer, INT32 pos, struct ICEUString* iIssuedTo, struct ICEUString* iIssuedBy, double issuedDate, double expireDate, struct ICEUString* iSerialNumber, struct ICEUString* iFingerPrint, void *const aData);

typedef CEHResult (*iCEHtmlFrameWindowPeer_onMouseOverElementChanged) (ICEHtmlFrameWindowPeer* iFrameWindowPeer, struct ICEUString* anchorUrl, struct ICEUString* imageUrl);

/*!
 * V-table of ICEHtmlFrameWindowPeer
 */
struct ICEHtmlFrameWindowPeer_vtbl
{
	iCEHtmlFrameWindowPeer_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlFrameWindowPeer_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlFrameWindowPeer_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlFrameWindowPeer_handleCancelEvent	_handleCancelEvent;
	iCEHtmlFrameWindowPeer_replyMouseOverElementInformation	_replyMouseOverElementInformation;
	iCEHtmlFrameWindowPeer_initializeTextInput	_initializeTextInput;
	iCEHtmlFrameWindowPeer_shutdownTextInput	_shutdownTextInput;
	iCEHtmlFrameWindowPeer_showPopupMenu	_showPopupMenu;
	iCEHtmlFrameWindowPeer_hidePopupMenu	_hidePopupMenu;
	iCEHtmlFrameWindowPeer_focusedElementChanged	_focusedElementChanged;
	iCEHtmlFrameWindowPeer_replyServerCertificateInformationCount	_replyServerCertificateInformationCount;
	iCEHtmlFrameWindowPeer_replyServerCertificateInformation	_replyServerCertificateInformation;
	iCEHtmlFrameWindowPeer_onMouseOverElementChanged	_onMouseOverElementChanged;
};

/*! @}
 * end of ICEHtmlFrameWindowPeer
 */

/*! \defgroup ICEHtmlFrameWindow ICEHtmlFrameWindow
 * @{
 */

/*!
 * ID of ICEHtmlFrameWindow
 */
#define CEComIID_ICEHtmlFrameWindow 0x48b85a14


/*!
 * ICEHtmlFrameWindow
 */
typedef struct ICEHtmlFrameWindow
{
	const struct ICEHtmlFrameWindow_vtbl* _vtbl;
} ICEHtmlFrameWindow;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iFrameWindow	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlFrameWindow_queryInterface) (ICEHtmlFrameWindow* iFrameWindow, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFrameWindow_addRef) (ICEHtmlFrameWindow* iFrameWindow);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFrameWindow_release) (ICEHtmlFrameWindow* iFrameWindow);

typedef CEHResult (*iCEHtmlFrameWindow_getFrameWindowWidget) (ICEHtmlFrameWindow* iFrameWindow, struct ICEHtmlFrameWindowWidget* *const iFrameWindowWidgetOut);

typedef CEHResult (*iCEHtmlFrameWindow_isLocked) (ICEHtmlFrameWindow* iFrameWindow, bool *const lockedOut);

typedef CEHResult (*iCEHtmlFrameWindow_getCreationInfo) (ICEHtmlFrameWindow* iFrameWindow, UINT16 *const creationFlagOut, CEHtmlInvokerType *const invokerOut);

typedef CEHResult (*iCEHtmlFrameWindow_getHistoryNavigator) (ICEHtmlFrameWindow* iFrameWindow, struct ICEHtmlHistoryNavigator* *const iHistoryNavigatorOut);

typedef CEHResult (*iCEHtmlFrameWindow_getDeepestFocusedElement) (ICEHtmlFrameWindow* iFrameWindow, struct ICEHtmlElementBaseProxy* *const iElementOut);

typedef CEHResult (*iCEHtmlFrameWindow_setWindowWidgetContainer) (ICEHtmlFrameWindow* iFrameWindow, struct ICEHtmlWindowWidgetContainer* iWindowWidgetContainer);

typedef CEHResult (*iCEHtmlFrameWindow_setStatusbarWidget) (ICEHtmlFrameWindow* iFrameWindow, struct ICEHtmlStatusbarWidget* iStatusbarWidget);

typedef CEHResult (*iCEHtmlFrameWindow_setNavigationEventHandler) (ICEHtmlFrameWindow* iFrameWindow, struct ICEHtmlFrameWindowNavigationEventHandler* iNavigationEventHandler);

typedef CEHResult (*iCEHtmlFrameWindow_setFocusInvalidateSuppressor) (ICEHtmlFrameWindow* iFrameWindow, struct ICEHtmlFocusInvalidateSuppressor* iFocusInvalidateSuppressor);

typedef CEHResult (*iCEHtmlFrameWindow_suspendedFeature) (ICEHtmlFrameWindow* iFrameWindow, CEHtmlSuspendedFeature feature, bool suspend);

typedef CEHResult (*iCEHtmlFrameWindow_getBrowserPreference) (ICEHtmlFrameWindow* iFrameWindow, struct ICEHtmlBrowserPreference* *const preferenceOut);

typedef CEHResult (*iCEHtmlFrameWindow_getDeepestScrollContext) (ICEHtmlFrameWindow* iFrameWindow, struct ICEHtmlScrollContext* *const iScrollContextOut);

typedef CEHResult (*iCEHtmlFrameWindow_postPaint) (ICEHtmlFrameWindow* iFrameWindow, struct ICEHtmlFrameWindowPaintEvent* iPaintEvent);

typedef CEHResult (*iCEHtmlFrameWindow_notifyResized) (ICEHtmlFrameWindow* iFrameWindow);

typedef CEHResult (*iCEHtmlFrameWindow_requestMouseOverElementInformation) (ICEHtmlFrameWindow* iFrameWindow, INT32 x, INT32 y, INT_PTR userData);

typedef CEHResult (*iCEHtmlFrameWindow_getTitle) (ICEHtmlFrameWindow* iFrameWindow, struct ICEUString* *titleRef);

typedef CEHResult (*iCEHtmlFrameWindow_getURL) (ICEHtmlFrameWindow* iFrameWindow, struct ICEUString* *urlRef);

typedef CEHResult (*iCEHtmlFrameWindow_keyboardEvent) (ICEHtmlFrameWindow* iFrameWindow, CEKeyboardEventParam* keyEventParam, CEATOMIC* consumingCount, bool *const consumedOut);

typedef CEHResult (*iCEHtmlFrameWindow_scrollToPosition) (ICEHtmlFrameWindow* iFrameWindow, INT32 vPosition, INT32 hPosition, bool relative);

typedef CEHResult (*iCEHtmlFrameWindow_setJavascriptDialogHandler) (ICEHtmlFrameWindow* iFrameWindow, struct ICEHtmlJavascriptDialogHandler* iJavascriptDialogHandler);

typedef CEHResult (*iCEHtmlFrameWindow_setNetworkUserNotifyHandler) (ICEHtmlFrameWindow* iFrameWindow, struct ICEHtmlNetworkUserNotifyHandler* iNetworkUserNotifyHandler);

typedef CEHResult (*iCEHtmlFrameWindow_setHtmlFrameWindowPeer) (ICEHtmlFrameWindow* iFrameWindow, struct ICEHtmlFrameWindowPeer* iCancelHander);

typedef CEHResult (*iCEHtmlFrameWindow_setSelectedItemsPopupMenu) (ICEHtmlFrameWindow* iFrameWindow, INT32 selectedIndex, void *const cData);

typedef CEHResult (*iCEHtmlFrameWindow_changeDefaultFontSize) (ICEHtmlFrameWindow* iFrameWindow, UINT32 sizePropIn, UINT32 sizeFixedIn);

typedef CEHResult (*iCEHtmlFrameWindow_setUserStyleSheet) (ICEHtmlFrameWindow* iFrameWindow, struct ICEUString *userStyleSheet);

typedef CEHResult (*iCEHtmlFrameWindow_setEnablePlugin) (ICEHtmlFrameWindow* iFrameWindow, bool enable);

typedef CEHResult (*iCEHtmlFrameWindow_replyConfirmPlugin) (ICEHtmlFrameWindow* iFrameWindow, bool result, bool keepResult, void *const cData);

typedef CEHResult (*iCEHtmlFrameWindow_setHitTestPadding) (ICEHtmlFrameWindow* iFrameWindow, INT32 docPadding);

typedef CEHResult (*iCEHtmlFrameWindow_requestServerCertificateInformation) (ICEHtmlFrameWindow* iFrameWindow, struct ICEUString* iUrl, void *const aData);

typedef CEHResult (*iCEHtmlFrameWindow_requestServerCertificatePosition) (ICEHtmlFrameWindow* iFrameWindow, UINT32 pos, void *const aData);

/*!
 * V-table of ICEHtmlFrameWindow
 */
struct ICEHtmlFrameWindow_vtbl
{
	iCEHtmlFrameWindow_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlFrameWindow_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlFrameWindow_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlFrameWindow_getFrameWindowWidget	_getFrameWindowWidget;
	iCEHtmlFrameWindow_isLocked	_isLocked;
	iCEHtmlFrameWindow_getCreationInfo	_getCreationInfo;
	iCEHtmlFrameWindow_getHistoryNavigator	_getHistoryNavigator;
	iCEHtmlFrameWindow_getDeepestFocusedElement	_getDeepestFocusedElement;
	iCEHtmlFrameWindow_setWindowWidgetContainer	_setWindowWidgetContainer;
	iCEHtmlFrameWindow_setStatusbarWidget	_setStatusbarWidget;
	iCEHtmlFrameWindow_setNavigationEventHandler	_setNavigationEventHandler;
	iCEHtmlFrameWindow_setFocusInvalidateSuppressor	_setFocusInvalidateSuppressor;
	iCEHtmlFrameWindow_suspendedFeature	_suspendedFeature;
	iCEHtmlFrameWindow_getBrowserPreference	_getBrowserPreference;
	iCEHtmlFrameWindow_getDeepestScrollContext	_getDeepestScrollContext;
	iCEHtmlFrameWindow_postPaint	_postPaint;
	iCEHtmlFrameWindow_notifyResized	_notifyResized;
	iCEHtmlFrameWindow_requestMouseOverElementInformation	_requestMouseOverElementInformation;
	iCEHtmlFrameWindow_getTitle	_getTitle;
	iCEHtmlFrameWindow_getURL	_getURL;
	iCEHtmlFrameWindow_keyboardEvent	_keyboardEvent;
	iCEHtmlFrameWindow_scrollToPosition	_scrollToPosition;
	iCEHtmlFrameWindow_setJavascriptDialogHandler	_setJavascriptDialogHandler;
	iCEHtmlFrameWindow_setNetworkUserNotifyHandler	_setNetworkUserNotifyHandler;
	iCEHtmlFrameWindow_setHtmlFrameWindowPeer	_setHtmlFrameWindowPeer;
	iCEHtmlFrameWindow_setSelectedItemsPopupMenu	_setSelectedItemsPopupMenu;
	iCEHtmlFrameWindow_changeDefaultFontSize	_changeDefaultFontSize;
	iCEHtmlFrameWindow_setUserStyleSheet	_setUserStyleSheet;
	iCEHtmlFrameWindow_setEnablePlugin	_setEnablePlugin;
	iCEHtmlFrameWindow_replyConfirmPlugin	_replyConfirmPlugin;
	iCEHtmlFrameWindow_setHitTestPadding	_setHitTestPadding;
	iCEHtmlFrameWindow_requestServerCertificateInformation	_requestServerCertificateInformation;
	iCEHtmlFrameWindow_requestServerCertificatePosition	_requestServerCertificatePosition;
};

/*! @}
 * end of ICEHtmlFrameWindow
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlFrameWindowPaintEventRef CEComICEHtmlFrameWindowPaintEventRef
 * @{
 */

class CEComICEHtmlFrameWindowPaintEventRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlFrameWindowPaintEventRef() : _iFrameWindowPaintEvent(0) {}
	CEComICEHtmlFrameWindowPaintEventRef(ICEHtmlFrameWindowPaintEvent* iOther) : _iFrameWindowPaintEvent(0)
	{
		if (iOther)
		{
			_iFrameWindowPaintEvent = iOther;
			_iFrameWindowPaintEvent->_vtbl->_addRef(_iFrameWindowPaintEvent);
		}
	}

	CEComICEHtmlFrameWindowPaintEventRef(const CEComICEHtmlFrameWindowPaintEventRef& other) : _iFrameWindowPaintEvent(0)
	{
		if (other._iFrameWindowPaintEvent)
		{
			_iFrameWindowPaintEvent = other._iFrameWindowPaintEvent;
			_iFrameWindowPaintEvent->_vtbl->_addRef(_iFrameWindowPaintEvent);
		}
	}

	~CEComICEHtmlFrameWindowPaintEventRef()
	{
		if (_iFrameWindowPaintEvent)
		{
			ICEHtmlFrameWindowPaintEvent* tmp = _iFrameWindowPaintEvent;
			_iFrameWindowPaintEvent = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlFrameWindowPaintEvent* iFrameWindowPaintEvent;
				void* _ptr;
			} uIntf;
			uIntf.iFrameWindowPaintEvent = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlFrameWindowPaintEvent, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iFrameWindowPaintEvent)
				{
					ICEHtmlFrameWindowPaintEvent* tmp = _iFrameWindowPaintEvent;
					_iFrameWindowPaintEvent = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iFrameWindowPaintEvent = uIntf.iFrameWindowPaintEvent;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowPaintEvent* object() const	{ return _iFrameWindowPaintEvent; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlFrameWindowPaintEvent* iOther)
	{
		if (_iFrameWindowPaintEvent)
		{
			ICEHtmlFrameWindowPaintEvent* tmp = _iFrameWindowPaintEvent;
			_iFrameWindowPaintEvent = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iFrameWindowPaintEvent = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlFrameWindowPaintEvent* detach()
	{
		ICEHtmlFrameWindowPaintEvent* iIntf = _iFrameWindowPaintEvent;
		_iFrameWindowPaintEvent = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlFrameWindowPaintEvent* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iFrameWindowPaintEvent;
		if (_iFrameWindowPaintEvent)
		{
			_iFrameWindowPaintEvent->_vtbl->_addRef(_iFrameWindowPaintEvent);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlFrameWindowPaintEvent*() const	{ return _iFrameWindowPaintEvent; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowPaintEvent& operator*() const	{ return *_iFrameWindowPaintEvent; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iFrameWindowPaintEvent == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlFrameWindowPaintEvent* iOther) const	{ return (_iFrameWindowPaintEvent != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlFrameWindowPaintEvent* iOther) const	{ return (_iFrameWindowPaintEvent == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlFrameWindowPaintEventRef& operator=(const CEComICEHtmlFrameWindowPaintEventRef& other)	{ return operator=(other._iFrameWindowPaintEvent); }

	CEComICEHtmlFrameWindowPaintEventRef& operator=(const ICEHtmlFrameWindowPaintEvent* iOther)
	{
		if (_iFrameWindowPaintEvent != iOther)
		{
			if (_iFrameWindowPaintEvent)
			{
				ICEHtmlFrameWindowPaintEvent* tmp = _iFrameWindowPaintEvent;
				_iFrameWindowPaintEvent = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iFrameWindowPaintEvent = const_cast<ICEHtmlFrameWindowPaintEvent*>(iOther);
			if (_iFrameWindowPaintEvent)
			{
				_iFrameWindowPaintEvent->_vtbl->_addRef(_iFrameWindowPaintEvent);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowPaintEvent** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlFrameWindowPaintEventRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iFrameWindowPaintEvent && "has a com object reference. clear first.");
		return & _iFrameWindowPaintEvent; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlFrameWindowPaintEventRef& other)
	{
		bool result = false;
		if (_iFrameWindowPaintEvent)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iFrameWindowPaintEvent);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iFrameWindowPaintEvent ? _iFrameWindowPaintEvent->_vtbl->_queryInterface(_iFrameWindowPaintEvent, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iFrameWindowPaintEvent) { _iFrameWindowPaintEvent->_vtbl->_addRef(_iFrameWindowPaintEvent); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iFrameWindowPaintEvent) { _iFrameWindowPaintEvent->_vtbl->_release(_iFrameWindowPaintEvent); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getGraphicsContext(struct ICEUIGraphicsContext** iGCOut)	{ return _iFrameWindowPaintEvent ? _iFrameWindowPaintEvent->_vtbl->_getGraphicsContext(_iFrameWindowPaintEvent, iGCOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyStarted()	{ return _iFrameWindowPaintEvent ? _iFrameWindowPaintEvent->_vtbl->_notifyStarted(_iFrameWindowPaintEvent) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyFinished(CEHResult result)	{ return _iFrameWindowPaintEvent ? _iFrameWindowPaintEvent->_vtbl->_notifyFinished(_iFrameWindowPaintEvent, result) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlFrameWindowPaintEvent* _iFrameWindowPaintEvent;
};

/*! @}
 * end of CEComICEHtmlFrameWindowPaintEventRef
 */

/*! \defgroup CEComICEHtmlFrameWindowPeerRef CEComICEHtmlFrameWindowPeerRef
 * @{
 */

class CEComICEHtmlFrameWindowPeerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlFrameWindowPeerRef() : _iFrameWindowPeer(0) {}
	CEComICEHtmlFrameWindowPeerRef(ICEHtmlFrameWindowPeer* iOther) : _iFrameWindowPeer(0)
	{
		if (iOther)
		{
			_iFrameWindowPeer = iOther;
			_iFrameWindowPeer->_vtbl->_addRef(_iFrameWindowPeer);
		}
	}

	CEComICEHtmlFrameWindowPeerRef(const CEComICEHtmlFrameWindowPeerRef& other) : _iFrameWindowPeer(0)
	{
		if (other._iFrameWindowPeer)
		{
			_iFrameWindowPeer = other._iFrameWindowPeer;
			_iFrameWindowPeer->_vtbl->_addRef(_iFrameWindowPeer);
		}
	}

	~CEComICEHtmlFrameWindowPeerRef()
	{
		if (_iFrameWindowPeer)
		{
			ICEHtmlFrameWindowPeer* tmp = _iFrameWindowPeer;
			_iFrameWindowPeer = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlFrameWindowPeer* iFrameWindowPeer;
				void* _ptr;
			} uIntf;
			uIntf.iFrameWindowPeer = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlFrameWindowPeer, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iFrameWindowPeer)
				{
					ICEHtmlFrameWindowPeer* tmp = _iFrameWindowPeer;
					_iFrameWindowPeer = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iFrameWindowPeer = uIntf.iFrameWindowPeer;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowPeer* object() const	{ return _iFrameWindowPeer; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlFrameWindowPeer* iOther)
	{
		if (_iFrameWindowPeer)
		{
			ICEHtmlFrameWindowPeer* tmp = _iFrameWindowPeer;
			_iFrameWindowPeer = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iFrameWindowPeer = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlFrameWindowPeer* detach()
	{
		ICEHtmlFrameWindowPeer* iIntf = _iFrameWindowPeer;
		_iFrameWindowPeer = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlFrameWindowPeer* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iFrameWindowPeer;
		if (_iFrameWindowPeer)
		{
			_iFrameWindowPeer->_vtbl->_addRef(_iFrameWindowPeer);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlFrameWindowPeer*() const	{ return _iFrameWindowPeer; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowPeer& operator*() const	{ return *_iFrameWindowPeer; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iFrameWindowPeer == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlFrameWindowPeer* iOther) const	{ return (_iFrameWindowPeer != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlFrameWindowPeer* iOther) const	{ return (_iFrameWindowPeer == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlFrameWindowPeerRef& operator=(const CEComICEHtmlFrameWindowPeerRef& other)	{ return operator=(other._iFrameWindowPeer); }

	CEComICEHtmlFrameWindowPeerRef& operator=(const ICEHtmlFrameWindowPeer* iOther)
	{
		if (_iFrameWindowPeer != iOther)
		{
			if (_iFrameWindowPeer)
			{
				ICEHtmlFrameWindowPeer* tmp = _iFrameWindowPeer;
				_iFrameWindowPeer = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iFrameWindowPeer = const_cast<ICEHtmlFrameWindowPeer*>(iOther);
			if (_iFrameWindowPeer)
			{
				_iFrameWindowPeer->_vtbl->_addRef(_iFrameWindowPeer);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowPeer** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlFrameWindowPeerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iFrameWindowPeer && "has a com object reference. clear first.");
		return & _iFrameWindowPeer; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlFrameWindowPeerRef& other)
	{
		bool result = false;
		if (_iFrameWindowPeer)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iFrameWindowPeer);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iFrameWindowPeer ? _iFrameWindowPeer->_vtbl->_queryInterface(_iFrameWindowPeer, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iFrameWindowPeer) { _iFrameWindowPeer->_vtbl->_addRef(_iFrameWindowPeer); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iFrameWindowPeer) { _iFrameWindowPeer->_vtbl->_release(_iFrameWindowPeer); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleCancelEvent()	{ return _iFrameWindowPeer ? _iFrameWindowPeer->_vtbl->_handleCancelEvent(_iFrameWindowPeer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult replyMouseOverElementInformation(CERect* zoomRect, struct ICEUString* anchorUrl, struct ICEUString* anchorText, struct ICEUString* imageUrl, INT_PTR userData)	{ return _iFrameWindowPeer ? _iFrameWindowPeer->_vtbl->_replyMouseOverElementInformation(_iFrameWindowPeer, zoomRect, anchorUrl, anchorText, imageUrl, userData) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult initializeTextInput(UINT32 mode, struct ICEUString* iString, INT32 maxLength, INT32 lineHieght, INT32 x, INT32 y, INT32 width, INT32 height)	{ return _iFrameWindowPeer ? _iFrameWindowPeer->_vtbl->_initializeTextInput(_iFrameWindowPeer, mode, iString, maxLength, lineHieght, x, y, width, height) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult shutdownTextInput(bool nextIsTextInput)	{ return _iFrameWindowPeer ? _iFrameWindowPeer->_vtbl->_shutdownTextInput(_iFrameWindowPeer, nextIsTextInput) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult showPopupMenu(CEUUINT32List *attrList, CEUStringList *itemList, INT32 selectedIndex, INT32 x, INT32 y, INT32 width, INT32 height, void *const cData)	{ return _iFrameWindowPeer ? _iFrameWindowPeer->_vtbl->_showPopupMenu(_iFrameWindowPeer, attrList, itemList, selectedIndex, x, y, width, height, cData) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult hidePopupMenu()	{ return _iFrameWindowPeer ? _iFrameWindowPeer->_vtbl->_hidePopupMenu(_iFrameWindowPeer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult focusedElementChanged(INT32 x, INT32 y, CERect* rect, struct ICEUString* anchorUrl)	{ return _iFrameWindowPeer ? _iFrameWindowPeer->_vtbl->_focusedElementChanged(_iFrameWindowPeer, x, y, rect, anchorUrl) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult replyServerCertificateInformationCount(UINT32 serverCertificateInformationCount, void *const aData)	{ return _iFrameWindowPeer ? _iFrameWindowPeer->_vtbl->_replyServerCertificateInformationCount(_iFrameWindowPeer, serverCertificateInformationCount, aData) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult replyServerCertificateInformation(INT32 pos, struct ICEUString* iIssuedTo, struct ICEUString* iIssuedBy, double issuedDate, double expireDate, struct ICEUString* iSerialNumber, struct ICEUString* iFingerPrint, void *const aData)	{ return _iFrameWindowPeer ? _iFrameWindowPeer->_vtbl->_replyServerCertificateInformation(_iFrameWindowPeer, pos, iIssuedTo, iIssuedBy, issuedDate, expireDate, iSerialNumber, iFingerPrint, aData) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onMouseOverElementChanged(struct ICEUString* anchorUrl, struct ICEUString* imageUrl)	{ return _iFrameWindowPeer ? _iFrameWindowPeer->_vtbl->_onMouseOverElementChanged(_iFrameWindowPeer, anchorUrl, imageUrl) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlFrameWindowPeer* _iFrameWindowPeer;
};

/*! @}
 * end of CEComICEHtmlFrameWindowPeerRef
 */

/*! \defgroup CEComICEHtmlFrameWindowRef CEComICEHtmlFrameWindowRef
 * @{
 */

class CEComICEHtmlFrameWindowRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlFrameWindowRef() : _iFrameWindow(0) {}
	CEComICEHtmlFrameWindowRef(ICEHtmlFrameWindow* iOther) : _iFrameWindow(0)
	{
		if (iOther)
		{
			_iFrameWindow = iOther;
			_iFrameWindow->_vtbl->_addRef(_iFrameWindow);
		}
	}

	CEComICEHtmlFrameWindowRef(const CEComICEHtmlFrameWindowRef& other) : _iFrameWindow(0)
	{
		if (other._iFrameWindow)
		{
			_iFrameWindow = other._iFrameWindow;
			_iFrameWindow->_vtbl->_addRef(_iFrameWindow);
		}
	}

	~CEComICEHtmlFrameWindowRef()
	{
		if (_iFrameWindow)
		{
			ICEHtmlFrameWindow* tmp = _iFrameWindow;
			_iFrameWindow = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlFrameWindow* iFrameWindow;
				void* _ptr;
			} uIntf;
			uIntf.iFrameWindow = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlFrameWindow, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iFrameWindow)
				{
					ICEHtmlFrameWindow* tmp = _iFrameWindow;
					_iFrameWindow = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iFrameWindow = uIntf.iFrameWindow;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindow* object() const	{ return _iFrameWindow; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlFrameWindow* iOther)
	{
		if (_iFrameWindow)
		{
			ICEHtmlFrameWindow* tmp = _iFrameWindow;
			_iFrameWindow = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iFrameWindow = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlFrameWindow* detach()
	{
		ICEHtmlFrameWindow* iIntf = _iFrameWindow;
		_iFrameWindow = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlFrameWindow* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iFrameWindow;
		if (_iFrameWindow)
		{
			_iFrameWindow->_vtbl->_addRef(_iFrameWindow);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlFrameWindow*() const	{ return _iFrameWindow; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindow& operator*() const	{ return *_iFrameWindow; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iFrameWindow == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlFrameWindow* iOther) const	{ return (_iFrameWindow != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlFrameWindow* iOther) const	{ return (_iFrameWindow == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlFrameWindowRef& operator=(const CEComICEHtmlFrameWindowRef& other)	{ return operator=(other._iFrameWindow); }

	CEComICEHtmlFrameWindowRef& operator=(const ICEHtmlFrameWindow* iOther)
	{
		if (_iFrameWindow != iOther)
		{
			if (_iFrameWindow)
			{
				ICEHtmlFrameWindow* tmp = _iFrameWindow;
				_iFrameWindow = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iFrameWindow = const_cast<ICEHtmlFrameWindow*>(iOther);
			if (_iFrameWindow)
			{
				_iFrameWindow->_vtbl->_addRef(_iFrameWindow);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindow** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlFrameWindowRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iFrameWindow && "has a com object reference. clear first.");
		return & _iFrameWindow; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlFrameWindowRef& other)
	{
		bool result = false;
		if (_iFrameWindow)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iFrameWindow);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_queryInterface(_iFrameWindow, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iFrameWindow) { _iFrameWindow->_vtbl->_addRef(_iFrameWindow); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iFrameWindow) { _iFrameWindow->_vtbl->_release(_iFrameWindow); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFrameWindowWidget(struct ICEHtmlFrameWindowWidget* *const iFrameWindowWidgetOut)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_getFrameWindowWidget(_iFrameWindow, iFrameWindowWidgetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isLocked(bool *const lockedOut)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_isLocked(_iFrameWindow, lockedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCreationInfo(UINT16 *const creationFlagOut, CEHtmlInvokerType *const invokerOut)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_getCreationInfo(_iFrameWindow, creationFlagOut, invokerOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getHistoryNavigator(struct ICEHtmlHistoryNavigator* *const iHistoryNavigatorOut)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_getHistoryNavigator(_iFrameWindow, iHistoryNavigatorOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDeepestFocusedElement(struct ICEHtmlElementBaseProxy* *const iElementOut)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_getDeepestFocusedElement(_iFrameWindow, iElementOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setWindowWidgetContainer(struct ICEHtmlWindowWidgetContainer* iWindowWidgetContainer)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_setWindowWidgetContainer(_iFrameWindow, iWindowWidgetContainer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setStatusbarWidget(struct ICEHtmlStatusbarWidget* iStatusbarWidget)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_setStatusbarWidget(_iFrameWindow, iStatusbarWidget) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setNavigationEventHandler(struct ICEHtmlFrameWindowNavigationEventHandler* iNavigationEventHandler)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_setNavigationEventHandler(_iFrameWindow, iNavigationEventHandler) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFocusInvalidateSuppressor(struct ICEHtmlFocusInvalidateSuppressor* iFocusInvalidateSuppressor)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_setFocusInvalidateSuppressor(_iFrameWindow, iFocusInvalidateSuppressor) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult suspendedFeature(CEHtmlSuspendedFeature feature, bool suspend)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_suspendedFeature(_iFrameWindow, feature, suspend) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBrowserPreference(struct ICEHtmlBrowserPreference* *const preferenceOut)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_getBrowserPreference(_iFrameWindow, preferenceOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDeepestScrollContext(struct ICEHtmlScrollContext* *const iScrollContextOut)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_getDeepestScrollContext(_iFrameWindow, iScrollContextOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult postPaint(struct ICEHtmlFrameWindowPaintEvent* iPaintEvent)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_postPaint(_iFrameWindow, iPaintEvent) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyResized()	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_notifyResized(_iFrameWindow) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult requestMouseOverElementInformation(INT32 x, INT32 y, INT_PTR userData)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_requestMouseOverElementInformation(_iFrameWindow, x, y, userData) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTitle(struct ICEUString* *titleRef)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_getTitle(_iFrameWindow, titleRef) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getURL(struct ICEUString* *urlRef)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_getURL(_iFrameWindow, urlRef) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult keyboardEvent(CEKeyboardEventParam* keyEventParam, CEATOMIC* consumingCount, bool *const consumedOut)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_keyboardEvent(_iFrameWindow, keyEventParam, consumingCount, consumedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult scrollToPosition(INT32 vPosition, INT32 hPosition, bool relative)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_scrollToPosition(_iFrameWindow, vPosition, hPosition, relative) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setJavascriptDialogHandler(struct ICEHtmlJavascriptDialogHandler* iJavascriptDialogHandler)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_setJavascriptDialogHandler(_iFrameWindow, iJavascriptDialogHandler) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setNetworkUserNotifyHandler(struct ICEHtmlNetworkUserNotifyHandler* iNetworkUserNotifyHandler)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_setNetworkUserNotifyHandler(_iFrameWindow, iNetworkUserNotifyHandler) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setHtmlFrameWindowPeer(struct ICEHtmlFrameWindowPeer* iCancelHander)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_setHtmlFrameWindowPeer(_iFrameWindow, iCancelHander) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setSelectedItemsPopupMenu(INT32 selectedIndex, void *const cData)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_setSelectedItemsPopupMenu(_iFrameWindow, selectedIndex, cData) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult changeDefaultFontSize(UINT32 sizePropIn, UINT32 sizeFixedIn)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_changeDefaultFontSize(_iFrameWindow, sizePropIn, sizeFixedIn) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setUserStyleSheet(struct ICEUString *userStyleSheet)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_setUserStyleSheet(_iFrameWindow, userStyleSheet) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setEnablePlugin(bool enable)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_setEnablePlugin(_iFrameWindow, enable) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult replyConfirmPlugin(bool result, bool keepResult, void *const cData)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_replyConfirmPlugin(_iFrameWindow, result, keepResult, cData) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setHitTestPadding(INT32 docPadding)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_setHitTestPadding(_iFrameWindow, docPadding) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult requestServerCertificateInformation(struct ICEUString* iUrl, void *const aData)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_requestServerCertificateInformation(_iFrameWindow, iUrl, aData) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult requestServerCertificatePosition(UINT32 pos, void *const aData)	{ return _iFrameWindow ? _iFrameWindow->_vtbl->_requestServerCertificatePosition(_iFrameWindow, pos, aData) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlFrameWindow* _iFrameWindow;
};

/*! @}
 * end of CEComICEHtmlFrameWindowRef
 */

#endif // __cplusplus

#endif
