///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlCredential_h
#define ICEHtmlCredential_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
    CEHtmlSSLMode_Loading,
    CEHtmlSSLMode_NonSecured,
    CEHtmlSSLMode_Secured,
    CEHtmlSSLMode_Mixed
} CEHtmlSSLMode;

typedef enum
{
    CEHtmlSSLAlert_None = 0,
    CEHtmlSSLAlert_BadCert = 1 << 0,
    CEHtmlSSLAlert_BadDomain = 1 << 1,
    CEHtmlSSLAlert_NoCert = 1 << 2,
    CEHtmlSSLAlert_UnknownCA = 1 << 3,
    CEHtmlSSLAlert_BadChain = 1 << 4,
    CEHtmlSSLAlert_Expired = 1 << 5,
    CEHtmlSSLAlert_NotYetValid = 1 << 6,
    CEHtmlSSLAlert_VerifyError = 1 << 7,
    CEHtmlSSLAlert_InternalError = 1 << 8,
    CEHtmlSSLAlert_Unknown = 1 << 9,
    CEHtmlSSLAlert_Untrusted_Issuer = 1 << 10,
    CEHtmlSSLAlert_Self_Signed_Cert = 1 << 11,
    CEHtmlSSLAlert_Decrypt_Error = 1 << 12,
    CEHtmlSSLAlert_Revoked = 1 << 13,
    CEHtmlSSLAlert_Unsupported_Purpose = 1 << 14,
    CEHtmlSSLAlert_CRL_File_Is_Not_Exist = 1 << 15,
    CEHtmlSSLAlert_CA_Invalid = 1 << 16,
    CEHtmlSSLAlert_Expired_Issuer = 1 << 17,
    CEHtmlSSLAlert_CRL_Expired = 1 << 18,
    CEHtmlSSLAlert_BadConstraint = 1 << 19,
    CEHtmlSSLAlert_BadCommonName = 1 << 20
} CEHtmlSSLAlert;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlCredential ICEHtmlCredential
 * @{
 */

/*!
 * ID of ICEHtmlCredential
 */
#define CEComIID_ICEHtmlCredential 0x13b77e26


/*!
 * ICEHtmlCredential
 */
typedef struct ICEHtmlCredential
{
	const struct ICEHtmlCredential_vtbl* _vtbl;
} ICEHtmlCredential;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iCredential	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlCredential_queryInterface) (ICEHtmlCredential* iCredential, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlCredential_addRef) (ICEHtmlCredential* iCredential);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlCredential_release) (ICEHtmlCredential* iCredential);

typedef CEHResult (*iCEHtmlCredential_getSSLMode) (ICEHtmlCredential* iCredential, CEHtmlSSLMode* modeOut);

typedef CEHResult (*iCEHtmlCredential_getSSLAlert) (ICEHtmlCredential* iCredential, UINT32* alertOut);

typedef CEHResult (*iCEHtmlCredential_getDomain) (ICEHtmlCredential* iCredential, const UTF16CHAR **const pCharArray16Out, UINT32 *const numOfChars16Out);

/*!
 * V-table of ICEHtmlCredential
 */
struct ICEHtmlCredential_vtbl
{
	iCEHtmlCredential_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlCredential_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlCredential_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlCredential_getSSLMode	_getSSLMode;
	iCEHtmlCredential_getSSLAlert	_getSSLAlert;
	iCEHtmlCredential_getDomain	_getDomain;
};

/*! @}
 * end of ICEHtmlCredential
 */

/*! \defgroup ICEHtmlCertificate ICEHtmlCertificate
 * @{
 */

/*!
 * ID of ICEHtmlCertificate
 */
#define CEComIID_ICEHtmlCertificate 0x712d7ab7

/*!
 * ICEHtmlCertificate
 */
typedef struct ICEHtmlCertificate
{
	const struct ICEHtmlCertificate_vtbl* _vtbl;
} ICEHtmlCertificate;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iCertificate	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlCertificate_queryInterface) (ICEHtmlCertificate* iCertificate, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlCertificate_addRef) (ICEHtmlCertificate* iCertificate);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlCertificate_release) (ICEHtmlCertificate* iCertificate);

typedef CEHResult (*iCEHtmlCertificate_getCertificate) (ICEHtmlCertificate* iCertificate, const void** cert);

/*!
 * V-table of ICEHtmlCertificate
 */
struct ICEHtmlCertificate_vtbl
{
	iCEHtmlCertificate_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlCertificate_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlCertificate_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlCertificate_getCertificate	_getCertificate;
};

/*! @}
 * end of ICEHtmlCertificate
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlCredentialRef CEComICEHtmlCredentialRef
 * @{
 */

class CEComICEHtmlCredentialRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlCredentialRef() : _iCredential(0) {}
	CEComICEHtmlCredentialRef(ICEHtmlCredential* iOther) : _iCredential(0)
	{
		if (iOther)
		{
			_iCredential = iOther;
			_iCredential->_vtbl->_addRef(_iCredential);
		}
	}

	CEComICEHtmlCredentialRef(const CEComICEHtmlCredentialRef& other) : _iCredential(0)
	{
		if (other._iCredential)
		{
			_iCredential = other._iCredential;
			_iCredential->_vtbl->_addRef(_iCredential);
		}
	}

	~CEComICEHtmlCredentialRef()
	{
		if (_iCredential)
		{
			ICEHtmlCredential* tmp = _iCredential;
			_iCredential = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlCredential* iCredential;
				void* _ptr;
			} uIntf;
			uIntf.iCredential = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlCredential, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iCredential)
				{
					ICEHtmlCredential* tmp = _iCredential;
					_iCredential = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iCredential = uIntf.iCredential;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlCredential* object() const	{ return _iCredential; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlCredential* iOther)
	{
		if (_iCredential)
		{
			ICEHtmlCredential* tmp = _iCredential;
			_iCredential = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iCredential = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlCredential* detach()
	{
		ICEHtmlCredential* iIntf = _iCredential;
		_iCredential = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlCredential* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iCredential;
		if (_iCredential)
		{
			_iCredential->_vtbl->_addRef(_iCredential);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlCredential*() const	{ return _iCredential; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlCredential& operator*() const	{ return *_iCredential; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iCredential == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlCredential* iOther) const	{ return (_iCredential != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlCredential* iOther) const	{ return (_iCredential == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlCredentialRef& operator=(const CEComICEHtmlCredentialRef& other)	{ return operator=(other._iCredential); }

	CEComICEHtmlCredentialRef& operator=(const ICEHtmlCredential* iOther)
	{
		if (_iCredential != iOther)
		{
			if (_iCredential)
			{
				ICEHtmlCredential* tmp = _iCredential;
				_iCredential = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iCredential = const_cast<ICEHtmlCredential*>(iOther);
			if (_iCredential)
			{
				_iCredential->_vtbl->_addRef(_iCredential);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlCredential** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlCredentialRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iCredential && "has a com object reference. clear first.");
		return & _iCredential; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlCredentialRef& other)
	{
		bool result = false;
		if (_iCredential)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iCredential);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iCredential ? _iCredential->_vtbl->_queryInterface(_iCredential, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iCredential) { _iCredential->_vtbl->_addRef(_iCredential); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iCredential) { _iCredential->_vtbl->_release(_iCredential); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getSSLMode(CEHtmlSSLMode* modeOut)	{ return _iCredential ? _iCredential->_vtbl->_getSSLMode(_iCredential, modeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getSSLAlert(UINT32* alertOut)	{ return _iCredential ? _iCredential->_vtbl->_getSSLAlert(_iCredential, alertOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDomain(const UTF16CHAR **const pCharArray16Out, UINT32 *const numOfChars16Out)	{ return _iCredential ? _iCredential->_vtbl->_getDomain(_iCredential, pCharArray16Out, numOfChars16Out) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlCredential* _iCredential;
};

/*! @}
 * end of CEComICEHtmlCredentialRef
 */

/*! \defgroup CEComICEHtmlCertificateRef CEComICEHtmlCertificateRef
 * @{
 */

class CEComICEHtmlCertificateRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlCertificateRef() : _iCertificate(0) {}
	CEComICEHtmlCertificateRef(ICEHtmlCertificate* iOther) : _iCertificate(0)
	{
		if (iOther)
		{
			_iCertificate = iOther;
			_iCertificate->_vtbl->_addRef(_iCertificate);
		}
	}

	CEComICEHtmlCertificateRef(const CEComICEHtmlCertificateRef& other) : _iCertificate(0)
	{
		if (other._iCertificate)
		{
			_iCertificate = other._iCertificate;
			_iCertificate->_vtbl->_addRef(_iCertificate);
		}
	}

	~CEComICEHtmlCertificateRef()
	{
		if (_iCertificate)
		{
			ICEHtmlCertificate* tmp = _iCertificate;
			_iCertificate = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlCertificate* iCertificate;
				void* _ptr;
			} uIntf;
			uIntf.iCertificate = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlCertificate, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iCertificate)
				{
					ICEHtmlCertificate* tmp = _iCertificate;
					_iCertificate = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iCertificate = uIntf.iCertificate;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlCertificate* object() const	{ return _iCertificate; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlCertificate* iOther)
	{
		if (_iCertificate)
		{
			ICEHtmlCertificate* tmp = _iCertificate;
			_iCertificate = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iCertificate = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlCertificate* detach()
	{
		ICEHtmlCertificate* iIntf = _iCertificate;
		_iCertificate = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlCertificate* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iCertificate;
		if (_iCertificate)
		{
			_iCertificate->_vtbl->_addRef(_iCertificate);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlCertificate*() const	{ return _iCertificate; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlCertificate& operator*() const	{ return *_iCertificate; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iCertificate == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlCertificate* iOther) const	{ return (_iCertificate != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlCertificate* iOther) const	{ return (_iCertificate == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlCertificateRef& operator=(const CEComICEHtmlCertificateRef& other)	{ return operator=(other._iCertificate); }

	CEComICEHtmlCertificateRef& operator=(const ICEHtmlCertificate* iOther)
	{
		if (_iCertificate != iOther)
		{
			if (_iCertificate)
			{
				ICEHtmlCertificate* tmp = _iCertificate;
				_iCertificate = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iCertificate = const_cast<ICEHtmlCertificate*>(iOther);
			if (_iCertificate)
			{
				_iCertificate->_vtbl->_addRef(_iCertificate);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlCertificate** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlCertificateRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iCertificate && "has a com object reference. clear first.");
		return & _iCertificate; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlCertificateRef& other)
	{
		bool result = false;
		if (_iCertificate)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iCertificate);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iCertificate ? _iCertificate->_vtbl->_queryInterface(_iCertificate, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iCertificate) { _iCertificate->_vtbl->_addRef(_iCertificate); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iCertificate) { _iCertificate->_vtbl->_release(_iCertificate); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCertificate(const void** cert)	{ return _iCertificate ? _iCertificate->_vtbl->_getCertificate(_iCertificate, cert) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlCertificate* _iCertificate;
};

/*! @}
 * end of CEComICEHtmlCertificateRef
 */

#endif // __cplusplus

#endif
