///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlBrowserResourceProvider_h
#define ICEHtmlBrowserResourceProvider_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
    CEHtmlBrowserResource_UserAgentString,
    CEHtmlBrowserResource_RequestTimedoutErrorPageString,
    CEHtmlBrowserResource_DNSErrorPageString,
    CEHtmlBrowserResource_NetworkOperationFailedPageString,
    CEHtmlBrowserResource_SslVersionErrorPageString,
    CEHtmlBrowserResource_SslAlertHandshakePageString,
    CEHtmlBrowserResource_DefaultFileBrowseButtonTitleString,
    CEHtmlBrowserResource_DefaultSubmitButtonTitleString,
    CEHtmlBrowserResource_DefaultResetButtonTitleString,
    CEHtmlBrowserResource_DefaultStyleSheetString,
    CEHtmlBrowserResource_DefaultQuirkStyleSheetString,
    CEHtmlBrowserResource_NoPluginMessageString,
    CEHtmlBrowserResource_AcceptLanguageString,
    CEHtmlBrowserResource_InvalidIconImage,
    CEHtmlBrowserResource_DownloadingIconImage,
    CEHtmlBrowserResource_InvalidPluginImage,

	// WebKitTheme
    CEHtmlBrowserResource_ScrollbarUpImage,
    CEHtmlBrowserResource_ScrollbarDownImage,
    CEHtmlBrowserResource_ScrollbarLeftImage,
    CEHtmlBrowserResource_ScrollbarRightImage,
	CEHtmlBrowserResource_ScrollbarHbarLeftImage,
	CEHtmlBrowserResource_ScrollbarHbarRightImage,
	CEHtmlBrowserResource_ScrollbarHbarMidImage,
	CEHtmlBrowserResource_ScrollbarHbarBodyImage,
	CEHtmlBrowserResource_ScrollbarHbarBgImage,
	CEHtmlBrowserResource_ScrollbarVbarTopImage,
	CEHtmlBrowserResource_ScrollbarVbarBottomImage,
	CEHtmlBrowserResource_ScrollbarVbarMidImage,
	CEHtmlBrowserResource_ScrollbarVbarBodyImage,
	CEHtmlBrowserResource_ScrollbarVbarBgImage,
	
	CEHtmlBrowserResource_ButtonLeftTopImage,
	CEHtmlBrowserResource_ButtonLeftBottomImage,
	CEHtmlBrowserResource_ButtonRightTopImage,
	CEHtmlBrowserResource_ButtonRightBottomImage,
	CEHtmlBrowserResource_ButtonLeftImage,
	CEHtmlBrowserResource_ButtonTopImage,
	CEHtmlBrowserResource_ButtonRightImage,
	CEHtmlBrowserResource_ButtonBottomImage,
	CEHtmlBrowserResource_ButtonCenterImage,

	CEHtmlBrowserResource_ButtonLeftTopPushedImage,
	CEHtmlBrowserResource_ButtonLeftBottomPushedImage,
	CEHtmlBrowserResource_ButtonRightTopPushedImage,
	CEHtmlBrowserResource_ButtonRightBottomPushedImage,
	CEHtmlBrowserResource_ButtonLeftPushedImage,
	CEHtmlBrowserResource_ButtonTopPushedImage,
	CEHtmlBrowserResource_ButtonRightPushedImage,
	CEHtmlBrowserResource_ButtonBottomPushedImage,
	CEHtmlBrowserResource_ButtonCenterPushedImage,

	CEHtmlBrowserResource_CheckboxNoCheckedImage,
	CEHtmlBrowserResource_CheckboxCheckedImage,
	CEHtmlBrowserResource_CheckboxNoCheckedDisabledImage,
	CEHtmlBrowserResource_CheckboxCheckedDisabledImage,
	
	CEHtmlBrowserResource_RadioNoCheckedImage,
	CEHtmlBrowserResource_RadioCheckedImage,
	CEHtmlBrowserResource_RadioNoCheckedDisabledImage,
	CEHtmlBrowserResource_RadioCheckedDisabledImage,
	
	CEHtmlBrowserResource_TextareaLeftTopImage,
	CEHtmlBrowserResource_TextareaLeftBottomImage,
	CEHtmlBrowserResource_TextareaRightTopImage,
	CEHtmlBrowserResource_TextareaRightBottomImage,
	CEHtmlBrowserResource_TextareaLeftImage,
	CEHtmlBrowserResource_TextareaTopImage,
	CEHtmlBrowserResource_TextareaRightImage,
	CEHtmlBrowserResource_TextareaBottomImage,
	CEHtmlBrowserResource_TextareaCenterImage,

	CEHtmlBrowserResource_MenulistButtonImage,
	
    // Refer to CEHtmlApiEnums.idl(.h)(enum CEHtmlApiBrowserResource) when adding it from now on
    CEHtmlBrowserResource_UserAgentSpecialString, // of course bad. should we say it one bye one?
    CEHtmlBrowserResource_WDomainSpecialString, // wdomain 
    CEHtmlBrowserResource_DomainSpecialString,  // domain
    CEHtmlBrowserResource_SerialNumberSpecialString1, // ok serial number 1 
    CEHtmlBrowserResource_SerialNumberSpecialString2, // ok serial number 2
    CEHtmlBrowserResource_SerialNumberSpecialString3, // ok serial number 3

    // Add ErrorMessage for Network    
    CEHtmlBrowserResource_CannotBeDisplayedString,
    CEHtmlBrowserResource_PageUnavailableString,
    CEHtmlBrowserResource_ResponseNotReceivedString,
    CEHtmlBrowserResource_CannotFindString,
    CEHtmlBrowserResource_CannotFindDnsString,
    CEHtmlBrowserResource_NetworkSettingErrorString,
} CEHtmlBrowserResource;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlBrowserResourceProvider ICEHtmlBrowserResourceProvider
 * @{
 */

/*!
 * ID of ICEHtmlBrowserResourceProvider
 */
#define CEComIID_ICEHtmlBrowserResourceProvider 0x27432a5e


/*!
 * ICEHtmlBrowserResourceProvider
 */
typedef struct ICEHtmlBrowserResourceProvider
{
	const struct ICEHtmlBrowserResourceProvider_vtbl* _vtbl;
} ICEHtmlBrowserResourceProvider;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iBrowserResourceProvider	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlBrowserResourceProvider_queryInterface) (ICEHtmlBrowserResourceProvider* iBrowserResourceProvider, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlBrowserResourceProvider_addRef) (ICEHtmlBrowserResourceProvider* iBrowserResourceProvider);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlBrowserResourceProvider_release) (ICEHtmlBrowserResourceProvider* iBrowserResourceProvider);

typedef CEHResult (*iCEHtmlBrowserResourceProvider_getResource) (ICEHtmlBrowserResourceProvider* iBrowserResourceProvider, CEHtmlBrowserResource type, struct ICEUnknown* *const iUnknownOut);

/*!
 * V-table of ICEHtmlBrowserResourceProvider
 */
struct ICEHtmlBrowserResourceProvider_vtbl
{
	iCEHtmlBrowserResourceProvider_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlBrowserResourceProvider_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlBrowserResourceProvider_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlBrowserResourceProvider_getResource	_getResource;
};

/*! @}
 * end of ICEHtmlBrowserResourceProvider
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlBrowserResourceProviderRef CEComICEHtmlBrowserResourceProviderRef
 * @{
 */

class CEComICEHtmlBrowserResourceProviderRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlBrowserResourceProviderRef() : _iBrowserResourceProvider(0) {}
	CEComICEHtmlBrowserResourceProviderRef(ICEHtmlBrowserResourceProvider* iOther) : _iBrowserResourceProvider(0)
	{
		if (iOther)
		{
			_iBrowserResourceProvider = iOther;
			_iBrowserResourceProvider->_vtbl->_addRef(_iBrowserResourceProvider);
		}
	}

	CEComICEHtmlBrowserResourceProviderRef(const CEComICEHtmlBrowserResourceProviderRef& other) : _iBrowserResourceProvider(0)
	{
		if (other._iBrowserResourceProvider)
		{
			_iBrowserResourceProvider = other._iBrowserResourceProvider;
			_iBrowserResourceProvider->_vtbl->_addRef(_iBrowserResourceProvider);
		}
	}

	~CEComICEHtmlBrowserResourceProviderRef()
	{
		if (_iBrowserResourceProvider)
		{
			ICEHtmlBrowserResourceProvider* tmp = _iBrowserResourceProvider;
			_iBrowserResourceProvider = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlBrowserResourceProvider* iBrowserResourceProvider;
				void* _ptr;
			} uIntf;
			uIntf.iBrowserResourceProvider = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlBrowserResourceProvider, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iBrowserResourceProvider)
				{
					ICEHtmlBrowserResourceProvider* tmp = _iBrowserResourceProvider;
					_iBrowserResourceProvider = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iBrowserResourceProvider = uIntf.iBrowserResourceProvider;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserResourceProvider* object() const	{ return _iBrowserResourceProvider; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlBrowserResourceProvider* iOther)
	{
		if (_iBrowserResourceProvider)
		{
			ICEHtmlBrowserResourceProvider* tmp = _iBrowserResourceProvider;
			_iBrowserResourceProvider = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iBrowserResourceProvider = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlBrowserResourceProvider* detach()
	{
		ICEHtmlBrowserResourceProvider* iIntf = _iBrowserResourceProvider;
		_iBrowserResourceProvider = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlBrowserResourceProvider* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iBrowserResourceProvider;
		if (_iBrowserResourceProvider)
		{
			_iBrowserResourceProvider->_vtbl->_addRef(_iBrowserResourceProvider);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlBrowserResourceProvider*() const	{ return _iBrowserResourceProvider; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserResourceProvider& operator*() const	{ return *_iBrowserResourceProvider; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iBrowserResourceProvider == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlBrowserResourceProvider* iOther) const	{ return (_iBrowserResourceProvider != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlBrowserResourceProvider* iOther) const	{ return (_iBrowserResourceProvider == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlBrowserResourceProviderRef& operator=(const CEComICEHtmlBrowserResourceProviderRef& other)	{ return operator=(other._iBrowserResourceProvider); }

	CEComICEHtmlBrowserResourceProviderRef& operator=(const ICEHtmlBrowserResourceProvider* iOther)
	{
		if (_iBrowserResourceProvider != iOther)
		{
			if (_iBrowserResourceProvider)
			{
				ICEHtmlBrowserResourceProvider* tmp = _iBrowserResourceProvider;
				_iBrowserResourceProvider = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iBrowserResourceProvider = const_cast<ICEHtmlBrowserResourceProvider*>(iOther);
			if (_iBrowserResourceProvider)
			{
				_iBrowserResourceProvider->_vtbl->_addRef(_iBrowserResourceProvider);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserResourceProvider** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlBrowserResourceProviderRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iBrowserResourceProvider && "has a com object reference. clear first.");
		return & _iBrowserResourceProvider; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlBrowserResourceProviderRef& other)
	{
		bool result = false;
		if (_iBrowserResourceProvider)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iBrowserResourceProvider);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iBrowserResourceProvider ? _iBrowserResourceProvider->_vtbl->_queryInterface(_iBrowserResourceProvider, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iBrowserResourceProvider) { _iBrowserResourceProvider->_vtbl->_addRef(_iBrowserResourceProvider); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iBrowserResourceProvider) { _iBrowserResourceProvider->_vtbl->_release(_iBrowserResourceProvider); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getResource(CEHtmlBrowserResource type, struct ICEUnknown* *const iUnknownOut)	{ return _iBrowserResourceProvider ? _iBrowserResourceProvider->_vtbl->_getResource(_iBrowserResourceProvider, type, iUnknownOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlBrowserResourceProvider* _iBrowserResourceProvider;
};

/*! @}
 * end of CEComICEHtmlBrowserResourceProviderRef
 */

#endif // __cplusplus

#endif
