///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlBrowserPreference_h
#define ICEHtmlBrowserPreference_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEUString.h"
#include "CEUrlCommon.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
    CEHtmlBrowserFeatureType_Unknown = -1,
    CEHtmlBrowserFeatureType_Cache,
    CEHtmlBrowserFeatureType_Cookie,
    CEHtmlBrowserFeatureType_History,
    CEHtmlBrowserFeatureType_Javascript,
    CEHtmlBrowserFeatureType_Plugin,
    CEHtmlBrowserFeatureType_ImageAnimation,
    CEHtmlBrowserFeatureType_ArrowFocusNavigation,
    CEHtmlBrowserFeatureType_FrameFocusNavigation,
    CEHtmlBrowserFeatureType_TVRendering,
    CEHtmlBrowserFeatureType_NoWrap,
    CEHtmlBrowserFeatureType_Selection,
    CEHtmlBrowserFeatureType_Image,
    CEHtmlBrowserFeatureType_AuthorStyleSheet,
    CEHtmlBrowserFeatureType_TrendMicroFilter,
    CEHtmlBrowserFeatureType_RequestFilter,
    CEHtmlBrowserFeatureType_InternalStatusAccess,
    CEHtmlBrowserFeatureType_Offline,
    CEHtmlBrowserFeatureType_AllCache,
    CEHtmlBrowserFeatureType_UseAnything,
} CEHtmlBrowserFeatureType;

typedef enum
{
    CEHtmlBrowserFeatureValueStatus_Unknown = -1,
    CEHtmlBrowserFeatureValueStatus_Available,
    CEHtmlBrowserFeatureValueStatus_Unavailable,
    CEHtmlBrowserFeatureValueStatus_Mixed,
} CEHtmlBrowserFeatureValueStatus;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlBrowserPreference ICEHtmlBrowserPreference
 * @{
 */

/*!
 * ID of ICEHtmlBrowserPreference
 */
#define CEComIID_ICEHtmlBrowserPreference 0x065dd3fb


/*!
 * ICEHtmlBrowserPreference
 */
typedef struct ICEHtmlBrowserPreference
{
	const struct ICEHtmlBrowserPreference_vtbl* _vtbl;
} ICEHtmlBrowserPreference;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iBrowserPreference	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlBrowserPreference_queryInterface) (ICEHtmlBrowserPreference* iBrowserPreference, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlBrowserPreference_addRef) (ICEHtmlBrowserPreference* iBrowserPreference);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlBrowserPreference_release) (ICEHtmlBrowserPreference* iBrowserPreference);

typedef CEHResult (*iCEHtmlBrowserPreference_setFeatureEnable) (ICEHtmlBrowserPreference* iBrowserPreference, CEHtmlBrowserFeatureType type, bool enable, CEHtmlBrowserFeatureValueStatus *const statusOut);

typedef CEHResult (*iCEHtmlBrowserPreference_getFeatureEnable) (ICEHtmlBrowserPreference* iBrowserPreference, CEHtmlBrowserFeatureType type, bool *const enableOut, CEHtmlBrowserFeatureValueStatus *const statusOut);

typedef CEHResult (*iCEHtmlBrowserPreference_updateProxyEnvironment) (ICEHtmlBrowserPreference* iBrowserPreference, struct ICEHtmlProxyEnvironment* iProxyEnvironment, CEHtmlBrowserFeatureValueStatus *const statusOut);

typedef CEHResult (*iCEHtmlBrowserPreference_setDefaultCharsetDetectorInfo) (ICEHtmlBrowserPreference* iBrowserPreference, const UINT32 charsetDetectorCLSID, CEHtmlBrowserFeatureValueStatus *const statusOut);

typedef CEHResult (*iCEHtmlBrowserPreference_getDefaultCharsetDetectorInfo) (ICEHtmlBrowserPreference* iBrowserPreference, UINT32 *const charsetDetectorCLSIDOut, CEHtmlBrowserFeatureValueStatus *const statusOut);

typedef CEHResult (*iCEHtmlBrowserPreference_setDefaultCharsetEncoding) (ICEHtmlBrowserPreference* iBrowserPreference, const struct ICEUString* iStrCharsetEncodingIanaName, CEHtmlBrowserFeatureValueStatus *const statusOut);

typedef CEHResult (*iCEHtmlBrowserPreference_getDefaultCharsetEncoding) (ICEHtmlBrowserPreference* iBrowserPreference, struct ICEUString* *const iStrCharsetEncodingIanaNameOut, CEHtmlBrowserFeatureValueStatus *const statusOut);

typedef CEHResult (*iCEHtmlBrowserPreference_deleteAllCookies) (ICEHtmlBrowserPreference* iBrowserPreference);

typedef CEHResult (*iCEHtmlBrowserPreference_setHitTestParams) (ICEHtmlBrowserPreference* iBrowserPreference, INT32 docPadding);

typedef CEHResult (*iCEHtmlBrowserPreference_getHitTestPadding) (ICEHtmlBrowserPreference* iBrowserPreference, INT32* docPaddingOut);

typedef CEHResult (*iCEHtmlBrowserPreference_deleteBasicAuthenticationCache) (ICEHtmlBrowserPreference* iBrowserPreference);

/*!
 * V-table of ICEHtmlBrowserPreference
 */
struct ICEHtmlBrowserPreference_vtbl
{
	iCEHtmlBrowserPreference_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlBrowserPreference_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlBrowserPreference_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlBrowserPreference_setFeatureEnable	_setFeatureEnable;
	iCEHtmlBrowserPreference_getFeatureEnable	_getFeatureEnable;
	iCEHtmlBrowserPreference_updateProxyEnvironment	_updateProxyEnvironment;
	iCEHtmlBrowserPreference_setDefaultCharsetDetectorInfo	_setDefaultCharsetDetectorInfo;
	iCEHtmlBrowserPreference_getDefaultCharsetDetectorInfo	_getDefaultCharsetDetectorInfo;
	iCEHtmlBrowserPreference_setDefaultCharsetEncoding	_setDefaultCharsetEncoding;
	iCEHtmlBrowserPreference_getDefaultCharsetEncoding	_getDefaultCharsetEncoding;
	iCEHtmlBrowserPreference_deleteAllCookies	_deleteAllCookies;
	iCEHtmlBrowserPreference_setHitTestParams	_setHitTestParams;
	iCEHtmlBrowserPreference_getHitTestPadding	_getHitTestPadding;
	iCEHtmlBrowserPreference_deleteBasicAuthenticationCache	_deleteBasicAuthenticationCache;
};

/*! @}
 * end of ICEHtmlBrowserPreference
 */

/*! \defgroup ICEHtmlFontPreference ICEHtmlFontPreference
 * @{
 */

/*!
 * ID of ICEHtmlFontPreference
 */
#define CEComIID_ICEHtmlFontPreference 0x2618d018

/*!
 * ICEHtmlFontPreference
 */
typedef struct ICEHtmlFontPreference
{
	const struct ICEHtmlFontPreference_vtbl* _vtbl;
} ICEHtmlFontPreference;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iFontPreference	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlFontPreference_queryInterface) (ICEHtmlFontPreference* iFontPreference, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFontPreference_addRef) (ICEHtmlFontPreference* iFontPreference);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFontPreference_release) (ICEHtmlFontPreference* iFontPreference);

typedef CEHResult (*iCEHtmlFontPreference_setBaseFontSize) (ICEHtmlFontPreference* iFontPreference, UINT32 absoluteSize, CEHtmlBrowserFeatureValueStatus *const statusOut);

typedef CEHResult (*iCEHtmlFontPreference_getBaseFontSize) (ICEHtmlFontPreference* iFontPreference, UINT32 *const absoluteSizeOut, CEHtmlBrowserFeatureValueStatus *const statusOut);

typedef CEHResult (*iCEHtmlFontPreference_getDefaultBaseFontSize) (ICEHtmlFontPreference* iFontPreference, UINT32 *const defaultBaseFontSizeOut, CEHtmlBrowserFeatureValueStatus *const statusOut);

/*!
 * V-table of ICEHtmlFontPreference
 */
struct ICEHtmlFontPreference_vtbl
{
	iCEHtmlFontPreference_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlFontPreference_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlFontPreference_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlFontPreference_setBaseFontSize	_setBaseFontSize;
	iCEHtmlFontPreference_getBaseFontSize	_getBaseFontSize;
	iCEHtmlFontPreference_getDefaultBaseFontSize	_getDefaultBaseFontSize;
};

/*! @}
 * end of ICEHtmlFontPreference
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlBrowserPreferenceRef CEComICEHtmlBrowserPreferenceRef
 * @{
 */

class CEComICEHtmlBrowserPreferenceRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlBrowserPreferenceRef() : _iBrowserPreference(0) {}
	CEComICEHtmlBrowserPreferenceRef(ICEHtmlBrowserPreference* iOther) : _iBrowserPreference(0)
	{
		if (iOther)
		{
			_iBrowserPreference = iOther;
			_iBrowserPreference->_vtbl->_addRef(_iBrowserPreference);
		}
	}

	CEComICEHtmlBrowserPreferenceRef(const CEComICEHtmlBrowserPreferenceRef& other) : _iBrowserPreference(0)
	{
		if (other._iBrowserPreference)
		{
			_iBrowserPreference = other._iBrowserPreference;
			_iBrowserPreference->_vtbl->_addRef(_iBrowserPreference);
		}
	}

	~CEComICEHtmlBrowserPreferenceRef()
	{
		if (_iBrowserPreference)
		{
			ICEHtmlBrowserPreference* tmp = _iBrowserPreference;
			_iBrowserPreference = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlBrowserPreference* iBrowserPreference;
				void* _ptr;
			} uIntf;
			uIntf.iBrowserPreference = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlBrowserPreference, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iBrowserPreference)
				{
					ICEHtmlBrowserPreference* tmp = _iBrowserPreference;
					_iBrowserPreference = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iBrowserPreference = uIntf.iBrowserPreference;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserPreference* object() const	{ return _iBrowserPreference; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlBrowserPreference* iOther)
	{
		if (_iBrowserPreference)
		{
			ICEHtmlBrowserPreference* tmp = _iBrowserPreference;
			_iBrowserPreference = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iBrowserPreference = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlBrowserPreference* detach()
	{
		ICEHtmlBrowserPreference* iIntf = _iBrowserPreference;
		_iBrowserPreference = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlBrowserPreference* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iBrowserPreference;
		if (_iBrowserPreference)
		{
			_iBrowserPreference->_vtbl->_addRef(_iBrowserPreference);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlBrowserPreference*() const	{ return _iBrowserPreference; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserPreference& operator*() const	{ return *_iBrowserPreference; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iBrowserPreference == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlBrowserPreference* iOther) const	{ return (_iBrowserPreference != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlBrowserPreference* iOther) const	{ return (_iBrowserPreference == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlBrowserPreferenceRef& operator=(const CEComICEHtmlBrowserPreferenceRef& other)	{ return operator=(other._iBrowserPreference); }

	CEComICEHtmlBrowserPreferenceRef& operator=(const ICEHtmlBrowserPreference* iOther)
	{
		if (_iBrowserPreference != iOther)
		{
			if (_iBrowserPreference)
			{
				ICEHtmlBrowserPreference* tmp = _iBrowserPreference;
				_iBrowserPreference = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iBrowserPreference = const_cast<ICEHtmlBrowserPreference*>(iOther);
			if (_iBrowserPreference)
			{
				_iBrowserPreference->_vtbl->_addRef(_iBrowserPreference);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlBrowserPreference** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlBrowserPreferenceRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iBrowserPreference && "has a com object reference. clear first.");
		return & _iBrowserPreference; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlBrowserPreferenceRef& other)
	{
		bool result = false;
		if (_iBrowserPreference)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iBrowserPreference);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iBrowserPreference ? _iBrowserPreference->_vtbl->_queryInterface(_iBrowserPreference, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iBrowserPreference) { _iBrowserPreference->_vtbl->_addRef(_iBrowserPreference); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iBrowserPreference) { _iBrowserPreference->_vtbl->_release(_iBrowserPreference); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFeatureEnable(CEHtmlBrowserFeatureType type, bool enable, CEHtmlBrowserFeatureValueStatus *const statusOut)	{ return _iBrowserPreference ? _iBrowserPreference->_vtbl->_setFeatureEnable(_iBrowserPreference, type, enable, statusOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFeatureEnable(CEHtmlBrowserFeatureType type, bool *const enableOut, CEHtmlBrowserFeatureValueStatus *const statusOut)	{ return _iBrowserPreference ? _iBrowserPreference->_vtbl->_getFeatureEnable(_iBrowserPreference, type, enableOut, statusOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult updateProxyEnvironment(struct ICEHtmlProxyEnvironment* iProxyEnvironment, CEHtmlBrowserFeatureValueStatus *const statusOut)	{ return _iBrowserPreference ? _iBrowserPreference->_vtbl->_updateProxyEnvironment(_iBrowserPreference, iProxyEnvironment, statusOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setDefaultCharsetDetectorInfo(const UINT32 charsetDetectorCLSID, CEHtmlBrowserFeatureValueStatus *const statusOut)	{ return _iBrowserPreference ? _iBrowserPreference->_vtbl->_setDefaultCharsetDetectorInfo(_iBrowserPreference, charsetDetectorCLSID, statusOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDefaultCharsetDetectorInfo(UINT32 *const charsetDetectorCLSIDOut, CEHtmlBrowserFeatureValueStatus *const statusOut)	{ return _iBrowserPreference ? _iBrowserPreference->_vtbl->_getDefaultCharsetDetectorInfo(_iBrowserPreference, charsetDetectorCLSIDOut, statusOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setDefaultCharsetEncoding(const struct ICEUString* iStrCharsetEncodingIanaName, CEHtmlBrowserFeatureValueStatus *const statusOut)	{ return _iBrowserPreference ? _iBrowserPreference->_vtbl->_setDefaultCharsetEncoding(_iBrowserPreference, iStrCharsetEncodingIanaName, statusOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDefaultCharsetEncoding(struct ICEUString* *const iStrCharsetEncodingIanaNameOut, CEHtmlBrowserFeatureValueStatus *const statusOut)	{ return _iBrowserPreference ? _iBrowserPreference->_vtbl->_getDefaultCharsetEncoding(_iBrowserPreference, iStrCharsetEncodingIanaNameOut, statusOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult deleteAllCookies()	{ return _iBrowserPreference ? _iBrowserPreference->_vtbl->_deleteAllCookies(_iBrowserPreference) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setHitTestParams(INT32 docPadding)	{ return _iBrowserPreference ? _iBrowserPreference->_vtbl->_setHitTestParams(_iBrowserPreference, docPadding) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getHitTestPadding(INT32* docPaddingOut)	{ return _iBrowserPreference ? _iBrowserPreference->_vtbl->_getHitTestPadding(_iBrowserPreference, docPaddingOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult deleteBasicAuthenticationCache()	{ return _iBrowserPreference ? _iBrowserPreference->_vtbl->_deleteBasicAuthenticationCache(_iBrowserPreference) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlBrowserPreference* _iBrowserPreference;
};

/*! @}
 * end of CEComICEHtmlBrowserPreferenceRef
 */

/*! \defgroup CEComICEHtmlFontPreferenceRef CEComICEHtmlFontPreferenceRef
 * @{
 */

class CEComICEHtmlFontPreferenceRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlFontPreferenceRef() : _iFontPreference(0) {}
	CEComICEHtmlFontPreferenceRef(ICEHtmlFontPreference* iOther) : _iFontPreference(0)
	{
		if (iOther)
		{
			_iFontPreference = iOther;
			_iFontPreference->_vtbl->_addRef(_iFontPreference);
		}
	}

	CEComICEHtmlFontPreferenceRef(const CEComICEHtmlFontPreferenceRef& other) : _iFontPreference(0)
	{
		if (other._iFontPreference)
		{
			_iFontPreference = other._iFontPreference;
			_iFontPreference->_vtbl->_addRef(_iFontPreference);
		}
	}

	~CEComICEHtmlFontPreferenceRef()
	{
		if (_iFontPreference)
		{
			ICEHtmlFontPreference* tmp = _iFontPreference;
			_iFontPreference = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlFontPreference* iFontPreference;
				void* _ptr;
			} uIntf;
			uIntf.iFontPreference = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlFontPreference, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iFontPreference)
				{
					ICEHtmlFontPreference* tmp = _iFontPreference;
					_iFontPreference = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iFontPreference = uIntf.iFontPreference;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFontPreference* object() const	{ return _iFontPreference; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlFontPreference* iOther)
	{
		if (_iFontPreference)
		{
			ICEHtmlFontPreference* tmp = _iFontPreference;
			_iFontPreference = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iFontPreference = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlFontPreference* detach()
	{
		ICEHtmlFontPreference* iIntf = _iFontPreference;
		_iFontPreference = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlFontPreference* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iFontPreference;
		if (_iFontPreference)
		{
			_iFontPreference->_vtbl->_addRef(_iFontPreference);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlFontPreference*() const	{ return _iFontPreference; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFontPreference& operator*() const	{ return *_iFontPreference; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iFontPreference == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlFontPreference* iOther) const	{ return (_iFontPreference != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlFontPreference* iOther) const	{ return (_iFontPreference == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlFontPreferenceRef& operator=(const CEComICEHtmlFontPreferenceRef& other)	{ return operator=(other._iFontPreference); }

	CEComICEHtmlFontPreferenceRef& operator=(const ICEHtmlFontPreference* iOther)
	{
		if (_iFontPreference != iOther)
		{
			if (_iFontPreference)
			{
				ICEHtmlFontPreference* tmp = _iFontPreference;
				_iFontPreference = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iFontPreference = const_cast<ICEHtmlFontPreference*>(iOther);
			if (_iFontPreference)
			{
				_iFontPreference->_vtbl->_addRef(_iFontPreference);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFontPreference** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlFontPreferenceRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iFontPreference && "has a com object reference. clear first.");
		return & _iFontPreference; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlFontPreferenceRef& other)
	{
		bool result = false;
		if (_iFontPreference)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iFontPreference);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iFontPreference ? _iFontPreference->_vtbl->_queryInterface(_iFontPreference, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iFontPreference) { _iFontPreference->_vtbl->_addRef(_iFontPreference); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iFontPreference) { _iFontPreference->_vtbl->_release(_iFontPreference); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setBaseFontSize(UINT32 absoluteSize, CEHtmlBrowserFeatureValueStatus *const statusOut)	{ return _iFontPreference ? _iFontPreference->_vtbl->_setBaseFontSize(_iFontPreference, absoluteSize, statusOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBaseFontSize(UINT32 *const absoluteSizeOut, CEHtmlBrowserFeatureValueStatus *const statusOut)	{ return _iFontPreference ? _iFontPreference->_vtbl->_getBaseFontSize(_iFontPreference, absoluteSizeOut, statusOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDefaultBaseFontSize(UINT32 *const defaultBaseFontSizeOut, CEHtmlBrowserFeatureValueStatus *const statusOut)	{ return _iFontPreference ? _iFontPreference->_vtbl->_getDefaultBaseFontSize(_iFontPreference, defaultBaseFontSizeOut, statusOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlFontPreference* _iFontPreference;
};

/*! @}
 * end of CEComICEHtmlFontPreferenceRef
 */

#endif // __cplusplus

#endif
