///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2007,2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CESysHandle_h__
#define __CESysHandle_h__

#include "CESysDefs.h"
#include "CESysDList.h"

#ifdef __cplusplus
extern "C"
{
#endif

	/////////////////////////////////////////////
	//  CESysHandle 
	/////////////////////////////////////////////

	#define CESYS_INVALID_HANDLE_VALUE  ((CESysHandle)-1)

	//! system object handle
	typedef UINT32 CESysHandle;

	//! close the system object specified from CESysHandle
	CE_DLL_EXPORT void CESysCloseHandle(CESysHandle hObject);




	/////////////////////////////////////////////
	//  Wait functions
	/////////////////////////////////////////////

	//! max number of waitable objects that CESysWaitForMultipleObjects() can accept
	#define CESYS_MAX_WAIT_OBJECTS	32

	// timeout constant
	#define CESYS_TIMEOUT_INFINITE (CE_INT32_MAX)

	// return code from WaitForXXX functions
	#define CESYS_WAIT_OBJECT_0		0UL
	#define CESYS_WAIT_ABANDONED_0	0x80UL
	#define CESYS_WAIT_TIMEOUT		0x102UL
	#define CESYS_WAIT_FAILED		0xffffffffUL


	//! wait until one-of or all objects are signaled
	//! \param[in] nHandles  number of handles to wait
	//! \param[in] pHandles  array of handles to wait
	//! \param[in] waitAll   specifies whether this function waits one-of object or all objects
	//! \param[in] usecTimeout  specifies the timeout period in micro-seconds
	//! \return CESYS_WAIT_OBJECT_0 to (CESYS_WAIT_OBJECT_0 + n -1), CESYS_WAIT_ABANDONED_0 to (CESYS_WAIT_ABANDONED_0 + n -1), CESYS_WAIT_TIMEOUT
	//!         or CESYS_WAIT_FAILED (for detail, call CESysGetLastError).
	CE_DLL_EXPORT UINT32 CESysWaitForMultipleObjects(UINT32 nHandles, const CESysHandle* pHandles, bool waitAll, UINT32 usecTimeout);



	/////////////////////////////////////////////
	//  Overlapped operations
	/////////////////////////////////////////////

	#define CESYS_IO_COMPLETED 0UL
	#define CESYS_IO_PENDING 1UL			// overlapped I/O is in progress
	#define CESYS_IO_INCOMPLETE 2UL			// overlapped I/O has not been signaled
	#define CESYS_IO_FAILED 0xffffffffUL

	typedef struct
	{
		UINT32 reserved[7];
		CESysHandle hEvent;
	} CESysOverlapped;


	//! initialize a overlapped structure
	//! \param[in] pOverlapped  pointer to the overlapped structure to be initialized
	//! \param[in] hEvent       handle of the event object
	CE_DLL_EXPORT void CESysInitializeOverlapped(CESysOverlapped* pOverlapped, CESysHandle hEvent);

	//! get the overlapped I/O result
	//!
	//! \param[in] hObj					handle to the overlapped I/O objects (currently MsgPipe only)
	//! \param[in] pOverlapped			pointer to the overlapped structure
	//! \param[out] pTransferedBytesOut	pointer to the variable to receive the transfered bytes
	//! \param[in] wait                 specifies whether wait or not if the overlapped I/O is still in progress
	//!
	//! \retval CESYS_IO_COMPLETED if succeeded.
	//! \retval CESYS_IO_INCOMPLETE if the specified overlapped I/O has not been completed. 
	//! \retval CESYS_IO_FAILED if failed. To get more detailed error information, call CESysGetLastError().
	CE_DLL_EXPORT UINT32 CESysGetOverlappedResult(CESysHandle hObj, CESysOverlapped* pOverlapped, size_t* pTransferedBytesOut, bool wait);


#ifdef __cplusplus
};
#endif

#endif // __CESysHandle_h__
