///////////////////////////////////////////////////////////////////////////////
// Copyright 2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CESysAtomicOpsXai_h__
#define __CESysAtomicOpsXai_h__

#ifdef __cplusplus
extern "C"
{
#endif

#define __lwarx(base) __extension__					\
	({unsigned int __macro_result;					\
		typedef  struct {char a[4];} wordsize;		\
		wordsize *ptrp = (wordsize*)(void*)(base);	\
		__asm__ volatile ("lwarx %0,%y1"			\
						  : "=r" (__macro_result)	\
						  : "Z" (*ptrp));			\
		__macro_result; })

#ifdef __powerpc64__
#define __ldarx(base) __extension__								\
	({unsigned long long __macro_result;						\
		typedef  struct {char a[8];} doublewordsize;			\
		doublewordsize *ptrp = (doublewordsize*)(void*)(base);	\
		__asm__ volatile ("ldarx %0,%y1"						\
						  : "=r" (__macro_result)				\
						  : "Z" (*ptrp));						\
		__macro_result; })
#endif /* __powerpc64__ */

#define __stwcx(base, value) __extension__			\
	({unsigned int __macro_result;					\
		typedef  struct {char a[4];} wordsize;		\
		wordsize *ptrp = (wordsize*)(void*)(base);	\
		__asm__ volatile ("stwcx. %2,%y1\n"			\
						  "\tmfocrf %0,0x80"		\
						  : "=r" (__macro_result),	\
							"=Z" (*ptrp)			\
						  : "r" (value) : "cr0");	\
		(__macro_result & 0x20000000); })

#ifdef __powerpc64__
#define __stdcx(base, value) __extension__						\
	({unsigned long long __macro_result;						\
		typedef  struct {char a[8];} doublewordsize;			\
		doublewordsize *ptrp = (doublewordsize*)(void*)(base);	\
		__asm__ volatile ("stdcx. %2,%y1\n"						\
						  "\tmfocrf %0,0x80"					\
						  : "=r" (__macro_result),				\
							"=Z" (*ptrp)						\
						  : "r" (value) : "cr0");				\
		(__macro_result & 0x20000000); })
#endif /* __powerpc64__ */

#define CE_HAVE_NATIVE_CAS32 1
static CE_FORCEINLINE INT32 CESysInterlockedCompareExchange(CESysAtomicINT32* dest, INT32 newValue, INT32 expectedValue)
{
	INT32 old;
	do {
		old = __lwarx(dest);
		if (old != expectedValue) {
			break;
		}
	} while (0 == __stwcx(dest, newValue));
	return old;
}

#define CE_HAVE_NATIVE_CAS64 1
static CE_FORCEINLINE INT64 CESysInterlockedCompareExchange64(CESysAtomicINT64* dest, INT64 newValue, INT64 expectedValue)
{
	INT64 old;
	do {
		old = __ldarx(dest);
		if (old != expectedValue) {
			break;
		}
	} while (0 == __stdcx(dest, newValue));
	return old;
}

#ifdef __cplusplus
};
#endif


#endif	// #ifndef __CESysAtomicOpsXai_h__
