///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CESysAssert_h__
#define __CESysAssert_h__

#include "CESysDefs.h"

///////////////////////////////////////
//  Assertion
///////////////////////////////////////

#ifdef __cplusplus
extern "C"
{
#endif

	typedef enum
	{
		CESysAssertMode_stop,
		CESysAssertMode_ignore,
		CESysAssertMode_abort,
	} CESysAssertMode;

	CE_DLL_EXPORT void CESysAssert(const char* expmsg, const char* file, int line);
	CE_DLL_EXPORT void CESysSetAssertMode(CESysAssertMode eAssertmode);
	CE_DLL_EXPORT void CESysDbgBreak();

#ifdef __cplusplus
};
#endif

#if CE_OS(ANDROID)
//$(ANDROID_TOP)/bionic/libc/kernel/arch-arm/asm/page.h
#define PAGE_SHIFT 12
#define PAGE_SIZE (1UL << PAGE_SHIFT)
#endif

#if defined(_DEBUG) || defined(FORCE_ENABLE_ASSERT) || CE_OS(ANDROID)

	#define CEASSERT(x) \
		{ \
			if ( !(x) ) \
			{ \
				CESysAssert(#x, __FILE__, __LINE__); \
			} \
		}

	#define CE_SET_ASSERTMODE(x) \
		{ \
			CESysSetAssertMode(x); \
		}

#else  //#if defined(_DEBUG) || defined(FORCE_ENABLE_ASSERT)

	#define CEASSERT(x)
	#define CE_SET_ASSERTMODE(x)

#endif // #if defined(_DEBUG) || defined(FORCE_ENABLE_ASSERT)


///////////////////////////////////////
//  Logging
///////////////////////////////////////

#ifdef __cplusplus
extern "C"
{
#endif

	typedef enum
	{
		eCESysDbgSeverity_Trace = 0,
		eCESysDbgSeverity_Debug,
		eCESysDbgSeverity_Info,
		eCESysDbgSeverity_Warning,
		eCESysDbgSeverity_Error
	}  eCESysDbgSeverity;

	CE_DLL_EXPORT void CESysDbgLoggingHandler(eCESysDbgSeverity severity, const char* name, const char* format, ...);

#ifdef __cplusplus
};
#endif

#if !defined(CEDBG_LOG_SOURCE)
	#define CEDBG_LOG_SOURCE CEFUNCSIG
#endif

#define _CEDBG_LOG_BASE(severity, source, format, ...) \
	CESysDbgLoggingHandler(severity, source, format, ##__VA_ARGS__)


#define CEDBG_LOG_ERROR(format, ...) \
	_CEDBG_LOG_BASE(eCESysDbgSeverity_Error, CEDBG_LOG_SOURCE, format, ##__VA_ARGS__)

#define CEDBG_LOG_WARNING(format, ...) \
	_CEDBG_LOG_BASE(eCESysDbgSeverity_Warning, CEDBG_LOG_SOURCE, format, ##__VA_ARGS__)

#define CEDBG_LOG_DEBUG(format, ...) \
	_CEDBG_LOG_BASE(eCESysDbgSeverity_Debug, CEDBG_LOG_SOURCE, format, ##__VA_ARGS__)

#define CEDBG_LOG_INFO(format, ...) \
	_CEDBG_LOG_BASE(eCESysDbgSeverity_Info, CEDBG_LOG_SOURCE, format, ##__VA_ARGS__)

#define CEDBG_LOG_TRACE(format, ...) \
	_CEDBG_LOG_BASE(eCESysDbgSeverity_Trace, CEDBG_LOG_SOURCE, format, ##__VA_ARGS__)

#endif // __CESysAssert_h__
