///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef CEApiEnums_h
#define CEApiEnums_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------


#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------


/*!
 * Special directory information
 */	
typedef enum
{
	CESpecialDir_Application = 0,     //!< Application directory path
	CESpecialDir_UserSpecificData = 1, //!< User specific data path
	CESpecialDir_FontInfoCache = 2 //!< Font info cache file path
} CESpecialDirId;


/*!
 * Window system library type
 */	
typedef enum
{
	CEWsysType_Win32 = 0,    //!< Win32
	CEWsysType_X     = 1,    //!< X11
	CEWsysType_NSG   = 2,    //!< NSG
	CEWsysType_AFW   = 3,    //!< AFW
	CEWsysType_Qt    = 4,    //!< Qt
	CEWsysType_CE    = 5,    //!< CEWS
	CEWsysType_Dsys  = 6,    //!< temporary for Display System
} CEWsysType;


/*!
 * Font rendering library type
 */	
typedef enum
{
	CEFontLibType_Win32GDI = 0,    //!< Win32GDI
	CEFontLibType_FontFusion = 1,  //!< Font Fusion
	CEFontLibType_FreeType = 2,    //!< FreeType
	CEFontLibType_NSG = 3,         //!< NSG
	CEFontLibType_BTX2 = 4,        //!< btX2
	CEFontLibType_CEPFFreeType = 5, //!< FreeType (CEPF version)
	CEFontLibType_CEPFBTX2 = 6,     //!< btX2 (CEPF version)
} CEFontLibType;


/*!
 * Bit mask for focus navigation property.
 * - Do not use this enum directly.
 * - If you set the focus navigation property. It is necessary to use macro functions.
 */
typedef enum
{
	CEFocusNavigationOffset_Type = 0,
	CEFocusNavigationOffset_TrackingMode = 4,
} CEFocusNavigationOffset;


/*!
 * Focus navigation mode
 */	
typedef enum
{
	CEFocusNavigationType_DomOrder = 0, //!< Dom order. Like a PC browser(Move by Tab/Shift+Tab Key).
	CEFocusNavigationType_Arrow = 1,    //!< Position base. Move be coursor, enter and cancel key.
	CEFocusNavigationType_None = 2,     //!< Disable FocusNavigation
} CEFocusNavigationType;


/*!
 * Focus tracking mode
 */
typedef enum
{
	CEFocusTrackingMode_None = 0, //!< No tracking.
	CEFocusTrackingMode_Scroll = 1, //!< Focus tracks scrolling. 
} CEFocusTrackingMode;


/*!
 * Scrollbar renderer type
 */
typedef enum
{
	CEScrollbarRendererType_Unknown						= -1,

	CEScrollbarRendererType_Standard					= 0,
	CEScrollbarRendererType_ResourceOverwriting			= 1,
	CEScrollbarRendererType_DTV05						= 2,

	CEScrollbarRendererType_NumberOfScrollbarRenderer	= 3,
} CEScrollbarRendererType;


/*!
 * Focus renderer type
 */
typedef enum
{
	CEFocusRendererType_Unknown					= -1,

	CEFocusRendererType_Standard				= 0,
	CEFocusRendererType_DTV05					= 1,
	CEFocusRendererType_Xai						= 2,
	CEFocusRendererType_Dragon					= 3,
	CEFocusRendererType_Toroid					= 5,
	CEFocusRendererType_None					= 6,

	CEFocusRendererType_NumberOfFocusRenderer	= 7,
} CEFocusRendererType;

typedef enum
{
	CEDirectFBFunctionType_DirectFBInit		= 0,
	CEDirectFBFunctionType_DirectFBCreate		= 1,
	CEDirectFBFunctionType_DirectFBCheckVersion	= 2
} CEDirectFBFunctionType;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

#endif // __cplusplus

#endif
