///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef CEApiComponentEnums_h
#define CEApiComponentEnums_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------


#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------


/*!
 * Size type
 */
typedef enum
{
	SizeType_Window, //!< Represent WindowSize
	SizeType_Preferred, //!< Represent PreferredSize
} CECompSizeType;


/*!
 * Property types of components
 */
typedef enum
{
	CEPropId_Enable      = 1, //!< specify the property whether the component is enabled 
	CEPropId_Visible     = 2, //!< specify the property whether the component is visible 
	CEPropId_Transparent = 3, //!< specify the property whether the component is transparent 
	CEPropId_Resize      = 4, //!< specify the property whether the component is resizable. the component should be FrameWindow or Dialog 
	CEPropId_Rollover    = 5,//!< specify the property when there is mouse cusor over the component 
	CEPropId_PasswordMode= 6 //!< specify the property whether the component is password mode. the component should be SingleLineText.
} CEPropertyId;


/*!
 * Border Types
 */
typedef enum
{
	CEBorderType_None, //!< No border 
	CEBorderType_Raised, //!< Border looks raised 
	CEBorderType_Recessed, //!< Border looks recessed 
	CEBorderType_Line, //!< Solid line border 
} CEBorderType;


/*! 
 *  Constraints for border/box layout
 */
typedef enum
{
	CELayoutConstraint_None, //!< No constraint 
	CEBorderLayoutConstraint_North, //!< Place north of parent container for border layout 
	CEBorderLayoutConstraint_West, //!< Place west of parent container for border layout 
	CEBorderLayoutConstraint_East, //!< Place east of parent container for border layout 
	CEBorderLayoutConstraint_South, //!< Place south of parent container for border layout 
	CEBorderLayoutConstraint_Center, //!< Place center of parent container for border layout 
	CEBoxLayoutConstraint_TopOrLeft, //!< Place Top/Left of the parent container for box layout whose direction is AxisX/AxisY
	CEBoxLayoutConstraint_Center, //!< Place Middle of the parent container for box layout 
	CEBoxLayoutConstraint_BottomOrRight,  //!< Place Bottom/Right of the parent container for box layout whose direction is AxisX/AxisY
} CEApiLayoutConstraint;


/*!
 * Layouter Type
 */
typedef enum
{
	CELayoutType_Border, //!< Border layout. This place components on North/West/East/South/Center 
	CELayoutType_Box //!< Box layout. This place components in a row horizontally or vertically 
} CELayoutType;


/*!
 * Specifies direction of BoxLayout in BoxLayoutParam
 *
 * \todo This enum should be matched with CEBoxLayout::CELayoutAxis
 */
typedef enum
{
	CEBoxLayout_AxisX, //!< Specify the direction of box layout horizontal 
	CEBoxLayout_AxisY //!< Specify the direction of box layout vertical 
} CEBoxLayoutAxis;


/*! 
 * Status types of components
 */
typedef enum
{
	CEComponentState_Normal, //!< specify the normal status 
	CEComponentState_Disabled, //!< specify the status that the component is disabled 
	CEComponentState_Pressed, //!< specify the status that the component like butto is pressed 
	CEComponentState_Rollover, //!< specify the status that mouse cursor is over the component 
	CEComponentState_Selected, //!< specify the status that the component is selected 
	CEComponentState_Focused //!< specify the status that the component is focused 
} CEComponentState;


/*!
 * Property of menu
 */
typedef enum
{
	CEMenuProp_Enabled, //!< specify the menu is enabled or not
	CEMenuProp_Checked, //!< specify the menu is checked or not
} CEMenuProperty;


/*!
 * IME mode.
 */
typedef enum
{
	CEIMEMode_Native     = 0, //!< Specify whether ime mode "native" is enabled.
	CEIMEMode_Katakana   = 1, //!< Specify whether ime mode "katakana" is enabled.
	CEIMEMode_Undefined  = 2, //!< Specify whether ime mode "native" is enabled.
	CEIMEMode_FullShape  = 3, //!< Specify whether ime mode "full shape" is enabled.
	CEIMEMode_Roman      = 4, //!< Specify whether ime mode "roman" is enabled.
	CEIMEMode_Number     = 5, //!< Specify whether ime mode "number" is enabled.
} CEIMEMode;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

#endif // __cplusplus

#endif
