///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2006,2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CEUThread_H__
#define __CEUThread_H__

#include "ceusync.h"
#include "CESysThread.h"

typedef enum CEUThread_MsgStatus
{
	CEUThread_MsgStatus_Delivered,
	CEUThread_MsgStatus_NotDelivered
}CEUThread_MsgStatus;

typedef enum CEUThread_Status
{
	CEUThread_Status_Normal = 0,
	CEUThread_Status_Terminating = 1 << 0,
	CEUThread_Status_Recovery = 1 << 1,
	CEUThread_Status_Suspending = 1 << 2,
} CEUThread_Status;

typedef CEHResult(*CEUThread_MessageHandlerProc)(void* userData, void* msg);
typedef void(*CEUThread_MessageStatusCB)(void* userData, void* msg, CEUThread_MsgStatus status);

typedef void* CEUThreadRef;

typedef CEHResult(*_ceuthread_create)(CEUThreadRef* threadOut, CEUThread_MessageHandlerProc proc, void* userData, UINT32 apartmentIID, eCESysThreadType type);
typedef CEHResult(*_ceuthread_destroy)(CEUThreadRef);
typedef CEHResult(*_ceuthread_postMessage)(CEUThreadRef dst, void* msg, CEUThread_MessageStatusCB cb, void* userData, UINT16 priority);

typedef struct _CEUThreadInterface
{
	_ceuthread_create      create;
	_ceuthread_destroy     destroy;
	_ceuthread_postMessage postMessage;
}CEUThreadInterface;

#ifdef __cplusplus
extern "C"
{
#endif

CE_DLL_EXPORT
CEHResult CEUThread_create(CEUThreadRef* threadOut, CEUThread_MessageHandlerProc proc, void* userData, UINT32 apartmentIID, eCESysThreadType type);
CE_DLL_EXPORT
CEHResult CEUThread_destroy(CEUThreadRef thread);
CE_DLL_EXPORT
CEHResult CEUThread_postMessage(CEUThreadRef dst, void* msg, CEUThread_MessageStatusCB cb, void* userData, UINT16 priority);

CE_DLL_EXPORT
CEHResult CEUThread_peepLastMessage(CEUThreadRef dst, void** msgOut);
CE_DLL_EXPORT
CEHResult CEUThread_acquireLock(CEUThreadRef dst);
CE_DLL_EXPORT
CEHResult CEUThread_releaseLock(CEUThreadRef dst);

CE_DLL_EXPORT
CEHResult CEUThread_getStackInfo(CEUThreadRef dst, void** base, USIZE_T* size);

CE_DLL_EXPORT
CEHResult CEUThread_self(UINT32* idOut);

CE_DLL_EXPORT
UINT32 CEUThread_getThreadStatus(CEUThreadRef dst);

CE_DLL_EXPORT
CEHResult CEUThread_incrementDependency(CEUThreadRef dst);

CE_DLL_EXPORT
CEHResult CEUThread_decrementDependency(CEUThreadRef dst);

CE_DLL_EXPORT
CEHResult CEUThread_setExtraSemaphore(CEUThreadRef dst, CEUSemaphoreRef semaphore);

#ifdef __cplusplus
}
#endif

#endif
