///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEUIGraphicsContext_h
#define ICEUIGraphicsContext_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "CEUITypes.h"
#include "ICEUIFont.h"
#include "ICEUIImage.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEUIGraphicsContext ICEUIGraphicsContext
 * @{
 */

/*!
 * ID of ICEUIGraphicsContext
 */
#define CEComIID_ICEUIGraphicsContext 0xcb2a0512


/*!
 * ICEUIGraphicsContext
 */
typedef struct ICEUIGraphicsContext
{
	const struct ICEUIGraphicsContext_vtbl* _vtbl;
} ICEUIGraphicsContext;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iUIGraphicsContext	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEUIGraphicsContext_queryInterface) (ICEUIGraphicsContext* iUIGraphicsContext, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIGraphicsContext_addRef) (ICEUIGraphicsContext* iUIGraphicsContext);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIGraphicsContext_release) (ICEUIGraphicsContext* iUIGraphicsContext);

typedef CEHResult (*iCEUIGraphicsContext_saveState) (ICEUIGraphicsContext* iUIGraphicsContext);

typedef CEHResult (*iCEUIGraphicsContext_restoreState) (ICEUIGraphicsContext* iUIGraphicsContext);

typedef CEHResult (*iCEUIGraphicsContext_translate) (ICEUIGraphicsContext* iUIGraphicsContext, const CEPointBase* pt);

typedef CEHResult (*iCEUIGraphicsContext_getColor) (ICEUIGraphicsContext* iUIGraphicsContext, bool isBackground, CERGBColor *const colorOut);

typedef CEHResult (*iCEUIGraphicsContext_setColor) (ICEUIGraphicsContext* iUIGraphicsContext, bool isBackground, const CERGBColor* color);

typedef CEHResult (*iCEUIGraphicsContext_draw) (ICEUIGraphicsContext* iUIGraphicsContext, const CERect* destRect, const CERect* sourceRect, struct ICEUIGraphicsContext* iSrcContext);

typedef CEHResult (*iCEUIGraphicsContext_drawText) (ICEUIGraphicsContext* iUIGraphicsContext, const CEPointBase* ptToDrawAt, struct ICEUString* iText);

typedef CEHResult (*iCEUIGraphicsContext_drawUTF16CHARArray) (ICEUIGraphicsContext* iUIGraphicsContext, const CEPointBase* ptToDrawAt, const UTF16CHAR* charArray, UINT32 numOfChar, CEUIFontOption* pFontOptionRef);

typedef CEHResult (*iCEUIGraphicsContext_drawGlyph) (ICEUIGraphicsContext* iUIGraphicsContext, const CEPointBase* ptToDrawAt, UINT32 glyphId);

typedef CEHResult (*iCEUIGraphicsContext_strokeGlyph) (ICEUIGraphicsContext* iUIGraphicsContext, const CEPointBase* ptToDrawAt, UINT32 glyphId);

typedef CEHResult (*iCEUIGraphicsContext_drawImage) (ICEUIGraphicsContext* iUIGraphicsContext, const CERect* rectDest, struct ICEUIImage* iImage);

typedef CEHResult (*iCEUIGraphicsContext_drawCompressedImage) (ICEUIGraphicsContext* iUIGraphicsContext, const CERect* rectDest, struct ICECompressedImage* iImage);

typedef CEHResult (*iCEUIGraphicsContext_drawRect) (ICEUIGraphicsContext* iUIGraphicsContext, const CERect* boxRect, bool fill, CELineStyle style);

typedef CEHResult (*iCEUIGraphicsContext_drawOval) (ICEUIGraphicsContext* iUIGraphicsContext, const CERect* boxRect, bool fill, CELineStyle style);

typedef CEHResult (*iCEUIGraphicsContext_drawRoundRect) (ICEUIGraphicsContext* iUIGraphicsContext, const CERect* boxRect, INT32 arcWidth, INT32 arcHeight, bool fill);

typedef CEHResult (*iCEUIGraphicsContext_drawLine) (ICEUIGraphicsContext* iUIGraphicsContext, const CEPointBase* pt1, const CEPointBase* pt2, CELineStyle style);

typedef CEHResult (*iCEUIGraphicsContext_drawPolygon) (ICEUIGraphicsContext* iUIGraphicsContext, const CEPointBase* points, UINT32 count, bool fill, CELineStyle style);

typedef CEHResult (*iCEUIGraphicsContext_clearRect) (ICEUIGraphicsContext* iUIGraphicsContext, const CERect* rect, bool isBase);

typedef CEHResult (*iCEUIGraphicsContext_fillRectWithTexture) (ICEUIGraphicsContext* iUIGraphicsContext, const CERect* pDstRect, struct ICEUIImage* iImage, const CEPointBase* pTexCoord);

typedef CEHResult (*iCEUIGraphicsContext_fillRectWithCompressedTexture) (ICEUIGraphicsContext* iUIGraphicsContext, const CERect* pDstRect, struct ICECompressedImage* iImage, const CEPointBase* pTexCoord);

typedef CEHResult (*iCEUIGraphicsContext_getClipRect) (ICEUIGraphicsContext* iUIGraphicsContext, CERect *const rectOut);

typedef CEHResult (*iCEUIGraphicsContext_setClipRect) (ICEUIGraphicsContext* iUIGraphicsContext, const CERect* rect);

typedef CEHResult (*iCEUIGraphicsContext_getTextExtent) (ICEUIGraphicsContext* iUIGraphicsContext, struct ICEUString* str, CEDim *const dimOut);

typedef CEHResult (*iCEUIGraphicsContext_getFont) (ICEUIGraphicsContext* iUIGraphicsContext, struct ICEUIFont* *const iFontOut);

typedef CEHResult (*iCEUIGraphicsContext_setFont) (ICEUIGraphicsContext* iUIGraphicsContext, struct ICEUIFont* iFont);

typedef CEHResult (*iCEUIGraphicsContext_setOpacity) (ICEUIGraphicsContext* iUIGraphicsContext, float opacity);

typedef CEHResult (*iCEUIGraphicsContext_getOpacity) (ICEUIGraphicsContext* iUIGraphicsContext, float *const opacityOut);

typedef CEHResult (*iCEUIGraphicsContext_drawArc) (ICEUIGraphicsContext* iUIGraphicsContext, CERect* boxRect, int startAngle, int arcAngle, bool fill);

typedef CEHResult (*iCEUIGraphicsContext_setIntersectClipRect) (ICEUIGraphicsContext* iUIGraphicsContext, const CERect* rect);

//! set LW translation mode and returns current LW translate point.

typedef CEHResult (*iCEUIGraphicsContext_setIsLWTranslationEnabled) (ICEUIGraphicsContext* iUIGraphicsContext, bool bEnable, CEPointBase *const pOptCtRef);

/*!
 * V-table of ICEUIGraphicsContext
 */
struct ICEUIGraphicsContext_vtbl
{
	iCEUIGraphicsContext_queryInterface	_queryInterface;	//!< Query interface.
	iCEUIGraphicsContext_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEUIGraphicsContext_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEUIGraphicsContext_saveState	_saveState;
	iCEUIGraphicsContext_restoreState	_restoreState;
	iCEUIGraphicsContext_translate	_translate;
	iCEUIGraphicsContext_getColor	_getColor;
	iCEUIGraphicsContext_setColor	_setColor;
	iCEUIGraphicsContext_draw	_draw;
	iCEUIGraphicsContext_drawText	_drawText;
	iCEUIGraphicsContext_drawUTF16CHARArray	_drawUTF16CHARArray;
	iCEUIGraphicsContext_drawGlyph	_drawGlyph;
	iCEUIGraphicsContext_strokeGlyph	_strokeGlyph;
	iCEUIGraphicsContext_drawImage	_drawImage;
	iCEUIGraphicsContext_drawCompressedImage	_drawCompressedImage;
	iCEUIGraphicsContext_drawRect	_drawRect;
	iCEUIGraphicsContext_drawOval	_drawOval;
	iCEUIGraphicsContext_drawRoundRect	_drawRoundRect;
	iCEUIGraphicsContext_drawLine	_drawLine;
	iCEUIGraphicsContext_drawPolygon	_drawPolygon;
	iCEUIGraphicsContext_clearRect	_clearRect;
	iCEUIGraphicsContext_fillRectWithTexture	_fillRectWithTexture;
	iCEUIGraphicsContext_fillRectWithCompressedTexture	_fillRectWithCompressedTexture;
	iCEUIGraphicsContext_getClipRect	_getClipRect;
	iCEUIGraphicsContext_setClipRect	_setClipRect;
	iCEUIGraphicsContext_getTextExtent	_getTextExtent;
	iCEUIGraphicsContext_getFont	_getFont;
	iCEUIGraphicsContext_setFont	_setFont;
	iCEUIGraphicsContext_setOpacity	_setOpacity;
	iCEUIGraphicsContext_getOpacity	_getOpacity;
	iCEUIGraphicsContext_drawArc	_drawArc;
	iCEUIGraphicsContext_setIntersectClipRect	_setIntersectClipRect;
	iCEUIGraphicsContext_setIsLWTranslationEnabled	_setIsLWTranslationEnabled;
};

/*! @}
 * end of ICEUIGraphicsContext
 */

/*! \defgroup ICEUIGraphicsContextDX ICEUIGraphicsContextDX
 * @{
 */

/*!
 * ID of ICEUIGraphicsContextDX
 */
#define CEComIID_ICEUIGraphicsContextDX 0x580c1ded

/*!
 * ICEUIGraphicsContextDX
 */
typedef struct ICEUIGraphicsContextDX
{
	const struct ICEUIGraphicsContextDX_vtbl* _vtbl;
} ICEUIGraphicsContextDX;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iUIGraphicsContextDX	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEUIGraphicsContextDX_queryInterface) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIGraphicsContextDX_addRef) (ICEUIGraphicsContextDX* iUIGraphicsContextDX);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUIGraphicsContextDX_release) (ICEUIGraphicsContextDX* iUIGraphicsContextDX);

typedef CEHResult (*iCEUIGraphicsContextDX_saveState) (ICEUIGraphicsContextDX* iUIGraphicsContextDX);

typedef CEHResult (*iCEUIGraphicsContextDX_restoreState) (ICEUIGraphicsContextDX* iUIGraphicsContextDX);

typedef CEHResult (*iCEUIGraphicsContextDX_translate) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CEPointBase* pt);

typedef CEHResult (*iCEUIGraphicsContextDX_getColor) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, bool isBackground, CERGBColor *const colorOut);

typedef CEHResult (*iCEUIGraphicsContextDX_setColor) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, bool isBackground, const CERGBColor* color);

typedef CEHResult (*iCEUIGraphicsContextDX_draw) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CERect* destRect, const CERect* sourceRect, struct ICEUIGraphicsContext* iSrcContext);

typedef CEHResult (*iCEUIGraphicsContextDX_drawText) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CEPointBase* ptToDrawAt, struct ICEUString* iText);

typedef CEHResult (*iCEUIGraphicsContextDX_drawUTF16CHARArray) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CEPointBase* ptToDrawAt, const UTF16CHAR* charArray, UINT32 numOfChar, CEUIFontOption* pFontOptionRef);

typedef CEHResult (*iCEUIGraphicsContextDX_drawGlyph) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CEPointBase* ptToDrawAt, UINT32 glyphId);

typedef CEHResult (*iCEUIGraphicsContextDX_strokeGlyph) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CEPointBase* ptToDrawAt, UINT32 glyphId);

typedef CEHResult (*iCEUIGraphicsContextDX_drawImage) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CERect* rectDest, struct ICEUIImage* iImage);

typedef CEHResult (*iCEUIGraphicsContextDX_drawCompressedImage) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CERect* rectDest, struct ICECompressedImage* iImage);

typedef CEHResult (*iCEUIGraphicsContextDX_drawRect) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CERect* boxRect, bool fill, CELineStyle style);

typedef CEHResult (*iCEUIGraphicsContextDX_drawOval) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CERect* boxRect, bool fill, CELineStyle style);

typedef CEHResult (*iCEUIGraphicsContextDX_drawRoundRect) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CERect* boxRect, INT32 arcWidth, INT32 arcHeight, bool fill);

typedef CEHResult (*iCEUIGraphicsContextDX_drawLine) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CEPointBase* pt1, const CEPointBase* pt2, CELineStyle style);

typedef CEHResult (*iCEUIGraphicsContextDX_drawPolygon) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CEPointBase* points, UINT32 count, bool fill, CELineStyle style);

typedef CEHResult (*iCEUIGraphicsContextDX_clearRect) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CERect* rect, bool isBase);

typedef CEHResult (*iCEUIGraphicsContextDX_fillRectWithTexture) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CERect* pDstRect, struct ICEUIImage* iImage, const CEPointBase* pTexCoord);

typedef CEHResult (*iCEUIGraphicsContextDX_fillRectWithCompressedTexture) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CERect* pDstRect, struct ICECompressedImage* iImage, const CEPointBase* pTexCoord);

typedef CEHResult (*iCEUIGraphicsContextDX_getClipRect) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, CERect *const rectOut);

typedef CEHResult (*iCEUIGraphicsContextDX_setClipRect) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CERect* rect);

typedef CEHResult (*iCEUIGraphicsContextDX_getTextExtent) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, struct ICEUString* str, CEDim *const dimOut);

typedef CEHResult (*iCEUIGraphicsContextDX_getFont) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, struct ICEUIFont* *const iFontOut);

typedef CEHResult (*iCEUIGraphicsContextDX_setFont) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, struct ICEUIFont* iFont);

typedef CEHResult (*iCEUIGraphicsContextDX_setOpacity) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, float opacity);

typedef CEHResult (*iCEUIGraphicsContextDX_getOpacity) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, float *const opacityOut);

typedef CEHResult (*iCEUIGraphicsContextDX_drawArc) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, CERect* boxRect, int startAngle, int arcAngle, bool fill);

typedef CEHResult (*iCEUIGraphicsContextDX_setIntersectClipRect) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, const CERect* rect);

//! set LW translation mode and returns current LW translate point.

typedef CEHResult (*iCEUIGraphicsContextDX_setIsLWTranslationEnabled) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, bool bEnable, CEPointBase *const pOptCtRef);

typedef CEHResult (*iCEUIGraphicsContextDX_getDXImage) (ICEUIGraphicsContextDX* iUIGraphicsContextDX, struct ICEDXContext2D* *const iCtx2D);

/*!
 * V-table of ICEUIGraphicsContextDX
 */
struct ICEUIGraphicsContextDX_vtbl
{
	iCEUIGraphicsContextDX_queryInterface	_queryInterface;	//!< Query interface.
	iCEUIGraphicsContextDX_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEUIGraphicsContextDX_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEUIGraphicsContextDX_saveState	_saveState;
	iCEUIGraphicsContextDX_restoreState	_restoreState;
	iCEUIGraphicsContextDX_translate	_translate;
	iCEUIGraphicsContextDX_getColor	_getColor;
	iCEUIGraphicsContextDX_setColor	_setColor;
	iCEUIGraphicsContextDX_draw	_draw;
	iCEUIGraphicsContextDX_drawText	_drawText;
	iCEUIGraphicsContextDX_drawUTF16CHARArray	_drawUTF16CHARArray;
	iCEUIGraphicsContextDX_drawGlyph	_drawGlyph;
	iCEUIGraphicsContextDX_strokeGlyph	_strokeGlyph;
	iCEUIGraphicsContextDX_drawImage	_drawImage;
	iCEUIGraphicsContextDX_drawCompressedImage	_drawCompressedImage;
	iCEUIGraphicsContextDX_drawRect	_drawRect;
	iCEUIGraphicsContextDX_drawOval	_drawOval;
	iCEUIGraphicsContextDX_drawRoundRect	_drawRoundRect;
	iCEUIGraphicsContextDX_drawLine	_drawLine;
	iCEUIGraphicsContextDX_drawPolygon	_drawPolygon;
	iCEUIGraphicsContextDX_clearRect	_clearRect;
	iCEUIGraphicsContextDX_fillRectWithTexture	_fillRectWithTexture;
	iCEUIGraphicsContextDX_fillRectWithCompressedTexture	_fillRectWithCompressedTexture;
	iCEUIGraphicsContextDX_getClipRect	_getClipRect;
	iCEUIGraphicsContextDX_setClipRect	_setClipRect;
	iCEUIGraphicsContextDX_getTextExtent	_getTextExtent;
	iCEUIGraphicsContextDX_getFont	_getFont;
	iCEUIGraphicsContextDX_setFont	_setFont;
	iCEUIGraphicsContextDX_setOpacity	_setOpacity;
	iCEUIGraphicsContextDX_getOpacity	_getOpacity;
	iCEUIGraphicsContextDX_drawArc	_drawArc;
	iCEUIGraphicsContextDX_setIntersectClipRect	_setIntersectClipRect;
	iCEUIGraphicsContextDX_setIsLWTranslationEnabled	_setIsLWTranslationEnabled;
	iCEUIGraphicsContextDX_getDXImage	_getDXImage;
};

/*! @}
 * end of ICEUIGraphicsContextDX
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEUIGraphicsContextRef CEComICEUIGraphicsContextRef
 * @{
 */

class CEComICEUIGraphicsContextRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEUIGraphicsContextRef() : _iUIGraphicsContext(0) {}
	CEComICEUIGraphicsContextRef(ICEUIGraphicsContext* iOther) : _iUIGraphicsContext(0)
	{
		if (iOther)
		{
			_iUIGraphicsContext = iOther;
			_iUIGraphicsContext->_vtbl->_addRef(_iUIGraphicsContext);
		}
	}

	CEComICEUIGraphicsContextRef(const CEComICEUIGraphicsContextRef& other) : _iUIGraphicsContext(0)
	{
		if (other._iUIGraphicsContext)
		{
			_iUIGraphicsContext = other._iUIGraphicsContext;
			_iUIGraphicsContext->_vtbl->_addRef(_iUIGraphicsContext);
		}
	}

	~CEComICEUIGraphicsContextRef()
	{
		if (_iUIGraphicsContext)
		{
			ICEUIGraphicsContext* tmp = _iUIGraphicsContext;
			_iUIGraphicsContext = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEUIGraphicsContext* iUIGraphicsContext;
				void* _ptr;
			} uIntf;
			uIntf.iUIGraphicsContext = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEUIGraphicsContext, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iUIGraphicsContext)
				{
					ICEUIGraphicsContext* tmp = _iUIGraphicsContext;
					_iUIGraphicsContext = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iUIGraphicsContext = uIntf.iUIGraphicsContext;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEUIGraphicsContext* object() const	{ return _iUIGraphicsContext; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEUIGraphicsContext* iOther)
	{
		if (_iUIGraphicsContext)
		{
			ICEUIGraphicsContext* tmp = _iUIGraphicsContext;
			_iUIGraphicsContext = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iUIGraphicsContext = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEUIGraphicsContext* detach()
	{
		ICEUIGraphicsContext* iIntf = _iUIGraphicsContext;
		_iUIGraphicsContext = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEUIGraphicsContext* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iUIGraphicsContext;
		if (_iUIGraphicsContext)
		{
			_iUIGraphicsContext->_vtbl->_addRef(_iUIGraphicsContext);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEUIGraphicsContext*() const	{ return _iUIGraphicsContext; }
	FORCEINLINE_WITHOUT_DEBUG ICEUIGraphicsContext& operator*() const	{ return *_iUIGraphicsContext; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iUIGraphicsContext == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEUIGraphicsContext* iOther) const	{ return (_iUIGraphicsContext != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEUIGraphicsContext* iOther) const	{ return (_iUIGraphicsContext == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEUIGraphicsContextRef& operator=(const CEComICEUIGraphicsContextRef& other)	{ return operator=(other._iUIGraphicsContext); }

	CEComICEUIGraphicsContextRef& operator=(const ICEUIGraphicsContext* iOther)
	{
		if (_iUIGraphicsContext != iOther)
		{
			if (_iUIGraphicsContext)
			{
				ICEUIGraphicsContext* tmp = _iUIGraphicsContext;
				_iUIGraphicsContext = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iUIGraphicsContext = const_cast<ICEUIGraphicsContext*>(iOther);
			if (_iUIGraphicsContext)
			{
				_iUIGraphicsContext->_vtbl->_addRef(_iUIGraphicsContext);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEUIGraphicsContext** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEUIGraphicsContextRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iUIGraphicsContext && "has a com object reference. clear first.");
		return & _iUIGraphicsContext; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEUIGraphicsContextRef& other)
	{
		bool result = false;
		if (_iUIGraphicsContext)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iUIGraphicsContext);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_queryInterface(_iUIGraphicsContext, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iUIGraphicsContext) { _iUIGraphicsContext->_vtbl->_addRef(_iUIGraphicsContext); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iUIGraphicsContext) { _iUIGraphicsContext->_vtbl->_release(_iUIGraphicsContext); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult saveState()	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_saveState(_iUIGraphicsContext) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult restoreState()	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_restoreState(_iUIGraphicsContext) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult translate(const CEPointBase* pt)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_translate(_iUIGraphicsContext, pt) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(bool isBackground, CERGBColor *const colorOut)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_getColor(_iUIGraphicsContext, isBackground, colorOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setColor(bool isBackground, const CERGBColor* color)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_setColor(_iUIGraphicsContext, isBackground, color) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult draw(const CERect* destRect, const CERect* sourceRect, struct ICEUIGraphicsContext* iSrcContext)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_draw(_iUIGraphicsContext, destRect, sourceRect, iSrcContext) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawText(const CEPointBase* ptToDrawAt, struct ICEUString* iText)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_drawText(_iUIGraphicsContext, ptToDrawAt, iText) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawUTF16CHARArray(const CEPointBase* ptToDrawAt, const UTF16CHAR* charArray, UINT32 numOfChar, CEUIFontOption* pFontOptionRef)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_drawUTF16CHARArray(_iUIGraphicsContext, ptToDrawAt, charArray, numOfChar, pFontOptionRef) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawGlyph(const CEPointBase* ptToDrawAt, UINT32 glyphId)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_drawGlyph(_iUIGraphicsContext, ptToDrawAt, glyphId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult strokeGlyph(const CEPointBase* ptToDrawAt, UINT32 glyphId)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_strokeGlyph(_iUIGraphicsContext, ptToDrawAt, glyphId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawImage(const CERect* rectDest, struct ICEUIImage* iImage)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_drawImage(_iUIGraphicsContext, rectDest, iImage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawCompressedImage(const CERect* rectDest, struct ICECompressedImage* iImage)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_drawCompressedImage(_iUIGraphicsContext, rectDest, iImage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawRect(const CERect* boxRect, bool fill, CELineStyle style)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_drawRect(_iUIGraphicsContext, boxRect, fill, style) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawOval(const CERect* boxRect, bool fill, CELineStyle style)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_drawOval(_iUIGraphicsContext, boxRect, fill, style) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawRoundRect(const CERect* boxRect, INT32 arcWidth, INT32 arcHeight, bool fill)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_drawRoundRect(_iUIGraphicsContext, boxRect, arcWidth, arcHeight, fill) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawLine(const CEPointBase* pt1, const CEPointBase* pt2, CELineStyle style)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_drawLine(_iUIGraphicsContext, pt1, pt2, style) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawPolygon(const CEPointBase* points, UINT32 count, bool fill, CELineStyle style)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_drawPolygon(_iUIGraphicsContext, points, count, fill, style) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult clearRect(const CERect* rect, bool isBase)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_clearRect(_iUIGraphicsContext, rect, isBase) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult fillRectWithTexture(const CERect* pDstRect, struct ICEUIImage* iImage, const CEPointBase* pTexCoord)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_fillRectWithTexture(_iUIGraphicsContext, pDstRect, iImage, pTexCoord) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult fillRectWithCompressedTexture(const CERect* pDstRect, struct ICECompressedImage* iImage, const CEPointBase* pTexCoord)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_fillRectWithCompressedTexture(_iUIGraphicsContext, pDstRect, iImage, pTexCoord) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getClipRect(CERect *const rectOut)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_getClipRect(_iUIGraphicsContext, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setClipRect(const CERect* rect)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_setClipRect(_iUIGraphicsContext, rect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTextExtent(struct ICEUString* str, CEDim *const dimOut)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_getTextExtent(_iUIGraphicsContext, str, dimOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUIFont* *const iFontOut)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_getFont(_iUIGraphicsContext, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFont(struct ICEUIFont* iFont)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_setFont(_iUIGraphicsContext, iFont) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setOpacity(float opacity)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_setOpacity(_iUIGraphicsContext, opacity) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getOpacity(float *const opacityOut)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_getOpacity(_iUIGraphicsContext, opacityOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawArc(CERect* boxRect, int startAngle, int arcAngle, bool fill)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_drawArc(_iUIGraphicsContext, boxRect, startAngle, arcAngle, fill) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setIntersectClipRect(const CERect* rect)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_setIntersectClipRect(_iUIGraphicsContext, rect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setIsLWTranslationEnabled(bool bEnable, CEPointBase *const pOptCtRef)	{ return _iUIGraphicsContext ? _iUIGraphicsContext->_vtbl->_setIsLWTranslationEnabled(_iUIGraphicsContext, bEnable, pOptCtRef) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEUIGraphicsContext* _iUIGraphicsContext;
};

/*! @}
 * end of CEComICEUIGraphicsContextRef
 */

/*! \defgroup CEComICEUIGraphicsContextDXRef CEComICEUIGraphicsContextDXRef
 * @{
 */

class CEComICEUIGraphicsContextDXRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEUIGraphicsContextDXRef() : _iUIGraphicsContextDX(0) {}
	CEComICEUIGraphicsContextDXRef(ICEUIGraphicsContextDX* iOther) : _iUIGraphicsContextDX(0)
	{
		if (iOther)
		{
			_iUIGraphicsContextDX = iOther;
			_iUIGraphicsContextDX->_vtbl->_addRef(_iUIGraphicsContextDX);
		}
	}

	CEComICEUIGraphicsContextDXRef(const CEComICEUIGraphicsContextDXRef& other) : _iUIGraphicsContextDX(0)
	{
		if (other._iUIGraphicsContextDX)
		{
			_iUIGraphicsContextDX = other._iUIGraphicsContextDX;
			_iUIGraphicsContextDX->_vtbl->_addRef(_iUIGraphicsContextDX);
		}
	}

	~CEComICEUIGraphicsContextDXRef()
	{
		if (_iUIGraphicsContextDX)
		{
			ICEUIGraphicsContextDX* tmp = _iUIGraphicsContextDX;
			_iUIGraphicsContextDX = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEUIGraphicsContextDX* iUIGraphicsContextDX;
				void* _ptr;
			} uIntf;
			uIntf.iUIGraphicsContextDX = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEUIGraphicsContextDX, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iUIGraphicsContextDX)
				{
					ICEUIGraphicsContextDX* tmp = _iUIGraphicsContextDX;
					_iUIGraphicsContextDX = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iUIGraphicsContextDX = uIntf.iUIGraphicsContextDX;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEUIGraphicsContextDX* object() const	{ return _iUIGraphicsContextDX; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEUIGraphicsContextDX* iOther)
	{
		if (_iUIGraphicsContextDX)
		{
			ICEUIGraphicsContextDX* tmp = _iUIGraphicsContextDX;
			_iUIGraphicsContextDX = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iUIGraphicsContextDX = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEUIGraphicsContextDX* detach()
	{
		ICEUIGraphicsContextDX* iIntf = _iUIGraphicsContextDX;
		_iUIGraphicsContextDX = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEUIGraphicsContextDX* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iUIGraphicsContextDX;
		if (_iUIGraphicsContextDX)
		{
			_iUIGraphicsContextDX->_vtbl->_addRef(_iUIGraphicsContextDX);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEUIGraphicsContextDX*() const	{ return _iUIGraphicsContextDX; }
	FORCEINLINE_WITHOUT_DEBUG ICEUIGraphicsContextDX& operator*() const	{ return *_iUIGraphicsContextDX; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iUIGraphicsContextDX == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEUIGraphicsContextDX* iOther) const	{ return (_iUIGraphicsContextDX != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEUIGraphicsContextDX* iOther) const	{ return (_iUIGraphicsContextDX == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEUIGraphicsContextDXRef& operator=(const CEComICEUIGraphicsContextDXRef& other)	{ return operator=(other._iUIGraphicsContextDX); }

	CEComICEUIGraphicsContextDXRef& operator=(const ICEUIGraphicsContextDX* iOther)
	{
		if (_iUIGraphicsContextDX != iOther)
		{
			if (_iUIGraphicsContextDX)
			{
				ICEUIGraphicsContextDX* tmp = _iUIGraphicsContextDX;
				_iUIGraphicsContextDX = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iUIGraphicsContextDX = const_cast<ICEUIGraphicsContextDX*>(iOther);
			if (_iUIGraphicsContextDX)
			{
				_iUIGraphicsContextDX->_vtbl->_addRef(_iUIGraphicsContextDX);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEUIGraphicsContextDX** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEUIGraphicsContextDXRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iUIGraphicsContextDX && "has a com object reference. clear first.");
		return & _iUIGraphicsContextDX; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEUIGraphicsContextDXRef& other)
	{
		bool result = false;
		if (_iUIGraphicsContextDX)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iUIGraphicsContextDX);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_queryInterface(_iUIGraphicsContextDX, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iUIGraphicsContextDX) { _iUIGraphicsContextDX->_vtbl->_addRef(_iUIGraphicsContextDX); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iUIGraphicsContextDX) { _iUIGraphicsContextDX->_vtbl->_release(_iUIGraphicsContextDX); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult saveState()	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_saveState(_iUIGraphicsContextDX) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult restoreState()	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_restoreState(_iUIGraphicsContextDX) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult translate(const CEPointBase* pt)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_translate(_iUIGraphicsContextDX, pt) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getColor(bool isBackground, CERGBColor *const colorOut)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_getColor(_iUIGraphicsContextDX, isBackground, colorOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setColor(bool isBackground, const CERGBColor* color)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_setColor(_iUIGraphicsContextDX, isBackground, color) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult draw(const CERect* destRect, const CERect* sourceRect, struct ICEUIGraphicsContext* iSrcContext)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_draw(_iUIGraphicsContextDX, destRect, sourceRect, iSrcContext) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawText(const CEPointBase* ptToDrawAt, struct ICEUString* iText)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_drawText(_iUIGraphicsContextDX, ptToDrawAt, iText) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawUTF16CHARArray(const CEPointBase* ptToDrawAt, const UTF16CHAR* charArray, UINT32 numOfChar, CEUIFontOption* pFontOptionRef)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_drawUTF16CHARArray(_iUIGraphicsContextDX, ptToDrawAt, charArray, numOfChar, pFontOptionRef) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawGlyph(const CEPointBase* ptToDrawAt, UINT32 glyphId)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_drawGlyph(_iUIGraphicsContextDX, ptToDrawAt, glyphId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult strokeGlyph(const CEPointBase* ptToDrawAt, UINT32 glyphId)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_strokeGlyph(_iUIGraphicsContextDX, ptToDrawAt, glyphId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawImage(const CERect* rectDest, struct ICEUIImage* iImage)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_drawImage(_iUIGraphicsContextDX, rectDest, iImage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawCompressedImage(const CERect* rectDest, struct ICECompressedImage* iImage)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_drawCompressedImage(_iUIGraphicsContextDX, rectDest, iImage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawRect(const CERect* boxRect, bool fill, CELineStyle style)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_drawRect(_iUIGraphicsContextDX, boxRect, fill, style) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawOval(const CERect* boxRect, bool fill, CELineStyle style)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_drawOval(_iUIGraphicsContextDX, boxRect, fill, style) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawRoundRect(const CERect* boxRect, INT32 arcWidth, INT32 arcHeight, bool fill)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_drawRoundRect(_iUIGraphicsContextDX, boxRect, arcWidth, arcHeight, fill) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawLine(const CEPointBase* pt1, const CEPointBase* pt2, CELineStyle style)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_drawLine(_iUIGraphicsContextDX, pt1, pt2, style) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawPolygon(const CEPointBase* points, UINT32 count, bool fill, CELineStyle style)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_drawPolygon(_iUIGraphicsContextDX, points, count, fill, style) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult clearRect(const CERect* rect, bool isBase)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_clearRect(_iUIGraphicsContextDX, rect, isBase) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult fillRectWithTexture(const CERect* pDstRect, struct ICEUIImage* iImage, const CEPointBase* pTexCoord)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_fillRectWithTexture(_iUIGraphicsContextDX, pDstRect, iImage, pTexCoord) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult fillRectWithCompressedTexture(const CERect* pDstRect, struct ICECompressedImage* iImage, const CEPointBase* pTexCoord)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_fillRectWithCompressedTexture(_iUIGraphicsContextDX, pDstRect, iImage, pTexCoord) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getClipRect(CERect *const rectOut)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_getClipRect(_iUIGraphicsContextDX, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setClipRect(const CERect* rect)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_setClipRect(_iUIGraphicsContextDX, rect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTextExtent(struct ICEUString* str, CEDim *const dimOut)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_getTextExtent(_iUIGraphicsContextDX, str, dimOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getFont(struct ICEUIFont* *const iFontOut)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_getFont(_iUIGraphicsContextDX, iFontOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFont(struct ICEUIFont* iFont)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_setFont(_iUIGraphicsContextDX, iFont) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setOpacity(float opacity)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_setOpacity(_iUIGraphicsContextDX, opacity) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getOpacity(float *const opacityOut)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_getOpacity(_iUIGraphicsContextDX, opacityOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawArc(CERect* boxRect, int startAngle, int arcAngle, bool fill)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_drawArc(_iUIGraphicsContextDX, boxRect, startAngle, arcAngle, fill) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setIntersectClipRect(const CERect* rect)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_setIntersectClipRect(_iUIGraphicsContextDX, rect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setIsLWTranslationEnabled(bool bEnable, CEPointBase *const pOptCtRef)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_setIsLWTranslationEnabled(_iUIGraphicsContextDX, bEnable, pOptCtRef) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDXImage(struct ICEDXContext2D* *const iCtx2D)	{ return _iUIGraphicsContextDX ? _iUIGraphicsContextDX->_vtbl->_getDXImage(_iUIGraphicsContextDX, iCtx2D) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEUIGraphicsContextDX* _iUIGraphicsContextDX;
};

/*! @}
 * end of CEComICEUIGraphicsContextDXRef
 */

#endif // __cplusplus

#endif
