///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEJSPrivilegeSSObjectDeclarer_h
#define ICEJSPrivilegeSSObjectDeclarer_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
	CEJSPrivilegeSSObjectAttr_None = 0,
	CEJSPrivilegeSSObjectAttr_ReadOnly = 1<<0
} CEJSPrivilegeSSObjectAttr;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEJSPrivilegeSSObjectDeclarer ICEJSPrivilegeSSObjectDeclarer
 * @{
 */

/*!
 * ID of ICEJSPrivilegeSSObjectDeclarer
 */
#define CEComIID_ICEJSPrivilegeSSObjectDeclarer 0x30fb0463


/*!
 * ICEJSPrivilegeSSObjectDeclarer
 */
typedef struct ICEJSPrivilegeSSObjectDeclarer
{
	const struct ICEJSPrivilegeSSObjectDeclarer_vtbl* _vtbl;
} ICEJSPrivilegeSSObjectDeclarer;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iJSPrivilegeSSObjectDeclarer	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEJSPrivilegeSSObjectDeclarer_queryInterface) (ICEJSPrivilegeSSObjectDeclarer* iJSPrivilegeSSObjectDeclarer, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSPrivilegeSSObjectDeclarer_addRef) (ICEJSPrivilegeSSObjectDeclarer* iJSPrivilegeSSObjectDeclarer);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSPrivilegeSSObjectDeclarer_release) (ICEJSPrivilegeSSObjectDeclarer* iJSPrivilegeSSObjectDeclarer);

typedef CEHResult (*iCEJSPrivilegeSSObjectDeclarer_declareObject) (ICEJSPrivilegeSSObjectDeclarer* iJSPrivilegeSSObjectDeclarer, INT32 classId, const UTF16CHAR* pObjectName, UINT32 numOfChars16, UINT32 attr);

/*!
 * V-table of ICEJSPrivilegeSSObjectDeclarer
 */
struct ICEJSPrivilegeSSObjectDeclarer_vtbl
{
	iCEJSPrivilegeSSObjectDeclarer_queryInterface	_queryInterface;	//!< Query interface.
	iCEJSPrivilegeSSObjectDeclarer_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEJSPrivilegeSSObjectDeclarer_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEJSPrivilegeSSObjectDeclarer_declareObject	_declareObject;
};

/*! @}
 * end of ICEJSPrivilegeSSObjectDeclarer
 */

/*! \defgroup ICEJSPrivilegeSSObjectParent ICEJSPrivilegeSSObjectParent
 * @{
 */

/*!
 * ID of ICEJSPrivilegeSSObjectParent
 */
#define CEComIID_ICEJSPrivilegeSSObjectParent 0x96e8d0dd


/*!
 * ICEJSPrivilegeSSObjectParent
 */
typedef struct ICEJSPrivilegeSSObjectParent
{
	const struct ICEJSPrivilegeSSObjectParent_vtbl* _vtbl;
} ICEJSPrivilegeSSObjectParent;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iJSPrivilegeSSObjectParent	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEJSPrivilegeSSObjectParent_queryInterface) (ICEJSPrivilegeSSObjectParent* iJSPrivilegeSSObjectParent, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSPrivilegeSSObjectParent_addRef) (ICEJSPrivilegeSSObjectParent* iJSPrivilegeSSObjectParent);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSPrivilegeSSObjectParent_release) (ICEJSPrivilegeSSObjectParent* iJSPrivilegeSSObjectParent);

typedef CEHResult (*iCEJSPrivilegeSSObjectParent_declareChildObject) (ICEJSPrivilegeSSObjectParent* iJSPrivilegeSSObjectParent, INT32 classId, const UTF16CHAR* pObjectName, UINT32 numOfChars16, const char* childObject, UINT32 attr);

/*!
 * V-table of ICEJSPrivilegeSSObjectParent
 */
struct ICEJSPrivilegeSSObjectParent_vtbl
{
	iCEJSPrivilegeSSObjectParent_queryInterface	_queryInterface;	//!< Query interface.
	iCEJSPrivilegeSSObjectParent_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEJSPrivilegeSSObjectParent_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEJSPrivilegeSSObjectParent_declareChildObject	_declareChildObject;
};

/*! @}
 * end of ICEJSPrivilegeSSObjectParent
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEJSPrivilegeSSObjectDeclarerRef CEComICEJSPrivilegeSSObjectDeclarerRef
 * @{
 */

class CEComICEJSPrivilegeSSObjectDeclarerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEJSPrivilegeSSObjectDeclarerRef() : _iJSPrivilegeSSObjectDeclarer(0) {}
	CEComICEJSPrivilegeSSObjectDeclarerRef(ICEJSPrivilegeSSObjectDeclarer* iOther) : _iJSPrivilegeSSObjectDeclarer(0)
	{
		if (iOther)
		{
			_iJSPrivilegeSSObjectDeclarer = iOther;
			_iJSPrivilegeSSObjectDeclarer->_vtbl->_addRef(_iJSPrivilegeSSObjectDeclarer);
		}
	}

	CEComICEJSPrivilegeSSObjectDeclarerRef(const CEComICEJSPrivilegeSSObjectDeclarerRef& other) : _iJSPrivilegeSSObjectDeclarer(0)
	{
		if (other._iJSPrivilegeSSObjectDeclarer)
		{
			_iJSPrivilegeSSObjectDeclarer = other._iJSPrivilegeSSObjectDeclarer;
			_iJSPrivilegeSSObjectDeclarer->_vtbl->_addRef(_iJSPrivilegeSSObjectDeclarer);
		}
	}

	~CEComICEJSPrivilegeSSObjectDeclarerRef()
	{
		if (_iJSPrivilegeSSObjectDeclarer)
		{
			ICEJSPrivilegeSSObjectDeclarer* tmp = _iJSPrivilegeSSObjectDeclarer;
			_iJSPrivilegeSSObjectDeclarer = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEJSPrivilegeSSObjectDeclarer* iJSPrivilegeSSObjectDeclarer;
				void* _ptr;
			} uIntf;
			uIntf.iJSPrivilegeSSObjectDeclarer = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEJSPrivilegeSSObjectDeclarer, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iJSPrivilegeSSObjectDeclarer)
				{
					ICEJSPrivilegeSSObjectDeclarer* tmp = _iJSPrivilegeSSObjectDeclarer;
					_iJSPrivilegeSSObjectDeclarer = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iJSPrivilegeSSObjectDeclarer = uIntf.iJSPrivilegeSSObjectDeclarer;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeSSObjectDeclarer* object() const	{ return _iJSPrivilegeSSObjectDeclarer; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEJSPrivilegeSSObjectDeclarer* iOther)
	{
		if (_iJSPrivilegeSSObjectDeclarer)
		{
			ICEJSPrivilegeSSObjectDeclarer* tmp = _iJSPrivilegeSSObjectDeclarer;
			_iJSPrivilegeSSObjectDeclarer = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iJSPrivilegeSSObjectDeclarer = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEJSPrivilegeSSObjectDeclarer* detach()
	{
		ICEJSPrivilegeSSObjectDeclarer* iIntf = _iJSPrivilegeSSObjectDeclarer;
		_iJSPrivilegeSSObjectDeclarer = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEJSPrivilegeSSObjectDeclarer* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iJSPrivilegeSSObjectDeclarer;
		if (_iJSPrivilegeSSObjectDeclarer)
		{
			_iJSPrivilegeSSObjectDeclarer->_vtbl->_addRef(_iJSPrivilegeSSObjectDeclarer);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEJSPrivilegeSSObjectDeclarer*() const	{ return _iJSPrivilegeSSObjectDeclarer; }
	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeSSObjectDeclarer& operator*() const	{ return *_iJSPrivilegeSSObjectDeclarer; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iJSPrivilegeSSObjectDeclarer == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEJSPrivilegeSSObjectDeclarer* iOther) const	{ return (_iJSPrivilegeSSObjectDeclarer != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEJSPrivilegeSSObjectDeclarer* iOther) const	{ return (_iJSPrivilegeSSObjectDeclarer == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEJSPrivilegeSSObjectDeclarerRef& operator=(const CEComICEJSPrivilegeSSObjectDeclarerRef& other)	{ return operator=(other._iJSPrivilegeSSObjectDeclarer); }

	CEComICEJSPrivilegeSSObjectDeclarerRef& operator=(const ICEJSPrivilegeSSObjectDeclarer* iOther)
	{
		if (_iJSPrivilegeSSObjectDeclarer != iOther)
		{
			if (_iJSPrivilegeSSObjectDeclarer)
			{
				ICEJSPrivilegeSSObjectDeclarer* tmp = _iJSPrivilegeSSObjectDeclarer;
				_iJSPrivilegeSSObjectDeclarer = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iJSPrivilegeSSObjectDeclarer = const_cast<ICEJSPrivilegeSSObjectDeclarer*>(iOther);
			if (_iJSPrivilegeSSObjectDeclarer)
			{
				_iJSPrivilegeSSObjectDeclarer->_vtbl->_addRef(_iJSPrivilegeSSObjectDeclarer);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeSSObjectDeclarer** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEJSPrivilegeSSObjectDeclarerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iJSPrivilegeSSObjectDeclarer && "has a com object reference. clear first.");
		return & _iJSPrivilegeSSObjectDeclarer; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEJSPrivilegeSSObjectDeclarerRef& other)
	{
		bool result = false;
		if (_iJSPrivilegeSSObjectDeclarer)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iJSPrivilegeSSObjectDeclarer);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iJSPrivilegeSSObjectDeclarer ? _iJSPrivilegeSSObjectDeclarer->_vtbl->_queryInterface(_iJSPrivilegeSSObjectDeclarer, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iJSPrivilegeSSObjectDeclarer) { _iJSPrivilegeSSObjectDeclarer->_vtbl->_addRef(_iJSPrivilegeSSObjectDeclarer); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iJSPrivilegeSSObjectDeclarer) { _iJSPrivilegeSSObjectDeclarer->_vtbl->_release(_iJSPrivilegeSSObjectDeclarer); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult declareObject(INT32 classId, const UTF16CHAR* pObjectName, UINT32 numOfChars16, UINT32 attr)	{ return _iJSPrivilegeSSObjectDeclarer ? _iJSPrivilegeSSObjectDeclarer->_vtbl->_declareObject(_iJSPrivilegeSSObjectDeclarer, classId, pObjectName, numOfChars16, attr) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEJSPrivilegeSSObjectDeclarer* _iJSPrivilegeSSObjectDeclarer;
};

/*! @}
 * end of CEComICEJSPrivilegeSSObjectDeclarerRef
 */

/*! \defgroup CEComICEJSPrivilegeSSObjectParentRef CEComICEJSPrivilegeSSObjectParentRef
 * @{
 */

class CEComICEJSPrivilegeSSObjectParentRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEJSPrivilegeSSObjectParentRef() : _iJSPrivilegeSSObjectParent(0) {}
	CEComICEJSPrivilegeSSObjectParentRef(ICEJSPrivilegeSSObjectParent* iOther) : _iJSPrivilegeSSObjectParent(0)
	{
		if (iOther)
		{
			_iJSPrivilegeSSObjectParent = iOther;
			_iJSPrivilegeSSObjectParent->_vtbl->_addRef(_iJSPrivilegeSSObjectParent);
		}
	}

	CEComICEJSPrivilegeSSObjectParentRef(const CEComICEJSPrivilegeSSObjectParentRef& other) : _iJSPrivilegeSSObjectParent(0)
	{
		if (other._iJSPrivilegeSSObjectParent)
		{
			_iJSPrivilegeSSObjectParent = other._iJSPrivilegeSSObjectParent;
			_iJSPrivilegeSSObjectParent->_vtbl->_addRef(_iJSPrivilegeSSObjectParent);
		}
	}

	~CEComICEJSPrivilegeSSObjectParentRef()
	{
		if (_iJSPrivilegeSSObjectParent)
		{
			ICEJSPrivilegeSSObjectParent* tmp = _iJSPrivilegeSSObjectParent;
			_iJSPrivilegeSSObjectParent = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEJSPrivilegeSSObjectParent* iJSPrivilegeSSObjectParent;
				void* _ptr;
			} uIntf;
			uIntf.iJSPrivilegeSSObjectParent = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEJSPrivilegeSSObjectParent, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iJSPrivilegeSSObjectParent)
				{
					ICEJSPrivilegeSSObjectParent* tmp = _iJSPrivilegeSSObjectParent;
					_iJSPrivilegeSSObjectParent = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iJSPrivilegeSSObjectParent = uIntf.iJSPrivilegeSSObjectParent;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeSSObjectParent* object() const	{ return _iJSPrivilegeSSObjectParent; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEJSPrivilegeSSObjectParent* iOther)
	{
		if (_iJSPrivilegeSSObjectParent)
		{
			ICEJSPrivilegeSSObjectParent* tmp = _iJSPrivilegeSSObjectParent;
			_iJSPrivilegeSSObjectParent = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iJSPrivilegeSSObjectParent = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEJSPrivilegeSSObjectParent* detach()
	{
		ICEJSPrivilegeSSObjectParent* iIntf = _iJSPrivilegeSSObjectParent;
		_iJSPrivilegeSSObjectParent = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEJSPrivilegeSSObjectParent* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iJSPrivilegeSSObjectParent;
		if (_iJSPrivilegeSSObjectParent)
		{
			_iJSPrivilegeSSObjectParent->_vtbl->_addRef(_iJSPrivilegeSSObjectParent);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEJSPrivilegeSSObjectParent*() const	{ return _iJSPrivilegeSSObjectParent; }
	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeSSObjectParent& operator*() const	{ return *_iJSPrivilegeSSObjectParent; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iJSPrivilegeSSObjectParent == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEJSPrivilegeSSObjectParent* iOther) const	{ return (_iJSPrivilegeSSObjectParent != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEJSPrivilegeSSObjectParent* iOther) const	{ return (_iJSPrivilegeSSObjectParent == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEJSPrivilegeSSObjectParentRef& operator=(const CEComICEJSPrivilegeSSObjectParentRef& other)	{ return operator=(other._iJSPrivilegeSSObjectParent); }

	CEComICEJSPrivilegeSSObjectParentRef& operator=(const ICEJSPrivilegeSSObjectParent* iOther)
	{
		if (_iJSPrivilegeSSObjectParent != iOther)
		{
			if (_iJSPrivilegeSSObjectParent)
			{
				ICEJSPrivilegeSSObjectParent* tmp = _iJSPrivilegeSSObjectParent;
				_iJSPrivilegeSSObjectParent = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iJSPrivilegeSSObjectParent = const_cast<ICEJSPrivilegeSSObjectParent*>(iOther);
			if (_iJSPrivilegeSSObjectParent)
			{
				_iJSPrivilegeSSObjectParent->_vtbl->_addRef(_iJSPrivilegeSSObjectParent);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeSSObjectParent** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEJSPrivilegeSSObjectParentRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iJSPrivilegeSSObjectParent && "has a com object reference. clear first.");
		return & _iJSPrivilegeSSObjectParent; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEJSPrivilegeSSObjectParentRef& other)
	{
		bool result = false;
		if (_iJSPrivilegeSSObjectParent)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iJSPrivilegeSSObjectParent);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iJSPrivilegeSSObjectParent ? _iJSPrivilegeSSObjectParent->_vtbl->_queryInterface(_iJSPrivilegeSSObjectParent, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iJSPrivilegeSSObjectParent) { _iJSPrivilegeSSObjectParent->_vtbl->_addRef(_iJSPrivilegeSSObjectParent); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iJSPrivilegeSSObjectParent) { _iJSPrivilegeSSObjectParent->_vtbl->_release(_iJSPrivilegeSSObjectParent); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult declareChildObject(INT32 classId, const UTF16CHAR* pObjectName, UINT32 numOfChars16, const char* childObject, UINT32 attr)	{ return _iJSPrivilegeSSObjectParent ? _iJSPrivilegeSSObjectParent->_vtbl->_declareChildObject(_iJSPrivilegeSSObjectParent, classId, pObjectName, numOfChars16, childObject, attr) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEJSPrivilegeSSObjectParent* _iJSPrivilegeSSObjectParent;
};

/*! @}
 * end of CEComICEJSPrivilegeSSObjectParentRef
 */

#endif // __cplusplus

#endif
