///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2005,2006,2008 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#if !defined(_ICEI18NSUPPORT_H_)
#define _ICEI18NSUPPORT_H_

// TODO: generate like this factory methods from idl or ccd.
#include "CECom.h"
#include "ICEI18n.h"
#include "ICETextSupport.h"

#define CEI18n_C_NBSP  0x00a0				//160
#define CEI18n_C_OBJECT_REPLACEMENT 0xfffc

inline bool IS_SPACE(UTF32CHAR u)
{
  return ((u) == 0x0020 || (u) == 0x0009 || (u) == 0x000a || (u) == 0x000d || (u)==0x200b);
}

inline bool IS_CJK(UTF32CHAR u)
{
  return ( (0x1100 <= (u)) &&       // speedup judgement for western char
           ( ((u) <= 0x11ff) ||     // jamo  1100 ~ 11ff
             (0x2e80 <= (u) && (u) <= 0xd7ff) ||  // kana & kanji, 
             (0xf900 <= (u) && (u) <= 0xfaff) ||  // cjk compatibility
             (0xff00 <= (u) && (u) <= 0xfffd) ) );  // half/full width forms
}

inline bool IS_KIND_OF_SPACE(UTF32CHAR c32)
{
	bool bIsSpace = false;
	if (c32 > 0xffff) bIsSpace = false;
	else 
	{ 
		bIsSpace = true; 
		switch(c32 & 0xffff)
		{
		case 0x0009:
			break;
		case 0x000A:
		case 0x00A0:
		case 0x000D:
		case 0x0020:
			break;
		case 0x200B:  
		case 0x0000:  
			break;
		case 0x3000:
			break;
		case 0xFEFF:
			break;
		case 0x2028: //LineSeparator    
		case 0xFFFC: //ObjectSubstitute
		case 0x202A: //LRE
		case 0x202B: //RLE
		case 0x202D: //LRO
		case 0x202E: //RLO
		case 0x202C: //PDF
			break;
		default: 
			bIsSpace = false; 
			break; 
		}
	}
	return bIsSpace;
}


typedef enum
{
	eCEI18NCharType_Space,
	eCEI18NCharType_CJK,
	eCEI18NCharType_NBSP,
	eCEI18NCharType_KindOfSpace,		// tab, space, nbsp
} eCEI18NCharType;

inline bool CEI18n_isCharOfType(eCEI18NCharType type, UTF32CHAR c)
{
	bool result = false;
	switch (type)
	{
	case eCEI18NCharType_Space:
		result = IS_SPACE(c);
		break;
	case eCEI18NCharType_CJK:
		result = IS_CJK(c);
		break;
	case eCEI18NCharType_NBSP:
		result = (c == CEI18n_C_NBSP);
		break;
	case eCEI18NCharType_KindOfSpace:
		result = IS_KIND_OF_SPACE(c);
		break;
	}
	return result;
}

#define ICEI18N_RESOURCE_CHARSET_ENCODING_CATEGORY   "cei18n_charset_encoding.displayName"
#define ICEI18N_RESOURCE_CHARSET_DETECTOR_CATEGORY   "cei18_charset_detector.displayName"
#define ICEI18N_RESOURCE_LOCALE_LANG_CATEGORY   "cei18n_locale_lang.displayName"
#define ICEI18N_RESOURCE_LOCALE_COUNTRY_CATEGORY   "cei18n_locale_coutry.displayName"

#define ICEI18N_CHARSET_ENCODING_ID_IANA_MIBENUM(_i32) ( (eCEI18nIanaMIBEnum)(_i32 < eCEI18nIanaMIBEnum_reserved ? _i32 : eCEI18nIanaMIBEnum_other))
#define ICEI18N_CHARSET_ENCODING_MAKE_ID(_i32) (_i32 + eCEI18nIanaMIBEnum_reserved)

/*
inline CEHResult ICEI18nCharsetDetectorCreate(UINT32 clsid, CEComICEI18nCharsetDetectorRef& refOut)
{
	refOut = 0;
	CEComICEClassFactoryRef cfRef;

	CEHResult hr = CEComGetClassObject(clsid, CEComIID_ICEClassFactory, (void**)&cfRef);
	if ( CESucceeded(hr) )
	{
		refOut = 0;
		hr = cfRef.createInstance(0, CEComIID_ICEI18nCharsetDetector, (void**)&refOut);
	}
	return hr;
}

*/

inline CEHResult ICEI18nUnicodeDecoderCreate(const char* ianaName, CEComICEI18nUnicodeDecoderRef& refOut)
{
	refOut = 0;
	CEComICEI18nClassFactoryRef cfRef;

	CEHResult hr = CEComGetClassObject(CEComStdClassID_CEI18nClassFactory, CEComIID_ICEI18nClassFactory, (void**)&cfRef);
	if ( CESucceeded(hr) )
	{
		refOut = 0;
		CEComICEI18nCharsetEncodingRef enc;
		hr = cfRef.getCharsetEncodingFromIanaCStringLiteral(ianaName, &enc);
		if ( CESucceeded(hr) )
		{
			CEASSERT(enc);
			hr = enc.getUnicodeDecoder(&refOut);
		}
	}
	return hr;
}

inline CEHResult ICEI18nUnicodeEncoderCreate(const char* ianaName, CEComICEI18nUnicodeEncoderRef& refOut)
{
	refOut = 0;
	CEComICEI18nClassFactoryRef cfRef;

	CEHResult hr = CEComGetClassObject(CEComStdClassID_CEI18nClassFactory, CEComIID_ICEI18nClassFactory, (void**)&cfRef);
	if ( CESucceeded(hr) )
	{
		refOut = 0;
		CEComICEI18nCharsetEncodingRef enc;
		hr = cfRef.getCharsetEncodingFromIanaCStringLiteral(ianaName, &enc);
		if ( CESucceeded(hr) )
		{
			CEASSERT(enc);
			hr = enc.getUnicodeEncoder(&refOut);
		}
	}
	return hr;
}


inline CEHResult ICEI18nClassFactoryCreate(UINT32 clsid, CEComICEI18nClassFactoryRef& refOut)
{
	refOut = 0;
	
	CEHResult hr = CEComGetClassObject(clsid, CEComIID_ICEI18nClassFactory, (void**)&refOut);
	return hr;
}

inline CEHResult ICEI18nLocaleCreateFromLanguageTagCStringLiteral(const char* languageTag, ICEI18nLocale* *const i18nLocaleOut)
{
	CEComICEI18nClassFactoryRef cf;
	CEHResult hr = ICEI18nClassFactoryCreate(CEComStdClassID_CEI18nClassFactory, cf);
	if ( CESucceeded(hr) )
	{
		hr = cf.getLocaleFromLanguageTagCStringLiteral(languageTag, i18nLocaleOut);
	}
	return hr;
}

inline CEHResult ICEI18nLocaleCreateFromLanguageTagUTF16Array(const UTF16CHAR* languageTag16, UINT32 numOfLangTagChars16, ICEI18nLocale* *const i18nLocaleOut)
{
	CEComICEI18nClassFactoryRef cf;
	CEHResult hr = ICEI18nClassFactoryCreate(CEComStdClassID_CEI18nClassFactory, cf);
	if ( CESucceeded(hr) )
	{
		hr = cf.getLocaleFromLanguageTagUtf16Array(languageTag16, numOfLangTagChars16, i18nLocaleOut);
	}
	return hr;
}

inline CEHResult ICEI18nNormalizeCharsetEncodingIanaName(ICEUString* src, ICEUString* *const normalizedOut)
{
	CEU_VALIDATE_PTR(src);
	CEU_VALIDATE_OUTPTR(normalizedOut);

	CEComICEUStringReaderRef in;
	CEHResult hr = ICEUStringReaderCreate(CEComStdClassID_CEUStringReader, in);
	if ( CESucceeded(hr) )
	{
		hr = in.open(src);
		if ( CESucceeded(hr) )
		{
			CEComICEUStringWriterRef out;
			hr = ICEUStringWriterCreate(CEComStdClassID_CEUStringWriter, out);
			if ( CESucceeded(hr) )
			{
				hr = out.open();
				if ( CESucceeded(hr) )
				{
					UTF32CHAR c32;
					bool bEof=false;
					while ( CESucceeded(hr = in.eof(&bEof)) && !bEof )
					{
						hr = in.read(&c32);
						if ( CESucceeded(hr) )
						{
							UINT32 bytes = 0;
							hr = out.writeUTF32(CEUCharacter_toLower(c32), &bytes);
							CEU_UNUSED(bytes);
						}
					}
					hr = out.close(normalizedOut);
				}
			}
		}
	}
	return hr;
}

inline CEHResult ICEI18nNormalizeCharsetEncodingIanaName(const char* nullTerminatedSrc, ICEUString* *const normalizedOut)
{
	CEU_VALIDATE_PTR(nullTerminatedSrc);
	CEU_VALIDATE_OUTPTR(normalizedOut);
	
	CEComICEUStringWriterRef out;
	CEHResult hr = ICEUStringWriterCreate(CEComStdClassID_CEUStringWriter, out);
	if ( CESucceeded(hr) )
	{
		hr = out.open();
		if ( CESucceeded(hr) )
		{
			while ( *nullTerminatedSrc )
			{
				UINT32 bytes = 0;
				hr = out.writeUTF32(CEUCharacter_toLower(*nullTerminatedSrc), &bytes);
				CEU_UNUSED(bytes);
				nullTerminatedSrc++;
			}
			hr = out.close(normalizedOut);
		}
	}
	return hr;
}

inline CEHResult ICEI18nNormalizeIsoLang(const UTF16CHAR* isoLang, UINT32 numOfisoLangChars16, ICEUString* *const iStrOut)
{
	CEU_VALIDATE_PTR(isoLang);
	CEU_VALIDATE_OUTPTR(iStrOut);

	UINT32 i=0;
	CEComICEUStringWriterRef out;
	CEHResult hr = ICEUStringWriterCreate(CEComStdClassID_CEUStringWriter, out);
	if ( CESucceeded(hr) )
	{
		hr = out.open();
		if ( CESucceeded(hr) )
		{
			for ( i=0; CESucceeded(hr) && i<numOfisoLangChars16; i++ )
			{
				UINT32 bytes=0;
				hr = out.writeUTF32(CEUCharacter_toLower(isoLang[i]), &bytes);
				CEU_UNUSED(bytes);
			}
			if ( CESucceeded(hr) )
			{
				hr = out.close(iStrOut);
			}
		}
	}
	return hr;
}

inline CEHResult ICEI18nNormalizeIsoCountry(const UTF16CHAR* isoCountry, UINT32 numOfisoCountryChars16, ICEUString* *const iStrOut)
{
	CEU_VALIDATE_PTR(isoCountry);
	CEU_VALIDATE_OUTPTR(iStrOut);

	UINT32 i=0;
	CEComICEUStringWriterRef out;
	CEHResult hr = ICEUStringWriterCreate(CEComStdClassID_CEUStringWriter, out);
	if ( CESucceeded(hr) )
	{
		hr = out.open();
		if ( CESucceeded(hr) )
		{
			for ( i=0; CESucceeded(hr) && i<numOfisoCountryChars16; i++ )
			{
				UINT32 bytes=0;
				hr = out.writeUTF32(CEUCharacter_toUpper(isoCountry[i]), &bytes);
				CEU_UNUSED(bytes);
			}
			if ( CESucceeded(hr) )
			{
				hr = out.close(iStrOut);
			}
		}
	}
	return hr;
}

inline bool ICEI18nCharsetEncoding_equals(const ICEI18nCharsetEncoding* iEnc1, const ICEI18nCharsetEncoding* iEnc2)
{

	bool b= (iEnc1 == iEnc2);
	if ( !b )
	{
		CEComICEI18nCharsetEncodingRef enc1(const_cast<ICEI18nCharsetEncoding*>(iEnc1));
		CEHResult hr = enc1.equals(const_cast<ICEI18nCharsetEncoding*>(iEnc2), &b);
		b = (CESucceeded(hr) && b);
	}
	return b;
}


#endif //#if !defined(_ICEI18NSUPPORT_H_)
