///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlScriptableProxy_h
#define ICEHtmlScriptableProxy_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEUString.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
	eCEHtmlDebugInfoType_unknown,
	eCEHtmlDebugInfoType_refURL,
	eCEHtmlDebugInfoType_mediaURL,
	eCEHtmlDebugInfoType_contentText,
} eCEHtmlDebugInfoType;

typedef enum
{
	eCEHtmlElementDebugInfoType_dom,
	eCEHtmlElementDebugInfoType_css,
	eCEHtmlElementDebugInfoType_internal
} eCEHtmlElementDebugInfoType;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

typedef struct CEHtmlDebugInfoProp
{
	eCEHtmlDebugInfoType	_eType;
	ICEUString*				_name;
	ICEUString*				_type;
	ICEUString*				_value;
} CEHtmlDebugInfoProp;

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlScriptableElementProxy ICEHtmlScriptableElementProxy
 * @{
 */

/*!
 * ID of ICEHtmlScriptableElementProxy
 */
#define CEComIID_ICEHtmlScriptableElementProxy 0x6c38d405


/*!
 * ICEHtmlScriptableElementProxy
 */
typedef struct ICEHtmlScriptableElementProxy
{
	const struct ICEHtmlScriptableElementProxy_vtbl* _vtbl;
} ICEHtmlScriptableElementProxy;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iScriptableElementProxy	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlScriptableElementProxy_queryInterface) (ICEHtmlScriptableElementProxy* iScriptableElementProxy, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlScriptableElementProxy_addRef) (ICEHtmlScriptableElementProxy* iScriptableElementProxy);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlScriptableElementProxy_release) (ICEHtmlScriptableElementProxy* iScriptableElementProxy);

typedef CEHResult (*iCEHtmlScriptableElementProxy_dbgSelect) (ICEHtmlScriptableElementProxy* iScriptableElementProxy);

typedef CEHResult (*iCEHtmlScriptableElementProxy_dumpDomTree) (ICEHtmlScriptableElementProxy* iScriptableElementProxy);

typedef CEHResult (*iCEHtmlScriptableElementProxy_dumpViewTree) (ICEHtmlScriptableElementProxy* iScriptableElementProxy);

typedef CEHResult (*iCEHtmlScriptableElementProxy_dumpSource) (ICEHtmlScriptableElementProxy* iScriptableElementProxy);

typedef CEHResult (*iCEHtmlScriptableElementProxy_dumpStyleSheet) (ICEHtmlScriptableElementProxy* iScriptableElementProxy);

typedef CEHResult (*iCEHtmlScriptableElementProxy_dumpWidgetTree) (ICEHtmlScriptableElementProxy* iScriptableElementProxy);

typedef CEHResult (*iCEHtmlScriptableElementProxy_dump) (ICEHtmlScriptableElementProxy* iScriptableElementProxy);

typedef CEHResult (*iCEHtmlScriptableElementProxy_dumpFontInfo) (ICEHtmlScriptableElementProxy* iScriptableElementProxy);

typedef CEHResult (*iCEHtmlScriptableElementProxy_dbgDump) (ICEHtmlScriptableElementProxy* iScriptableElementProxy, UTF32CHAR cmdC32, void** args, UINT32 numOfArgs, bool* bInvalidateWindowOut);

	//! Enumerats all children of this element.
	//! Specify bFirstChild to true to get the first child element of this element.
	//! ex...
	//!
	//! CEComICEHtmlScriptableElementProxyRef childProxy;
	//! CEHResult err = elmProxy.getNextChild(true, &childProxy);
	//! while ( err == JGSS_SUCCESS )
	//! {
	//!     CEComICEUStringRef elmStr;
	//!     // ex.. get string representation of childProxy.
	//!     err = childProxy.toString(&elmStr);
	//!     if ( !err ) 
	//!     {
	//!			// get next child
	//!			childProxy = 0;
	//!			err = elmProxy.getNextChild(false, &childProxy);
	//!     }
	//! }
	//!

typedef CEHResult (*iCEHtmlScriptableElementProxy_getNextChild) (ICEHtmlScriptableElementProxy* iScriptableElementProxy, bool bFirstChild, struct ICEHtmlScriptableElementProxy* *const iChildProxyOut);

	//! Enumerats all children of this element.
	//! Specify bFirstChild to true to get the first child element of this element.
	//! ex...
	//!
	//! CEHtmlDebugInfoProp infoProp;
	//! CEHResult err = elmProxy.getNextDebugInfo(eCEHtmlElementDebugInfoType_dom, true, &infoProp);
	//! while ( err == JGSS_SUCCESS )
	//! {
	//!     // ex.. show infoProp._name, infoProp._type, infoProp.value
	//!		
	//!		// get next info.
	//!     err = childProxy.getNextDebugInfo(eCEHtmlElementDebugInfoType_dom, false, &infoProp);
	//! }
	//!
	//!
	//! @param[in] resolveMode: specify one of "normal", "hover", "visited", "active".

typedef CEHResult (*iCEHtmlScriptableElementProxy_getNextDebugInfo) (ICEHtmlScriptableElementProxy* iScriptableElementProxy, eCEHtmlElementDebugInfoType infoType, bool bFirstProperty, CEHtmlDebugInfoProp* infoPropOut);

	//! returns string representation of this element.

typedef CEHResult (*iCEHtmlScriptableElementProxy_toString) (ICEHtmlScriptableElementProxy* iScriptableElementProxy, struct ICEUString* *const iStrOut);

	//! get specified javascript property of this element as string.

typedef CEHResult (*iCEHtmlScriptableElementProxy_getPropertyAsString) (ICEHtmlScriptableElementProxy* iScriptableElementProxy, struct ICEUString* propName, struct ICEUString* *const valueOut);

	//! set specified javascript property of this element with string.

typedef CEHResult (*iCEHtmlScriptableElementProxy_setPropertyWithString) (ICEHtmlScriptableElementProxy* iScriptableElementProxy, struct ICEUString* propName, struct ICEUString* value);

	//! return JGSS_SUCCESS: this proxy object is active. 

typedef CEHResult (*iCEHtmlScriptableElementProxy_isActive) (ICEHtmlScriptableElementProxy* iScriptableElementProxy);

	//! call dbgInspect().

typedef CEHResult (*iCEHtmlScriptableElementProxy_dbgInspect) (ICEHtmlScriptableElementProxy* iScriptableElementProxy);

/*!
 * V-table of ICEHtmlScriptableElementProxy
 */
struct ICEHtmlScriptableElementProxy_vtbl
{
	iCEHtmlScriptableElementProxy_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlScriptableElementProxy_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlScriptableElementProxy_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlScriptableElementProxy_dbgSelect	_dbgSelect;
	iCEHtmlScriptableElementProxy_dumpDomTree	_dumpDomTree;
	iCEHtmlScriptableElementProxy_dumpViewTree	_dumpViewTree;
	iCEHtmlScriptableElementProxy_dumpSource	_dumpSource;
	iCEHtmlScriptableElementProxy_dumpStyleSheet	_dumpStyleSheet;
	iCEHtmlScriptableElementProxy_dumpWidgetTree	_dumpWidgetTree;
	iCEHtmlScriptableElementProxy_dump	_dump;
	iCEHtmlScriptableElementProxy_dumpFontInfo	_dumpFontInfo;
	iCEHtmlScriptableElementProxy_dbgDump	_dbgDump;
	iCEHtmlScriptableElementProxy_getNextChild	_getNextChild;
	iCEHtmlScriptableElementProxy_getNextDebugInfo	_getNextDebugInfo;
	iCEHtmlScriptableElementProxy_toString	_toString;
	iCEHtmlScriptableElementProxy_getPropertyAsString	_getPropertyAsString;
	iCEHtmlScriptableElementProxy_setPropertyWithString	_setPropertyWithString;
	iCEHtmlScriptableElementProxy_isActive	_isActive;
	iCEHtmlScriptableElementProxy_dbgInspect	_dbgInspect;
};

/*! @}
 * end of ICEHtmlScriptableElementProxy
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlScriptableElementProxyRef CEComICEHtmlScriptableElementProxyRef
 * @{
 */

class CEComICEHtmlScriptableElementProxyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlScriptableElementProxyRef() : _iScriptableElementProxy(0) {}
	CEComICEHtmlScriptableElementProxyRef(ICEHtmlScriptableElementProxy* iOther) : _iScriptableElementProxy(0)
	{
		if (iOther)
		{
			_iScriptableElementProxy = iOther;
			_iScriptableElementProxy->_vtbl->_addRef(_iScriptableElementProxy);
		}
	}

	CEComICEHtmlScriptableElementProxyRef(const CEComICEHtmlScriptableElementProxyRef& other) : _iScriptableElementProxy(0)
	{
		if (other._iScriptableElementProxy)
		{
			_iScriptableElementProxy = other._iScriptableElementProxy;
			_iScriptableElementProxy->_vtbl->_addRef(_iScriptableElementProxy);
		}
	}

	~CEComICEHtmlScriptableElementProxyRef()
	{
		if (_iScriptableElementProxy)
		{
			ICEHtmlScriptableElementProxy* tmp = _iScriptableElementProxy;
			_iScriptableElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlScriptableElementProxy* iScriptableElementProxy;
				void* _ptr;
			} uIntf;
			uIntf.iScriptableElementProxy = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlScriptableElementProxy, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iScriptableElementProxy)
				{
					ICEHtmlScriptableElementProxy* tmp = _iScriptableElementProxy;
					_iScriptableElementProxy = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iScriptableElementProxy = uIntf.iScriptableElementProxy;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlScriptableElementProxy* object() const	{ return _iScriptableElementProxy; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlScriptableElementProxy* iOther)
	{
		if (_iScriptableElementProxy)
		{
			ICEHtmlScriptableElementProxy* tmp = _iScriptableElementProxy;
			_iScriptableElementProxy = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iScriptableElementProxy = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlScriptableElementProxy* detach()
	{
		ICEHtmlScriptableElementProxy* iIntf = _iScriptableElementProxy;
		_iScriptableElementProxy = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlScriptableElementProxy* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iScriptableElementProxy;
		if (_iScriptableElementProxy)
		{
			_iScriptableElementProxy->_vtbl->_addRef(_iScriptableElementProxy);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlScriptableElementProxy*() const	{ return _iScriptableElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlScriptableElementProxy& operator*() const	{ return *_iScriptableElementProxy; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iScriptableElementProxy == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlScriptableElementProxy* iOther) const	{ return (_iScriptableElementProxy != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlScriptableElementProxy* iOther) const	{ return (_iScriptableElementProxy == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlScriptableElementProxyRef& operator=(const CEComICEHtmlScriptableElementProxyRef& other)	{ return operator=(other._iScriptableElementProxy); }

	CEComICEHtmlScriptableElementProxyRef& operator=(const ICEHtmlScriptableElementProxy* iOther)
	{
		if (_iScriptableElementProxy != iOther)
		{
			if (_iScriptableElementProxy)
			{
				ICEHtmlScriptableElementProxy* tmp = _iScriptableElementProxy;
				_iScriptableElementProxy = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iScriptableElementProxy = const_cast<ICEHtmlScriptableElementProxy*>(iOther);
			if (_iScriptableElementProxy)
			{
				_iScriptableElementProxy->_vtbl->_addRef(_iScriptableElementProxy);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlScriptableElementProxy** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlScriptableElementProxyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iScriptableElementProxy && "has a com object reference. clear first.");
		return & _iScriptableElementProxy; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlScriptableElementProxyRef& other)
	{
		bool result = false;
		if (_iScriptableElementProxy)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iScriptableElementProxy);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_queryInterface(_iScriptableElementProxy, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iScriptableElementProxy) { _iScriptableElementProxy->_vtbl->_addRef(_iScriptableElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iScriptableElementProxy) { _iScriptableElementProxy->_vtbl->_release(_iScriptableElementProxy); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult dbgSelect()	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_dbgSelect(_iScriptableElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult dumpDomTree()	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_dumpDomTree(_iScriptableElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult dumpViewTree()	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_dumpViewTree(_iScriptableElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult dumpSource()	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_dumpSource(_iScriptableElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult dumpStyleSheet()	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_dumpStyleSheet(_iScriptableElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult dumpWidgetTree()	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_dumpWidgetTree(_iScriptableElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult dump()	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_dump(_iScriptableElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult dumpFontInfo()	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_dumpFontInfo(_iScriptableElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult dbgDump(UTF32CHAR cmdC32, void** args, UINT32 numOfArgs, bool* bInvalidateWindowOut)	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_dbgDump(_iScriptableElementProxy, cmdC32, args, numOfArgs, bInvalidateWindowOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getNextChild(bool bFirstChild, struct ICEHtmlScriptableElementProxy* *const iChildProxyOut)	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_getNextChild(_iScriptableElementProxy, bFirstChild, iChildProxyOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getNextDebugInfo(eCEHtmlElementDebugInfoType infoType, bool bFirstProperty, CEHtmlDebugInfoProp* infoPropOut)	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_getNextDebugInfo(_iScriptableElementProxy, infoType, bFirstProperty, infoPropOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult toString(struct ICEUString* *const iStrOut)	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_toString(_iScriptableElementProxy, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPropertyAsString(struct ICEUString* propName, struct ICEUString* *const valueOut)	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_getPropertyAsString(_iScriptableElementProxy, propName, valueOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setPropertyWithString(struct ICEUString* propName, struct ICEUString* value)	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_setPropertyWithString(_iScriptableElementProxy, propName, value) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isActive()	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_isActive(_iScriptableElementProxy) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult dbgInspect()	{ return _iScriptableElementProxy ? _iScriptableElementProxy->_vtbl->_dbgInspect(_iScriptableElementProxy) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlScriptableElementProxy* _iScriptableElementProxy;
};

/*! @}
 * end of CEComICEHtmlScriptableElementProxyRef
 */

#endif // __cplusplus

#endif
