///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlJavascriptDialogHandler_h
#define ICEHtmlJavascriptDialogHandler_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "CEUITypes.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlJavascriptDialogHandler ICEHtmlJavascriptDialogHandler
 * @{
 */

/*!
 * ID of ICEHtmlJavascriptDialogHandler
 */
#define CEComIID_ICEHtmlJavascriptDialogHandler 0x667b3ba8


/*!
 * ICEHtmlJavascriptDialogHandler
 */
typedef struct ICEHtmlJavascriptDialogHandler
{
	const struct ICEHtmlJavascriptDialogHandler_vtbl* _vtbl;
} ICEHtmlJavascriptDialogHandler;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iJavascriptDialogHandler	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlJavascriptDialogHandler_queryInterface) (ICEHtmlJavascriptDialogHandler* iJavascriptDialogHandler, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlJavascriptDialogHandler_addRef) (ICEHtmlJavascriptDialogHandler* iJavascriptDialogHandler);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlJavascriptDialogHandler_release) (ICEHtmlJavascriptDialogHandler* iJavascriptDialogHandler);

typedef CEHResult (*iCEHtmlJavascriptDialogHandler_alert) (ICEHtmlJavascriptDialogHandler* iJavascriptDialogHandler, struct ICEUString* iStrMessage);

typedef CEHResult (*iCEHtmlJavascriptDialogHandler_confirm) (ICEHtmlJavascriptDialogHandler* iJavascriptDialogHandler, struct ICEUString* iStrMessage, bool *const isOkOut);

typedef CEHResult (*iCEHtmlJavascriptDialogHandler_prompt) (ICEHtmlJavascriptDialogHandler* iJavascriptDialogHandler, struct ICEUString* iStrMessage, struct ICEUString* iStrDefaultValue, struct ICEUString* *const iStrOut);

/*!
 * V-table of ICEHtmlJavascriptDialogHandler
 */
struct ICEHtmlJavascriptDialogHandler_vtbl
{
	iCEHtmlJavascriptDialogHandler_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlJavascriptDialogHandler_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlJavascriptDialogHandler_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlJavascriptDialogHandler_alert	_alert;
	iCEHtmlJavascriptDialogHandler_confirm	_confirm;
	iCEHtmlJavascriptDialogHandler_prompt	_prompt;
};

/*! @}
 * end of ICEHtmlJavascriptDialogHandler
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlJavascriptDialogHandlerRef CEComICEHtmlJavascriptDialogHandlerRef
 * @{
 */

class CEComICEHtmlJavascriptDialogHandlerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlJavascriptDialogHandlerRef() : _iJavascriptDialogHandler(0) {}
	CEComICEHtmlJavascriptDialogHandlerRef(ICEHtmlJavascriptDialogHandler* iOther) : _iJavascriptDialogHandler(0)
	{
		if (iOther)
		{
			_iJavascriptDialogHandler = iOther;
			_iJavascriptDialogHandler->_vtbl->_addRef(_iJavascriptDialogHandler);
		}
	}

	CEComICEHtmlJavascriptDialogHandlerRef(const CEComICEHtmlJavascriptDialogHandlerRef& other) : _iJavascriptDialogHandler(0)
	{
		if (other._iJavascriptDialogHandler)
		{
			_iJavascriptDialogHandler = other._iJavascriptDialogHandler;
			_iJavascriptDialogHandler->_vtbl->_addRef(_iJavascriptDialogHandler);
		}
	}

	~CEComICEHtmlJavascriptDialogHandlerRef()
	{
		if (_iJavascriptDialogHandler)
		{
			ICEHtmlJavascriptDialogHandler* tmp = _iJavascriptDialogHandler;
			_iJavascriptDialogHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlJavascriptDialogHandler* iJavascriptDialogHandler;
				void* _ptr;
			} uIntf;
			uIntf.iJavascriptDialogHandler = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlJavascriptDialogHandler, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iJavascriptDialogHandler)
				{
					ICEHtmlJavascriptDialogHandler* tmp = _iJavascriptDialogHandler;
					_iJavascriptDialogHandler = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iJavascriptDialogHandler = uIntf.iJavascriptDialogHandler;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlJavascriptDialogHandler* object() const	{ return _iJavascriptDialogHandler; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlJavascriptDialogHandler* iOther)
	{
		if (_iJavascriptDialogHandler)
		{
			ICEHtmlJavascriptDialogHandler* tmp = _iJavascriptDialogHandler;
			_iJavascriptDialogHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iJavascriptDialogHandler = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlJavascriptDialogHandler* detach()
	{
		ICEHtmlJavascriptDialogHandler* iIntf = _iJavascriptDialogHandler;
		_iJavascriptDialogHandler = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlJavascriptDialogHandler* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iJavascriptDialogHandler;
		if (_iJavascriptDialogHandler)
		{
			_iJavascriptDialogHandler->_vtbl->_addRef(_iJavascriptDialogHandler);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlJavascriptDialogHandler*() const	{ return _iJavascriptDialogHandler; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlJavascriptDialogHandler& operator*() const	{ return *_iJavascriptDialogHandler; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iJavascriptDialogHandler == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlJavascriptDialogHandler* iOther) const	{ return (_iJavascriptDialogHandler != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlJavascriptDialogHandler* iOther) const	{ return (_iJavascriptDialogHandler == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlJavascriptDialogHandlerRef& operator=(const CEComICEHtmlJavascriptDialogHandlerRef& other)	{ return operator=(other._iJavascriptDialogHandler); }

	CEComICEHtmlJavascriptDialogHandlerRef& operator=(const ICEHtmlJavascriptDialogHandler* iOther)
	{
		if (_iJavascriptDialogHandler != iOther)
		{
			if (_iJavascriptDialogHandler)
			{
				ICEHtmlJavascriptDialogHandler* tmp = _iJavascriptDialogHandler;
				_iJavascriptDialogHandler = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iJavascriptDialogHandler = const_cast<ICEHtmlJavascriptDialogHandler*>(iOther);
			if (_iJavascriptDialogHandler)
			{
				_iJavascriptDialogHandler->_vtbl->_addRef(_iJavascriptDialogHandler);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlJavascriptDialogHandler** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlJavascriptDialogHandlerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iJavascriptDialogHandler && "has a com object reference. clear first.");
		return & _iJavascriptDialogHandler; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlJavascriptDialogHandlerRef& other)
	{
		bool result = false;
		if (_iJavascriptDialogHandler)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iJavascriptDialogHandler);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iJavascriptDialogHandler ? _iJavascriptDialogHandler->_vtbl->_queryInterface(_iJavascriptDialogHandler, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iJavascriptDialogHandler) { _iJavascriptDialogHandler->_vtbl->_addRef(_iJavascriptDialogHandler); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iJavascriptDialogHandler) { _iJavascriptDialogHandler->_vtbl->_release(_iJavascriptDialogHandler); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult alert(struct ICEUString* iStrMessage)	{ return _iJavascriptDialogHandler ? _iJavascriptDialogHandler->_vtbl->_alert(_iJavascriptDialogHandler, iStrMessage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult confirm(struct ICEUString* iStrMessage, bool *const isOkOut)	{ return _iJavascriptDialogHandler ? _iJavascriptDialogHandler->_vtbl->_confirm(_iJavascriptDialogHandler, iStrMessage, isOkOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult prompt(struct ICEUString* iStrMessage, struct ICEUString* iStrDefaultValue, struct ICEUString* *const iStrOut)	{ return _iJavascriptDialogHandler ? _iJavascriptDialogHandler->_vtbl->_prompt(_iJavascriptDialogHandler, iStrMessage, iStrDefaultValue, iStrOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlJavascriptDialogHandler* _iJavascriptDialogHandler;
};

/*! @}
 * end of CEComICEHtmlJavascriptDialogHandlerRef
 */

#endif // __cplusplus

#endif
