///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlHttpConfigHandler_h
#define ICEHtmlHttpConfigHandler_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlHttpConfigHandler ICEHtmlHttpConfigHandler
 * @{
 */

/*!
 * ID of ICEHtmlHttpConfigHandler
 */
#define CEComIID_ICEHtmlHttpConfigHandler 0x7cac77b1


/*!
 * ICEHtmlHttpConfigHandler
 */
typedef struct ICEHtmlHttpConfigHandler
{
	const struct ICEHtmlHttpConfigHandler_vtbl* _vtbl;
} ICEHtmlHttpConfigHandler;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iHttpConfigHandler	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlHttpConfigHandler_queryInterface) (ICEHtmlHttpConfigHandler* iHttpConfigHandler, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlHttpConfigHandler_addRef) (ICEHtmlHttpConfigHandler* iHttpConfigHandler);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlHttpConfigHandler_release) (ICEHtmlHttpConfigHandler* iHttpConfigHandler);

typedef CEHResult (*iCEHtmlHttpConfigHandler_getPlatformSpecificConfigHandler) (ICEHtmlHttpConfigHandler* iHttpConfigHandler, struct ICEHtmlPlatformSpecificConfig* *const config);

typedef CEHResult (*iCEHtmlHttpConfigHandler_handleSSLError) (ICEHtmlHttpConfigHandler* iHttpConfigHandler, UINT32 errorCodeIn);

typedef CEHResult (*iCEHtmlHttpConfigHandler_handleBlockingSSLError) (ICEHtmlHttpConfigHandler* iHttpConfigHandler, UINT32 errorCodeIn, bool* continueOut);

/*!
 * V-table of ICEHtmlHttpConfigHandler
 */
struct ICEHtmlHttpConfigHandler_vtbl
{
	iCEHtmlHttpConfigHandler_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlHttpConfigHandler_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlHttpConfigHandler_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlHttpConfigHandler_getPlatformSpecificConfigHandler	_getPlatformSpecificConfigHandler;
	iCEHtmlHttpConfigHandler_handleSSLError	_handleSSLError;
	iCEHtmlHttpConfigHandler_handleBlockingSSLError	_handleBlockingSSLError;
};

/*! @}
 * end of ICEHtmlHttpConfigHandler
 */

/*! \defgroup ICEHtmlPlatformSpecificConfig ICEHtmlPlatformSpecificConfig
 * @{
 */

/*!
 * ID of ICEHtmlPlatformSpecificConfig
 */
#define CEComIID_ICEHtmlPlatformSpecificConfig 0x131b7e5c

/*!
 * ICEHtmlPlatformSpecificConfig
 */
typedef struct ICEHtmlPlatformSpecificConfig
{
	const struct ICEHtmlPlatformSpecificConfig_vtbl* _vtbl;
} ICEHtmlPlatformSpecificConfig;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iPlatformSpecificConfig	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlPlatformSpecificConfig_queryInterface) (ICEHtmlPlatformSpecificConfig* iPlatformSpecificConfig, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlPlatformSpecificConfig_addRef) (ICEHtmlPlatformSpecificConfig* iPlatformSpecificConfig);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlPlatformSpecificConfig_release) (ICEHtmlPlatformSpecificConfig* iPlatformSpecificConfig);

typedef CEHResult (*iCEHtmlPlatformSpecificConfig_getHttpClientId) (ICEHtmlPlatformSpecificConfig* iPlatformSpecificConfig, void** id);

typedef CEHResult (*iCEHtmlPlatformSpecificConfig_getHttpClientIdConfigMask) (ICEHtmlPlatformSpecificConfig* iPlatformSpecificConfig, UINT32* mask);

typedef CEHResult (*iCEHtmlPlatformSpecificConfig_getCookieEnabled) (ICEHtmlPlatformSpecificConfig* iPlatformSpecificConfig, bool* enabledOut);

typedef CEHResult (*iCEHtmlPlatformSpecificConfig_getTrendMicroConfigFile) (ICEHtmlPlatformSpecificConfig* iPlatformSpecificConfig, UINT32 numOfFilePathCharsBuf, CHAR8* filePathCharsBufOut);

typedef CEHResult (*iCEHtmlPlatformSpecificConfig_getTrendMicroDeviceId) (ICEHtmlPlatformSpecificConfig* iPlatformSpecificConfig, UINT32 numOfDeviceIdCharsBuf, CHAR8* deviceIdCharsBufOut);

typedef CEHResult (*iCEHtmlPlatformSpecificConfig_getTrendMicroService) (ICEHtmlPlatformSpecificConfig* iPlatformSpecificConfig, INT32* serviceOut);

/*!
 * V-table of ICEHtmlPlatformSpecificConfig
 */
struct ICEHtmlPlatformSpecificConfig_vtbl
{
	iCEHtmlPlatformSpecificConfig_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlPlatformSpecificConfig_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlPlatformSpecificConfig_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlPlatformSpecificConfig_getHttpClientId	_getHttpClientId;
	iCEHtmlPlatformSpecificConfig_getHttpClientIdConfigMask	_getHttpClientIdConfigMask;
	iCEHtmlPlatformSpecificConfig_getCookieEnabled	_getCookieEnabled;
	iCEHtmlPlatformSpecificConfig_getTrendMicroConfigFile	_getTrendMicroConfigFile;
	iCEHtmlPlatformSpecificConfig_getTrendMicroDeviceId	_getTrendMicroDeviceId;
	iCEHtmlPlatformSpecificConfig_getTrendMicroService	_getTrendMicroService;
};

/*! @}
 * end of ICEHtmlPlatformSpecificConfig
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlHttpConfigHandlerRef CEComICEHtmlHttpConfigHandlerRef
 * @{
 */

class CEComICEHtmlHttpConfigHandlerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlHttpConfigHandlerRef() : _iHttpConfigHandler(0) {}
	CEComICEHtmlHttpConfigHandlerRef(ICEHtmlHttpConfigHandler* iOther) : _iHttpConfigHandler(0)
	{
		if (iOther)
		{
			_iHttpConfigHandler = iOther;
			_iHttpConfigHandler->_vtbl->_addRef(_iHttpConfigHandler);
		}
	}

	CEComICEHtmlHttpConfigHandlerRef(const CEComICEHtmlHttpConfigHandlerRef& other) : _iHttpConfigHandler(0)
	{
		if (other._iHttpConfigHandler)
		{
			_iHttpConfigHandler = other._iHttpConfigHandler;
			_iHttpConfigHandler->_vtbl->_addRef(_iHttpConfigHandler);
		}
	}

	~CEComICEHtmlHttpConfigHandlerRef()
	{
		if (_iHttpConfigHandler)
		{
			ICEHtmlHttpConfigHandler* tmp = _iHttpConfigHandler;
			_iHttpConfigHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlHttpConfigHandler* iHttpConfigHandler;
				void* _ptr;
			} uIntf;
			uIntf.iHttpConfigHandler = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlHttpConfigHandler, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iHttpConfigHandler)
				{
					ICEHtmlHttpConfigHandler* tmp = _iHttpConfigHandler;
					_iHttpConfigHandler = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iHttpConfigHandler = uIntf.iHttpConfigHandler;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlHttpConfigHandler* object() const	{ return _iHttpConfigHandler; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlHttpConfigHandler* iOther)
	{
		if (_iHttpConfigHandler)
		{
			ICEHtmlHttpConfigHandler* tmp = _iHttpConfigHandler;
			_iHttpConfigHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iHttpConfigHandler = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlHttpConfigHandler* detach()
	{
		ICEHtmlHttpConfigHandler* iIntf = _iHttpConfigHandler;
		_iHttpConfigHandler = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlHttpConfigHandler* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iHttpConfigHandler;
		if (_iHttpConfigHandler)
		{
			_iHttpConfigHandler->_vtbl->_addRef(_iHttpConfigHandler);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlHttpConfigHandler*() const	{ return _iHttpConfigHandler; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlHttpConfigHandler& operator*() const	{ return *_iHttpConfigHandler; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iHttpConfigHandler == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlHttpConfigHandler* iOther) const	{ return (_iHttpConfigHandler != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlHttpConfigHandler* iOther) const	{ return (_iHttpConfigHandler == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlHttpConfigHandlerRef& operator=(const CEComICEHtmlHttpConfigHandlerRef& other)	{ return operator=(other._iHttpConfigHandler); }

	CEComICEHtmlHttpConfigHandlerRef& operator=(const ICEHtmlHttpConfigHandler* iOther)
	{
		if (_iHttpConfigHandler != iOther)
		{
			if (_iHttpConfigHandler)
			{
				ICEHtmlHttpConfigHandler* tmp = _iHttpConfigHandler;
				_iHttpConfigHandler = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iHttpConfigHandler = const_cast<ICEHtmlHttpConfigHandler*>(iOther);
			if (_iHttpConfigHandler)
			{
				_iHttpConfigHandler->_vtbl->_addRef(_iHttpConfigHandler);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlHttpConfigHandler** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlHttpConfigHandlerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iHttpConfigHandler && "has a com object reference. clear first.");
		return & _iHttpConfigHandler; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlHttpConfigHandlerRef& other)
	{
		bool result = false;
		if (_iHttpConfigHandler)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iHttpConfigHandler);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iHttpConfigHandler ? _iHttpConfigHandler->_vtbl->_queryInterface(_iHttpConfigHandler, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iHttpConfigHandler) { _iHttpConfigHandler->_vtbl->_addRef(_iHttpConfigHandler); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iHttpConfigHandler) { _iHttpConfigHandler->_vtbl->_release(_iHttpConfigHandler); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPlatformSpecificConfigHandler(struct ICEHtmlPlatformSpecificConfig* *const config)	{ return _iHttpConfigHandler ? _iHttpConfigHandler->_vtbl->_getPlatformSpecificConfigHandler(_iHttpConfigHandler, config) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleSSLError(UINT32 errorCodeIn)	{ return _iHttpConfigHandler ? _iHttpConfigHandler->_vtbl->_handleSSLError(_iHttpConfigHandler, errorCodeIn) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleBlockingSSLError(UINT32 errorCodeIn, bool* continueOut)	{ return _iHttpConfigHandler ? _iHttpConfigHandler->_vtbl->_handleBlockingSSLError(_iHttpConfigHandler, errorCodeIn, continueOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlHttpConfigHandler* _iHttpConfigHandler;
};

/*! @}
 * end of CEComICEHtmlHttpConfigHandlerRef
 */

/*! \defgroup CEComICEHtmlPlatformSpecificConfigRef CEComICEHtmlPlatformSpecificConfigRef
 * @{
 */

class CEComICEHtmlPlatformSpecificConfigRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlPlatformSpecificConfigRef() : _iPlatformSpecificConfig(0) {}
	CEComICEHtmlPlatformSpecificConfigRef(ICEHtmlPlatformSpecificConfig* iOther) : _iPlatformSpecificConfig(0)
	{
		if (iOther)
		{
			_iPlatformSpecificConfig = iOther;
			_iPlatformSpecificConfig->_vtbl->_addRef(_iPlatformSpecificConfig);
		}
	}

	CEComICEHtmlPlatformSpecificConfigRef(const CEComICEHtmlPlatformSpecificConfigRef& other) : _iPlatformSpecificConfig(0)
	{
		if (other._iPlatformSpecificConfig)
		{
			_iPlatformSpecificConfig = other._iPlatformSpecificConfig;
			_iPlatformSpecificConfig->_vtbl->_addRef(_iPlatformSpecificConfig);
		}
	}

	~CEComICEHtmlPlatformSpecificConfigRef()
	{
		if (_iPlatformSpecificConfig)
		{
			ICEHtmlPlatformSpecificConfig* tmp = _iPlatformSpecificConfig;
			_iPlatformSpecificConfig = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlPlatformSpecificConfig* iPlatformSpecificConfig;
				void* _ptr;
			} uIntf;
			uIntf.iPlatformSpecificConfig = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlPlatformSpecificConfig, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iPlatformSpecificConfig)
				{
					ICEHtmlPlatformSpecificConfig* tmp = _iPlatformSpecificConfig;
					_iPlatformSpecificConfig = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iPlatformSpecificConfig = uIntf.iPlatformSpecificConfig;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPlatformSpecificConfig* object() const	{ return _iPlatformSpecificConfig; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlPlatformSpecificConfig* iOther)
	{
		if (_iPlatformSpecificConfig)
		{
			ICEHtmlPlatformSpecificConfig* tmp = _iPlatformSpecificConfig;
			_iPlatformSpecificConfig = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iPlatformSpecificConfig = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlPlatformSpecificConfig* detach()
	{
		ICEHtmlPlatformSpecificConfig* iIntf = _iPlatformSpecificConfig;
		_iPlatformSpecificConfig = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlPlatformSpecificConfig* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iPlatformSpecificConfig;
		if (_iPlatformSpecificConfig)
		{
			_iPlatformSpecificConfig->_vtbl->_addRef(_iPlatformSpecificConfig);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlPlatformSpecificConfig*() const	{ return _iPlatformSpecificConfig; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPlatformSpecificConfig& operator*() const	{ return *_iPlatformSpecificConfig; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iPlatformSpecificConfig == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlPlatformSpecificConfig* iOther) const	{ return (_iPlatformSpecificConfig != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlPlatformSpecificConfig* iOther) const	{ return (_iPlatformSpecificConfig == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlPlatformSpecificConfigRef& operator=(const CEComICEHtmlPlatformSpecificConfigRef& other)	{ return operator=(other._iPlatformSpecificConfig); }

	CEComICEHtmlPlatformSpecificConfigRef& operator=(const ICEHtmlPlatformSpecificConfig* iOther)
	{
		if (_iPlatformSpecificConfig != iOther)
		{
			if (_iPlatformSpecificConfig)
			{
				ICEHtmlPlatformSpecificConfig* tmp = _iPlatformSpecificConfig;
				_iPlatformSpecificConfig = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iPlatformSpecificConfig = const_cast<ICEHtmlPlatformSpecificConfig*>(iOther);
			if (_iPlatformSpecificConfig)
			{
				_iPlatformSpecificConfig->_vtbl->_addRef(_iPlatformSpecificConfig);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlPlatformSpecificConfig** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlPlatformSpecificConfigRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iPlatformSpecificConfig && "has a com object reference. clear first.");
		return & _iPlatformSpecificConfig; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlPlatformSpecificConfigRef& other)
	{
		bool result = false;
		if (_iPlatformSpecificConfig)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iPlatformSpecificConfig);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iPlatformSpecificConfig ? _iPlatformSpecificConfig->_vtbl->_queryInterface(_iPlatformSpecificConfig, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iPlatformSpecificConfig) { _iPlatformSpecificConfig->_vtbl->_addRef(_iPlatformSpecificConfig); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iPlatformSpecificConfig) { _iPlatformSpecificConfig->_vtbl->_release(_iPlatformSpecificConfig); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getHttpClientId(void** id)	{ return _iPlatformSpecificConfig ? _iPlatformSpecificConfig->_vtbl->_getHttpClientId(_iPlatformSpecificConfig, id) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getHttpClientIdConfigMask(UINT32* mask)	{ return _iPlatformSpecificConfig ? _iPlatformSpecificConfig->_vtbl->_getHttpClientIdConfigMask(_iPlatformSpecificConfig, mask) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCookieEnabled(bool* enabledOut)	{ return _iPlatformSpecificConfig ? _iPlatformSpecificConfig->_vtbl->_getCookieEnabled(_iPlatformSpecificConfig, enabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTrendMicroConfigFile(UINT32 numOfFilePathCharsBuf, CHAR8* filePathCharsBufOut)	{ return _iPlatformSpecificConfig ? _iPlatformSpecificConfig->_vtbl->_getTrendMicroConfigFile(_iPlatformSpecificConfig, numOfFilePathCharsBuf, filePathCharsBufOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTrendMicroDeviceId(UINT32 numOfDeviceIdCharsBuf, CHAR8* deviceIdCharsBufOut)	{ return _iPlatformSpecificConfig ? _iPlatformSpecificConfig->_vtbl->_getTrendMicroDeviceId(_iPlatformSpecificConfig, numOfDeviceIdCharsBuf, deviceIdCharsBufOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTrendMicroService(INT32* serviceOut)	{ return _iPlatformSpecificConfig ? _iPlatformSpecificConfig->_vtbl->_getTrendMicroService(_iPlatformSpecificConfig, serviceOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlPlatformSpecificConfig* _iPlatformSpecificConfig;
};

/*! @}
 * end of CEComICEHtmlPlatformSpecificConfigRef
 */

#endif // __cplusplus

#endif
