///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlHistoryNavigator_h
#define ICEHtmlHistoryNavigator_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlHistoryNavigator ICEHtmlHistoryNavigator
 * @{
 */

/*!
 * ID of ICEHtmlHistoryNavigator
 */
#define CEComIID_ICEHtmlHistoryNavigator 0x6e91d1f1


/*!
 * ICEHtmlHistoryNavigator
 */
typedef struct ICEHtmlHistoryNavigator
{
	const struct ICEHtmlHistoryNavigator_vtbl* _vtbl;
} ICEHtmlHistoryNavigator;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iHistoryNavigator	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlHistoryNavigator_queryInterface) (ICEHtmlHistoryNavigator* iHistoryNavigator, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlHistoryNavigator_addRef) (ICEHtmlHistoryNavigator* iHistoryNavigator);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlHistoryNavigator_release) (ICEHtmlHistoryNavigator* iHistoryNavigator);

typedef CEHResult (*iCEHtmlHistoryNavigator_navigate) (ICEHtmlHistoryNavigator* iHistoryNavigator, struct ICEUString* iURLStr);

typedef CEHResult (*iCEHtmlHistoryNavigator_navigatePost) (ICEHtmlHistoryNavigator* iHistoryNavigator, struct ICEURL* iURL, struct ICEUString* postData);

typedef CEHResult (*iCEHtmlHistoryNavigator_navigateAsUnregisteredMimeType) (ICEHtmlHistoryNavigator* iHistoryNavigator, struct ICEURL* iURL, struct ICEURL* referer, struct ICEUString* iEncodingIanaNameOfEncodedUrl);

typedef CEHResult (*iCEHtmlHistoryNavigator_stop) (ICEHtmlHistoryNavigator* iHistoryNavigator);

typedef CEHResult (*iCEHtmlHistoryNavigator_forward) (ICEHtmlHistoryNavigator* iHistoryNavigator, UINT32 amount);

typedef CEHResult (*iCEHtmlHistoryNavigator_back) (ICEHtmlHistoryNavigator* iHistoryNavigator, UINT32 amount);

typedef CEHResult (*iCEHtmlHistoryNavigator_canBack) (ICEHtmlHistoryNavigator* iHistoryNavigator, UINT32 amount, bool *const canBackOut);

typedef CEHResult (*iCEHtmlHistoryNavigator_canForward) (ICEHtmlHistoryNavigator* iHistoryNavigator, UINT32 amount, bool *const canForwardOut);

typedef CEHResult (*iCEHtmlHistoryNavigator_reload) (ICEHtmlHistoryNavigator* iHistoryNavigator, bool skipCache);

typedef CEHResult (*iCEHtmlHistoryNavigator_clearCurrent) (ICEHtmlHistoryNavigator* iHistoryNavigator);

typedef CEHResult (*iCEHtmlHistoryNavigator_shrinkHistory) (ICEHtmlHistoryNavigator* iHistoryNavigator, UINT32 minimumSize);

typedef CEHResult (*iCEHtmlHistoryNavigator_setCollapseThresholdTime) (ICEHtmlHistoryNavigator* iHistoryNavigator, INT32 millisec);

typedef CEHResult (*iCEHtmlHistoryNavigator_clearMemoryCache) (ICEHtmlHistoryNavigator* iHistoryNavigator);

typedef CEHResult (*iCEHtmlHistoryNavigator_clearOldMemoryCache) (ICEHtmlHistoryNavigator* iHistoryNavigator, INT32 numRemain);

typedef CEHResult (*iCEHtmlHistoryNavigator_getHistoryURL) (ICEHtmlHistoryNavigator* iHistoryNavigator, INT32 distanceFromCurrent, struct ICEURL* *const iURLOut);

typedef CEHResult (*iCEHtmlHistoryNavigator_isNavigating) (ICEHtmlHistoryNavigator* iHistoryNavigator, bool *const isNavigatingOut);

typedef CEHResult (*iCEHtmlHistoryNavigator_switchCurrent) (ICEHtmlHistoryNavigator* iHistoryNavigator);

typedef CEHResult (*iCEHtmlHistoryNavigator_navigateToResource) (ICEHtmlHistoryNavigator* iHistoryNavigator, struct ICEUnknown* iUnknown);

typedef CEHResult (*iCEHtmlHistoryNavigator_getHistoryLength) (ICEHtmlHistoryNavigator* iHistoryNavigator, INT32 *const lengthOut);

typedef CEHResult (*iCEHtmlHistoryNavigator_setHistoryLimit) (ICEHtmlHistoryNavigator* iHistoryNavigator, const INT32 limitLength);

typedef CEHResult (*iCEHtmlHistoryNavigator_setCustomTextEncodingName) (ICEHtmlHistoryNavigator* iHistoryNavigator, struct ICEUString* iTitle);

typedef CEHResult (*iCEHtmlHistoryNavigator_changeCharSize) (ICEHtmlHistoryNavigator* iHistoryNavigator, const UINT32 sizeIn);

typedef CEHResult (*iCEHtmlHistoryNavigator_getTitle) (ICEHtmlHistoryNavigator* iHistoryNavigator, struct ICEUString* *titleOut);

typedef CEHResult (*iCEHtmlHistoryNavigator_getURL) (ICEHtmlHistoryNavigator* iHistoryNavigator, struct ICEUString* *urlOut);

/*!
 * V-table of ICEHtmlHistoryNavigator
 */
struct ICEHtmlHistoryNavigator_vtbl
{
	iCEHtmlHistoryNavigator_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlHistoryNavigator_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlHistoryNavigator_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlHistoryNavigator_navigate	_navigate;
	iCEHtmlHistoryNavigator_navigatePost	_navigatePost;
	iCEHtmlHistoryNavigator_navigateAsUnregisteredMimeType	_navigateAsUnregisteredMimeType;
	iCEHtmlHistoryNavigator_stop	_stop;
	iCEHtmlHistoryNavigator_forward	_forward;
	iCEHtmlHistoryNavigator_back	_back;
	iCEHtmlHistoryNavigator_canBack	_canBack;
	iCEHtmlHistoryNavigator_canForward	_canForward;
	iCEHtmlHistoryNavigator_reload	_reload;
	iCEHtmlHistoryNavigator_clearCurrent	_clearCurrent;
	iCEHtmlHistoryNavigator_shrinkHistory	_shrinkHistory;
	iCEHtmlHistoryNavigator_setCollapseThresholdTime	_setCollapseThresholdTime;
	iCEHtmlHistoryNavigator_clearMemoryCache	_clearMemoryCache;
	iCEHtmlHistoryNavigator_clearOldMemoryCache	_clearOldMemoryCache;
	iCEHtmlHistoryNavigator_getHistoryURL	_getHistoryURL;
	iCEHtmlHistoryNavigator_isNavigating	_isNavigating;
	iCEHtmlHistoryNavigator_switchCurrent	_switchCurrent;
	iCEHtmlHistoryNavigator_navigateToResource	_navigateToResource;
	iCEHtmlHistoryNavigator_getHistoryLength	_getHistoryLength;
	iCEHtmlHistoryNavigator_setHistoryLimit	_setHistoryLimit;
	iCEHtmlHistoryNavigator_setCustomTextEncodingName	_setCustomTextEncodingName;
	iCEHtmlHistoryNavigator_changeCharSize	_changeCharSize;
	iCEHtmlHistoryNavigator_getTitle	_getTitle;
	iCEHtmlHistoryNavigator_getURL	_getURL;
};

/*! @}
 * end of ICEHtmlHistoryNavigator
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlHistoryNavigatorRef CEComICEHtmlHistoryNavigatorRef
 * @{
 */

class CEComICEHtmlHistoryNavigatorRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlHistoryNavigatorRef() : _iHistoryNavigator(0) {}
	CEComICEHtmlHistoryNavigatorRef(ICEHtmlHistoryNavigator* iOther) : _iHistoryNavigator(0)
	{
		if (iOther)
		{
			_iHistoryNavigator = iOther;
			_iHistoryNavigator->_vtbl->_addRef(_iHistoryNavigator);
		}
	}

	CEComICEHtmlHistoryNavigatorRef(const CEComICEHtmlHistoryNavigatorRef& other) : _iHistoryNavigator(0)
	{
		if (other._iHistoryNavigator)
		{
			_iHistoryNavigator = other._iHistoryNavigator;
			_iHistoryNavigator->_vtbl->_addRef(_iHistoryNavigator);
		}
	}

	~CEComICEHtmlHistoryNavigatorRef()
	{
		if (_iHistoryNavigator)
		{
			ICEHtmlHistoryNavigator* tmp = _iHistoryNavigator;
			_iHistoryNavigator = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlHistoryNavigator* iHistoryNavigator;
				void* _ptr;
			} uIntf;
			uIntf.iHistoryNavigator = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlHistoryNavigator, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iHistoryNavigator)
				{
					ICEHtmlHistoryNavigator* tmp = _iHistoryNavigator;
					_iHistoryNavigator = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iHistoryNavigator = uIntf.iHistoryNavigator;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlHistoryNavigator* object() const	{ return _iHistoryNavigator; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlHistoryNavigator* iOther)
	{
		if (_iHistoryNavigator)
		{
			ICEHtmlHistoryNavigator* tmp = _iHistoryNavigator;
			_iHistoryNavigator = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iHistoryNavigator = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlHistoryNavigator* detach()
	{
		ICEHtmlHistoryNavigator* iIntf = _iHistoryNavigator;
		_iHistoryNavigator = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlHistoryNavigator* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iHistoryNavigator;
		if (_iHistoryNavigator)
		{
			_iHistoryNavigator->_vtbl->_addRef(_iHistoryNavigator);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlHistoryNavigator*() const	{ return _iHistoryNavigator; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlHistoryNavigator& operator*() const	{ return *_iHistoryNavigator; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iHistoryNavigator == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlHistoryNavigator* iOther) const	{ return (_iHistoryNavigator != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlHistoryNavigator* iOther) const	{ return (_iHistoryNavigator == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlHistoryNavigatorRef& operator=(const CEComICEHtmlHistoryNavigatorRef& other)	{ return operator=(other._iHistoryNavigator); }

	CEComICEHtmlHistoryNavigatorRef& operator=(const ICEHtmlHistoryNavigator* iOther)
	{
		if (_iHistoryNavigator != iOther)
		{
			if (_iHistoryNavigator)
			{
				ICEHtmlHistoryNavigator* tmp = _iHistoryNavigator;
				_iHistoryNavigator = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iHistoryNavigator = const_cast<ICEHtmlHistoryNavigator*>(iOther);
			if (_iHistoryNavigator)
			{
				_iHistoryNavigator->_vtbl->_addRef(_iHistoryNavigator);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlHistoryNavigator** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlHistoryNavigatorRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iHistoryNavigator && "has a com object reference. clear first.");
		return & _iHistoryNavigator; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlHistoryNavigatorRef& other)
	{
		bool result = false;
		if (_iHistoryNavigator)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iHistoryNavigator);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_queryInterface(_iHistoryNavigator, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iHistoryNavigator) { _iHistoryNavigator->_vtbl->_addRef(_iHistoryNavigator); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iHistoryNavigator) { _iHistoryNavigator->_vtbl->_release(_iHistoryNavigator); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult navigate(struct ICEUString* iURLStr)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_navigate(_iHistoryNavigator, iURLStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult navigatePost(struct ICEURL* iURL, struct ICEUString* postData)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_navigatePost(_iHistoryNavigator, iURL, postData) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult navigateAsUnregisteredMimeType(struct ICEURL* iURL, struct ICEURL* referer, struct ICEUString* iEncodingIanaNameOfEncodedUrl)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_navigateAsUnregisteredMimeType(_iHistoryNavigator, iURL, referer, iEncodingIanaNameOfEncodedUrl) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult stop()	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_stop(_iHistoryNavigator) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult forward(UINT32 amount)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_forward(_iHistoryNavigator, amount) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult back(UINT32 amount)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_back(_iHistoryNavigator, amount) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult canBack(UINT32 amount, bool *const canBackOut)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_canBack(_iHistoryNavigator, amount, canBackOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult canForward(UINT32 amount, bool *const canForwardOut)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_canForward(_iHistoryNavigator, amount, canForwardOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult reload(bool skipCache)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_reload(_iHistoryNavigator, skipCache) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult clearCurrent()	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_clearCurrent(_iHistoryNavigator) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult shrinkHistory(UINT32 minimumSize)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_shrinkHistory(_iHistoryNavigator, minimumSize) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setCollapseThresholdTime(INT32 millisec)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_setCollapseThresholdTime(_iHistoryNavigator, millisec) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult clearMemoryCache()	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_clearMemoryCache(_iHistoryNavigator) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult clearOldMemoryCache(INT32 numRemain)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_clearOldMemoryCache(_iHistoryNavigator, numRemain) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getHistoryURL(INT32 distanceFromCurrent, struct ICEURL* *const iURLOut)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_getHistoryURL(_iHistoryNavigator, distanceFromCurrent, iURLOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isNavigating(bool *const isNavigatingOut)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_isNavigating(_iHistoryNavigator, isNavigatingOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult switchCurrent()	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_switchCurrent(_iHistoryNavigator) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult navigateToResource(struct ICEUnknown* iUnknown)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_navigateToResource(_iHistoryNavigator, iUnknown) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getHistoryLength(INT32 *const lengthOut)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_getHistoryLength(_iHistoryNavigator, lengthOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setHistoryLimit(const INT32 limitLength)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_setHistoryLimit(_iHistoryNavigator, limitLength) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setCustomTextEncodingName(struct ICEUString* iTitle)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_setCustomTextEncodingName(_iHistoryNavigator, iTitle) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult changeCharSize(const UINT32 sizeIn)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_changeCharSize(_iHistoryNavigator, sizeIn) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTitle(struct ICEUString* *titleOut)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_getTitle(_iHistoryNavigator, titleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getURL(struct ICEUString* *urlOut)	{ return _iHistoryNavigator ? _iHistoryNavigator->_vtbl->_getURL(_iHistoryNavigator, urlOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlHistoryNavigator* _iHistoryNavigator;
};

/*! @}
 * end of CEComICEHtmlHistoryNavigatorRef
 */

#endif // __cplusplus

#endif
