///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlFrameWindowWidget_h
#define ICEHtmlFrameWindowWidget_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "URL.h"
#include "ICEHtmlFrameWindow.h"
#include "ICEDXMath.h"
#include "CEHtmlWindowCommon.h"
#include "CEUITypes.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------

struct ICEHtmlFrameWindow;

//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
	CEHtmlMouseCursor_Crosshair,
	CEHtmlMouseCursor_Default,
	CEHtmlMouseCursor_Pointer,
	CEHtmlMouseCursor_Move,
	CEHtmlMouseCursor_Text,
	CEHtmlMouseCursor_Wait,
	CEHtmlMouseCursor_Help,
	CEHtmlMouseCursor_Eresize,
	CEHtmlMouseCursor_NEresize,
	CEHtmlMouseCursor_NWresize,
	CEHtmlMouseCursor_Nresize,
	CEHtmlMouseCursor_SEresize,
	CEHtmlMouseCursor_SWresize,
	CEHtmlMouseCursor_Sresize,
	CEHtmlMouseCursor_Wresize,
	CEHtmlMouseCursor_None,
} CEHtmlMouseCursor;


/*!
 * CEHtmlFrameScrolling
 */
typedef enum
{
	CEHtmlFrameScrolling_Undefined,
	CEHtmlFrameScrolling_No,
	CEHtmlFrameScrolling_Yes,
	CEHtmlFrameScrolling_Auto,
	CEHtmlFrameScrolling_Vertical_No,
	CEHtmlFrameScrolling_Vertical_Yes,
	CEHtmlFrameScrolling_Vertical_Auto,
	CEHtmlFrameScrolling_Horizontal_No,
	CEHtmlFrameScrolling_Horizontal_Yes,
	CEHtmlFrameScrolling_Horizontal_Auto,
} CEHtmlFrameScrolling;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlFrameWindowWidget ICEHtmlFrameWindowWidget
 * @{
 */

/*!
 * ID of ICEHtmlFrameWindowWidget
 */
#define CEComIID_ICEHtmlFrameWindowWidget 0xdd9b76e4


/*!
 * ICEHtmlFrameWindowWidget
 */
typedef struct ICEHtmlFrameWindowWidget
{
	const struct ICEHtmlFrameWindowWidget_vtbl* _vtbl;
} ICEHtmlFrameWindowWidget;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iFrameWindowWidget	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlFrameWindowWidget_queryInterface) (ICEHtmlFrameWindowWidget* iFrameWindowWidget, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFrameWindowWidget_addRef) (ICEHtmlFrameWindowWidget* iFrameWindowWidget);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFrameWindowWidget_release) (ICEHtmlFrameWindowWidget* iFrameWindowWidget);

typedef CEHResult (*iCEHtmlFrameWindowWidget_focus) (ICEHtmlFrameWindowWidget* iFrameWindowWidget);

typedef CEHResult (*iCEHtmlFrameWindowWidget_blur) (ICEHtmlFrameWindowWidget* iFrameWindowWidget);

typedef CEHResult (*iCEHtmlFrameWindowWidget_updateCursor) (ICEHtmlFrameWindowWidget* iFrameWindowWidget, const CEHtmlMouseCursor cursor);

typedef CEHResult (*iCEHtmlFrameWindowWidget_notifyCursorInformation) (ICEHtmlFrameWindowWidget* iFrameWindowWidget, const UINT32 x, const UINT32 y, const CERect* boundingRect);

typedef CEHResult (*iCEHtmlFrameWindowWidget_invalidateRegion) (ICEHtmlFrameWindowWidget* iFrameWindowWidget, struct ICEDXRegion* region);

typedef CEHResult (*iCEHtmlFrameWindowWidget_setBounds) (ICEHtmlFrameWindowWidget* iFrameWindowWidget, const CERect* rect);

typedef CEHResult (*iCEHtmlFrameWindowWidget_getBounds) (ICEHtmlFrameWindowWidget* iFrameWindowWidget, CERect *const rectOut);

typedef CEHResult (*iCEHtmlFrameWindowWidget_getPointToScreen) (ICEHtmlFrameWindowWidget* iFrameWindowWidget, CEPointBase* pointOut);

typedef CEHResult (*iCEHtmlFrameWindowWidget_getScrollbarPreference) (ICEHtmlFrameWindowWidget* iFrameWindowWidget, CEHtmlFrameScrolling *const preferenceHOut, CEHtmlFrameScrolling *const preferenceVOut);

typedef CEHResult (*iCEHtmlFrameWindowWidget_setFrameWindowLocation) (ICEHtmlFrameWindowWidget* iFrameWindowWidget, const UINT32 x, const UINT32 y);

typedef CEHResult (*iCEHtmlFrameWindowWidget_setFrameWindowSize) (ICEHtmlFrameWindowWidget* iFrameWindowWidget, const UINT32 width, const UINT32 height);

/*!
 * V-table of ICEHtmlFrameWindowWidget
 */
struct ICEHtmlFrameWindowWidget_vtbl
{
	iCEHtmlFrameWindowWidget_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlFrameWindowWidget_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlFrameWindowWidget_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlFrameWindowWidget_focus	_focus;
	iCEHtmlFrameWindowWidget_blur	_blur;
	iCEHtmlFrameWindowWidget_updateCursor	_updateCursor;
	iCEHtmlFrameWindowWidget_notifyCursorInformation	_notifyCursorInformation;
	iCEHtmlFrameWindowWidget_invalidateRegion	_invalidateRegion;
	iCEHtmlFrameWindowWidget_setBounds	_setBounds;
	iCEHtmlFrameWindowWidget_getBounds	_getBounds;
	iCEHtmlFrameWindowWidget_getPointToScreen	_getPointToScreen;
	iCEHtmlFrameWindowWidget_getScrollbarPreference	_getScrollbarPreference;
	iCEHtmlFrameWindowWidget_setFrameWindowLocation	_setFrameWindowLocation;
	iCEHtmlFrameWindowWidget_setFrameWindowSize	_setFrameWindowSize;
};

/*! @}
 * end of ICEHtmlFrameWindowWidget
 */

/*! \defgroup ICEHtmlFocusInvalidateSuppressor ICEHtmlFocusInvalidateSuppressor
 * @{
 */

/*!
 * ID of ICEHtmlFocusInvalidateSuppressor
 */
#define CEComIID_ICEHtmlFocusInvalidateSuppressor 0x431452a5

/*!
 * ICEHtmlFocusInvalidateSuppressor
 */
typedef struct ICEHtmlFocusInvalidateSuppressor
{
	const struct ICEHtmlFocusInvalidateSuppressor_vtbl* _vtbl;
} ICEHtmlFocusInvalidateSuppressor;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iFocusInvalidateSuppressor	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlFocusInvalidateSuppressor_queryInterface) (ICEHtmlFocusInvalidateSuppressor* iFocusInvalidateSuppressor, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFocusInvalidateSuppressor_addRef) (ICEHtmlFocusInvalidateSuppressor* iFocusInvalidateSuppressor);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFocusInvalidateSuppressor_release) (ICEHtmlFocusInvalidateSuppressor* iFocusInvalidateSuppressor);

typedef CEHResult (*iCEHtmlFocusInvalidateSuppressor_incFocusInvalidateSuppressionCount) (ICEHtmlFocusInvalidateSuppressor* iFocusInvalidateSuppressor);

typedef CEHResult (*iCEHtmlFocusInvalidateSuppressor_decFocusInvalidateSuppressionCount) (ICEHtmlFocusInvalidateSuppressor* iFocusInvalidateSuppressor);

/*!
 * V-table of ICEHtmlFocusInvalidateSuppressor
 */
struct ICEHtmlFocusInvalidateSuppressor_vtbl
{
	iCEHtmlFocusInvalidateSuppressor_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlFocusInvalidateSuppressor_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlFocusInvalidateSuppressor_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlFocusInvalidateSuppressor_incFocusInvalidateSuppressionCount	_incFocusInvalidateSuppressionCount;
	iCEHtmlFocusInvalidateSuppressor_decFocusInvalidateSuppressionCount	_decFocusInvalidateSuppressionCount;
};

/*! @}
 * end of ICEHtmlFocusInvalidateSuppressor
 */

/*! \defgroup ICEHtmlFrameWindowWidgetManager ICEHtmlFrameWindowWidgetManager
 * @{
 */

/*!
 * ID of ICEHtmlFrameWindowWidgetManager
 */
#define CEComIID_ICEHtmlFrameWindowWidgetManager 0x29df6fe9


/*!
 * ICEHtmlFrameWindowWidgetFactory
 */
typedef struct ICEHtmlFrameWindowWidgetManager
{
	const struct ICEHtmlFrameWindowWidgetManager_vtbl* _vtbl;
} ICEHtmlFrameWindowWidgetManager;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iFrameWindowWidgetManager	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlFrameWindowWidgetManager_queryInterface) (ICEHtmlFrameWindowWidgetManager* iFrameWindowWidgetManager, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFrameWindowWidgetManager_addRef) (ICEHtmlFrameWindowWidgetManager* iFrameWindowWidgetManager);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFrameWindowWidgetManager_release) (ICEHtmlFrameWindowWidgetManager* iFrameWindowWidgetManager);

typedef CEHResult (*iCEHtmlFrameWindowWidgetManager_create) (ICEHtmlFrameWindowWidgetManager* iFrameWindowWidgetManager, struct ICEHtmlFrameWindow* iFrameWindow, const CEHtmlInvokerType invokerType, struct ICEURL* iUrl, UINT16 windowCreationFlags, INT32 leftPos, INT32 topPos, INT32 width, INT32 height, void* const userData, void* const userData2, struct ICEHtmlFrameWindowWidget* *const iFrameWindowWidgetOut);

typedef CEHResult (*iCEHtmlFrameWindowWidgetManager_createByContent) (ICEHtmlFrameWindowWidgetManager* iFrameWindowWidgetManager, struct ICEHtmlFrameWindow* iFrameWindow, const CEHtmlInvokerType invokerType, struct ICEURL* iUrl, UINT16 windowCreationFlags, INT32 leftPos, INT32 topPos, INT32 width, INT32 height, struct ICEHtmlFrameWindow* iOpenerWindow, void* const dummy, struct ICEHtmlFrameWindowWidget** iFrameWindowWidgetOut);

typedef CEHResult (*iCEHtmlFrameWindowWidgetManager_destroy) (ICEHtmlFrameWindowWidgetManager* iFrameWindowWidgetManager, struct ICEHtmlFrameWindowWidget* iFrameWindowWidget);

/*!
 * V-table of ICEHtmlFrameWindowWidgetManager
 */
struct ICEHtmlFrameWindowWidgetManager_vtbl
{
	iCEHtmlFrameWindowWidgetManager_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlFrameWindowWidgetManager_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlFrameWindowWidgetManager_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlFrameWindowWidgetManager_create	_create;
	iCEHtmlFrameWindowWidgetManager_createByContent	_createByContent;
	iCEHtmlFrameWindowWidgetManager_destroy	_destroy;
};

/*! @}
 * end of ICEHtmlFrameWindowWidgetManager
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlFrameWindowWidgetRef CEComICEHtmlFrameWindowWidgetRef
 * @{
 */

class CEComICEHtmlFrameWindowWidgetRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlFrameWindowWidgetRef() : _iFrameWindowWidget(0) {}
	CEComICEHtmlFrameWindowWidgetRef(ICEHtmlFrameWindowWidget* iOther) : _iFrameWindowWidget(0)
	{
		if (iOther)
		{
			_iFrameWindowWidget = iOther;
			_iFrameWindowWidget->_vtbl->_addRef(_iFrameWindowWidget);
		}
	}

	CEComICEHtmlFrameWindowWidgetRef(const CEComICEHtmlFrameWindowWidgetRef& other) : _iFrameWindowWidget(0)
	{
		if (other._iFrameWindowWidget)
		{
			_iFrameWindowWidget = other._iFrameWindowWidget;
			_iFrameWindowWidget->_vtbl->_addRef(_iFrameWindowWidget);
		}
	}

	~CEComICEHtmlFrameWindowWidgetRef()
	{
		if (_iFrameWindowWidget)
		{
			ICEHtmlFrameWindowWidget* tmp = _iFrameWindowWidget;
			_iFrameWindowWidget = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlFrameWindowWidget* iFrameWindowWidget;
				void* _ptr;
			} uIntf;
			uIntf.iFrameWindowWidget = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlFrameWindowWidget, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iFrameWindowWidget)
				{
					ICEHtmlFrameWindowWidget* tmp = _iFrameWindowWidget;
					_iFrameWindowWidget = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iFrameWindowWidget = uIntf.iFrameWindowWidget;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowWidget* object() const	{ return _iFrameWindowWidget; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlFrameWindowWidget* iOther)
	{
		if (_iFrameWindowWidget)
		{
			ICEHtmlFrameWindowWidget* tmp = _iFrameWindowWidget;
			_iFrameWindowWidget = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iFrameWindowWidget = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlFrameWindowWidget* detach()
	{
		ICEHtmlFrameWindowWidget* iIntf = _iFrameWindowWidget;
		_iFrameWindowWidget = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlFrameWindowWidget* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iFrameWindowWidget;
		if (_iFrameWindowWidget)
		{
			_iFrameWindowWidget->_vtbl->_addRef(_iFrameWindowWidget);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlFrameWindowWidget*() const	{ return _iFrameWindowWidget; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowWidget& operator*() const	{ return *_iFrameWindowWidget; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iFrameWindowWidget == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlFrameWindowWidget* iOther) const	{ return (_iFrameWindowWidget != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlFrameWindowWidget* iOther) const	{ return (_iFrameWindowWidget == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlFrameWindowWidgetRef& operator=(const CEComICEHtmlFrameWindowWidgetRef& other)	{ return operator=(other._iFrameWindowWidget); }

	CEComICEHtmlFrameWindowWidgetRef& operator=(const ICEHtmlFrameWindowWidget* iOther)
	{
		if (_iFrameWindowWidget != iOther)
		{
			if (_iFrameWindowWidget)
			{
				ICEHtmlFrameWindowWidget* tmp = _iFrameWindowWidget;
				_iFrameWindowWidget = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iFrameWindowWidget = const_cast<ICEHtmlFrameWindowWidget*>(iOther);
			if (_iFrameWindowWidget)
			{
				_iFrameWindowWidget->_vtbl->_addRef(_iFrameWindowWidget);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowWidget** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlFrameWindowWidgetRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iFrameWindowWidget && "has a com object reference. clear first.");
		return & _iFrameWindowWidget; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlFrameWindowWidgetRef& other)
	{
		bool result = false;
		if (_iFrameWindowWidget)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iFrameWindowWidget);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iFrameWindowWidget ? _iFrameWindowWidget->_vtbl->_queryInterface(_iFrameWindowWidget, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iFrameWindowWidget) { _iFrameWindowWidget->_vtbl->_addRef(_iFrameWindowWidget); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iFrameWindowWidget) { _iFrameWindowWidget->_vtbl->_release(_iFrameWindowWidget); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult focus()	{ return _iFrameWindowWidget ? _iFrameWindowWidget->_vtbl->_focus(_iFrameWindowWidget) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult blur()	{ return _iFrameWindowWidget ? _iFrameWindowWidget->_vtbl->_blur(_iFrameWindowWidget) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult updateCursor(const CEHtmlMouseCursor cursor)	{ return _iFrameWindowWidget ? _iFrameWindowWidget->_vtbl->_updateCursor(_iFrameWindowWidget, cursor) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyCursorInformation(const UINT32 x, const UINT32 y, const CERect* boundingRect)	{ return _iFrameWindowWidget ? _iFrameWindowWidget->_vtbl->_notifyCursorInformation(_iFrameWindowWidget, x, y, boundingRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult invalidateRegion(struct ICEDXRegion* region)	{ return _iFrameWindowWidget ? _iFrameWindowWidget->_vtbl->_invalidateRegion(_iFrameWindowWidget, region) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setBounds(const CERect* rect)	{ return _iFrameWindowWidget ? _iFrameWindowWidget->_vtbl->_setBounds(_iFrameWindowWidget, rect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getBounds(CERect *const rectOut)	{ return _iFrameWindowWidget ? _iFrameWindowWidget->_vtbl->_getBounds(_iFrameWindowWidget, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPointToScreen(CEPointBase* pointOut)	{ return _iFrameWindowWidget ? _iFrameWindowWidget->_vtbl->_getPointToScreen(_iFrameWindowWidget, pointOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getScrollbarPreference(CEHtmlFrameScrolling *const preferenceHOut, CEHtmlFrameScrolling *const preferenceVOut)	{ return _iFrameWindowWidget ? _iFrameWindowWidget->_vtbl->_getScrollbarPreference(_iFrameWindowWidget, preferenceHOut, preferenceVOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFrameWindowLocation(const UINT32 x, const UINT32 y)	{ return _iFrameWindowWidget ? _iFrameWindowWidget->_vtbl->_setFrameWindowLocation(_iFrameWindowWidget, x, y) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFrameWindowSize(const UINT32 width, const UINT32 height)	{ return _iFrameWindowWidget ? _iFrameWindowWidget->_vtbl->_setFrameWindowSize(_iFrameWindowWidget, width, height) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlFrameWindowWidget* _iFrameWindowWidget;
};

/*! @}
 * end of CEComICEHtmlFrameWindowWidgetRef
 */

/*! \defgroup CEComICEHtmlFocusInvalidateSuppressorRef CEComICEHtmlFocusInvalidateSuppressorRef
 * @{
 */

class CEComICEHtmlFocusInvalidateSuppressorRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlFocusInvalidateSuppressorRef() : _iFocusInvalidateSuppressor(0) {}
	CEComICEHtmlFocusInvalidateSuppressorRef(ICEHtmlFocusInvalidateSuppressor* iOther) : _iFocusInvalidateSuppressor(0)
	{
		if (iOther)
		{
			_iFocusInvalidateSuppressor = iOther;
			_iFocusInvalidateSuppressor->_vtbl->_addRef(_iFocusInvalidateSuppressor);
		}
	}

	CEComICEHtmlFocusInvalidateSuppressorRef(const CEComICEHtmlFocusInvalidateSuppressorRef& other) : _iFocusInvalidateSuppressor(0)
	{
		if (other._iFocusInvalidateSuppressor)
		{
			_iFocusInvalidateSuppressor = other._iFocusInvalidateSuppressor;
			_iFocusInvalidateSuppressor->_vtbl->_addRef(_iFocusInvalidateSuppressor);
		}
	}

	~CEComICEHtmlFocusInvalidateSuppressorRef()
	{
		if (_iFocusInvalidateSuppressor)
		{
			ICEHtmlFocusInvalidateSuppressor* tmp = _iFocusInvalidateSuppressor;
			_iFocusInvalidateSuppressor = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlFocusInvalidateSuppressor* iFocusInvalidateSuppressor;
				void* _ptr;
			} uIntf;
			uIntf.iFocusInvalidateSuppressor = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlFocusInvalidateSuppressor, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iFocusInvalidateSuppressor)
				{
					ICEHtmlFocusInvalidateSuppressor* tmp = _iFocusInvalidateSuppressor;
					_iFocusInvalidateSuppressor = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iFocusInvalidateSuppressor = uIntf.iFocusInvalidateSuppressor;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFocusInvalidateSuppressor* object() const	{ return _iFocusInvalidateSuppressor; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlFocusInvalidateSuppressor* iOther)
	{
		if (_iFocusInvalidateSuppressor)
		{
			ICEHtmlFocusInvalidateSuppressor* tmp = _iFocusInvalidateSuppressor;
			_iFocusInvalidateSuppressor = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iFocusInvalidateSuppressor = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlFocusInvalidateSuppressor* detach()
	{
		ICEHtmlFocusInvalidateSuppressor* iIntf = _iFocusInvalidateSuppressor;
		_iFocusInvalidateSuppressor = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlFocusInvalidateSuppressor* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iFocusInvalidateSuppressor;
		if (_iFocusInvalidateSuppressor)
		{
			_iFocusInvalidateSuppressor->_vtbl->_addRef(_iFocusInvalidateSuppressor);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlFocusInvalidateSuppressor*() const	{ return _iFocusInvalidateSuppressor; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFocusInvalidateSuppressor& operator*() const	{ return *_iFocusInvalidateSuppressor; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iFocusInvalidateSuppressor == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlFocusInvalidateSuppressor* iOther) const	{ return (_iFocusInvalidateSuppressor != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlFocusInvalidateSuppressor* iOther) const	{ return (_iFocusInvalidateSuppressor == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlFocusInvalidateSuppressorRef& operator=(const CEComICEHtmlFocusInvalidateSuppressorRef& other)	{ return operator=(other._iFocusInvalidateSuppressor); }

	CEComICEHtmlFocusInvalidateSuppressorRef& operator=(const ICEHtmlFocusInvalidateSuppressor* iOther)
	{
		if (_iFocusInvalidateSuppressor != iOther)
		{
			if (_iFocusInvalidateSuppressor)
			{
				ICEHtmlFocusInvalidateSuppressor* tmp = _iFocusInvalidateSuppressor;
				_iFocusInvalidateSuppressor = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iFocusInvalidateSuppressor = const_cast<ICEHtmlFocusInvalidateSuppressor*>(iOther);
			if (_iFocusInvalidateSuppressor)
			{
				_iFocusInvalidateSuppressor->_vtbl->_addRef(_iFocusInvalidateSuppressor);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFocusInvalidateSuppressor** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlFocusInvalidateSuppressorRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iFocusInvalidateSuppressor && "has a com object reference. clear first.");
		return & _iFocusInvalidateSuppressor; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlFocusInvalidateSuppressorRef& other)
	{
		bool result = false;
		if (_iFocusInvalidateSuppressor)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iFocusInvalidateSuppressor);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iFocusInvalidateSuppressor ? _iFocusInvalidateSuppressor->_vtbl->_queryInterface(_iFocusInvalidateSuppressor, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iFocusInvalidateSuppressor) { _iFocusInvalidateSuppressor->_vtbl->_addRef(_iFocusInvalidateSuppressor); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iFocusInvalidateSuppressor) { _iFocusInvalidateSuppressor->_vtbl->_release(_iFocusInvalidateSuppressor); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult incFocusInvalidateSuppressionCount()	{ return _iFocusInvalidateSuppressor ? _iFocusInvalidateSuppressor->_vtbl->_incFocusInvalidateSuppressionCount(_iFocusInvalidateSuppressor) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult decFocusInvalidateSuppressionCount()	{ return _iFocusInvalidateSuppressor ? _iFocusInvalidateSuppressor->_vtbl->_decFocusInvalidateSuppressionCount(_iFocusInvalidateSuppressor) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlFocusInvalidateSuppressor* _iFocusInvalidateSuppressor;
};

/*! @}
 * end of CEComICEHtmlFocusInvalidateSuppressorRef
 */

/*! \defgroup CEComICEHtmlFrameWindowWidgetManagerRef CEComICEHtmlFrameWindowWidgetManagerRef
 * @{
 */

class CEComICEHtmlFrameWindowWidgetManagerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlFrameWindowWidgetManagerRef() : _iFrameWindowWidgetManager(0) {}
	CEComICEHtmlFrameWindowWidgetManagerRef(ICEHtmlFrameWindowWidgetManager* iOther) : _iFrameWindowWidgetManager(0)
	{
		if (iOther)
		{
			_iFrameWindowWidgetManager = iOther;
			_iFrameWindowWidgetManager->_vtbl->_addRef(_iFrameWindowWidgetManager);
		}
	}

	CEComICEHtmlFrameWindowWidgetManagerRef(const CEComICEHtmlFrameWindowWidgetManagerRef& other) : _iFrameWindowWidgetManager(0)
	{
		if (other._iFrameWindowWidgetManager)
		{
			_iFrameWindowWidgetManager = other._iFrameWindowWidgetManager;
			_iFrameWindowWidgetManager->_vtbl->_addRef(_iFrameWindowWidgetManager);
		}
	}

	~CEComICEHtmlFrameWindowWidgetManagerRef()
	{
		if (_iFrameWindowWidgetManager)
		{
			ICEHtmlFrameWindowWidgetManager* tmp = _iFrameWindowWidgetManager;
			_iFrameWindowWidgetManager = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlFrameWindowWidgetManager* iFrameWindowWidgetManager;
				void* _ptr;
			} uIntf;
			uIntf.iFrameWindowWidgetManager = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlFrameWindowWidgetManager, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iFrameWindowWidgetManager)
				{
					ICEHtmlFrameWindowWidgetManager* tmp = _iFrameWindowWidgetManager;
					_iFrameWindowWidgetManager = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iFrameWindowWidgetManager = uIntf.iFrameWindowWidgetManager;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowWidgetManager* object() const	{ return _iFrameWindowWidgetManager; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlFrameWindowWidgetManager* iOther)
	{
		if (_iFrameWindowWidgetManager)
		{
			ICEHtmlFrameWindowWidgetManager* tmp = _iFrameWindowWidgetManager;
			_iFrameWindowWidgetManager = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iFrameWindowWidgetManager = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlFrameWindowWidgetManager* detach()
	{
		ICEHtmlFrameWindowWidgetManager* iIntf = _iFrameWindowWidgetManager;
		_iFrameWindowWidgetManager = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlFrameWindowWidgetManager* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iFrameWindowWidgetManager;
		if (_iFrameWindowWidgetManager)
		{
			_iFrameWindowWidgetManager->_vtbl->_addRef(_iFrameWindowWidgetManager);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlFrameWindowWidgetManager*() const	{ return _iFrameWindowWidgetManager; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowWidgetManager& operator*() const	{ return *_iFrameWindowWidgetManager; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iFrameWindowWidgetManager == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlFrameWindowWidgetManager* iOther) const	{ return (_iFrameWindowWidgetManager != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlFrameWindowWidgetManager* iOther) const	{ return (_iFrameWindowWidgetManager == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlFrameWindowWidgetManagerRef& operator=(const CEComICEHtmlFrameWindowWidgetManagerRef& other)	{ return operator=(other._iFrameWindowWidgetManager); }

	CEComICEHtmlFrameWindowWidgetManagerRef& operator=(const ICEHtmlFrameWindowWidgetManager* iOther)
	{
		if (_iFrameWindowWidgetManager != iOther)
		{
			if (_iFrameWindowWidgetManager)
			{
				ICEHtmlFrameWindowWidgetManager* tmp = _iFrameWindowWidgetManager;
				_iFrameWindowWidgetManager = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iFrameWindowWidgetManager = const_cast<ICEHtmlFrameWindowWidgetManager*>(iOther);
			if (_iFrameWindowWidgetManager)
			{
				_iFrameWindowWidgetManager->_vtbl->_addRef(_iFrameWindowWidgetManager);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowWidgetManager** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlFrameWindowWidgetManagerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iFrameWindowWidgetManager && "has a com object reference. clear first.");
		return & _iFrameWindowWidgetManager; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlFrameWindowWidgetManagerRef& other)
	{
		bool result = false;
		if (_iFrameWindowWidgetManager)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iFrameWindowWidgetManager);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iFrameWindowWidgetManager ? _iFrameWindowWidgetManager->_vtbl->_queryInterface(_iFrameWindowWidgetManager, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iFrameWindowWidgetManager) { _iFrameWindowWidgetManager->_vtbl->_addRef(_iFrameWindowWidgetManager); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iFrameWindowWidgetManager) { _iFrameWindowWidgetManager->_vtbl->_release(_iFrameWindowWidgetManager); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult create(struct ICEHtmlFrameWindow* iFrameWindow, const CEHtmlInvokerType invokerType, struct ICEURL* iUrl, UINT16 windowCreationFlags, INT32 leftPos, INT32 topPos, INT32 width, INT32 height, void* const userData, void* const userData2, struct ICEHtmlFrameWindowWidget* *const iFrameWindowWidgetOut)	{ return _iFrameWindowWidgetManager ? _iFrameWindowWidgetManager->_vtbl->_create(_iFrameWindowWidgetManager, iFrameWindow, invokerType, iUrl, windowCreationFlags, leftPos, topPos, width, height, userData, userData2, iFrameWindowWidgetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createByContent(struct ICEHtmlFrameWindow* iFrameWindow, const CEHtmlInvokerType invokerType, struct ICEURL* iUrl, UINT16 windowCreationFlags, INT32 leftPos, INT32 topPos, INT32 width, INT32 height, struct ICEHtmlFrameWindow* iOpenerWindow, void* const dummy, struct ICEHtmlFrameWindowWidget** iFrameWindowWidgetOut)	{ return _iFrameWindowWidgetManager ? _iFrameWindowWidgetManager->_vtbl->_createByContent(_iFrameWindowWidgetManager, iFrameWindow, invokerType, iUrl, windowCreationFlags, leftPos, topPos, width, height, iOpenerWindow, dummy, iFrameWindowWidgetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult destroy(struct ICEHtmlFrameWindowWidget* iFrameWindowWidget)	{ return _iFrameWindowWidgetManager ? _iFrameWindowWidgetManager->_vtbl->_destroy(_iFrameWindowWidgetManager, iFrameWindowWidget) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlFrameWindowWidgetManager* _iFrameWindowWidgetManager;
};

/*! @}
 * end of CEComICEHtmlFrameWindowWidgetManagerRef
 */

#endif // __cplusplus

#endif
