///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlFrameWindowNavigationEventHandler_h
#define ICEHtmlFrameWindowNavigationEventHandler_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEHtmlWindow.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
	// navigation is starting 
	CEHtmlWindowNavStatus_NavigationStarting,
	// the document header was received 
	CEHtmlWindowNavStatus_HeaderReceived,
	// the document was redirected 
	CEHtmlWindowNavStatus_Redirected,
	// the document is negotiating authentication 
	CEHtmlWindowNavStatus_Negotiating,
	// the document body is being transfered 
	CEHtmlWindowNavStatus_TransferringBody,
	// the document's body has been transfered 
	CEHtmlWindowNavStatus_BodyTransferComplete,
	// navigation is complete 
	CEHtmlWindowNavStatus_NavigationComplete,
	// upload is starting
	CEHtmlWindowNavStatus_UploadStarting,
	// upload is progressing
	CEHtmlWindowNavStatus_UploadProgressing,
	// navigation is complete 
	CEHtmlWindowNavStatus_UploadComplete,
} CEHtmlWindowNavStatus;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlFrameWindowNavigationEventHandler ICEHtmlFrameWindowNavigationEventHandler
 * @{
 */

/*!
 * ID of ICEHtmlFrameWindowNavigationEventHandler
 */
#define CEComIID_ICEHtmlFrameWindowNavigationEventHandler 0x9e525e2c


/*!
 * ICEHtmlNavigationEventHandler
 */
typedef struct ICEHtmlFrameWindowNavigationEventHandler
{
	const struct ICEHtmlFrameWindowNavigationEventHandler_vtbl* _vtbl;
} ICEHtmlFrameWindowNavigationEventHandler;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iFrameWindowNavigationEventHandler	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlFrameWindowNavigationEventHandler_queryInterface) (ICEHtmlFrameWindowNavigationEventHandler* iFrameWindowNavigationEventHandler, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFrameWindowNavigationEventHandler_addRef) (ICEHtmlFrameWindowNavigationEventHandler* iFrameWindowNavigationEventHandler);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFrameWindowNavigationEventHandler_release) (ICEHtmlFrameWindowNavigationEventHandler* iFrameWindowNavigationEventHandler);

typedef CEHResult (*iCEHtmlFrameWindowNavigationEventHandler_onNewNavigation) (ICEHtmlFrameWindowNavigationEventHandler* iFrameWindowNavigationEventHandler);

typedef CEHResult (*iCEHtmlFrameWindowNavigationEventHandler_onNavigationStatusChanged) (ICEHtmlFrameWindowNavigationEventHandler* iFrameWindowNavigationEventHandler, struct ICEHtmlWindow* sourceWindow, CEHtmlWindowNavStatus newStatus);

typedef CEHResult (*iCEHtmlFrameWindowNavigationEventHandler_onSecureStatusChanged) (ICEHtmlFrameWindowNavigationEventHandler* iFrameWindowNavigationEventHandler, eCESSLMode mode);

typedef CEHResult (*iCEHtmlFrameWindowNavigationEventHandler_onPendingDownloadCountChanged) (ICEHtmlFrameWindowNavigationEventHandler* iFrameWindowNavigationEventHandler, INT32 pendingDownloads);

typedef CEHResult (*iCEHtmlFrameWindowNavigationEventHandler_onTitleChanged) (ICEHtmlFrameWindowNavigationEventHandler* iFrameWindowNavigationEventHandler, struct ICEUString* iTitle);

typedef CEHResult (*iCEHtmlFrameWindowNavigationEventHandler_onUrlChanged) (ICEHtmlFrameWindowNavigationEventHandler* iFrameWindowNavigationEventHandler, struct ICEUString* iUrl);

typedef CEHResult (*iCEHtmlFrameWindowNavigationEventHandler_onHistoryStackChanged) (ICEHtmlFrameWindowNavigationEventHandler* iFrameWindowNavigationEventHandler, bool canBack, bool canForward);

typedef CEHResult (*iCEHtmlFrameWindowNavigationEventHandler_onProgressPercentageChanged) (ICEHtmlFrameWindowNavigationEventHandler* iFrameWindowNavigationEventHandler, double percentage);

typedef CEHResult (*iCEHtmlFrameWindowNavigationEventHandler_onInitialized) (ICEHtmlFrameWindowNavigationEventHandler* iFrameWindowNavigationEventHandler);

/*!
 * V-table of ICEHtmlFrameWindowNavigationEventHandler
 */
struct ICEHtmlFrameWindowNavigationEventHandler_vtbl
{
	iCEHtmlFrameWindowNavigationEventHandler_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlFrameWindowNavigationEventHandler_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlFrameWindowNavigationEventHandler_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlFrameWindowNavigationEventHandler_onNewNavigation	_onNewNavigation;
	iCEHtmlFrameWindowNavigationEventHandler_onNavigationStatusChanged	_onNavigationStatusChanged;
	iCEHtmlFrameWindowNavigationEventHandler_onSecureStatusChanged	_onSecureStatusChanged;
	iCEHtmlFrameWindowNavigationEventHandler_onPendingDownloadCountChanged	_onPendingDownloadCountChanged;
	iCEHtmlFrameWindowNavigationEventHandler_onTitleChanged	_onTitleChanged;
	iCEHtmlFrameWindowNavigationEventHandler_onUrlChanged	_onUrlChanged;
	iCEHtmlFrameWindowNavigationEventHandler_onHistoryStackChanged	_onHistoryStackChanged;
	iCEHtmlFrameWindowNavigationEventHandler_onProgressPercentageChanged	_onProgressPercentageChanged;
	iCEHtmlFrameWindowNavigationEventHandler_onInitialized	_onInitialized;
};

/*! @}
 * end of ICEHtmlFrameWindowNavigationEventHandler
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlFrameWindowNavigationEventHandlerRef CEComICEHtmlFrameWindowNavigationEventHandlerRef
 * @{
 */

class CEComICEHtmlFrameWindowNavigationEventHandlerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlFrameWindowNavigationEventHandlerRef() : _iFrameWindowNavigationEventHandler(0) {}
	CEComICEHtmlFrameWindowNavigationEventHandlerRef(ICEHtmlFrameWindowNavigationEventHandler* iOther) : _iFrameWindowNavigationEventHandler(0)
	{
		if (iOther)
		{
			_iFrameWindowNavigationEventHandler = iOther;
			_iFrameWindowNavigationEventHandler->_vtbl->_addRef(_iFrameWindowNavigationEventHandler);
		}
	}

	CEComICEHtmlFrameWindowNavigationEventHandlerRef(const CEComICEHtmlFrameWindowNavigationEventHandlerRef& other) : _iFrameWindowNavigationEventHandler(0)
	{
		if (other._iFrameWindowNavigationEventHandler)
		{
			_iFrameWindowNavigationEventHandler = other._iFrameWindowNavigationEventHandler;
			_iFrameWindowNavigationEventHandler->_vtbl->_addRef(_iFrameWindowNavigationEventHandler);
		}
	}

	~CEComICEHtmlFrameWindowNavigationEventHandlerRef()
	{
		if (_iFrameWindowNavigationEventHandler)
		{
			ICEHtmlFrameWindowNavigationEventHandler* tmp = _iFrameWindowNavigationEventHandler;
			_iFrameWindowNavigationEventHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlFrameWindowNavigationEventHandler* iFrameWindowNavigationEventHandler;
				void* _ptr;
			} uIntf;
			uIntf.iFrameWindowNavigationEventHandler = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlFrameWindowNavigationEventHandler, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iFrameWindowNavigationEventHandler)
				{
					ICEHtmlFrameWindowNavigationEventHandler* tmp = _iFrameWindowNavigationEventHandler;
					_iFrameWindowNavigationEventHandler = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iFrameWindowNavigationEventHandler = uIntf.iFrameWindowNavigationEventHandler;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowNavigationEventHandler* object() const	{ return _iFrameWindowNavigationEventHandler; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlFrameWindowNavigationEventHandler* iOther)
	{
		if (_iFrameWindowNavigationEventHandler)
		{
			ICEHtmlFrameWindowNavigationEventHandler* tmp = _iFrameWindowNavigationEventHandler;
			_iFrameWindowNavigationEventHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iFrameWindowNavigationEventHandler = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlFrameWindowNavigationEventHandler* detach()
	{
		ICEHtmlFrameWindowNavigationEventHandler* iIntf = _iFrameWindowNavigationEventHandler;
		_iFrameWindowNavigationEventHandler = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlFrameWindowNavigationEventHandler* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iFrameWindowNavigationEventHandler;
		if (_iFrameWindowNavigationEventHandler)
		{
			_iFrameWindowNavigationEventHandler->_vtbl->_addRef(_iFrameWindowNavigationEventHandler);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlFrameWindowNavigationEventHandler*() const	{ return _iFrameWindowNavigationEventHandler; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowNavigationEventHandler& operator*() const	{ return *_iFrameWindowNavigationEventHandler; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iFrameWindowNavigationEventHandler == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlFrameWindowNavigationEventHandler* iOther) const	{ return (_iFrameWindowNavigationEventHandler != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlFrameWindowNavigationEventHandler* iOther) const	{ return (_iFrameWindowNavigationEventHandler == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlFrameWindowNavigationEventHandlerRef& operator=(const CEComICEHtmlFrameWindowNavigationEventHandlerRef& other)	{ return operator=(other._iFrameWindowNavigationEventHandler); }

	CEComICEHtmlFrameWindowNavigationEventHandlerRef& operator=(const ICEHtmlFrameWindowNavigationEventHandler* iOther)
	{
		if (_iFrameWindowNavigationEventHandler != iOther)
		{
			if (_iFrameWindowNavigationEventHandler)
			{
				ICEHtmlFrameWindowNavigationEventHandler* tmp = _iFrameWindowNavigationEventHandler;
				_iFrameWindowNavigationEventHandler = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iFrameWindowNavigationEventHandler = const_cast<ICEHtmlFrameWindowNavigationEventHandler*>(iOther);
			if (_iFrameWindowNavigationEventHandler)
			{
				_iFrameWindowNavigationEventHandler->_vtbl->_addRef(_iFrameWindowNavigationEventHandler);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFrameWindowNavigationEventHandler** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlFrameWindowNavigationEventHandlerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iFrameWindowNavigationEventHandler && "has a com object reference. clear first.");
		return & _iFrameWindowNavigationEventHandler; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlFrameWindowNavigationEventHandlerRef& other)
	{
		bool result = false;
		if (_iFrameWindowNavigationEventHandler)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iFrameWindowNavigationEventHandler);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iFrameWindowNavigationEventHandler ? _iFrameWindowNavigationEventHandler->_vtbl->_queryInterface(_iFrameWindowNavigationEventHandler, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iFrameWindowNavigationEventHandler) { _iFrameWindowNavigationEventHandler->_vtbl->_addRef(_iFrameWindowNavigationEventHandler); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iFrameWindowNavigationEventHandler) { _iFrameWindowNavigationEventHandler->_vtbl->_release(_iFrameWindowNavigationEventHandler); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onNewNavigation()	{ return _iFrameWindowNavigationEventHandler ? _iFrameWindowNavigationEventHandler->_vtbl->_onNewNavigation(_iFrameWindowNavigationEventHandler) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onNavigationStatusChanged(struct ICEHtmlWindow* sourceWindow, CEHtmlWindowNavStatus newStatus)	{ return _iFrameWindowNavigationEventHandler ? _iFrameWindowNavigationEventHandler->_vtbl->_onNavigationStatusChanged(_iFrameWindowNavigationEventHandler, sourceWindow, newStatus) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onSecureStatusChanged(eCESSLMode mode)	{ return _iFrameWindowNavigationEventHandler ? _iFrameWindowNavigationEventHandler->_vtbl->_onSecureStatusChanged(_iFrameWindowNavigationEventHandler, mode) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onPendingDownloadCountChanged(INT32 pendingDownloads)	{ return _iFrameWindowNavigationEventHandler ? _iFrameWindowNavigationEventHandler->_vtbl->_onPendingDownloadCountChanged(_iFrameWindowNavigationEventHandler, pendingDownloads) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onTitleChanged(struct ICEUString* iTitle)	{ return _iFrameWindowNavigationEventHandler ? _iFrameWindowNavigationEventHandler->_vtbl->_onTitleChanged(_iFrameWindowNavigationEventHandler, iTitle) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onUrlChanged(struct ICEUString* iUrl)	{ return _iFrameWindowNavigationEventHandler ? _iFrameWindowNavigationEventHandler->_vtbl->_onUrlChanged(_iFrameWindowNavigationEventHandler, iUrl) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onHistoryStackChanged(bool canBack, bool canForward)	{ return _iFrameWindowNavigationEventHandler ? _iFrameWindowNavigationEventHandler->_vtbl->_onHistoryStackChanged(_iFrameWindowNavigationEventHandler, canBack, canForward) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onProgressPercentageChanged(double percentage)	{ return _iFrameWindowNavigationEventHandler ? _iFrameWindowNavigationEventHandler->_vtbl->_onProgressPercentageChanged(_iFrameWindowNavigationEventHandler, percentage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult onInitialized()	{ return _iFrameWindowNavigationEventHandler ? _iFrameWindowNavigationEventHandler->_vtbl->_onInitialized(_iFrameWindowNavigationEventHandler) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlFrameWindowNavigationEventHandler* _iFrameWindowNavigationEventHandler;
};

/*! @}
 * end of CEComICEHtmlFrameWindowNavigationEventHandlerRef
 */

#endif // __cplusplus

#endif
