///////////////////////////////////////////////////////////////////////////////
// Copyright 2012 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEDpyRunLoop_h
#define ICEDpyRunLoop_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "CEUITypes.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------

struct ICEDpyRunLoopConfig;

//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
	eCEDpyTimerEvent_Expired = 0,	//!< the specified time on addTimerListener() has been elapsed
	eCEDpyTimerEvent_Shutdown		//!< ICEDpyTimerMangaer is shutttng down
} eCEDpyTimerEvent;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEDpyRunLoop ICEDpyRunLoop
 * @{
 */

/*!
 * ID of ICEDpyRunLoop
 */
#define CEComIID_ICEDpyRunLoop 0x51119e82

/*!
 * ICEDpyRunLoop
 */
typedef struct ICEDpyRunLoop
{
	const struct ICEDpyRunLoop_vtbl* _vtbl;
} ICEDpyRunLoop;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDpyRunLoop	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEDpyRunLoop_queryInterface) (ICEDpyRunLoop* iDpyRunLoop, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyRunLoop_addRef) (ICEDpyRunLoop* iDpyRunLoop);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyRunLoop_release) (ICEDpyRunLoop* iDpyRunLoop);

typedef CEHResult (*iCEDpyRunLoop_run) (ICEDpyRunLoop* iDpyRunLoop);

/*!
 * V-table of ICEDpyRunLoop
 */
struct ICEDpyRunLoop_vtbl
{
	iCEDpyRunLoop_queryInterface	_queryInterface;	//!< Query interface.
	iCEDpyRunLoop_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEDpyRunLoop_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEDpyRunLoop_run	_run;
};

/*! @}
 * end of ICEDpyRunLoop
 */

/*! \defgroup ICEDpyRunLoopWithExternalListener ICEDpyRunLoopWithExternalListener
 * @{
 */

/*!
 * ID of ICEDpyRunLoopWithExternalListener
 */
#define CEComIID_ICEDpyRunLoopWithExternalListener 0xcbca7c1a

/*!
 * ICEDpyRunLoopWithExternalListener
 */
typedef struct ICEDpyRunLoopWithExternalListener
{
	const struct ICEDpyRunLoopWithExternalListener_vtbl* _vtbl;
} ICEDpyRunLoopWithExternalListener;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDpyRunLoopWithExternalListener	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEDpyRunLoopWithExternalListener_queryInterface) (ICEDpyRunLoopWithExternalListener* iDpyRunLoopWithExternalListener, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyRunLoopWithExternalListener_addRef) (ICEDpyRunLoopWithExternalListener* iDpyRunLoopWithExternalListener);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyRunLoopWithExternalListener_release) (ICEDpyRunLoopWithExternalListener* iDpyRunLoopWithExternalListener);

typedef CEHResult (*iCEDpyRunLoopWithExternalListener_run) (ICEDpyRunLoopWithExternalListener* iDpyRunLoopWithExternalListener);

typedef CEHResult (*iCEDpyRunLoopWithExternalListener_runWithExternalListener) (ICEDpyRunLoopWithExternalListener* iDpyRunLoopWithExternalListener, struct ICEDpySyncObjectSignalListener* iListener);

/*!
 * V-table of ICEDpyRunLoopWithExternalListener
 */
struct ICEDpyRunLoopWithExternalListener_vtbl
{
	iCEDpyRunLoopWithExternalListener_queryInterface	_queryInterface;	//!< Query interface.
	iCEDpyRunLoopWithExternalListener_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEDpyRunLoopWithExternalListener_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEDpyRunLoopWithExternalListener_run	_run;
	iCEDpyRunLoopWithExternalListener_runWithExternalListener	_runWithExternalListener;
};

/*! @}
 * end of ICEDpyRunLoopWithExternalListener
 */

/*! \defgroup ICEDpyPumpListener ICEDpyPumpListener
 * @{
 */

/*!
 * ID of ICEDpyPumpListener
 */
#define CEComIID_ICEDpyPumpListener 0x575e71f3

/*!
 * ICEDpyPumpListener
 */
typedef struct ICEDpyPumpListener
{
	const struct ICEDpyPumpListener_vtbl* _vtbl;
} ICEDpyPumpListener;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDpyPumpListener	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEDpyPumpListener_queryInterface) (ICEDpyPumpListener* iDpyPumpListener, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyPumpListener_addRef) (ICEDpyPumpListener* iDpyPumpListener);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyPumpListener_release) (ICEDpyPumpListener* iDpyPumpListener);

typedef CEHResult (*iCEDpyPumpListener_handlePumped) (ICEDpyPumpListener* iDpyPumpListener);

/*!
 * V-table of ICEDpyPumpListener
 */
struct ICEDpyPumpListener_vtbl
{
	iCEDpyPumpListener_queryInterface	_queryInterface;	//!< Query interface.
	iCEDpyPumpListener_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEDpyPumpListener_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEDpyPumpListener_handlePumped	_handlePumped;
};

/*! @}
 * end of ICEDpyPumpListener
 */

/*! \defgroup ICEDpyPumpManager ICEDpyPumpManager
 * @{
 */

/*!
 * ID of ICEDpyPumpManager
 */
#define CEComIID_ICEDpyPumpManager 0x598a8865

/*!
 * ICEDpyPumpManager
 */
typedef struct ICEDpyPumpManager
{
	const struct ICEDpyPumpManager_vtbl* _vtbl;
} ICEDpyPumpManager;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDpyPumpManager	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEDpyPumpManager_queryInterface) (ICEDpyPumpManager* iDpyPumpManager, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyPumpManager_addRef) (ICEDpyPumpManager* iDpyPumpManager);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyPumpManager_release) (ICEDpyPumpManager* iDpyPumpManager);

typedef CEHResult (*iCEDpyPumpManager_setListener) (ICEDpyPumpManager* iDpyPumpManager, struct ICEDpyPumpListener* listener);

typedef CEHResult (*iCEDpyPumpManager_pump) (ICEDpyPumpManager* iDpyPumpManager);

/*!
 * V-table of ICEDpyPumpManager
 */
struct ICEDpyPumpManager_vtbl
{
	iCEDpyPumpManager_queryInterface	_queryInterface;	//!< Query interface.
	iCEDpyPumpManager_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEDpyPumpManager_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEDpyPumpManager_setListener	_setListener;
	iCEDpyPumpManager_pump	_pump;
};

/*! @}
 * end of ICEDpyPumpManager
 */

/*! \defgroup ICEDpyRunLoopConfig ICEDpyRunLoopConfig
 * @{
 */

/*!
 * ID of ICEDpyRunLoopConfig
 */
#define CEComIID_ICEDpyRunLoopConfig 0xf7299877

/*!
 * ICEDpyRunLoopConfig
 */
typedef struct ICEDpyRunLoopConfig
{
	const struct ICEDpyRunLoopConfig_vtbl* _vtbl;
} ICEDpyRunLoopConfig;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDpyRunLoopConfig	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEDpyRunLoopConfig_queryInterface) (ICEDpyRunLoopConfig* iDpyRunLoopConfig, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyRunLoopConfig_addRef) (ICEDpyRunLoopConfig* iDpyRunLoopConfig);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyRunLoopConfig_release) (ICEDpyRunLoopConfig* iDpyRunLoopConfig);

typedef CEHResult (*iCEDpyRunLoopConfig_getScreenDimension) (ICEDpyRunLoopConfig* iDpyRunLoopConfig, CEDim *const dimOut);

typedef CEHResult (*iCEDpyRunLoopConfig_getShellCLSID) (ICEDpyRunLoopConfig* iDpyRunLoopConfig, UINT32 *const clsidOut);

	//! DX library's class ID

typedef CEHResult (*iCEDpyRunLoopConfig_getDXCLSID) (ICEDpyRunLoopConfig* iDpyRunLoopConfig, UINT32 *const clsidOut);

/*!
 * V-table of ICEDpyRunLoopConfig
 */
struct ICEDpyRunLoopConfig_vtbl
{
	iCEDpyRunLoopConfig_queryInterface	_queryInterface;	//!< Query interface.
	iCEDpyRunLoopConfig_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEDpyRunLoopConfig_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEDpyRunLoopConfig_getScreenDimension	_getScreenDimension;
	iCEDpyRunLoopConfig_getShellCLSID	_getShellCLSID;
	iCEDpyRunLoopConfig_getDXCLSID	_getDXCLSID;
};

/*! @}
 * end of ICEDpyRunLoopConfig
 */

/*! \defgroup ICEDpyTimerEventListener ICEDpyTimerEventListener
 * @{
 */

/*!
 * ID of ICEDpyTimerEventListener
 */
#define CEComIID_ICEDpyTimerEventListener 0x3c410735

/*!
 * ICEDpyTimerEventListener
 */
typedef struct ICEDpyTimerEventListener
{
	const struct ICEDpyTimerEventListener_vtbl* _vtbl;
} ICEDpyTimerEventListener;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDpyTimerEventListener	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEDpyTimerEventListener_queryInterface) (ICEDpyTimerEventListener* iDpyTimerEventListener, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyTimerEventListener_addRef) (ICEDpyTimerEventListener* iDpyTimerEventListener);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyTimerEventListener_release) (ICEDpyTimerEventListener* iDpyTimerEventListener);

typedef CEHResult (*iCEDpyTimerEventListener_handleTimerEvent) (ICEDpyTimerEventListener* iDpyTimerEventListener, eCEDpyTimerEvent timerEvent, INT64 currentTimeInUSec);

/*!
 * V-table of ICEDpyTimerEventListener
 */
struct ICEDpyTimerEventListener_vtbl
{
	iCEDpyTimerEventListener_queryInterface	_queryInterface;	//!< Query interface.
	iCEDpyTimerEventListener_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEDpyTimerEventListener_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEDpyTimerEventListener_handleTimerEvent	_handleTimerEvent;
};

/*! @}
 * end of ICEDpyTimerEventListener
 */

/*! \defgroup ICEDpyTimerManager ICEDpyTimerManager
 * @{
 */

/*!
 * ID of ICEDpyTimerManager
 */
#define CEComIID_ICEDpyTimerManager 0xd5416524

/*!
 * ICEDpyTimerManager
 */
typedef struct ICEDpyTimerManager
{
	const struct ICEDpyTimerManager_vtbl* _vtbl;
} ICEDpyTimerManager;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDpyTimerManager	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEDpyTimerManager_queryInterface) (ICEDpyTimerManager* iDpyTimerManager, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyTimerManager_addRef) (ICEDpyTimerManager* iDpyTimerManager);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyTimerManager_release) (ICEDpyTimerManager* iDpyTimerManager);

typedef CEHResult (*iCEDpyTimerManager_addTimerListener) (ICEDpyTimerManager* iDpyTimerManager, struct ICEDpyTimerEventListener* iListener, INT64 elapsedTimeInUSec);

typedef CEHResult (*iCEDpyTimerManager_removeTimerListener) (ICEDpyTimerManager* iDpyTimerManager, struct ICEDpyTimerEventListener* iListener);

/*!
 * V-table of ICEDpyTimerManager
 */
struct ICEDpyTimerManager_vtbl
{
	iCEDpyTimerManager_queryInterface	_queryInterface;	//!< Query interface.
	iCEDpyTimerManager_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEDpyTimerManager_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEDpyTimerManager_addTimerListener	_addTimerListener;
	iCEDpyTimerManager_removeTimerListener	_removeTimerListener;
};

/*! @}
 * end of ICEDpyTimerManager
 */

/*! \defgroup ICEDpyCustomEventListener ICEDpyCustomEventListener
 * @{
 */

/*!
 * ID of ICEDpyCustomEventListener
 */
#define CEComIID_ICEDpyCustomEventListener 0x57d17d9b

/*!
 * ICEDpyCustomEventListener
 */
typedef struct ICEDpyCustomEventListener
{
	const struct ICEDpyCustomEventListener_vtbl* _vtbl;
} ICEDpyCustomEventListener;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDpyCustomEventListener	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEDpyCustomEventListener_queryInterface) (ICEDpyCustomEventListener* iDpyCustomEventListener, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyCustomEventListener_addRef) (ICEDpyCustomEventListener* iDpyCustomEventListener);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyCustomEventListener_release) (ICEDpyCustomEventListener* iDpyCustomEventListener);

typedef CEHResult (*iCEDpyCustomEventListener_handleCustomEvent) (ICEDpyCustomEventListener* iDpyCustomEventListener, UINT_PTR key, void* userData);

/*!
 * V-table of ICEDpyCustomEventListener
 */
struct ICEDpyCustomEventListener_vtbl
{
	iCEDpyCustomEventListener_queryInterface	_queryInterface;	//!< Query interface.
	iCEDpyCustomEventListener_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEDpyCustomEventListener_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEDpyCustomEventListener_handleCustomEvent	_handleCustomEvent;
};

/*! @}
 * end of ICEDpyCustomEventListener
 */

/*! \defgroup ICEDpyCustomEventManager ICEDpyCustomEventManager
 * @{
 */

/*!
 * ID of ICEDpyCustomEventManager
 */
#define CEComIID_ICEDpyCustomEventManager 0xa6be9c01

/*!
 * ICEDpyCustomEventManager
 */
typedef struct ICEDpyCustomEventManager
{
	const struct ICEDpyCustomEventManager_vtbl* _vtbl;
} ICEDpyCustomEventManager;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDpyCustomEventManager	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEDpyCustomEventManager_queryInterface) (ICEDpyCustomEventManager* iDpyCustomEventManager, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyCustomEventManager_addRef) (ICEDpyCustomEventManager* iDpyCustomEventManager);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyCustomEventManager_release) (ICEDpyCustomEventManager* iDpyCustomEventManager);

typedef CEHResult (*iCEDpyCustomEventManager_addCustomEventListener) (ICEDpyCustomEventManager* iDpyCustomEventManager, UINT_PTR key, struct ICEDpyCustomEventListener* iListener);

typedef CEHResult (*iCEDpyCustomEventManager_removeCustomEventListener) (ICEDpyCustomEventManager* iDpyCustomEventManager, UINT_PTR key, struct ICEDpyCustomEventListener* iListener);

typedef CEHResult (*iCEDpyCustomEventManager_postEvent) (ICEDpyCustomEventManager* iDpyCustomEventManager, UINT_PTR key, void* userData);

/*!
 * V-table of ICEDpyCustomEventManager
 */
struct ICEDpyCustomEventManager_vtbl
{
	iCEDpyCustomEventManager_queryInterface	_queryInterface;	//!< Query interface.
	iCEDpyCustomEventManager_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEDpyCustomEventManager_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEDpyCustomEventManager_addCustomEventListener	_addCustomEventListener;
	iCEDpyCustomEventManager_removeCustomEventListener	_removeCustomEventListener;
	iCEDpyCustomEventManager_postEvent	_postEvent;
};

/*! @}
 * end of ICEDpyCustomEventManager
 */

/*! \defgroup ICEDpyApplicationEventDispatcher ICEDpyApplicationEventDispatcher
 * @{
 */

/*!
 * ID of ICEDpyApplicationEventDispatcher
 */
#define CEComIID_ICEDpyApplicationEventDispatcher 0x3cf46b51

/*!
 * ICEDpyApplicationEventDispatcher
 */
typedef struct ICEDpyApplicationEventDispatcher
{
	const struct ICEDpyApplicationEventDispatcher_vtbl* _vtbl;
} ICEDpyApplicationEventDispatcher;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDpyApplicationEventDispatcher	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEDpyApplicationEventDispatcher_queryInterface) (ICEDpyApplicationEventDispatcher* iDpyApplicationEventDispatcher, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyApplicationEventDispatcher_addRef) (ICEDpyApplicationEventDispatcher* iDpyApplicationEventDispatcher);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyApplicationEventDispatcher_release) (ICEDpyApplicationEventDispatcher* iDpyApplicationEventDispatcher);

typedef CEHResult (*iCEDpyApplicationEventDispatcher_addApplicationEventListener) (ICEDpyApplicationEventDispatcher* iDpyApplicationEventDispatcher, struct ICEDpyApplicationEventListener* listener);

typedef CEHResult (*iCEDpyApplicationEventDispatcher_removeApplicationEventListener) (ICEDpyApplicationEventDispatcher* iDpyApplicationEventDispatcher, struct ICEDpyApplicationEventListener* listener);

typedef CEHResult (*iCEDpyApplicationEventDispatcher_requestApplicationEvent) (ICEDpyApplicationEventDispatcher* iDpyApplicationEventDispatcher);

/*!
 * V-table of ICEDpyApplicationEventDispatcher
 */
struct ICEDpyApplicationEventDispatcher_vtbl
{
	iCEDpyApplicationEventDispatcher_queryInterface	_queryInterface;	//!< Query interface.
	iCEDpyApplicationEventDispatcher_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEDpyApplicationEventDispatcher_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEDpyApplicationEventDispatcher_addApplicationEventListener	_addApplicationEventListener;
	iCEDpyApplicationEventDispatcher_removeApplicationEventListener	_removeApplicationEventListener;
	iCEDpyApplicationEventDispatcher_requestApplicationEvent	_requestApplicationEvent;
};

/*! @}
 * end of ICEDpyApplicationEventDispatcher
 */

/*! \defgroup ICEDpyApplicationEventListener ICEDpyApplicationEventListener
 * @{
 */

/*!
 * ID of ICEDpyApplicationEventListener
 */
#define CEComIID_ICEDpyApplicationEventListener 0xf56f5b84

/*!
 * ICEDpyApplicationEventListener
 */
typedef struct ICEDpyApplicationEventListener
{
	const struct ICEDpyApplicationEventListener_vtbl* _vtbl;
} ICEDpyApplicationEventListener;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iDpyApplicationEventListener	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEDpyApplicationEventListener_queryInterface) (ICEDpyApplicationEventListener* iDpyApplicationEventListener, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyApplicationEventListener_addRef) (ICEDpyApplicationEventListener* iDpyApplicationEventListener);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEDpyApplicationEventListener_release) (ICEDpyApplicationEventListener* iDpyApplicationEventListener);

typedef CEHResult (*iCEDpyApplicationEventListener_replyApplicationEvent) (ICEDpyApplicationEventListener* iDpyApplicationEventListener);

/*!
 * V-table of ICEDpyApplicationEventListener
 */
struct ICEDpyApplicationEventListener_vtbl
{
	iCEDpyApplicationEventListener_queryInterface	_queryInterface;	//!< Query interface.
	iCEDpyApplicationEventListener_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEDpyApplicationEventListener_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEDpyApplicationEventListener_replyApplicationEvent	_replyApplicationEvent;
};

/*! @}
 * end of ICEDpyApplicationEventListener
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEDpyRunLoopRef CEComICEDpyRunLoopRef
 * @{
 */

class CEComICEDpyRunLoopRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEDpyRunLoopRef() : _iDpyRunLoop(0) {}
	CEComICEDpyRunLoopRef(ICEDpyRunLoop* iOther) : _iDpyRunLoop(0)
	{
		if (iOther)
		{
			_iDpyRunLoop = iOther;
			_iDpyRunLoop->_vtbl->_addRef(_iDpyRunLoop);
		}
	}

	CEComICEDpyRunLoopRef(const CEComICEDpyRunLoopRef& other) : _iDpyRunLoop(0)
	{
		if (other._iDpyRunLoop)
		{
			_iDpyRunLoop = other._iDpyRunLoop;
			_iDpyRunLoop->_vtbl->_addRef(_iDpyRunLoop);
		}
	}

	~CEComICEDpyRunLoopRef()
	{
		if (_iDpyRunLoop)
		{
			ICEDpyRunLoop* tmp = _iDpyRunLoop;
			_iDpyRunLoop = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEDpyRunLoop* iDpyRunLoop;
				void* _ptr;
			} uIntf;
			uIntf.iDpyRunLoop = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEDpyRunLoop, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDpyRunLoop)
				{
					ICEDpyRunLoop* tmp = _iDpyRunLoop;
					_iDpyRunLoop = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDpyRunLoop = uIntf.iDpyRunLoop;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEDpyRunLoop* object() const	{ return _iDpyRunLoop; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEDpyRunLoop* iOther)
	{
		if (_iDpyRunLoop)
		{
			ICEDpyRunLoop* tmp = _iDpyRunLoop;
			_iDpyRunLoop = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDpyRunLoop = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEDpyRunLoop* detach()
	{
		ICEDpyRunLoop* iIntf = _iDpyRunLoop;
		_iDpyRunLoop = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEDpyRunLoop* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDpyRunLoop;
		if (_iDpyRunLoop)
		{
			_iDpyRunLoop->_vtbl->_addRef(_iDpyRunLoop);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEDpyRunLoop*() const	{ return _iDpyRunLoop; }
	FORCEINLINE_WITHOUT_DEBUG ICEDpyRunLoop& operator*() const	{ return *_iDpyRunLoop; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDpyRunLoop == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEDpyRunLoop* iOther) const	{ return (_iDpyRunLoop != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEDpyRunLoop* iOther) const	{ return (_iDpyRunLoop == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEDpyRunLoopRef& operator=(const CEComICEDpyRunLoopRef& other)	{ return operator=(other._iDpyRunLoop); }

	CEComICEDpyRunLoopRef& operator=(const ICEDpyRunLoop* iOther)
	{
		if (_iDpyRunLoop != iOther)
		{
			if (_iDpyRunLoop)
			{
				ICEDpyRunLoop* tmp = _iDpyRunLoop;
				_iDpyRunLoop = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDpyRunLoop = const_cast<ICEDpyRunLoop*>(iOther);
			if (_iDpyRunLoop)
			{
				_iDpyRunLoop->_vtbl->_addRef(_iDpyRunLoop);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEDpyRunLoop** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEDpyRunLoopRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDpyRunLoop && "has a com object reference. clear first.");
		return & _iDpyRunLoop; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEDpyRunLoopRef& other)
	{
		bool result = false;
		if (_iDpyRunLoop)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDpyRunLoop);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDpyRunLoop ? _iDpyRunLoop->_vtbl->_queryInterface(_iDpyRunLoop, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDpyRunLoop) { _iDpyRunLoop->_vtbl->_addRef(_iDpyRunLoop); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDpyRunLoop) { _iDpyRunLoop->_vtbl->_release(_iDpyRunLoop); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult run()	{ return _iDpyRunLoop ? _iDpyRunLoop->_vtbl->_run(_iDpyRunLoop) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEDpyRunLoop* _iDpyRunLoop;
};

/*! @}
 * end of CEComICEDpyRunLoopRef
 */

/*! \defgroup CEComICEDpyRunLoopWithExternalListenerRef CEComICEDpyRunLoopWithExternalListenerRef
 * @{
 */

class CEComICEDpyRunLoopWithExternalListenerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEDpyRunLoopWithExternalListenerRef() : _iDpyRunLoopWithExternalListener(0) {}
	CEComICEDpyRunLoopWithExternalListenerRef(ICEDpyRunLoopWithExternalListener* iOther) : _iDpyRunLoopWithExternalListener(0)
	{
		if (iOther)
		{
			_iDpyRunLoopWithExternalListener = iOther;
			_iDpyRunLoopWithExternalListener->_vtbl->_addRef(_iDpyRunLoopWithExternalListener);
		}
	}

	CEComICEDpyRunLoopWithExternalListenerRef(const CEComICEDpyRunLoopWithExternalListenerRef& other) : _iDpyRunLoopWithExternalListener(0)
	{
		if (other._iDpyRunLoopWithExternalListener)
		{
			_iDpyRunLoopWithExternalListener = other._iDpyRunLoopWithExternalListener;
			_iDpyRunLoopWithExternalListener->_vtbl->_addRef(_iDpyRunLoopWithExternalListener);
		}
	}

	~CEComICEDpyRunLoopWithExternalListenerRef()
	{
		if (_iDpyRunLoopWithExternalListener)
		{
			ICEDpyRunLoopWithExternalListener* tmp = _iDpyRunLoopWithExternalListener;
			_iDpyRunLoopWithExternalListener = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEDpyRunLoopWithExternalListener* iDpyRunLoopWithExternalListener;
				void* _ptr;
			} uIntf;
			uIntf.iDpyRunLoopWithExternalListener = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEDpyRunLoopWithExternalListener, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDpyRunLoopWithExternalListener)
				{
					ICEDpyRunLoopWithExternalListener* tmp = _iDpyRunLoopWithExternalListener;
					_iDpyRunLoopWithExternalListener = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDpyRunLoopWithExternalListener = uIntf.iDpyRunLoopWithExternalListener;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEDpyRunLoopWithExternalListener* object() const	{ return _iDpyRunLoopWithExternalListener; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEDpyRunLoopWithExternalListener* iOther)
	{
		if (_iDpyRunLoopWithExternalListener)
		{
			ICEDpyRunLoopWithExternalListener* tmp = _iDpyRunLoopWithExternalListener;
			_iDpyRunLoopWithExternalListener = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDpyRunLoopWithExternalListener = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEDpyRunLoopWithExternalListener* detach()
	{
		ICEDpyRunLoopWithExternalListener* iIntf = _iDpyRunLoopWithExternalListener;
		_iDpyRunLoopWithExternalListener = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEDpyRunLoopWithExternalListener* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDpyRunLoopWithExternalListener;
		if (_iDpyRunLoopWithExternalListener)
		{
			_iDpyRunLoopWithExternalListener->_vtbl->_addRef(_iDpyRunLoopWithExternalListener);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEDpyRunLoopWithExternalListener*() const	{ return _iDpyRunLoopWithExternalListener; }
	FORCEINLINE_WITHOUT_DEBUG ICEDpyRunLoopWithExternalListener& operator*() const	{ return *_iDpyRunLoopWithExternalListener; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDpyRunLoopWithExternalListener == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEDpyRunLoopWithExternalListener* iOther) const	{ return (_iDpyRunLoopWithExternalListener != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEDpyRunLoopWithExternalListener* iOther) const	{ return (_iDpyRunLoopWithExternalListener == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEDpyRunLoopWithExternalListenerRef& operator=(const CEComICEDpyRunLoopWithExternalListenerRef& other)	{ return operator=(other._iDpyRunLoopWithExternalListener); }

	CEComICEDpyRunLoopWithExternalListenerRef& operator=(const ICEDpyRunLoopWithExternalListener* iOther)
	{
		if (_iDpyRunLoopWithExternalListener != iOther)
		{
			if (_iDpyRunLoopWithExternalListener)
			{
				ICEDpyRunLoopWithExternalListener* tmp = _iDpyRunLoopWithExternalListener;
				_iDpyRunLoopWithExternalListener = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDpyRunLoopWithExternalListener = const_cast<ICEDpyRunLoopWithExternalListener*>(iOther);
			if (_iDpyRunLoopWithExternalListener)
			{
				_iDpyRunLoopWithExternalListener->_vtbl->_addRef(_iDpyRunLoopWithExternalListener);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEDpyRunLoopWithExternalListener** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEDpyRunLoopWithExternalListenerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDpyRunLoopWithExternalListener && "has a com object reference. clear first.");
		return & _iDpyRunLoopWithExternalListener; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEDpyRunLoopWithExternalListenerRef& other)
	{
		bool result = false;
		if (_iDpyRunLoopWithExternalListener)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDpyRunLoopWithExternalListener);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDpyRunLoopWithExternalListener ? _iDpyRunLoopWithExternalListener->_vtbl->_queryInterface(_iDpyRunLoopWithExternalListener, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDpyRunLoopWithExternalListener) { _iDpyRunLoopWithExternalListener->_vtbl->_addRef(_iDpyRunLoopWithExternalListener); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDpyRunLoopWithExternalListener) { _iDpyRunLoopWithExternalListener->_vtbl->_release(_iDpyRunLoopWithExternalListener); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult run()	{ return _iDpyRunLoopWithExternalListener ? _iDpyRunLoopWithExternalListener->_vtbl->_run(_iDpyRunLoopWithExternalListener) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult runWithExternalListener(struct ICEDpySyncObjectSignalListener* iListener)	{ return _iDpyRunLoopWithExternalListener ? _iDpyRunLoopWithExternalListener->_vtbl->_runWithExternalListener(_iDpyRunLoopWithExternalListener, iListener) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEDpyRunLoopWithExternalListener* _iDpyRunLoopWithExternalListener;
};

/*! @}
 * end of CEComICEDpyRunLoopWithExternalListenerRef
 */

/*! \defgroup CEComICEDpyPumpListenerRef CEComICEDpyPumpListenerRef
 * @{
 */

class CEComICEDpyPumpListenerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEDpyPumpListenerRef() : _iDpyPumpListener(0) {}
	CEComICEDpyPumpListenerRef(ICEDpyPumpListener* iOther) : _iDpyPumpListener(0)
	{
		if (iOther)
		{
			_iDpyPumpListener = iOther;
			_iDpyPumpListener->_vtbl->_addRef(_iDpyPumpListener);
		}
	}

	CEComICEDpyPumpListenerRef(const CEComICEDpyPumpListenerRef& other) : _iDpyPumpListener(0)
	{
		if (other._iDpyPumpListener)
		{
			_iDpyPumpListener = other._iDpyPumpListener;
			_iDpyPumpListener->_vtbl->_addRef(_iDpyPumpListener);
		}
	}

	~CEComICEDpyPumpListenerRef()
	{
		if (_iDpyPumpListener)
		{
			ICEDpyPumpListener* tmp = _iDpyPumpListener;
			_iDpyPumpListener = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEDpyPumpListener* iDpyPumpListener;
				void* _ptr;
			} uIntf;
			uIntf.iDpyPumpListener = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEDpyPumpListener, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDpyPumpListener)
				{
					ICEDpyPumpListener* tmp = _iDpyPumpListener;
					_iDpyPumpListener = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDpyPumpListener = uIntf.iDpyPumpListener;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEDpyPumpListener* object() const	{ return _iDpyPumpListener; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEDpyPumpListener* iOther)
	{
		if (_iDpyPumpListener)
		{
			ICEDpyPumpListener* tmp = _iDpyPumpListener;
			_iDpyPumpListener = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDpyPumpListener = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEDpyPumpListener* detach()
	{
		ICEDpyPumpListener* iIntf = _iDpyPumpListener;
		_iDpyPumpListener = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEDpyPumpListener* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDpyPumpListener;
		if (_iDpyPumpListener)
		{
			_iDpyPumpListener->_vtbl->_addRef(_iDpyPumpListener);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEDpyPumpListener*() const	{ return _iDpyPumpListener; }
	FORCEINLINE_WITHOUT_DEBUG ICEDpyPumpListener& operator*() const	{ return *_iDpyPumpListener; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDpyPumpListener == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEDpyPumpListener* iOther) const	{ return (_iDpyPumpListener != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEDpyPumpListener* iOther) const	{ return (_iDpyPumpListener == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEDpyPumpListenerRef& operator=(const CEComICEDpyPumpListenerRef& other)	{ return operator=(other._iDpyPumpListener); }

	CEComICEDpyPumpListenerRef& operator=(const ICEDpyPumpListener* iOther)
	{
		if (_iDpyPumpListener != iOther)
		{
			if (_iDpyPumpListener)
			{
				ICEDpyPumpListener* tmp = _iDpyPumpListener;
				_iDpyPumpListener = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDpyPumpListener = const_cast<ICEDpyPumpListener*>(iOther);
			if (_iDpyPumpListener)
			{
				_iDpyPumpListener->_vtbl->_addRef(_iDpyPumpListener);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEDpyPumpListener** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEDpyPumpListenerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDpyPumpListener && "has a com object reference. clear first.");
		return & _iDpyPumpListener; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEDpyPumpListenerRef& other)
	{
		bool result = false;
		if (_iDpyPumpListener)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDpyPumpListener);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDpyPumpListener ? _iDpyPumpListener->_vtbl->_queryInterface(_iDpyPumpListener, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDpyPumpListener) { _iDpyPumpListener->_vtbl->_addRef(_iDpyPumpListener); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDpyPumpListener) { _iDpyPumpListener->_vtbl->_release(_iDpyPumpListener); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handlePumped()	{ return _iDpyPumpListener ? _iDpyPumpListener->_vtbl->_handlePumped(_iDpyPumpListener) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEDpyPumpListener* _iDpyPumpListener;
};

/*! @}
 * end of CEComICEDpyPumpListenerRef
 */

/*! \defgroup CEComICEDpyPumpManagerRef CEComICEDpyPumpManagerRef
 * @{
 */

class CEComICEDpyPumpManagerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEDpyPumpManagerRef() : _iDpyPumpManager(0) {}
	CEComICEDpyPumpManagerRef(ICEDpyPumpManager* iOther) : _iDpyPumpManager(0)
	{
		if (iOther)
		{
			_iDpyPumpManager = iOther;
			_iDpyPumpManager->_vtbl->_addRef(_iDpyPumpManager);
		}
	}

	CEComICEDpyPumpManagerRef(const CEComICEDpyPumpManagerRef& other) : _iDpyPumpManager(0)
	{
		if (other._iDpyPumpManager)
		{
			_iDpyPumpManager = other._iDpyPumpManager;
			_iDpyPumpManager->_vtbl->_addRef(_iDpyPumpManager);
		}
	}

	~CEComICEDpyPumpManagerRef()
	{
		if (_iDpyPumpManager)
		{
			ICEDpyPumpManager* tmp = _iDpyPumpManager;
			_iDpyPumpManager = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEDpyPumpManager* iDpyPumpManager;
				void* _ptr;
			} uIntf;
			uIntf.iDpyPumpManager = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEDpyPumpManager, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDpyPumpManager)
				{
					ICEDpyPumpManager* tmp = _iDpyPumpManager;
					_iDpyPumpManager = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDpyPumpManager = uIntf.iDpyPumpManager;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEDpyPumpManager* object() const	{ return _iDpyPumpManager; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEDpyPumpManager* iOther)
	{
		if (_iDpyPumpManager)
		{
			ICEDpyPumpManager* tmp = _iDpyPumpManager;
			_iDpyPumpManager = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDpyPumpManager = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEDpyPumpManager* detach()
	{
		ICEDpyPumpManager* iIntf = _iDpyPumpManager;
		_iDpyPumpManager = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEDpyPumpManager* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDpyPumpManager;
		if (_iDpyPumpManager)
		{
			_iDpyPumpManager->_vtbl->_addRef(_iDpyPumpManager);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEDpyPumpManager*() const	{ return _iDpyPumpManager; }
	FORCEINLINE_WITHOUT_DEBUG ICEDpyPumpManager& operator*() const	{ return *_iDpyPumpManager; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDpyPumpManager == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEDpyPumpManager* iOther) const	{ return (_iDpyPumpManager != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEDpyPumpManager* iOther) const	{ return (_iDpyPumpManager == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEDpyPumpManagerRef& operator=(const CEComICEDpyPumpManagerRef& other)	{ return operator=(other._iDpyPumpManager); }

	CEComICEDpyPumpManagerRef& operator=(const ICEDpyPumpManager* iOther)
	{
		if (_iDpyPumpManager != iOther)
		{
			if (_iDpyPumpManager)
			{
				ICEDpyPumpManager* tmp = _iDpyPumpManager;
				_iDpyPumpManager = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDpyPumpManager = const_cast<ICEDpyPumpManager*>(iOther);
			if (_iDpyPumpManager)
			{
				_iDpyPumpManager->_vtbl->_addRef(_iDpyPumpManager);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEDpyPumpManager** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEDpyPumpManagerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDpyPumpManager && "has a com object reference. clear first.");
		return & _iDpyPumpManager; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEDpyPumpManagerRef& other)
	{
		bool result = false;
		if (_iDpyPumpManager)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDpyPumpManager);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDpyPumpManager ? _iDpyPumpManager->_vtbl->_queryInterface(_iDpyPumpManager, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDpyPumpManager) { _iDpyPumpManager->_vtbl->_addRef(_iDpyPumpManager); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDpyPumpManager) { _iDpyPumpManager->_vtbl->_release(_iDpyPumpManager); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setListener(struct ICEDpyPumpListener* listener)	{ return _iDpyPumpManager ? _iDpyPumpManager->_vtbl->_setListener(_iDpyPumpManager, listener) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult pump()	{ return _iDpyPumpManager ? _iDpyPumpManager->_vtbl->_pump(_iDpyPumpManager) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEDpyPumpManager* _iDpyPumpManager;
};

/*! @}
 * end of CEComICEDpyPumpManagerRef
 */

/*! \defgroup CEComICEDpyRunLoopConfigRef CEComICEDpyRunLoopConfigRef
 * @{
 */

class CEComICEDpyRunLoopConfigRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEDpyRunLoopConfigRef() : _iDpyRunLoopConfig(0) {}
	CEComICEDpyRunLoopConfigRef(ICEDpyRunLoopConfig* iOther) : _iDpyRunLoopConfig(0)
	{
		if (iOther)
		{
			_iDpyRunLoopConfig = iOther;
			_iDpyRunLoopConfig->_vtbl->_addRef(_iDpyRunLoopConfig);
		}
	}

	CEComICEDpyRunLoopConfigRef(const CEComICEDpyRunLoopConfigRef& other) : _iDpyRunLoopConfig(0)
	{
		if (other._iDpyRunLoopConfig)
		{
			_iDpyRunLoopConfig = other._iDpyRunLoopConfig;
			_iDpyRunLoopConfig->_vtbl->_addRef(_iDpyRunLoopConfig);
		}
	}

	~CEComICEDpyRunLoopConfigRef()
	{
		if (_iDpyRunLoopConfig)
		{
			ICEDpyRunLoopConfig* tmp = _iDpyRunLoopConfig;
			_iDpyRunLoopConfig = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEDpyRunLoopConfig* iDpyRunLoopConfig;
				void* _ptr;
			} uIntf;
			uIntf.iDpyRunLoopConfig = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEDpyRunLoopConfig, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDpyRunLoopConfig)
				{
					ICEDpyRunLoopConfig* tmp = _iDpyRunLoopConfig;
					_iDpyRunLoopConfig = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDpyRunLoopConfig = uIntf.iDpyRunLoopConfig;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEDpyRunLoopConfig* object() const	{ return _iDpyRunLoopConfig; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEDpyRunLoopConfig* iOther)
	{
		if (_iDpyRunLoopConfig)
		{
			ICEDpyRunLoopConfig* tmp = _iDpyRunLoopConfig;
			_iDpyRunLoopConfig = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDpyRunLoopConfig = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEDpyRunLoopConfig* detach()
	{
		ICEDpyRunLoopConfig* iIntf = _iDpyRunLoopConfig;
		_iDpyRunLoopConfig = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEDpyRunLoopConfig* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDpyRunLoopConfig;
		if (_iDpyRunLoopConfig)
		{
			_iDpyRunLoopConfig->_vtbl->_addRef(_iDpyRunLoopConfig);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEDpyRunLoopConfig*() const	{ return _iDpyRunLoopConfig; }
	FORCEINLINE_WITHOUT_DEBUG ICEDpyRunLoopConfig& operator*() const	{ return *_iDpyRunLoopConfig; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDpyRunLoopConfig == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEDpyRunLoopConfig* iOther) const	{ return (_iDpyRunLoopConfig != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEDpyRunLoopConfig* iOther) const	{ return (_iDpyRunLoopConfig == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEDpyRunLoopConfigRef& operator=(const CEComICEDpyRunLoopConfigRef& other)	{ return operator=(other._iDpyRunLoopConfig); }

	CEComICEDpyRunLoopConfigRef& operator=(const ICEDpyRunLoopConfig* iOther)
	{
		if (_iDpyRunLoopConfig != iOther)
		{
			if (_iDpyRunLoopConfig)
			{
				ICEDpyRunLoopConfig* tmp = _iDpyRunLoopConfig;
				_iDpyRunLoopConfig = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDpyRunLoopConfig = const_cast<ICEDpyRunLoopConfig*>(iOther);
			if (_iDpyRunLoopConfig)
			{
				_iDpyRunLoopConfig->_vtbl->_addRef(_iDpyRunLoopConfig);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEDpyRunLoopConfig** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEDpyRunLoopConfigRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDpyRunLoopConfig && "has a com object reference. clear first.");
		return & _iDpyRunLoopConfig; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEDpyRunLoopConfigRef& other)
	{
		bool result = false;
		if (_iDpyRunLoopConfig)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDpyRunLoopConfig);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDpyRunLoopConfig ? _iDpyRunLoopConfig->_vtbl->_queryInterface(_iDpyRunLoopConfig, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDpyRunLoopConfig) { _iDpyRunLoopConfig->_vtbl->_addRef(_iDpyRunLoopConfig); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDpyRunLoopConfig) { _iDpyRunLoopConfig->_vtbl->_release(_iDpyRunLoopConfig); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getScreenDimension(CEDim *const dimOut)	{ return _iDpyRunLoopConfig ? _iDpyRunLoopConfig->_vtbl->_getScreenDimension(_iDpyRunLoopConfig, dimOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getShellCLSID(UINT32 *const clsidOut)	{ return _iDpyRunLoopConfig ? _iDpyRunLoopConfig->_vtbl->_getShellCLSID(_iDpyRunLoopConfig, clsidOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDXCLSID(UINT32 *const clsidOut)	{ return _iDpyRunLoopConfig ? _iDpyRunLoopConfig->_vtbl->_getDXCLSID(_iDpyRunLoopConfig, clsidOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEDpyRunLoopConfig* _iDpyRunLoopConfig;
};

/*! @}
 * end of CEComICEDpyRunLoopConfigRef
 */

/*! \defgroup CEComICEDpyTimerEventListenerRef CEComICEDpyTimerEventListenerRef
 * @{
 */

class CEComICEDpyTimerEventListenerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEDpyTimerEventListenerRef() : _iDpyTimerEventListener(0) {}
	CEComICEDpyTimerEventListenerRef(ICEDpyTimerEventListener* iOther) : _iDpyTimerEventListener(0)
	{
		if (iOther)
		{
			_iDpyTimerEventListener = iOther;
			_iDpyTimerEventListener->_vtbl->_addRef(_iDpyTimerEventListener);
		}
	}

	CEComICEDpyTimerEventListenerRef(const CEComICEDpyTimerEventListenerRef& other) : _iDpyTimerEventListener(0)
	{
		if (other._iDpyTimerEventListener)
		{
			_iDpyTimerEventListener = other._iDpyTimerEventListener;
			_iDpyTimerEventListener->_vtbl->_addRef(_iDpyTimerEventListener);
		}
	}

	~CEComICEDpyTimerEventListenerRef()
	{
		if (_iDpyTimerEventListener)
		{
			ICEDpyTimerEventListener* tmp = _iDpyTimerEventListener;
			_iDpyTimerEventListener = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEDpyTimerEventListener* iDpyTimerEventListener;
				void* _ptr;
			} uIntf;
			uIntf.iDpyTimerEventListener = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEDpyTimerEventListener, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDpyTimerEventListener)
				{
					ICEDpyTimerEventListener* tmp = _iDpyTimerEventListener;
					_iDpyTimerEventListener = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDpyTimerEventListener = uIntf.iDpyTimerEventListener;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEDpyTimerEventListener* object() const	{ return _iDpyTimerEventListener; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEDpyTimerEventListener* iOther)
	{
		if (_iDpyTimerEventListener)
		{
			ICEDpyTimerEventListener* tmp = _iDpyTimerEventListener;
			_iDpyTimerEventListener = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDpyTimerEventListener = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEDpyTimerEventListener* detach()
	{
		ICEDpyTimerEventListener* iIntf = _iDpyTimerEventListener;
		_iDpyTimerEventListener = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEDpyTimerEventListener* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDpyTimerEventListener;
		if (_iDpyTimerEventListener)
		{
			_iDpyTimerEventListener->_vtbl->_addRef(_iDpyTimerEventListener);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEDpyTimerEventListener*() const	{ return _iDpyTimerEventListener; }
	FORCEINLINE_WITHOUT_DEBUG ICEDpyTimerEventListener& operator*() const	{ return *_iDpyTimerEventListener; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDpyTimerEventListener == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEDpyTimerEventListener* iOther) const	{ return (_iDpyTimerEventListener != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEDpyTimerEventListener* iOther) const	{ return (_iDpyTimerEventListener == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEDpyTimerEventListenerRef& operator=(const CEComICEDpyTimerEventListenerRef& other)	{ return operator=(other._iDpyTimerEventListener); }

	CEComICEDpyTimerEventListenerRef& operator=(const ICEDpyTimerEventListener* iOther)
	{
		if (_iDpyTimerEventListener != iOther)
		{
			if (_iDpyTimerEventListener)
			{
				ICEDpyTimerEventListener* tmp = _iDpyTimerEventListener;
				_iDpyTimerEventListener = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDpyTimerEventListener = const_cast<ICEDpyTimerEventListener*>(iOther);
			if (_iDpyTimerEventListener)
			{
				_iDpyTimerEventListener->_vtbl->_addRef(_iDpyTimerEventListener);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEDpyTimerEventListener** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEDpyTimerEventListenerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDpyTimerEventListener && "has a com object reference. clear first.");
		return & _iDpyTimerEventListener; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEDpyTimerEventListenerRef& other)
	{
		bool result = false;
		if (_iDpyTimerEventListener)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDpyTimerEventListener);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDpyTimerEventListener ? _iDpyTimerEventListener->_vtbl->_queryInterface(_iDpyTimerEventListener, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDpyTimerEventListener) { _iDpyTimerEventListener->_vtbl->_addRef(_iDpyTimerEventListener); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDpyTimerEventListener) { _iDpyTimerEventListener->_vtbl->_release(_iDpyTimerEventListener); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleTimerEvent(eCEDpyTimerEvent timerEvent, INT64 currentTimeInUSec)	{ return _iDpyTimerEventListener ? _iDpyTimerEventListener->_vtbl->_handleTimerEvent(_iDpyTimerEventListener, timerEvent, currentTimeInUSec) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEDpyTimerEventListener* _iDpyTimerEventListener;
};

/*! @}
 * end of CEComICEDpyTimerEventListenerRef
 */

/*! \defgroup CEComICEDpyTimerManagerRef CEComICEDpyTimerManagerRef
 * @{
 */

class CEComICEDpyTimerManagerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEDpyTimerManagerRef() : _iDpyTimerManager(0) {}
	CEComICEDpyTimerManagerRef(ICEDpyTimerManager* iOther) : _iDpyTimerManager(0)
	{
		if (iOther)
		{
			_iDpyTimerManager = iOther;
			_iDpyTimerManager->_vtbl->_addRef(_iDpyTimerManager);
		}
	}

	CEComICEDpyTimerManagerRef(const CEComICEDpyTimerManagerRef& other) : _iDpyTimerManager(0)
	{
		if (other._iDpyTimerManager)
		{
			_iDpyTimerManager = other._iDpyTimerManager;
			_iDpyTimerManager->_vtbl->_addRef(_iDpyTimerManager);
		}
	}

	~CEComICEDpyTimerManagerRef()
	{
		if (_iDpyTimerManager)
		{
			ICEDpyTimerManager* tmp = _iDpyTimerManager;
			_iDpyTimerManager = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEDpyTimerManager* iDpyTimerManager;
				void* _ptr;
			} uIntf;
			uIntf.iDpyTimerManager = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEDpyTimerManager, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDpyTimerManager)
				{
					ICEDpyTimerManager* tmp = _iDpyTimerManager;
					_iDpyTimerManager = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDpyTimerManager = uIntf.iDpyTimerManager;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEDpyTimerManager* object() const	{ return _iDpyTimerManager; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEDpyTimerManager* iOther)
	{
		if (_iDpyTimerManager)
		{
			ICEDpyTimerManager* tmp = _iDpyTimerManager;
			_iDpyTimerManager = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDpyTimerManager = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEDpyTimerManager* detach()
	{
		ICEDpyTimerManager* iIntf = _iDpyTimerManager;
		_iDpyTimerManager = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEDpyTimerManager* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDpyTimerManager;
		if (_iDpyTimerManager)
		{
			_iDpyTimerManager->_vtbl->_addRef(_iDpyTimerManager);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEDpyTimerManager*() const	{ return _iDpyTimerManager; }
	FORCEINLINE_WITHOUT_DEBUG ICEDpyTimerManager& operator*() const	{ return *_iDpyTimerManager; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDpyTimerManager == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEDpyTimerManager* iOther) const	{ return (_iDpyTimerManager != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEDpyTimerManager* iOther) const	{ return (_iDpyTimerManager == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEDpyTimerManagerRef& operator=(const CEComICEDpyTimerManagerRef& other)	{ return operator=(other._iDpyTimerManager); }

	CEComICEDpyTimerManagerRef& operator=(const ICEDpyTimerManager* iOther)
	{
		if (_iDpyTimerManager != iOther)
		{
			if (_iDpyTimerManager)
			{
				ICEDpyTimerManager* tmp = _iDpyTimerManager;
				_iDpyTimerManager = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDpyTimerManager = const_cast<ICEDpyTimerManager*>(iOther);
			if (_iDpyTimerManager)
			{
				_iDpyTimerManager->_vtbl->_addRef(_iDpyTimerManager);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEDpyTimerManager** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEDpyTimerManagerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDpyTimerManager && "has a com object reference. clear first.");
		return & _iDpyTimerManager; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEDpyTimerManagerRef& other)
	{
		bool result = false;
		if (_iDpyTimerManager)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDpyTimerManager);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDpyTimerManager ? _iDpyTimerManager->_vtbl->_queryInterface(_iDpyTimerManager, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDpyTimerManager) { _iDpyTimerManager->_vtbl->_addRef(_iDpyTimerManager); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDpyTimerManager) { _iDpyTimerManager->_vtbl->_release(_iDpyTimerManager); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult addTimerListener(struct ICEDpyTimerEventListener* iListener, INT64 elapsedTimeInUSec)	{ return _iDpyTimerManager ? _iDpyTimerManager->_vtbl->_addTimerListener(_iDpyTimerManager, iListener, elapsedTimeInUSec) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult removeTimerListener(struct ICEDpyTimerEventListener* iListener)	{ return _iDpyTimerManager ? _iDpyTimerManager->_vtbl->_removeTimerListener(_iDpyTimerManager, iListener) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEDpyTimerManager* _iDpyTimerManager;
};

/*! @}
 * end of CEComICEDpyTimerManagerRef
 */

/*! \defgroup CEComICEDpyCustomEventListenerRef CEComICEDpyCustomEventListenerRef
 * @{
 */

class CEComICEDpyCustomEventListenerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEDpyCustomEventListenerRef() : _iDpyCustomEventListener(0) {}
	CEComICEDpyCustomEventListenerRef(ICEDpyCustomEventListener* iOther) : _iDpyCustomEventListener(0)
	{
		if (iOther)
		{
			_iDpyCustomEventListener = iOther;
			_iDpyCustomEventListener->_vtbl->_addRef(_iDpyCustomEventListener);
		}
	}

	CEComICEDpyCustomEventListenerRef(const CEComICEDpyCustomEventListenerRef& other) : _iDpyCustomEventListener(0)
	{
		if (other._iDpyCustomEventListener)
		{
			_iDpyCustomEventListener = other._iDpyCustomEventListener;
			_iDpyCustomEventListener->_vtbl->_addRef(_iDpyCustomEventListener);
		}
	}

	~CEComICEDpyCustomEventListenerRef()
	{
		if (_iDpyCustomEventListener)
		{
			ICEDpyCustomEventListener* tmp = _iDpyCustomEventListener;
			_iDpyCustomEventListener = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEDpyCustomEventListener* iDpyCustomEventListener;
				void* _ptr;
			} uIntf;
			uIntf.iDpyCustomEventListener = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEDpyCustomEventListener, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDpyCustomEventListener)
				{
					ICEDpyCustomEventListener* tmp = _iDpyCustomEventListener;
					_iDpyCustomEventListener = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDpyCustomEventListener = uIntf.iDpyCustomEventListener;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEDpyCustomEventListener* object() const	{ return _iDpyCustomEventListener; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEDpyCustomEventListener* iOther)
	{
		if (_iDpyCustomEventListener)
		{
			ICEDpyCustomEventListener* tmp = _iDpyCustomEventListener;
			_iDpyCustomEventListener = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDpyCustomEventListener = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEDpyCustomEventListener* detach()
	{
		ICEDpyCustomEventListener* iIntf = _iDpyCustomEventListener;
		_iDpyCustomEventListener = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEDpyCustomEventListener* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDpyCustomEventListener;
		if (_iDpyCustomEventListener)
		{
			_iDpyCustomEventListener->_vtbl->_addRef(_iDpyCustomEventListener);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEDpyCustomEventListener*() const	{ return _iDpyCustomEventListener; }
	FORCEINLINE_WITHOUT_DEBUG ICEDpyCustomEventListener& operator*() const	{ return *_iDpyCustomEventListener; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDpyCustomEventListener == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEDpyCustomEventListener* iOther) const	{ return (_iDpyCustomEventListener != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEDpyCustomEventListener* iOther) const	{ return (_iDpyCustomEventListener == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEDpyCustomEventListenerRef& operator=(const CEComICEDpyCustomEventListenerRef& other)	{ return operator=(other._iDpyCustomEventListener); }

	CEComICEDpyCustomEventListenerRef& operator=(const ICEDpyCustomEventListener* iOther)
	{
		if (_iDpyCustomEventListener != iOther)
		{
			if (_iDpyCustomEventListener)
			{
				ICEDpyCustomEventListener* tmp = _iDpyCustomEventListener;
				_iDpyCustomEventListener = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDpyCustomEventListener = const_cast<ICEDpyCustomEventListener*>(iOther);
			if (_iDpyCustomEventListener)
			{
				_iDpyCustomEventListener->_vtbl->_addRef(_iDpyCustomEventListener);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEDpyCustomEventListener** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEDpyCustomEventListenerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDpyCustomEventListener && "has a com object reference. clear first.");
		return & _iDpyCustomEventListener; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEDpyCustomEventListenerRef& other)
	{
		bool result = false;
		if (_iDpyCustomEventListener)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDpyCustomEventListener);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDpyCustomEventListener ? _iDpyCustomEventListener->_vtbl->_queryInterface(_iDpyCustomEventListener, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDpyCustomEventListener) { _iDpyCustomEventListener->_vtbl->_addRef(_iDpyCustomEventListener); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDpyCustomEventListener) { _iDpyCustomEventListener->_vtbl->_release(_iDpyCustomEventListener); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleCustomEvent(UINT_PTR key, void* userData)	{ return _iDpyCustomEventListener ? _iDpyCustomEventListener->_vtbl->_handleCustomEvent(_iDpyCustomEventListener, key, userData) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEDpyCustomEventListener* _iDpyCustomEventListener;
};

/*! @}
 * end of CEComICEDpyCustomEventListenerRef
 */

/*! \defgroup CEComICEDpyCustomEventManagerRef CEComICEDpyCustomEventManagerRef
 * @{
 */

class CEComICEDpyCustomEventManagerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEDpyCustomEventManagerRef() : _iDpyCustomEventManager(0) {}
	CEComICEDpyCustomEventManagerRef(ICEDpyCustomEventManager* iOther) : _iDpyCustomEventManager(0)
	{
		if (iOther)
		{
			_iDpyCustomEventManager = iOther;
			_iDpyCustomEventManager->_vtbl->_addRef(_iDpyCustomEventManager);
		}
	}

	CEComICEDpyCustomEventManagerRef(const CEComICEDpyCustomEventManagerRef& other) : _iDpyCustomEventManager(0)
	{
		if (other._iDpyCustomEventManager)
		{
			_iDpyCustomEventManager = other._iDpyCustomEventManager;
			_iDpyCustomEventManager->_vtbl->_addRef(_iDpyCustomEventManager);
		}
	}

	~CEComICEDpyCustomEventManagerRef()
	{
		if (_iDpyCustomEventManager)
		{
			ICEDpyCustomEventManager* tmp = _iDpyCustomEventManager;
			_iDpyCustomEventManager = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEDpyCustomEventManager* iDpyCustomEventManager;
				void* _ptr;
			} uIntf;
			uIntf.iDpyCustomEventManager = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEDpyCustomEventManager, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDpyCustomEventManager)
				{
					ICEDpyCustomEventManager* tmp = _iDpyCustomEventManager;
					_iDpyCustomEventManager = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDpyCustomEventManager = uIntf.iDpyCustomEventManager;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEDpyCustomEventManager* object() const	{ return _iDpyCustomEventManager; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEDpyCustomEventManager* iOther)
	{
		if (_iDpyCustomEventManager)
		{
			ICEDpyCustomEventManager* tmp = _iDpyCustomEventManager;
			_iDpyCustomEventManager = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDpyCustomEventManager = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEDpyCustomEventManager* detach()
	{
		ICEDpyCustomEventManager* iIntf = _iDpyCustomEventManager;
		_iDpyCustomEventManager = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEDpyCustomEventManager* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDpyCustomEventManager;
		if (_iDpyCustomEventManager)
		{
			_iDpyCustomEventManager->_vtbl->_addRef(_iDpyCustomEventManager);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEDpyCustomEventManager*() const	{ return _iDpyCustomEventManager; }
	FORCEINLINE_WITHOUT_DEBUG ICEDpyCustomEventManager& operator*() const	{ return *_iDpyCustomEventManager; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDpyCustomEventManager == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEDpyCustomEventManager* iOther) const	{ return (_iDpyCustomEventManager != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEDpyCustomEventManager* iOther) const	{ return (_iDpyCustomEventManager == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEDpyCustomEventManagerRef& operator=(const CEComICEDpyCustomEventManagerRef& other)	{ return operator=(other._iDpyCustomEventManager); }

	CEComICEDpyCustomEventManagerRef& operator=(const ICEDpyCustomEventManager* iOther)
	{
		if (_iDpyCustomEventManager != iOther)
		{
			if (_iDpyCustomEventManager)
			{
				ICEDpyCustomEventManager* tmp = _iDpyCustomEventManager;
				_iDpyCustomEventManager = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDpyCustomEventManager = const_cast<ICEDpyCustomEventManager*>(iOther);
			if (_iDpyCustomEventManager)
			{
				_iDpyCustomEventManager->_vtbl->_addRef(_iDpyCustomEventManager);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEDpyCustomEventManager** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEDpyCustomEventManagerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDpyCustomEventManager && "has a com object reference. clear first.");
		return & _iDpyCustomEventManager; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEDpyCustomEventManagerRef& other)
	{
		bool result = false;
		if (_iDpyCustomEventManager)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDpyCustomEventManager);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDpyCustomEventManager ? _iDpyCustomEventManager->_vtbl->_queryInterface(_iDpyCustomEventManager, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDpyCustomEventManager) { _iDpyCustomEventManager->_vtbl->_addRef(_iDpyCustomEventManager); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDpyCustomEventManager) { _iDpyCustomEventManager->_vtbl->_release(_iDpyCustomEventManager); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult addCustomEventListener(UINT_PTR key, struct ICEDpyCustomEventListener* iListener)	{ return _iDpyCustomEventManager ? _iDpyCustomEventManager->_vtbl->_addCustomEventListener(_iDpyCustomEventManager, key, iListener) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult removeCustomEventListener(UINT_PTR key, struct ICEDpyCustomEventListener* iListener)	{ return _iDpyCustomEventManager ? _iDpyCustomEventManager->_vtbl->_removeCustomEventListener(_iDpyCustomEventManager, key, iListener) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult postEvent(UINT_PTR key, void* userData)	{ return _iDpyCustomEventManager ? _iDpyCustomEventManager->_vtbl->_postEvent(_iDpyCustomEventManager, key, userData) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEDpyCustomEventManager* _iDpyCustomEventManager;
};

/*! @}
 * end of CEComICEDpyCustomEventManagerRef
 */

/*! \defgroup CEComICEDpyApplicationEventDispatcherRef CEComICEDpyApplicationEventDispatcherRef
 * @{
 */

class CEComICEDpyApplicationEventDispatcherRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEDpyApplicationEventDispatcherRef() : _iDpyApplicationEventDispatcher(0) {}
	CEComICEDpyApplicationEventDispatcherRef(ICEDpyApplicationEventDispatcher* iOther) : _iDpyApplicationEventDispatcher(0)
	{
		if (iOther)
		{
			_iDpyApplicationEventDispatcher = iOther;
			_iDpyApplicationEventDispatcher->_vtbl->_addRef(_iDpyApplicationEventDispatcher);
		}
	}

	CEComICEDpyApplicationEventDispatcherRef(const CEComICEDpyApplicationEventDispatcherRef& other) : _iDpyApplicationEventDispatcher(0)
	{
		if (other._iDpyApplicationEventDispatcher)
		{
			_iDpyApplicationEventDispatcher = other._iDpyApplicationEventDispatcher;
			_iDpyApplicationEventDispatcher->_vtbl->_addRef(_iDpyApplicationEventDispatcher);
		}
	}

	~CEComICEDpyApplicationEventDispatcherRef()
	{
		if (_iDpyApplicationEventDispatcher)
		{
			ICEDpyApplicationEventDispatcher* tmp = _iDpyApplicationEventDispatcher;
			_iDpyApplicationEventDispatcher = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEDpyApplicationEventDispatcher* iDpyApplicationEventDispatcher;
				void* _ptr;
			} uIntf;
			uIntf.iDpyApplicationEventDispatcher = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEDpyApplicationEventDispatcher, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDpyApplicationEventDispatcher)
				{
					ICEDpyApplicationEventDispatcher* tmp = _iDpyApplicationEventDispatcher;
					_iDpyApplicationEventDispatcher = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDpyApplicationEventDispatcher = uIntf.iDpyApplicationEventDispatcher;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEDpyApplicationEventDispatcher* object() const	{ return _iDpyApplicationEventDispatcher; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEDpyApplicationEventDispatcher* iOther)
	{
		if (_iDpyApplicationEventDispatcher)
		{
			ICEDpyApplicationEventDispatcher* tmp = _iDpyApplicationEventDispatcher;
			_iDpyApplicationEventDispatcher = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDpyApplicationEventDispatcher = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEDpyApplicationEventDispatcher* detach()
	{
		ICEDpyApplicationEventDispatcher* iIntf = _iDpyApplicationEventDispatcher;
		_iDpyApplicationEventDispatcher = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEDpyApplicationEventDispatcher* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDpyApplicationEventDispatcher;
		if (_iDpyApplicationEventDispatcher)
		{
			_iDpyApplicationEventDispatcher->_vtbl->_addRef(_iDpyApplicationEventDispatcher);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEDpyApplicationEventDispatcher*() const	{ return _iDpyApplicationEventDispatcher; }
	FORCEINLINE_WITHOUT_DEBUG ICEDpyApplicationEventDispatcher& operator*() const	{ return *_iDpyApplicationEventDispatcher; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDpyApplicationEventDispatcher == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEDpyApplicationEventDispatcher* iOther) const	{ return (_iDpyApplicationEventDispatcher != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEDpyApplicationEventDispatcher* iOther) const	{ return (_iDpyApplicationEventDispatcher == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEDpyApplicationEventDispatcherRef& operator=(const CEComICEDpyApplicationEventDispatcherRef& other)	{ return operator=(other._iDpyApplicationEventDispatcher); }

	CEComICEDpyApplicationEventDispatcherRef& operator=(const ICEDpyApplicationEventDispatcher* iOther)
	{
		if (_iDpyApplicationEventDispatcher != iOther)
		{
			if (_iDpyApplicationEventDispatcher)
			{
				ICEDpyApplicationEventDispatcher* tmp = _iDpyApplicationEventDispatcher;
				_iDpyApplicationEventDispatcher = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDpyApplicationEventDispatcher = const_cast<ICEDpyApplicationEventDispatcher*>(iOther);
			if (_iDpyApplicationEventDispatcher)
			{
				_iDpyApplicationEventDispatcher->_vtbl->_addRef(_iDpyApplicationEventDispatcher);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEDpyApplicationEventDispatcher** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEDpyApplicationEventDispatcherRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDpyApplicationEventDispatcher && "has a com object reference. clear first.");
		return & _iDpyApplicationEventDispatcher; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEDpyApplicationEventDispatcherRef& other)
	{
		bool result = false;
		if (_iDpyApplicationEventDispatcher)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDpyApplicationEventDispatcher);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDpyApplicationEventDispatcher ? _iDpyApplicationEventDispatcher->_vtbl->_queryInterface(_iDpyApplicationEventDispatcher, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDpyApplicationEventDispatcher) { _iDpyApplicationEventDispatcher->_vtbl->_addRef(_iDpyApplicationEventDispatcher); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDpyApplicationEventDispatcher) { _iDpyApplicationEventDispatcher->_vtbl->_release(_iDpyApplicationEventDispatcher); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult addApplicationEventListener(struct ICEDpyApplicationEventListener* listener)	{ return _iDpyApplicationEventDispatcher ? _iDpyApplicationEventDispatcher->_vtbl->_addApplicationEventListener(_iDpyApplicationEventDispatcher, listener) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult removeApplicationEventListener(struct ICEDpyApplicationEventListener* listener)	{ return _iDpyApplicationEventDispatcher ? _iDpyApplicationEventDispatcher->_vtbl->_removeApplicationEventListener(_iDpyApplicationEventDispatcher, listener) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult requestApplicationEvent()	{ return _iDpyApplicationEventDispatcher ? _iDpyApplicationEventDispatcher->_vtbl->_requestApplicationEvent(_iDpyApplicationEventDispatcher) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEDpyApplicationEventDispatcher* _iDpyApplicationEventDispatcher;
};

/*! @}
 * end of CEComICEDpyApplicationEventDispatcherRef
 */

/*! \defgroup CEComICEDpyApplicationEventListenerRef CEComICEDpyApplicationEventListenerRef
 * @{
 */

class CEComICEDpyApplicationEventListenerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEDpyApplicationEventListenerRef() : _iDpyApplicationEventListener(0) {}
	CEComICEDpyApplicationEventListenerRef(ICEDpyApplicationEventListener* iOther) : _iDpyApplicationEventListener(0)
	{
		if (iOther)
		{
			_iDpyApplicationEventListener = iOther;
			_iDpyApplicationEventListener->_vtbl->_addRef(_iDpyApplicationEventListener);
		}
	}

	CEComICEDpyApplicationEventListenerRef(const CEComICEDpyApplicationEventListenerRef& other) : _iDpyApplicationEventListener(0)
	{
		if (other._iDpyApplicationEventListener)
		{
			_iDpyApplicationEventListener = other._iDpyApplicationEventListener;
			_iDpyApplicationEventListener->_vtbl->_addRef(_iDpyApplicationEventListener);
		}
	}

	~CEComICEDpyApplicationEventListenerRef()
	{
		if (_iDpyApplicationEventListener)
		{
			ICEDpyApplicationEventListener* tmp = _iDpyApplicationEventListener;
			_iDpyApplicationEventListener = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEDpyApplicationEventListener* iDpyApplicationEventListener;
				void* _ptr;
			} uIntf;
			uIntf.iDpyApplicationEventListener = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEDpyApplicationEventListener, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iDpyApplicationEventListener)
				{
					ICEDpyApplicationEventListener* tmp = _iDpyApplicationEventListener;
					_iDpyApplicationEventListener = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iDpyApplicationEventListener = uIntf.iDpyApplicationEventListener;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEDpyApplicationEventListener* object() const	{ return _iDpyApplicationEventListener; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEDpyApplicationEventListener* iOther)
	{
		if (_iDpyApplicationEventListener)
		{
			ICEDpyApplicationEventListener* tmp = _iDpyApplicationEventListener;
			_iDpyApplicationEventListener = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iDpyApplicationEventListener = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEDpyApplicationEventListener* detach()
	{
		ICEDpyApplicationEventListener* iIntf = _iDpyApplicationEventListener;
		_iDpyApplicationEventListener = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEDpyApplicationEventListener* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iDpyApplicationEventListener;
		if (_iDpyApplicationEventListener)
		{
			_iDpyApplicationEventListener->_vtbl->_addRef(_iDpyApplicationEventListener);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEDpyApplicationEventListener*() const	{ return _iDpyApplicationEventListener; }
	FORCEINLINE_WITHOUT_DEBUG ICEDpyApplicationEventListener& operator*() const	{ return *_iDpyApplicationEventListener; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iDpyApplicationEventListener == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEDpyApplicationEventListener* iOther) const	{ return (_iDpyApplicationEventListener != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEDpyApplicationEventListener* iOther) const	{ return (_iDpyApplicationEventListener == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEDpyApplicationEventListenerRef& operator=(const CEComICEDpyApplicationEventListenerRef& other)	{ return operator=(other._iDpyApplicationEventListener); }

	CEComICEDpyApplicationEventListenerRef& operator=(const ICEDpyApplicationEventListener* iOther)
	{
		if (_iDpyApplicationEventListener != iOther)
		{
			if (_iDpyApplicationEventListener)
			{
				ICEDpyApplicationEventListener* tmp = _iDpyApplicationEventListener;
				_iDpyApplicationEventListener = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iDpyApplicationEventListener = const_cast<ICEDpyApplicationEventListener*>(iOther);
			if (_iDpyApplicationEventListener)
			{
				_iDpyApplicationEventListener->_vtbl->_addRef(_iDpyApplicationEventListener);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEDpyApplicationEventListener** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEDpyApplicationEventListenerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iDpyApplicationEventListener && "has a com object reference. clear first.");
		return & _iDpyApplicationEventListener; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEDpyApplicationEventListenerRef& other)
	{
		bool result = false;
		if (_iDpyApplicationEventListener)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iDpyApplicationEventListener);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iDpyApplicationEventListener ? _iDpyApplicationEventListener->_vtbl->_queryInterface(_iDpyApplicationEventListener, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iDpyApplicationEventListener) { _iDpyApplicationEventListener->_vtbl->_addRef(_iDpyApplicationEventListener); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iDpyApplicationEventListener) { _iDpyApplicationEventListener->_vtbl->_release(_iDpyApplicationEventListener); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult replyApplicationEvent()	{ return _iDpyApplicationEventListener ? _iDpyApplicationEventListener->_vtbl->_replyApplicationEvent(_iDpyApplicationEventListener) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEDpyApplicationEventListener* _iDpyApplicationEventListener;
};

/*! @}
 * end of CEComICEDpyApplicationEventListenerRef
 */

#endif // __cplusplus

#endif
