///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2007 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CESysTls_h__
#define __CESysTls_h__

#include "CESysConfig.h"

#ifdef __cplusplus
extern "C"
{
#endif

	//! TLS destructor type
	typedef void (*CESysTlsDestructorProc)(void* tlsValue);

	//! allocate TLS slot
	//! \param[out] tlsIndexOut pointer to the variable to receive the allocated TLS slot index
	//! \param[int] destructor  optional function pointer of destructor. The destructor is called
	//!             when CESysThread ends, given TLS value as first arugment. A corresponding
	//!             TLS slot is 0 when the destructor is called. Do not set non-zero value to the
	//!             TLS slot when the destructor returns. The oder of calling destructors is not
	//!             unspecified.
	CE_DLL_EXPORT CEHResult CESysTlsAlloc(UINT32* tlsIndexOut, CESysTlsDestructorProc dtor);

	//! free TLS slot
	CE_DLL_EXPORT void CESysTlsFree(UINT32 tlsIndex);

	//! get TLS slot value
	//! \param[in] tlsIndex  specifies the TLS slot index to get
	CE_DLL_EXPORT void* CESysTlsGetValue(UINT32 tlsIndex);

	//! set TLS slot value
	//! \param[in] tlsIndex  specifies the TLS slot index to set
	//! \param[in] value     specifies the new value to set
	CE_DLL_EXPORT CEHResult CESysTlsSetValue(UINT32 tlsIndex, void* value);

#ifdef __cplusplus
}
#endif

#endif // __CESysTls_h__
