///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2007,2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CESysCriticalSectionLinux_h__
#define __CESysCriticalSectionLinux_h__

#include <pthread.h>

#ifdef __cplusplus
extern "C"
{
#endif

	extern void CESysInitializeCriticalSection(CESysCriticalSection* cs);

	extern void CESysDeleteCriticalSection(CESysCriticalSection* cs);


	CE_FORCEINLINE void CESysEnterCriticalSection(CESysCriticalSection* cs)
	{
		::pthread_mutex_lock(cs);
	}

	CE_FORCEINLINE bool CESysTryEnterCriticalSection(CESysCriticalSection* cs)
	{
		bool result = false;
		if (!::pthread_mutex_trylock(cs))
		{
			result = true;
		}
		return result;
	}

	CE_FORCEINLINE void CESysLeaveCriticalSection(CESysCriticalSection* cs)
	{
		::pthread_mutex_unlock(cs);
	}


#ifdef __cplusplus
}
#endif

#endif // __CESysCriticalSectionLinux_h__
