///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CESysAtomicOpsLinuxX86_h__
#define __CESysAtomicOpsLinuxX86_h__

////////////////////////////////////////
// C-based atomic primitives
////////////////////////////////////////

#ifdef __cplusplus
extern "C"
{
#endif

    #define CE_HAVE_NATIVE_CAS32 1
	static CE_FORCEINLINE INT32 CESysInterlockedCompareExchange(CESysAtomicINT32* dest, INT32 newValue, INT32 expectedValue)
	{
		CESysAtomicINT32 old;
		asm volatile ( "lock; cmpxchgl %1, %2" 
					   : "=a" (old)
					   : "r" (newValue), "m" (*(dest)), "0" (expectedValue)
					   : "memory", "cc" );
		return old;
	}

    #define CE_HAVE_NATIVE_CESysInterlockedExchangeAdd 1
	static CE_FORCEINLINE INT32 CESysInterlockedExchangeAdd(CESysAtomicINT32* var, INT32 value)
	{
		CESysAtomicINT32 result;
		asm volatile ( "lock; xaddl %0, %1" 
					   : "=r" (result), "=m" (*var) 
					   : "0" (value), "m" (*var) 
					   : "memory" );
		return result;
	}

	
#ifdef __cplusplus
};
#endif

#endif // __CESysAtomicOpsLinuxX86_h__
