///////////////////////////////////////////////////////////////////////////////
// Copyright 2006,2007,2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef CEComServerRegistryEntry_h
#define CEComServerRegistryEntry_h

#include "CECom.h"

#if defined(STATIC_LINK)

#if CE_OS(WIN32)
#error unsupported platform
#elif CE_OS(LINUX) || CE_OS(XAI) || CE_OS(HYDRA) || CE_OS(ANDROID)

#define COMSERVER(libname) \
	extern "C" \
	{ \
		extern CEHResult libname##_CEDllGetClassObject(UINT32 clsid, UINT32 iid, CEComAllocatorRec* pAllocatorRec, void** ppv); \
		extern bool libname##_CEDllCanUnloadNow(); \
		extern bool libname##_CEDllMain(CEDllHandle hDLL, UINT32 reason, void* param); \
	};

#if defined(CECOM_SERVREG_Bookmark)
COMSERVER(Bookmark)
#endif

#if defined(CECOM_SERVREG_CECssParser)
COMSERVER(CECssParser)
#endif

#if defined(CECOM_SERVREG_CEDpyAppDesktopService)
COMSERVER(CEDpyAppDesktopService)
#endif

#if defined(CECOM_SERVREG_CEDpyAppSample)
COMSERVER(CEDpyAppSample)
#endif

#if defined(CECOM_SERVREG_CEAppKitQa)
COMSERVER(CEAppKitQa)
#endif

#if defined(CECOM_SERVREG_CEQaUtil)
COMSERVER(CEQaUtil)
#endif

#if defined(CECOM_SERVREG_CEDpyAppWeb)
COMSERVER(CEDpyAppWeb)
#endif

#if defined(CECOM_SERVREG_CEDpyAppSilkBrowser)
COMSERVER(CEDpyAppSilkBrowser)
#endif

#if defined(CECOM_SERVREG_CEDpyAppController)
COMSERVER(CEDpyAppController)
#endif

#if defined(CECOM_SERVREG_CEDpyAppBdre)
COMSERVER(CEDpyAppBdre)
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopStdWin32)
COMSERVER(CEDpyRunLoopStdWin32)
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopFB)
COMSERVER(CEDpyRunLoopFB)
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopStdX11)
COMSERVER(CEDpyRunLoopStdX11)
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopDfb)
COMSERVER(CEDpyRunLoopDfb)
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopDragon)
COMSERVER(CEDpyRunLoopDragon)
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopBdre)
COMSERVER(CEDpyRunLoopBdre)
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopXYZ)
COMSERVER(CEDpyRunLoopXYZ)
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopXai)
COMSERVER(CEDpyRunLoopXai)
#endif

#if defined(CECOM_SERVREG_CEDXOpenGLWin32)
COMSERVER(CEDXOpenGLWin32)
#endif

#if defined(CECOM_SERVREG_CEDXOpenGLX11)
COMSERVER(CEDXOpenGLX11)
#endif

#if defined(CECOM_SERVREG_CEDXXai)
COMSERVER(CEDXXai)
#endif
	
#if defined(CECOM_SERVREG_CEDXD3D)
COMSERVER(CEDXD3D)
#endif

#if defined(CECOM_SERVREG_CEDXX11)
COMSERVER(CEDXX11)
#endif

#if defined(CECOM_SERVREG_CEDXDfb)
COMSERVER(CEDXDfb)
#endif

#if defined(CECOM_SERVREG_CEDXFB)
COMSERVER(CEDXFB)
#endif

#if defined(CECOM_SERVREG_CEGClient)
COMSERVER(CEGClient)
#endif

#if defined(CECOM_SERVREG_CEDXDragon)
COMSERVER(CEDXDragon)
#endif

#if defined(CECOM_SERVREG_CEDXBdre)
COMSERVER(CEDXBdre)
#endif

#if defined(CECOM_SERVREG_CEDXXYZ)
COMSERVER(CEDXXYZ)
#endif

#if defined(CECOM_SERVREG_CEDXSkia)
COMSERVER(CEDXSkia)
#endif

#if defined(CECOM_SERVREG_CEDXMath)
COMSERVER(CEDXMath)
#endif

#if defined(CECOM_SERVREG_CETextInputServerSJ3)
COMSERVER(CETextInputServerSJ3)
#endif

#if defined(CECOM_SERVREG_CEImgMgr)
COMSERVER(CEImgMgr)
#endif

#if defined(CECOM_SERVREG_CEImgDecBMP)
COMSERVER(CEImgDecBMP)
#endif

#if defined(CECOM_SERVREG_CEImgDecGIF)
COMSERVER(CEImgDecGIF)
#endif

#if defined(CECOM_SERVREG_CEImgDecJPEG)
COMSERVER(CEImgDecJPEG)
#endif

#if defined(CECOM_SERVREG_CEImgDecPNG)
COMSERVER(CEImgDecPNG)
#endif

#if defined(CECOM_SERVREG_CETL)
COMSERVER(CETL)
#endif

#if defined(CECOM_SERVREG_CEDX2DGDIplus)
COMSERVER(CEDX2DGDIplus)
#endif

#if defined(CECOM_SERVREG_CEDX2DGeneric)
COMSERVER(CEDX2DGeneric)
#endif

#if defined(CECOM_SERVREG_CEDX2DXai)
COMSERVER(CEDX2DXai)
#endif

#if defined(CECOM_SERVREG_CEDX2DGPU)
COMSERVER(CEDX2DGPU)
#endif

#if defined(CECOM_SERVREG_CEDX2DX11)
COMSERVER(CEDX2DX11)
#endif

#if defined(CECOM_SERVREG_CEHtml)
COMSERVER(CEHtml)
#endif

#if defined(CECOM_SERVREG_WebKitSilk)
COMSERVER(WebKitSilk)
#endif

#if defined(CECOM_SERVREG_CEXmbEmu)
COMSERVER(CEXmbEmu)
#endif

#if defined(CECOM_SERVREG_ceapartment)
COMSERVER(ceapartment)
#endif

#if defined(CECOM_SERVREG_cedtime)
COMSERVER(cedtime)
#endif

#if defined(CECOM_SERVREG_cedtproxy)
COMSERVER(cedtproxy)
#endif

#if defined(CECOM_SERVREG_cefsioomc)
COMSERVER(cefsioomc)
#endif

#if defined(CECOM_SERVREG_cefsiowin32)
COMSERVER(cefsiowin32)
#endif

#if defined(CECOM_SERVREG_cefsioposix)
COMSERVER(cefsioposix)
#endif

#if defined(CECOM_SERVREG_cefsioxai)
COMSERVER(cefsioxai)
#endif

#if defined(CECOM_SERVREG_cefspathwipo)
COMSERVER(cefspathwipo)
#endif

#if defined(CECOM_SERVREG_cefsstructpad)
COMSERVER(cefsstructpad)
#endif

#if defined(CECOM_SERVREG_cepfrFontService)
COMSERVER(cepfrFontService)
#endif

#if defined(CECOM_SERVREG_cei18nL10N)
COMSERVER(cei18nL10N)
#endif

#if defined(CECOM_SERVREG_cei18nCommon)
COMSERVER(cei18nCommon)
#endif

#if defined(CECOM_SERVREG_cei18nCommonICU)
COMSERVER(cei18nCommonICU)
#endif

#if defined(CECOM_SERVREG_cepffreetype)
COMSERVER(cepffreetype)
#endif

#if defined(CECOM_SERVREG_CEPFBitmap)
COMSERVER(CEPFBitmap)
#endif

#if defined(CECOM_SERVREG_CEPFMgr)
COMSERVER(CEPFMgr)
#endif

#if defined(CECOM_SERVREG_CEPFRes)
COMSERVER(CEPFRes)
#endif

#if defined(CECOM_SERVREG_cesymbol)
COMSERVER(cesymbol)
#endif

#if defined(CECOM_SERVREG_cetext)
COMSERVER(cetext)
#endif

#if defined(CECOM_SERVREG_cetime)
COMSERVER(cetime)
#endif

#if defined(CECOM_SERVREG_cexml)
COMSERVER(cexml)
#endif

#if defined(CECOM_SERVREG_cexmlplist)
COMSERVER(cexmlplist)
#endif

#if defined(CECOM_SERVREG_CEPlugin)
COMSERVER(CEPlugin)
#endif

#if defined(CECOM_SERVREG_CEPhWeb)
COMSERVER(CEPhWeb)
#endif

#if defined(CECOM_SERVREG_CEBrowserBase)
COMSERVER(CEBrowserBase)
#endif

#if defined(CECOM_SERVREG_CEDpyCommonWidget)
COMSERVER(CEDpyCommonWidget)
#endif

#if defined(CECOM_SERVREG_CEDpyWindowManagerGeneric)
COMSERVER(CEDpyWindowManagerGeneric)
#endif

#if defined(CECOM_SERVREG_cescm)
COMSERVER(cescm)
#endif

#if defined(CECOM_SERVREG_CENetwork)
COMSERVER(CENetwork)
#endif

#if defined(CECOM_SERVREG_ceps2)
COMSERVER(ceps2)
#endif

#if defined(CECOM_SERVREG_cehttp)
COMSERVER(cehttp)
#endif

#if defined(CECOM_SERVREG_cesocket)
COMSERVER(cesocket)
#endif

#if defined(CECOM_SERVREG_cessl2)
COMSERVER(cessl2)
#endif

#if defined(CECOM_SERVREG_cecert)
COMSERVER(cecert)
#endif

#if defined(CECOM_SERVREG_ceuri)
COMSERVER(ceuri)
#endif

#if defined(CECOM_SERVREG_ceurlfilter)
COMSERVER(ceurlfilter)
#endif

#if defined(CECOM_SERVREG_cehttpcache)
COMSERVER(cehttpcache)
#endif

#if defined(CECOM_SERVREG_cedatacontainer)
COMSERVER(cedatacontainer)
#endif

#if defined(CECOM_SERVREG_cedevport)
COMSERVER(cedevport)
#endif

#if defined(CECOM_SERVREG_CEZetaW)
COMSERVER(CEZetaW)
#endif

#if defined(CECOM_SERVREG_cecookie)
COMSERVER(cecookie)
#endif

#if defined(PLATFORM_DTT)
#if defined(CECOM_SERVREG_CETMPlayerDtv)
COMSERVER(CETMPlayerDtv)
#endif
#elif defined(PLATFORM_DRAGON)
#if defined(CECOM_SERVREG_CETMPlayerDragon)
COMSERVER(CETMPlayerDragon)
#endif
#elif defined(PLATFORM_BDRE)
#if defined(CECOM_SERVREG_CETMPlayerBdre)
COMSERVER(CETMPlayerBdre)
#endif
#else
#if defined(CECOM_SERVREG_CETMPlayerGeneric)
COMSERVER(CETMPlayerGeneric)
#endif
#endif

//////////////////////////////////////
// entry for CEDllMain only.
#if defined(CECOM_SERVREG_CEFramework)
COMSERVER(CEFramework)
#endif

#if defined(CECOM_SERVREG_CEHtmlUI)
COMSERVER(CEHtmlUI)
#endif

#if defined(CECOM_SERVREG_CEHtmlApi)
COMSERVER(CEHtmlApi)
#endif

#if defined(CECOM_SERVREG_Utility)
COMSERVER(Utility)
#endif

#if defined(CECOM_SERVREG_cedbonmemory)
COMSERVER(Utility)
#endif

#if defined(CECOM_SERVREG_AppBase)
COMSERVER(AppBase)
#endif

#if defined(CECOM_SERVREG_ceps)
COMSERVER(ceps)
#endif

#if defined(CECOM_SERVREG_CEAppProxy)
COMSERVER(CEAppProxy)
#endif
// entry for CEDllMain only.
//////////////////////////////////////

#define COMSERVERENTRY(clsid, libname) {clsid, libname##_CEDllGetClassObject, libname##_CEDllCanUnloadNow, libname##_CEDllMain}

#else
#error unknown or unspecified development platform
#endif

#else // STATIC_LINK
#define COMSERVERENTRY(clsid, libname) { clsid, #libname}
#endif // STATIC_LINK


#if defined(STATIC_LINK)
static CEComEarlyBindServerRegistryEntry clsidToFilenames[] = 
#else // defined(STATIC_LINK)
static CEComLateBindServerRegistryEntry clsidToFilenames[] = 
#endif // defined(STATIC_LINK)
{
#if defined(CECOM_SERVREG_Bookmark) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEBMXbelSchema, Bookmark),
#endif

#if defined(CECOM_SERVREG_CECssParser) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComStdClassID_CECssParserFactory, CECssParser),
#endif

#if defined(CECOM_SERVREG_CEDpyAppDesktopService) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDpyAppProfMonFactory, CEDpyAppDesktopService),
	COMSERVERENTRY(CEComClassID_CEDpyAppTextServiceFactory, CEDpyAppDesktopService),
	COMSERVERENTRY(CEComClassID_CEDpyAppTextServiceBdreFactory, CEDpyAppDesktopService),
#endif

#if defined(CECOM_SERVREG_CEDpyAppSample) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDpyAppSampleFactory, CEDpyAppSample),
	COMSERVERENTRY(CEComClassID_CEDpyAppImageViewerFactory, CEDpyAppSample),
	COMSERVERENTRY(CEComClassID_CEDpyAppContext2DTestFactory, CEDpyAppSample),
	COMSERVERENTRY(CEComClassID_CEDpyAppTLTestFactory, CEDpyAppSample),
	COMSERVERENTRY(CEComClassID_CEDpyAppPaintFactory, CEDpyAppSample),
	COMSERVERENTRY(CEComClassID_CEDpySimpleAppLauncherFactory, CEDpyAppSample),
	COMSERVERENTRY(CEComClassID_CEDpyBDdemoFactory, CEDpyAppSample),
	COMSERVERENTRY(CEComClassID_CEDpyTextViewTestFactory, CEDpyAppSample),
	COMSERVERENTRY(CEComClassID_CEDpyWindowOrderFactory, CEDpyAppSample),
	COMSERVERENTRY(CEComClassID_CEDpyAppFBTestFactory, CEDpyAppSample),
#endif

#if defined(CECOM_SERVREG_CEAppKitQa) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEAppKitQaFactory, CEAppKitQa),
#endif

#if defined(CECOM_SERVREG_CEQaUtil) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEQaUtilFactory, CEQaUtil),
#endif


#if defined(CECOM_SERVREG_CEDpyAppWeb) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDpyAppWebFactory, CEDpyAppWeb),
#endif

#if defined(CECOM_SERVREG_CEDpyAppSilkBrowser) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDpyAppSBFactory, CEDpyAppSilkBrowser),
#endif

#if defined(CECOM_SERVREG_CEDpyAppController) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDpyAppControllerFactory, CEDpyAppController),
#endif

#if defined(CECOM_SERVREG_CEDpyAppBdre) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDpyAppBdreFactory, CEDpyAppBdre),
#endif

#if defined(CECOM_SERVREG_CEXmbEmu) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEXmbEmuAppFactory, CEXmbEmu),
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopStdWin32) || !defined(STATIC_LINK)
#if CE_OS(WIN32)
	COMSERVERENTRY(CEComClassID_CEDpyRunLoopStdWin32, CEDpyRunLoopStdWin32),
#endif
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopFB) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDpyRunLoopFB, CEDpyRunLoopFB),
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopStdX11) || !defined(STATIC_LINK)
#if CE_OS(LINUX)
	COMSERVERENTRY(CEComClassID_CEDpyRunLoopStdX11, CEDpyRunLoopStdX11),
#endif
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopDfb) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDpyRunLoopDfb, CEDpyRunLoopDfb),
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopDragon) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDpyRunLoopDragon, CEDpyRunLoopDragon),
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopBdre) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDpyRunLoopBdre, CEDpyRunLoopBdre),
#endif

#if defined(CECOM_SERVREG_CEDpyRunLoopXYZ) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDpyRunLoopXYZ, CEDpyRunLoopXYZ),
#endif


#if defined(CECOM_SERVREG_CEDpyRunLoopXai) || !defined(STATIC_LINK)
#if CE_OS(XAI)
	COMSERVERENTRY(CEComClassID_CEDpyRunLoopXai, CEDpyRunLoopXai),
#endif
#endif

#if defined(CECOM_SERVREG_CEDXOpenGLWin32) || !defined(STATIC_LINK)
#if CE_OS(WIN32)
	COMSERVERENTRY(CEComClassID_CEDXOpenGLWin32, CEDXOpenGLWin32),
#endif
#endif

#if defined(CECOM_SERVREG_CEDXOpenGLX11) || !defined(STATIC_LINK)
#if CE_OS(LINUX)
	COMSERVERENTRY(CEComClassID_CEDXOpenGLX11, CEDXOpenGLX11),
#endif
#endif

#if defined(CECOM_SERVREG_CEDXXai) || !defined(STATIC_LINK)
#if CE_OS(XAI)
	COMSERVERENTRY(CEComClassID_CEDXXai, CEDXXai),
	COMSERVERENTRY(CEComClassID_CEDX2DFactoryXai, CEDXXai),
	COMSERVERENTRY(CEComClassID_CEDX2DFactoryCairoFB, CEDXXai),
#endif
#endif
	
#if defined(CECOM_SERVREG_CEDXD3D) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDXD3D, CEDXD3D),
	COMSERVERENTRY(CEComClassID_CEDXMathD3D, CEDXD3D),
#endif

#if defined(CECOM_SERVREG_CEDXGDIplus) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDXGDIplus, CEDXGDIplus),
#endif

#if defined(CECOM_SERVREG_CEDXDfb) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDXDfb, CEDXDfb),
	COMSERVERENTRY(CEComClassID_CEDX2DFactoryDfb, CEDXDfb),
#endif

#if defined(CECOM_SERVREG_CEDXFB) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDXFB, CEDXFB),
	COMSERVERENTRY(CEComClassID_CEDX2DFactoryFB, CEDXFB),
#if !CE_OS(XAI)
	COMSERVERENTRY(CEComClassID_CEDX2DFactoryCairoFB, CEDXFB),
#endif
#endif

#if defined(CECOM_SERVREG_CEGClient) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEVGFactoryCairo, CEGClient),
#endif

#if defined(CECOM_SERVREG_CEDXDragon) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDXDragon, CEDXDragon),
	COMSERVERENTRY(CEComClassID_CEDX2DFactoryDragon, CEDXDragon),
	COMSERVERENTRY(CEComClassID_CEDXDeviceDragon, CEDXDragon),
#endif

#if defined(CECOM_SERVREG_CEDXBdre) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDXBdre, CEDXBdre),
	COMSERVERENTRY(CEComClassID_CEDX2DFactoryBdre, CEDXBdre),
#endif

#if defined(CECOM_SERVREG_CEDXXYZ) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDXXYZ, CEDXXYZ),
	COMSERVERENTRY(CEComClassID_CEDX2DFactoryXYZ, CEDXXYZ),
#endif

#if defined(CECOM_SERVREG_CEDXX11) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDXX11, CEDXX11),
	COMSERVERENTRY(CEComClassID_CEDX2DFactoryX11, CEDXX11),
#endif

#if defined(CECOM_SERVREG_CEDXSkia) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDXSkia, CEDXSkia),
	COMSERVERENTRY(CEComClassID_CEDX2DFactorySkia, CEDXSkia),
#endif

#if defined(CECOM_SERVREG_CEDXMath) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDXMath, CEDXMath),
#endif

#if defined(CECOM_SERVREG_CETextInputServerMSIME) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CETextInputServerFactoryMSIME, CETextInputServerMSIME),
#endif

#if defined(CECOM_SERVREG_CETextInputServerMSIMEBackEnd) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CETextInputServerFactoryMSIMEBackEnd, CETextInputServerMSIMEBackEnd),
#endif

#if defined(CECOM_SERVREG_CETextInputServerSJ3) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CETextInputServerFactorySJ3, CETextInputServerSJ3),
#endif

#if defined(CECOM_SERVREG_CEImgMgr) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEImageManager, CEImgMgr),
#endif

#if defined(CECOM_SERVREG_CEImgDecBMP) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEImgDecBMPFactory, CEImgDecBMP),
#endif

#if defined(CECOM_SERVREG_CEImgDecGIF) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEImgDecGIFFactory, CEImgDecGIF),
#endif

#if defined(CECOM_SERVREG_CEImgDecJPEG) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEImgDecJPEGFactory, CEImgDecJPEG),
#endif

#if defined(CECOM_SERVREG_CEImgDecPNG) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEImgDecPNGFactory, CEImgDecPNG),
#endif

#if defined(CECOM_SERVREG_CETL) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CETLFactory, CETL),
#endif

#if defined(CECOM_SERVREG_CEDX2DGDIplus) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDX2DFactoryGDIplus, CEDX2DGDIplus),
#endif

#if defined(CECOM_SERVREG_CEDX2DGPU) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDX2DFactoryGPU, CEDX2DGPU),
#endif

#if defined(CECOM_SERVREG_CEHtml) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComStdClassID_CEHtmlBrowserManager, CEHtml),

	//// Marshall for cecom
	COMSERVERENTRY(CEComStdClassID_CEHtmlUnknownLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlClassFactoryLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlUnknownStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlClassFactoryStandardMarshaller, CEHtml),

	//// Marshall for cetext
	COMSERVERENTRY(CEComClassID_CEUStringLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEUStringReaderLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEUStringWriterLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEUTokenizerCallbacksLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEUTokenizerLightWeightMarshaller, CEHtml),

	//// Marshall for cefs
	COMSERVERENTRY(CEComClassID_CEFSFileSystemLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEFSFileLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEFSDirectoryEnumeratorLightWeightMarshaller, CEHtml),

	//// Marshall for cefspathname
	COMSERVERENTRY(CEComClassID_CEFSPathnameLightWeightMarshaller, CEHtml),

	//// Marshall for CEFramework
// 	COMSERVERENTRY(CEComClassID_CEUIBoundaryLightWeightMarshaller, CEHtml),
// 	COMSERVERENTRY(CEComClassID_CEUIFocusFrameLightWeightMarshaller, CEHtml),
// 	COMSERVERENTRY(CEComClassID_CEUIFocusFrameFactoryStandardMarshaller, CEHtml),
// 	COMSERVERENTRY(CEComClassID_CEUIFontLightWeightMarshaller, CEHtml),
// 	COMSERVERENTRY(CEComClassID_CEUIFontFamilyNameUtilityLightWeightMarshaller, CEHtml),
// 	COMSERVERENTRY(CEComClassID_CEUIGraphicsContextLightWeightMarshaller, CEHtml),
// 	COMSERVERENTRY(CEComClassID_CEUIGraphicsEnvironmentLightWeightMarshaller, CEHtml),
// 	COMSERVERENTRY(CEComClassID_CEUIImageLightWeightMarshaller, CEHtml),
// 	COMSERVERENTRY(CEComClassID_CEUIImageDecoderLightWeightMarshaller, CEHtml),
// 	COMSERVERENTRY(CEComClassID_CEUIImageDecoderNotificationReceiverLightWeightMarshaller, CEHtml),
// 	COMSERVERENTRY(CEComClassID_CEUIImageDecoderFactoryLightWeightMarshaller, CEHtml),
// 	COMSERVERENTRY(CEComClassID_CEUIImageUtilityLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEUIFocusFrameFactoryStandardMarshaller, CEHtml),

	COMSERVERENTRY(CEComClassID_CEUIGraphicsContextStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEUIGraphicsEnvironmentStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEUIImageStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEUIImageDecoderStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEUIImageDecoderFactoryStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlRadioGroupStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CETimerFactoryStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CETimerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEUIImageUtilityLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEUIImageDecoderNotificationReceiverLightWeightMarshaller, CEHtml),

	//// Marshall for ceurl
	COMSERVERENTRY(CEComClassID_CEURLLightWeightMarshaller, CEHtml),

	//// Marshall for CEHtml
//	COMSERVERENTRY(CEComStdClassID_CEHtmlBrowserEnvironmentLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlBrowserManagerLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlBrowserPreferenceLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlBrowserResourceProviderLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlCharsetEncodingContextLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlDocumentLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlDocumentEventHandlerLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlScriptableElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlElementBaseProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlResolvedElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlFormElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlFormControlElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlButtonElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlTextControlElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlInputTextElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlInputButtonElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlFileSelectElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlTextAreaElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlFormSelectableElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlOptionElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlSelectElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlSelectListElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlSelectComboElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlCheckBoxElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlRadioElementProxyLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlPluginElementProxyLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlPluginElementJointLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlElementEventHandlerLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlFontPreferenceLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlFormControlWidgetLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlFormControlWidgetFactoryLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlFrameWindowLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlFrameWindowManagerLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlFrameWindowNavigationEventHandlerLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlFrameWindowWidgetLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlFrameWindowWidgetManagerLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlHistoryNavigatorLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlJavascriptDialogHandlerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlExternalJavaScriptHandlerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlFileUploadHandlerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlMouseOverElementHandlerStandardMarshaller, CEHtml),

	COMSERVERENTRY(CEComStdClassID_CEHtmlNetworkEventHandlerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlNetworkPromptHandlerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlObjectWindowWidgetLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlPluginInstanceLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlPluginWidgetLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlPluginWidgetContainerLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlProxyEnvironmentLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlScrollContextLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlStatusbarWidgetLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComStdClassID_CEHtmlWindowLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlWindowNotificationHandlerLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlWindowPromptHandlerLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlWindowWidgetLightWeightMarshaller, CEHtml),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlWindowWidgetContainerLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlWebRequestContextLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlWidgetEventHandlerLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlPluginProcessLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlRequestContextLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlHelperAppRequestFactoryLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlCookieServiceLightWeightMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlPluginConfirmationStandardMarshaller, CEHtml),

	//// Marshall for CEHtmlUI
	COMSERVERENTRY(CEComClassID_CEHtmlBrowserEnvironmentStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlBrowserResourceProviderStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlDocumentEventHandlerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlElementEventHandlerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlFormControlWidgetStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlFormControlWidgetFactoryStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlFrameWindowNavigationEventHandlerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlFrameWindowWidgetStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlFrameWindowWidgetManagerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlPluginWidgetStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlPluginWidgetContainerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlProxyEnvironmentStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlHtmlHttpConfigHandlerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlAdditionalMimeTypeHandlerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlApplicationSpecificBrowserInformationHandlerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlScrollContextStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlStatusbarWidgetStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlWindowNotificationHandlerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlWindowPromptHandlerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlNetDeviceStateNotifierPeerStandardMarshaller, CEHtml),

	COMSERVERENTRY(CEComClassID_CEHtmlWindowWidgetStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlWindowWidgetContainerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlHelperAppHandlerFactoryStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlHelperAppHandlerStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEPSWebResponseInfoLightWeightMarshaller, CEHtml),

	// plugin
	COMSERVERENTRY(CEComClassID_CEPluginStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEPluginSharedObjectLoaderMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEPluginRequestContextContextStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlPluginInstanceStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEHtmlPluginElementJointStandardMarshaller, CEHtml),

	//// Javascript
	COMSERVERENTRY(CEComClassID_CEJSObjectClassFactory, CEHtml),
	COMSERVERENTRY(CEComClassID_CEJSObject, CEHtml),

	//// Scriptable
	COMSERVERENTRY(CEComClassID_CEScriptableStandardMarshaller, CEHtml),

	//// media player
	COMSERVERENTRY(CEComClassID_CETMMediaPlayerStandardMarshaller, CEHtml),

	//// text input
	COMSERVERENTRY(CEComClassID_CEDsysTextInputByWindowStandardMarshaller, CEHtml),
	COMSERVERENTRY(CEComClassID_CEDsysTextInputEventListenerLightWeightMarshaller, CEHtml),

	//// plugin
	COMSERVERENTRY(CEComClassID_CEPluginModuleLoaderMarshaller, CEHtml),

#endif

#if defined(CECOM_SERVREG_WebKitSilk) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEWebKit, WebKitSilk),
#endif

#if defined(CECOM_SERVREG_ceapartment) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CESingleThreadApartment, ceapartment),
	COMSERVERENTRY(CEComClassID_CENeutralApartment, ceapartment),
	COMSERVERENTRY(CEComClassID_CEApartmentSupport, ceapartment),
#endif

#if defined(CECOM_SERVREG_cedtime) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComStdClassID_CEDtIMEFactory, cedtime),
#endif

#if defined(CECOM_SERVREG_cedtproxy) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComStdClassID_CEDtProxy, cedtproxy),
#endif

#if defined(CECOM_SERVREG_cefsioomc) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEFSOnMemoryCacheFileSystemFactory, cefsioomc),
#endif

#if defined(CECOM_SERVREG_cefsiowin32) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEFSWin32FileSystemFactory, cefsiowin32),
	COMSERVERENTRY(CEComStdClassID_CEFSFileSystemFactory, cefsiowin32),
#endif

#if defined(CECOM_SERVREG_cefsioposix) || !defined(STATIC_LINK)
#if CE_OS(LINUX)
	COMSERVERENTRY(CEComClassID_CEFSPOSIXFileSystemFactory, cefsioposix),
	COMSERVERENTRY(CEComStdClassID_CEFSFileSystemFactory, cefsioposix),
#endif
#endif

#if defined(CECOM_SERVREG_cefsioxai) || !defined(STATIC_LINK)
#if CE_OS(XAI)
	COMSERVERENTRY(CEComStdClassID_CEFSFileSystemFactory, cefsioxai),
#endif
#endif

#if defined(CECOM_SERVREG_cefspathwipo) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComStdClassID_CEFSPathnameFactory, cefspathwipo),
#endif

#if defined(CECOM_SERVREG_cefsstructpad) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEFSPaddedFileSystemFactory, cefsstructpad),
#endif

#if defined(CECOM_SERVREG_cepfrFontService) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComStdClassID_CEUIFontService, cepfrFontService),
#endif

#  if defined(CECOM_SERVREG_cei18nCommonICU) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComStdClassID_CEI18nUcICUClassFactory , cei18nCommonICU),
	COMSERVERENTRY(CEComStdClassID_CEI18nCalendarFactory, cei18nCommonICU),
	COMSERVERENTRY(CEComClassID_CEI18nCommonClassFactoryICU , cei18nCommonICU),
#  endif // #if defined(CECOM_SERVREG_cei18nCommon) || !defined(STATIC_LINK)

#if defined(CECOM_SERVREG_cepffreetype) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEPFRasterizerFreeType, cepffreetype),
	COMSERVERENTRY(CEComClassID_CEPFRasterizerFreeType_DTV_Morisawa, cepffreetype),  //<<-- bug 5048 -->>
	COMSERVERENTRY(CEComClassID_CEPFRasterizerFreeType_BDRE_Morisawa, cepffreetype), //<<-- bug 7532 / bug 7546 -->>
#endif

#if defined(CECOM_SERVREG_CEPFBitmap) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEPFRasterizerBitmap, CEPFBitmap),
#endif

#if defined(CECOM_SERVREG_CEPFMgr) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEPFManager, CEPFMgr),
#endif

#if defined(CECOM_SERVREG_CEPFRes) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEPFResourceResolver, CEPFRes),
#endif

#if defined(CECOM_SERVREG_cesymbol) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComStdClassID_CESymbolFactory, cesymbol),
	COMSERVERENTRY(CEComClassID_CEPropertyManager, cesymbol),
#endif

#if defined(CECOM_SERVREG_cetext) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEUString , cetext),
	COMSERVERENTRY(CEComClassID_CEUStringReader , cetext),
	COMSERVERENTRY(CEComClassID_CEUStringWriter , cetext),
	COMSERVERENTRY(CEComStdClassID_CEUTokenizer , cetext),
	COMSERVERENTRY(CEComStdClassID_CEUTokenizerCallbacks , cetext),
#endif

#if defined(CECOM_SERVREG_cetime) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEClockDeviceSystemTick, cetime),
	COMSERVERENTRY(CEComClassID_CETimeBaseDeviceRTC, cetime),
	COMSERVERENTRY(CEComClassID_CEDateTime, cetime),
#endif

#if defined(CECOM_SERVREG_cexml) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComStdClassID_CEXmlParserFactory, cexml),
	COMSERVERENTRY(CEComStdClassID_CEXmlFileFactory, cexml),
//	COMSERVERENTRY(CEComClassID_CEXmlGenericSchema, cexml),
#endif

#if defined(CECOM_SERVREG_cexmlplist) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEXMLPListSchema, cexmlplist),
#endif

	// ????
//	COMSERVERENTRY(CEComStdClassID_CEHtmlPluginRequestGlue , ????),
//	COMSERVERENTRY(CEComStdClassID_CEHtmlPluginDummyStreamReplyGlue, ????),

#if defined(CECOM_SERVREG_CEPlugin) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEPlugin, CEPlugin),
#endif

#if defined(CECOM_SERVREG_CEPhWeb) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEPhBrowserManagerFactory, CEPhWeb),
	COMSERVERENTRY(CEComClassID_CEPhBrowserManagerPeerFactory, CEPhWeb),
#endif

#if defined(CECOM_SERVREG_CEBrowserBase) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEBBBrowserManagerFactory, CEBrowserBase),
#endif

#if defined(CECOM_SERVREG_CEDpyCommonWidget) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEDpyCommonWidgetFactory, CEDpyCommonWidget),
#endif

#if defined(CECOM_SERVREG_cescm) || !defined(STATIC_LINK)
	COMSERVERENTRY(CEComClassID_CEScmContextClassFactory, cescm),
	COMSERVERENTRY(CEComClassID_CEScmContext, cescm),
#endif

#if defined(CECOM_SERVREG_CENetwork) || !defined(STATIC_LINK)
        COMSERVERENTRY(CEComClassID_CENetworkClassFactory, CENetwork),
        COMSERVERENTRY(CEComClassID_CENetwork, CENetwork),
#endif

#if defined(CECOM_SERVREG_ceps2) || !defined(STATIC_LINK)
        COMSERVERENTRY(CEComClassID_CEPS2ClassFactory, ceps2),
        COMSERVERENTRY(CEComClassID_CEPS2_1, ceps2),
        COMSERVERENTRY(CEComClassID_CEPS2ConfigFactory, ceps2),
#endif

#if defined(CECOM_SERVREG_cehttp) || !defined(STATIC_LINK)
        COMSERVERENTRY(CEComClassID_CEHTTPClassFactory, cehttp),
        COMSERVERENTRY(CEComClassID_CEHTTPClient, cehttp),
        COMSERVERENTRY(CEComClassID_CEHTTPRequest, cehttp),
		COMSERVERENTRY(CEComClassID_CEHTTPResponseHeader, cehttp),
#endif

#if defined(CECOM_SERVREG_cesocket) || !defined(STATIC_LINK)
        COMSERVERENTRY(CEComClassID_CESocketClassFactory, cesocket),
        COMSERVERENTRY(CEComClassID_CESocket, cesocket),
        COMSERVERENTRY(CEComClassID_CEServerSocket, cesocket),
#endif

#if defined(CECOM_SERVREG_cessl2) || !defined(STATIC_LINK)
        COMSERVERENTRY(CEComClassID_CESSL2ClassFactory, cessl2),
        COMSERVERENTRY(CEComClassID_CESSL2Connection, cessl2),
        COMSERVERENTRY(CEComClassID_CESSL2ServerConnection, cessl2),
        COMSERVERENTRY(CEComClassID_CESSL2Internal, cessl2),
#endif

#if defined(CECOM_SERVREG_cecert) || !defined(STATIC_LINK)
        COMSERVERENTRY(CEComClassID_CECertClassFactory, cecert),
        COMSERVERENTRY(CEComClassID_CEX509Certificate, cecert),
        COMSERVERENTRY(CEComClassID_CEX509CertificateDistinguishedName, cecert),
        COMSERVERENTRY(CEComClassID_CEX509CertificateChain, cecert),
        COMSERVERENTRY(CEComClassID_CEX509CertificateChainPool, cecert),
#endif

#if defined(CECOM_SERVREG_ceuri) || !defined(STATIC_LINK)
        COMSERVERENTRY(CEComClassID_CEURIClassFactory, ceuri),
        COMSERVERENTRY(CEComClassID_CEURI, ceuri),
        COMSERVERENTRY(CEComClassID_CEMutableURI, ceuri),
#endif

#if defined(CECOM_SERVREG_ceurlfilter) || !defined(STATIC_LINK)
        COMSERVERENTRY(CEComClassID_CEURLFilterClassFactory, ceurlfilter),
        COMSERVERENTRY(CEComClassID_CEURLFilterConfigFactoryTM1, ceurlfilter),
        COMSERVERENTRY(CEComClassID_CEURLFilterConfigFactoryTM2, ceurlfilter),
        COMSERVERENTRY(CEComClassID_CEURLFilterConfigFactoryDA1, ceurlfilter),
        COMSERVERENTRY(CEComClassID_CEURLFilterTM1, ceurlfilter),
        COMSERVERENTRY(CEComClassID_CEURLFilterTM2, ceurlfilter),
        COMSERVERENTRY(CEComClassID_CEURLFilterDA1, ceurlfilter),
        COMSERVERENTRY(CEComClassID_CETrendMicro, ceurlfilter),
        COMSERVERENTRY(CEComClassID_CEURLFilterXAI, ceurlfilter),
#endif

#if defined(CECOM_SERVREG_CEZetaW) || !defined(STATIC_LINK)
        COMSERVERENTRY(CEComClassID_CEZetaFactory, CEZetaW),
#endif

#if defined(CECOM_SERVREG_CEDpyWindowManagerGeneric) || !defined(STATIC_LINK)
        COMSERVERENTRY(CEComClassID_CEDpyWindowManagerGeneric, CEDpyWindowManagerGeneric),
#endif

#if defined(CECOM_SERVREG_CEAppProxy) || !defined(STATIC_LINK)
        COMSERVERENTRY(CEComClassID_CEApxDomain, CEAppProxy),
#endif

#if defined(PLATFORM_DTT)
#if defined(CECOM_SERVREG_CETMPlayerDtv) || !defined(STATIC_LINK)
		COMSERVERENTRY(CEComClassID_CETMFactoryDtv, CETMPlayerDtv),
#endif
#elif defined(PLATFORM_DRAGON)
#if defined(CECOM_SERVREG_CETMPlayerDragon) || !defined(STATIC_LINK)
		COMSERVERENTRY(CEComClassID_CETMFactoryDragon, CETMPlayerDragon),
#endif
#elif defined(PLATFORM_BDRE)
#if defined(CECOM_SERVREG_CETMPlayerBdre) || !defined(STATIC_LINK)
		COMSERVERENTRY(CEComClassID_CETMFactoryBdre, CETMPlayerBdre),
#endif
#else
#if defined(CECOM_SERVREG_CETMPlayerGeneric) || !defined(STATIC_LINK)
		COMSERVERENTRY(CEComClassID_CETMFactoryGeneric, CETMPlayerGeneric),
#endif
#endif


//////////////////////////////////////
// entry for CEDllMain only.
#if defined(CECOM_SERVREG_CEFramework) || !defined(STATIC_LINK)
        COMSERVERENTRY(0xffffffff, CEFramework), // disable CEDllGetClassObject.
#endif

#if defined(CECOM_SERVREG_CEHtmlUI) || !defined(STATIC_LINK)
        COMSERVERENTRY(0xffffffff, CEHtmlUI), // disable CEDllGetClassObject.
#endif

#if defined(CECOM_SERVREG_CEHtmlApi) || !defined(STATIC_LINK)
        COMSERVERENTRY(0xffffffff, CEHtmlApi), // disable CEDllGetClassObject.
#endif

#if defined(CECOM_SERVREG_Utility) || !defined(STATIC_LINK)
        COMSERVERENTRY(0xffffffff, Utility), // disable CEDllGetClassObject.
#endif

#if defined(CECOM_SERVREG_cddbonmemory) || !defined(STATIC_LINK)
        COMSERVERENTRY(0xffffffff, cddbonmemory), // disable CEDllGetClassObject.
#endif

#if defined(CECOM_SERVREG_AppBase) || !defined(STATIC_LINK)
        COMSERVERENTRY(0xffffffff, AppBase), // disable CEDllGetClassObject.
#endif

#if defined(CECOM_SERVREG_ceps) || !defined(STATIC_LINK)
        COMSERVERENTRY(0xffffffff, ceps), // disable CEDllGetClassObject
#endif

// entry for CEDllMain only.
//////////////////////////////////////


#if !defined(STATIC_LINK)
	{0, 0}     // end of data.
#endif // !defined(STATIC_LINK)
};

#endif // CEComServerRegistryEntry_h
