///////////////////////////////////////////////////////////////////////////////
// Copyright 2006 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef CEApiMacro_h
#define CEApiMacro_h

#include "CESysDefs.h"

#if CE_COMPILER(MSC) || CE_COMPILER(SNC)

	#define MEMBER_TO_INSTANCE(classname, valuename, member) (##valuename ? reinterpret_cast<##classname *>(reinterpret_cast<UINT8*>(##valuename) - reinterpret_cast<UINT8*>(&(reinterpret_cast<##classname*>(0)->##member))) : 0)
	#define INSTANCE_TO_MEMBER(membertype, classname, valuename, member) (##valuename ? reinterpret_cast<##membertype *>(&##valuename->##member) : 0)


#elif CE_COMPILER(GCC)

	#define MEMBER_TO_INSTANCE(classname, valuename, member) \
        (valuename ? reinterpret_cast<classname *>(reinterpret_cast<UINT_PTR>(valuename) - CEOFFSETOF(classname, member)) : 0)

	#define INSTANCE_TO_MEMBER(membertype, classname,  valuename, member) \
        (valuename ? reinterpret_cast<membertype *>(reinterpret_cast<UINT_PTR>(valuename) + CEOFFSETOF(classname, member)) : 0)

#else
#error unsupported compiler
#endif

#define IPTR_TO_INSTANCE(classname, valuename, member) MEMBER_TO_INSTANCE(classname, valuename, member)
#define INSTANCE_TO_IPTR(interfacename, classname, valuename, member) INSTANCE_TO_MEMBER(interfacename, classname, valuename, member)


#endif //CEApiMacro_h
